<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Ebook extends Home_Core_Controller {

    public function __construct()
    {
        parent::__construct();
    }
    public function ebook_details($slug)
    {
        $datas['event'] = $this->ebook_model->get_ebook_by_slug($slug);
        $datas['title'] = $datas['event']->title;
        if($datas['event']->create_mode == 1)
        {
            $this->load->view('front/view_ebook_page', $datas);
        }
        else
        {
            $data['app_setting'] = $this->setting_model->get_all_app_setting();
            $data['visual_setting'] = $this->setting_model->get_visual_setting();
            $data['page'] = $this->ebook_model->get_event_landing_page_for_home_page($slug);
            $data['all_pass_details'] = $this->ebook_model->all_pass_details_by_page_id($data['page']->page_id);
            $data['slug'] =$slug;
            $this->load->view('front/include/header', $data);
            $this->load->view('front/ebook_page_2');
            $this->load->view('front/include/footer');
        }
        
    }

    public function events()
    {
        $data['title'] = 'Events';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['visual_setting'] = $this->setting_model->get_visual_setting();
        $this->load->view('front/include/header', $data);
        $this->load->view('front/events');
        $this->load->view('front/include/footer');
    }

    function ebook_payment($slug)
    {
        $name = $this->session->userdata('upsell_name');
        $email = $this->session->userdata('upsell_email');
        $mob = $this->session->userdata('upsell_mob');
        if($name)
        {
            $this->load->model('upsell_model', 'upsell');
            $data = $this->upsell->get_page_by_slug($slug);
            if($data)
            {
                $app_setting = $this->setting_model->get_all_app_setting();
                $this->session->set_userdata('upsell_id', $data->page_id);
                if($data->page_discount_price)
                {
                    $amount = $data->page_discount_price;
                }
                else
                {
                    $amount = $data->page_main_price;
                }
                $rand = "RAOR".date("Ymd").rand(1000, 9999);
                $order_id = $rand;
                $api = new Api($app_setting->rozar_key_id, $app_setting->rozar_key_secret);
                $razorpayOrder = $api->order->create(array(
                    'receipt'         => $order_id,
                    'amount'          => $amount * 100,
                    'currency'        => 'INR',
                    'payment_capture' => 1 
                ));
                $amount = $razorpayOrder['amount'];
                $razorpayOrderId = $razorpayOrder['id'];
                $_SESSION['razorpay_order_id'] = $razorpayOrderId;
                $_SESSION['recharge_id'] = $order_id;
                $_SESSION['amount'] = $amount;
                $raz_pay_data = $this->rozr_pay_prepareData_2($amount,$razorpayOrderId, $order_id);
                $this->load->view('rezorpay_payment_by_upsell', array('data' => $raz_pay_data));
            }
            else
            {
                redirect(base_url());
            }
        }
        else
        {
            redirect(base_url().'ebook-details/'.$slug);
        }
    }

    


    
   

    public function all_events($offset=NULL)
    {
        $data['title'] = 'Events';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['visual_setting'] = $this->setting_model->get_visual_setting();

        $config['base_url'] = base_url().'events';
        $config["total_rows"] = $this->blog_model->count_all_blog();
        $config["per_page"] = 6; 
        $config['num_links'] = 5;
        $config['full_tag_open'] = '<ul class="justify-content-center">';
        $config['full_tag_close'] = '</ul>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a  class="">';
        $config['cur_tag_close'] = '</a></li>';
        $config['prev_tag_open'] = '<li class="prev">';
        $config['prev_tag_close'] = '<li>';
        $config['next_tag_open'] = '<li class="next">';
        $config['next_tag_close'] = '</li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['first_link'] = '<i class="icofont-rounded-left"></i>';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = '<i class="icofont-rounded-right"></i>';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['pagination'] = $this->pagination->create_links();
        $data['all_blog'] = $this->blog_model->get_all_blog_for_blog_page($config['per_page'], $offset);

        $data['facebook_fan_count'] = $this->getFacebookPageFanCount();
        $data['get_follower'] = $this->getTwitterFollower();
        $data['SubscriberCount'] = $this->getYoutubeSubscriberCount();
        $data['system_subscriber'] = $this->subscriber_model->count_all_subscriber();
        $data['InstagramCount'] = $this->getInstagramCount();
        $data['all_blog_category'] = $this->blog_model->get_all_blog_category();
        $data['get_all_widget'] = $this->setting_model->get_all_widget();
        $this->load->view('front/include/header', $data);
        $this->load->view('front/blog');
        $this->load->view('front/include/footer');
    }

}

/* End of file Events.php */
/* Location: ./application/views/front/Events.php */