<?php
defined('BASEPATH') OR exit('No direct script access allowed');


class Event extends Home_Core_Controller {

    public function __construct()
    {
        parent::__construct();
    }
    public function event_details($slug)
    {
        $data['event'] = $this->event_model->get_event_by_slug($slug);
        if($data['event'])
        {
            if($data['event']->event_build_mode == 1)
            {
                $data['title'] = $data['event']->title;
                $this->load->view('front/view_event_details', $data);
            }
            else
            {
                $data['title'] = 'Event Details';
                $data['app_setting'] = $this->setting_model->get_all_app_setting();
                $data['visual_setting'] = $this->setting_model->get_visual_setting();
                $data['slug'] = $data['event']->link;
                $this->load->view('front/include/header', $data);
                $this->load->view('front/event_details_2');
                $this->load->view('front/include/footer');
            }
            
        }
        else
        {
            redirect(base_url());
        }

        
    }

   
    public function all_events($offset=NULL)
    {
        $data['title'] = 'Events';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['visual_setting'] = $this->setting_model->get_visual_setting();

        $config['base_url'] = base_url().'events';
        $config["total_rows"] = $this->blog_model->count_all_blog();
        $config["per_page"] = 6; 
        $config['num_links'] = 5;
        $config['full_tag_open'] = '<ul class="justify-content-center">';
        $config['full_tag_close'] = '</ul>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a  class="">';
        $config['cur_tag_close'] = '</a></li>';
        $config['prev_tag_open'] = '<li class="prev">';
        $config['prev_tag_close'] = '<li>';
        $config['next_tag_open'] = '<li class="next">';
        $config['next_tag_close'] = '</li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['first_link'] = '<i class="icofont-rounded-left"></i>';
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['last_link'] = '<i class="icofont-rounded-right"></i>';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        $data['pagination'] = $this->pagination->create_links();
        $data['all_blog'] = $this->blog_model->get_all_blog_for_blog_page($config['per_page'], $offset);

        $data['facebook_fan_count'] = $this->getFacebookPageFanCount();
        $data['get_follower'] = $this->getTwitterFollower();
        $data['SubscriberCount'] = $this->getYoutubeSubscriberCount();
        $data['system_subscriber'] = $this->subscriber_model->count_all_subscriber();
        $data['InstagramCount'] = $this->getInstagramCount();
        $data['all_blog_category'] = $this->blog_model->get_all_blog_category();
        $data['get_all_widget'] = $this->setting_model->get_all_widget();
        $this->load->view('front/include/header', $data);
        $this->load->view('front/blog');
        $this->load->view('front/include/footer');
    }

    public function thank_you()
    {
        $data['title'] = 'Thank You';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['visual_setting'] = $this->setting_model->get_visual_setting();
        $this->load->view('front/include/header', $data);
        $this->load->view('front/thank_you');
        $this->load->view('front/include/footer');
    }

}

/* End of file Events.php */
/* Location: ./application/views/front/Events.php */