<?php
defined('BASEPATH') or exit('No direct script access allowed');
require './vendor/autoload.php';

use Razorpay\Api\Api;
use Razorpay\Api\Errors\SignatureVerificationError;


class Home extends Home_Core_Controller
{

	public function __construct()
	{
		parent::__construct();
		$this->post_load_more_count = 6;
		$this->load->model('branch_model', 'branch');
		$this->load->library('output_compression');
			$this->load->model('Product_model');
		$this->load->model('Product_section_model');
	}

	public function index()
	{
		$this->load->model('video_page_model');
		$data['title'] = 'Home';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['section_on_off'] = $this->frontend_model->get_all_section_on_off();
		$data['get_all_course'] = $this->course_model->get_all_course();
		$data['get_all_blog'] = $this->blog_model->get_all_blog();
		$data['get_all_counting'] = $this->frontend_model->get_all_counting();
		$data['get_all_are_you'] = $this->frontend_model->get_all_are_you();
		$data['about_us'] = $this->frontend_model->get_short_about_us();
		$data['get_all_stacks'] = $this->frontend_model->get_all_stacks();
		$data['cta'] = $this->frontend_model->get_cta_content();
		$data['video'] = $this->frontend_model->get_front_video();
		$data['slider'] = $this->frontend_model->get_all_slider_by_id();
		$data['all_social_media_info'] = $this->frontend_model->get_all_social_media_info();
		$data['all_placed_student'] = $this->frontend_model->get_all_placed_student();
		$data['get_all_company_logo'] = $this->frontend_model->get_all_company_logo();
		$data['heading'] = $this->frontend_model->get_all_heading_and_sub_heading();
		$data['video_image'] = $this->frontend_model->get_front_video_image();
		$data['all_latest_event'] = $this->event_model->get_all_latest_event();
		$data['get_all_latest_ebook'] = $this->ebook_model->get_all_latest_ebook();
		$data['category_all'] = $this->category_model->get_all_cat_for_cat_page();
		$data['all_flag_course'] = $this->course_model->get_flag_course();
		$data['all_course_with_out_flag'] = $this->course_model->all_course_with_out_flag();
		$data['feature'] = $this->frontend_model->get_all_feature_for_you();
		$data['app'] = $this->frontend_model->download_app_section();
		$data['all_current_op'] = $this->frontend_model->get_all_career_opportunities_current_placements();
		if ($data['section_on_off']->sec_flag_course == 1) {
			$data['get_flag_course'] = $this->course_model->get_flag_course();
		}
		// if ($data['section_on_off']->sec_course == 1) {
		// 	$ch = curl_init();
		// 	curl_setopt($ch, CURLOPT_URL, 'https://academy.dotcomvidya.com/home/get_course_api');
		// 	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		// 	$response = curl_exec($ch);
		// 	$result = json_decode($response);
		// 	curl_close($ch);
		// } else {
		// 	$result = [];
		// }
		$data['main_page'] = 'home';
		$data['all_api_course'] = $result;
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->output_compression->compress_output();
		// $this->load->view('front/include/footer');


		//$this->load->view('home');
	}
	public function check_user_avaliablity()
	{
		$mobile = $this->input->post('inputmobile');
		$avaliablity_check = $this->user_model->check_user_avaliablity_by_mobile_no($mobile);
		if ($avaliablity_check == 1) {
			echo true;
		} else {
			echo false;
		}
	}

	function saveUserInDatabase($email, $username, $token, $provider)
	{

		$this->db->where('email', $email);
		$user = $this->db->get('users')->num_rows();
		if ($user > 0) {
			$pw = $this->auth_model->login_done($email);
			$rand = rand();
			$user = array(
				'bcount_sess_id' => $pw['id'],
				'bcount_sess_mobile' => $pw['mobile'],
				'bcount_sess_email' => $pw['email'],
				'bcount_sess_role' => $pw['role'],
				'bcount_sess_status' => $pw['status'],
				'bcount_sess_logged_in' => true,
				'bcount_sess_token' => $token,
				'bcount_sess_app_id' => $this->config->item('app_key')
			);
			$this->auth_model->active_token($pw['id'], $token);
			$this->auth_model->active_session_id($pw['id'], $rand);
			$this->session->set_userdata($user);
			echo "Login Successfull";
		} else {
			$data = array(
				'email' => $email,
				'role' => 'User',
				'token' => $token,
				'login_type' => $provider,
				'status' => 'Active',
				'created_at' => 'Y-m-d H:i:s'
			);

			$qr = $this->db->insert('users', $data);

			if ($qr) {

				$pw = $this->auth_model->login_done($email);
				$rand = rand();
				$user = array(
					'bcount_sess_id' => $pw['id'],
					'bcount_sess_mobile' => $pw['mobile'],
					'bcount_sess_email' => $pw['email'],
					'bcount_sess_role' => $pw['role'],
					'bcount_sess_status' => $pw['status'],
					'bcount_sess_logged_in' => true,
					'bcount_sess_token' => $token,
					'bcount_sess_app_id' => $this->config->item('app_key')
				);
				$this->auth_model->active_token($pw['id'], $token);
				$this->auth_model->active_session_id($pw['id'], $rand);
				$this->session->set_userdata($user);
				echo "User Created";
			} else {
				echo "Failed to Create User";
			}
		}
	}

	function login_user_by_phone($email, $username, $token, $provider)
	{


		$pw = $this->auth_model->login_done_by_mobile(substr($email, 3));
		$rand = rand();
		$user = array(
			'bcount_sess_id' => $pw['id'],
			'bcount_sess_mobile' => $pw['mobile'],
			'bcount_sess_email' => $pw['email'],
			'bcount_sess_role' => $pw['role'],
			'bcount_sess_status' => $pw['status'],
			'bcount_sess_logged_in' => true,
			'bcount_sess_token' => $token,
			'bcount_sess_app_id' => $this->config->item('app_key')
		);
		$this->auth_model->active_token($pw['id'], $token);
		$this->auth_model->active_session_id($pw['id'], $rand);
		$this->session->set_userdata($user);
		echo "Login Successfull";
	}

	function fire_base_request()
	{
		$app_setting = $this->setting_model->get_all_app_setting();
		$email    = $_GET['email'];
		$provider = $_GET['provider'];
		$username = $_GET['username'];
		$token    = $_GET['token'];

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => "https://identitytoolkit.googleapis.com/v1/accounts:lookup?key=" . $app_setting->apiKey . "&idToken=" . $token,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_HTTPHEADER => array(
				"Content-length:0"
			)
		));

		$response = curl_exec($curl);


		curl_close($curl);
		//echo $response;
		$array_response = json_decode($response, true);

		if (array_key_exists("users", $array_response)) {
			$user_res = $array_response["users"];
			if (count($user_res) > 0) {
				$user_res_1 = $user_res[0];

				if (array_key_exists("phoneNumber", $user_res_1)) {
					if ($email == $user_res_1['phoneNumber']) {
						$this->login_user_by_phone($email, $username, $token, "Phone");
					} else {
						echo "Invalid Login Request";
					}
				} else {
					if ($user_res_1["email"] == $email) {
						$provider1 = $user_res_1["providerUserInfo"][0]["providerId"];
						if ($user_res_1["emailVerified"] == "1" || $user_res_1["emailVerified"] == "true" || $user_res_1["emailVerified"] == true || $provider1 == "facebook.com") {
							$this->saveUserInDatabase($email, $username, $token, $provider);
						} else {
							echo "Please Verify Your Email to Get Login";
						}
					} else {
						echo "Unknown Email User";
					}
				}
			} else {
				echo "Invalid Request User Not Found";
			}
		} else {
			echo "Unknown Bad Request";
		}
	}



	/**
	 * Load More Posts
	 */
	public function load_more_posts()
	{
		//$last_id = $id;
		$last_id = $this->input->post("load_more_posts_last_id", true);


		$latest_posts = load_more_posts($last_id, $this->post_load_more_count);
		if (!empty($latest_posts)) {
			$html_content = "";
			$hide_button = false;
			foreach ($latest_posts as $post) {
				$vars = array('post' => $post, 'show_label' => true);
				$html_content .= $this->load->view("front/post", $vars, true);
				$last_id = $post->id;
			}
			if (empty($this->blog_model->load_more_posts($last_id, $this->post_load_more_count))) {
				$hide_button = true;
			}
			$data = array(
				'result' => 1,
				'html_content' => $html_content,
				'last_id' => $last_id,
				'hide_button' => $hide_button
			);
			//print_r($data);
			echo json_encode($data);
		} else {
			$data = array(
				'result' => 0,
			);
			//print_r($data);
			echo json_encode($data);
		}
	}

	public function blog_details($slug)
	{
		if ($blog = $this->blog_model->get_blog_details_slug($slug)) {
			$data['app_setting'] = $this->setting_model->get_all_app_setting();
			$data['visual_setting'] = $this->setting_model->get_visual_setting();
			$data['title'] = $blog->title;
			$data['blog'] = $blog;
			$data['facebook_fan_count'] = $this->getFacebookPageFanCount();
			$data['get_follower'] = $this->getTwitterFollower();
			$data['SubscriberCount'] = $this->getYoutubeSubscriberCount();
			$data['system_subscriber'] = $this->subscriber_model->count_all_subscriber();
			$data['InstagramCount'] = $this->getInstagramCount();
			$data['all_blog_category'] = $this->blog_model->get_all_blog_category();
			$data['blog_image'] = $this->blog_model->get_blog_image_by_blog_id_one($blog->id);
			$data['blog_comment'] = $this->blog_model->get_all_blog_comment_by_id($blog->id);
			$data['category'] = $this->blog_model->get_all_category_by_blog_id($blog->category);
			$data['all_main_comment'] = $this->blog_model->get_all_main_comment();
			$data['get_all_widget'] = $this->setting_model->get_all_widget();
			$data['main_page'] = 'blog_details';
			// $this->load->view('front/include/header', $data);
			$this->load->view('front/index', $data);
			// $this->load->view('front/include/footer');
		} else {
			$this->error_404();
		}
	}

	public function all_blog($offset = NULL)
	{
		$data['title'] = 'Blog';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();

		$config['base_url'] = base_url() . 'blog';
		$config["total_rows"] = $this->blog_model->count_all_blog();
		$config["per_page"] = 6;
		$config['num_links'] = 5;
		$config['full_tag_open'] = '<ul class="justify-content-center">';
		$config['full_tag_close'] = '</ul>';
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';
		$config['cur_tag_open'] = '<li class="active"><a  class="">';
		$config['cur_tag_close'] = '</a></li>';
		$config['prev_tag_open'] = '<li class="prev">';
		$config['prev_tag_close'] = '<li>';
		$config['next_tag_open'] = '<li class="next">';
		$config['next_tag_close'] = '</li>';
		$config['num_tag_open'] = '<li>';
		$config['num_tag_close'] = '</li>';
		$config['first_link'] = '<i class="icofont-rounded-left"></i>';
		$config['first_tag_open'] = '<li>';
		$config['first_tag_close'] = '</li>';
		$config['last_link'] = '<i class="icofont-rounded-right"></i>';
		$config['last_tag_open'] = '<li>';
		$config['last_tag_close'] = '</li>';
		$this->pagination->initialize($config);
		$data['pagination'] = $this->pagination->create_links();
		$data['all_blog'] = $this->blog_model->get_all_blog_for_blog_page($config['per_page'], $offset);

		$data['facebook_fan_count'] = $this->getFacebookPageFanCount();
		$data['get_follower'] = $this->getTwitterFollower();
		$data['SubscriberCount'] = $this->getYoutubeSubscriberCount();
		$data['system_subscriber'] = $this->subscriber_model->count_all_subscriber();
		$data['InstagramCount'] = $this->getInstagramCount();
		$data['all_blog_category'] = $this->blog_model->get_all_blog_category();
		$data['get_all_widget'] = $this->setting_model->get_all_widget();
		$data['main_page'] = 'blog';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	public function blog_category($cat_slug, $id)
	{
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$category = $this->blog_model->get_all_category_by_blog_id($id);
		$data['category'] = $category;
		$data['title'] = $category->category_name;
		$data['all_blog'] = $this->blog_model->get_all_blog_for_blog_page_by_cat_id($category->id);
		$data['all_blog_category'] = $this->blog_model->get_all_blog_category();
		$this->load->view('front/include/header', $data);
		$this->load->view('front/blog_category');
		$this->load->view('front/include/footer');
	}


	public function add_reaction()
	{
		$blog_id = $this->input->post('blog_id');
		$reaction = $this->input->post('reaction');
		$blog = $this->blog_model->get_blog_by_id($blog_id);

		$get_cookie = get_cookie('blog_reaction_' . $blog_id);
		if (!$get_cookie) {
			$cookie = array(
				'name'   => 'blog_reaction_' . $blog_id,
				'value'  => $blog_id . '_' . $reaction,
				'expire' => strtotime("+1 year"),
				'prefix' => ''
			);
			$this->input->set_cookie($cookie);
			$reaction_count = $blog->$reaction + 1;

			$data1 = array($reaction => $reaction_count);
			$this->db->where('id', $blog_id);
			$process = $this->db->update('blog', $data1);
			if ($process == TRUE) {
				echo '2';
			} else {
				echo '1';
			}
		} elseif (trim(explode('_', $get_cookie)[1]) == $reaction) {
			$get_data = trim(explode('_', $get_cookie)[1]);
			$reaction_count = $blog->$get_data - 1;
			$data1 = array($get_data => $reaction_count);
			$this->db->where('id', $blog_id);
			$this->db->update('blog', $data1);
			delete_cookie('blog_reaction_' . $blog_id);
			echo '2';
		} elseif (!empty($get_cookie) && trim(explode('_', $get_cookie)[1]) != $reaction) {
			$get_data = trim(explode('_', $get_cookie)[1]);
			$reaction_count = $blog->$get_data - 1;
			$data1 = array($get_data => $reaction_count);
			$this->db->where('id', $blog_id);
			$this->db->update('blog', $data1);
			delete_cookie('blog_reaction_' . $blog_id);
			$cookie1 = array(
				'name'   => 'blog_reaction_' . $blog_id,
				'value'  => $blog_id . '_' . $reaction,
				'expire' => strtotime("+1 year"),
				'prefix' => ''
			);
			$this->input->set_cookie($cookie1);
			$reaction_count1 = $blog->$reaction + 1;

			$data11 = array($reaction => $reaction_count1);
			$this->db->where('id', $blog_id);
			$this->db->update('blog', $data11);
			echo '2';
		}


		/*if($get_cookie != 'blog_view_'.$blog->id)
		{
		  
		  $blog_count = $blog->view + 1;
		  $data1 = array('view' => $blog_count);
		  $this->db->where('id', $blog->id);
		  $this->db->update('blog', $data1);
		  $this->input->set_cookie($cookie);
		}*/
	}

	//Submit a subcriber.
	public function add_subscribe()
	{
		$data = array(
			'subscriber_id' => rand(100000, 10000000),
			'apply_ip' => $_SERVER['REMOTE_ADDR'],
			'email' => $this->input->post('sub_email'),
			'status' => 1
		);
		$result = $this->subscriber_model->subscriber_entry($data);
		if ($result) {
			echo "2";
		} else {
			echo "3";
		}
	}

	public function error_404()
	{
		header("HTTP/1.0 404 Not Found");
		$data['title'] = "Error 404";
		$data['description'] = "Error 404";
		$data['keywords'] = "error,404";
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$this->load->view('front/include/header', $data);
		$this->load->view('errors/error_404');
		$this->load->view('front/include/footer');
	}

	function getFacebookPageFanCount()
	{
		$app_setting = $this->setting_model->get_all_app_setting();
		$fb_page = $app_setting->fb_page;
		$access_token = $app_setting->fb_access_token;
		if (!empty($access_token) && !empty($fb_page)) {
			$url = 'https://graph.facebook.com/v10.0/' . $fb_page . '?fields=fan_count&access_token=' . $access_token;
			$curl = curl_init($url);
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
			$result = curl_exec($curl);
			curl_close($curl);
			$details = json_decode($result, true);
			return $details['fan_count'];
		} else {
			return 0;
		}
	}
	function getTwitterFollower()
	{
		$app_setting = $this->setting_model->get_all_app_setting();
		$tw_username = $app_setting->tw_username;
		if (!empty($tw_username)) {
			$data = file_get_contents('https://cdn.syndication.twimg.com/widgets/followbutton/info.json?screen_names=' . $tw_username);
			$parsed =  json_decode($data, true);
			return $tw_followers =  $parsed[0]['followers_count'];
		} else {
			return 0;
		}
	}
	function getYoutubeSubscriberCount()
	{
		$app_setting = $this->setting_model->get_all_app_setting();
		$channel_id = $app_setting->channel_id;
		$youtube_api_key = $app_setting->youtube_api_key;
		if (!empty($channel_id) && !empty($youtube_api_key)) {
			$channel_id = $channel_id;
			$api_key = $youtube_api_key;
			$api_response = file_get_contents('https://www.googleapis.com/youtube/v3/channels?part=statistics&id=' . $channel_id . '&fields=items/statistics/subscriberCount&key=' . $api_key);
			$api_response_decoded = json_decode($api_response, true);
			return $api_response_decoded['items'][0]['statistics']['subscriberCount'];
		} else {
			return 0;
		}
	}
	function getInstagramCount()
	{
		$app_setting = $this->setting_model->get_all_app_setting();
		$insta_username = $app_setting->insta_username;
		if (!empty($insta_username)) {
			$username = $insta_username;
			$response = @file_get_contents("https://www.instagram.com/$username/?__a=1");

			if ($response !== false) {
				$data = json_decode($response, true);
				if ($data !== null) {
					$follower  = $data['graphql']['user']['edge_followed_by']['count'];
					return $follower;
				}
			} else {
				return 0;
			}
		} else {
			return 0;
		}
	}

	function add_comment()
	{
		$this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('comment', 'Comment', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_flashdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			$this->blog_model->add_comment();
			$this->session->set_flashdata('success', 'Comment Successfull Added');
			redirect($this->agent->referrer());
		}
	}

	public function get_started()
	{
		$this->session->set_userdata(
			array(
				'user_name' => $this->input->post('name')
			)
		);

		redirect(base_url() . 'lab-plus');
	}

	public function lab_plus()
	{
		$data['title'] = 'Lab Plus';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['video_image'] = $this->frontend_model->get_front_video_image();
		$this->load->view('front/include/header', $data);
		$this->load->view('front/lab_plus');
		$this->load->view('front/include/footer');
	}

	function submit_inquery()
	{
		$this->load->model('lab_page_model', 'lab');
		$this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_flashdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			$this->lab->submit_inquery();
			$this->session->set_flashdata('success', 'Inquery Successfull Added');
			redirect($this->agent->referrer());
		}
	}

	function submit_registration_form()
	{
		$this->load->model('video_page_model', 'video');
		$this->form_validation->set_rules('f_name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_flashdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			$name = $this->input->post('f_name');
			$this->session->set_userdata('upsell_name', $name);
			$this->session->set_userdata('upsell_email', $this->input->post('email'));
			$this->session->set_userdata('upsell_mob', $this->input->post('mobile'));
			// $session_id = session_id();
			// $this->video->submit_registration_form($session_id);
			redirect(base_url() . 'upsell/free-digital-marketing-course');
		}
	}

	function lession()
	{
		$this->load->model('video_page_model', 'video');
		$session_id = session_id();
		$data['title'] = 'Lession';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['video'] = $this->video->get_all_intro_video();
		$this->load->view('front/include/header', $data);
		$this->load->view('front/lession_first');
		$this->load->view('front/include/footer');
	}

	function lession_1()
	{
		$this->load->model('video_page_model', 'video');
		$session_id = session_id();
		$data['title'] = 'Lession 1';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['all_video'] = $this->video->get_video_by_category_and_session_id($session_id);
		//print_r($data['all_video']);
		//exit();
		$this->load->view('front/include/header', $data);
		$this->load->view('front/lession');
		$this->load->view('front/include/footer');
	}

	function request_training_quotation()
	{
		$data = array(
			'class' => $this->input->post('class'),
			'name' => $this->input->post('name'),
			'email' => $this->input->post('email'),
			'mobile' => $this->input->post('mobile'),
			'course' => $this->input->post('course'),
			'date' => date('Y-m-d h:i:s'),
		);
		echo $this->user_model->request_training_quotation($data);
	}

	function request_call_back()
	{
		$data = array(
			'class' => $this->input->post('class'),
			'name' => $this->input->post('name'),
			'email' => $this->input->post('email'),
			'mobile' => $this->input->post('mobile'),
			'city' => $this->input->post('city'),
			'date' => date('Y-m-d'),
		);
		echo $this->user_model->request_call_back($data);
	}

	function course_details($slug)
	{
		$data['course'] = $this->course_model->get_course_by_slug($slug);
		$data['title'] = $data['course']->course_meta_title;
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();

		// $data['id_course'] = $this->course_model->get_course_by_rand_id($rand_id);
		// $data['count_course'] = $this->course_model->count_lession_by_course($data['id_course']->id);
		// $data['all_letest_course'] = $this->course_model->get_all_letest_course_for_course_page($data['id_course']->id);
		// $data['all_top_course'] = $this->course_model->get_all_letest_course_for_course_page_2($data['id_course']->id);
		$data['all_current_op'] = $this->frontend_model->get_all_career_opportunities_current_placements();
		$data['main_page'] = 'course_theme/' . $data['course']->course_theme;
		$this->load->view('front/index', $data);
	}

	public function course_category($slug)
	{
		$data['category'] = $this->category_model->get_category_by_cat_slug($slug);

		// Get filter values from GET request
		$categories = $this->input->get('category') ?? [];
		$types = $this->input->get('type') ?? [];

		// Ensure categories is always an array
		if (empty($categories)) {
			$categories = [$data['category']->id];
		}

		$data['title'] = $data['category']->name;
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['all_course'] = $this->course_model->get_filtered_courses($categories, $types);
		$data['all_category'] = $this->category_model->get_all_category_name();
		$data['main_page'] = 'course_category';

		// Load views
		$this->load->view('front/index', $data);
	}




	function submit_course_form()
	{
		$this->load->model('course_model', 'course');
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_flashdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			$this->course->submit_course_form();
			$this->session->set_flashdata('success', 'Redquest Successfully Send.');
			redirect($this->agent->referrer());
		}
	}

	function submit_reg_button()
	{
		$this->load->model('course_model', 'course');
		$this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			$this->course->add_course_reg();
			$this->session->set_userdata('success', 'Redquest Successfully Send.');
			redirect($this->agent->referrer());
		}
	}

	function about_us()
	{
		$data['title'] = 'About Us';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['content_1'] = $this->frontend_model->get_all_about_us_content_1();
		$data['content_2'] = $this->frontend_model->get_all_about_us_content_2_i();
		$data['content_2_i'] = $this->frontend_model->get_all_about_us_content_2_ii();
		$data['content_3'] = $this->frontend_model->get_all_about_us_content_3();
		$data['content_4_i'] = $this->frontend_model->get_all_about_us_content_4_i();
		$data['content_4_ii'] = $this->frontend_model->get_all_about_us_content_4_ii();
		$data['content_5'] = $this->frontend_model->get_all_about_us_content_5();
		$data['content_6_i'] = $this->frontend_model->get_all_about_us_content_6_i();
		$data['content_6_ii'] = $this->frontend_model->get_all_about_us_content_6_ii();
		$data['all_timeline'] = $this->frontend_model->get_all_about_us_content_timeline();
		$data['brain'] = $this->frontend_model->get_brain_behiend();
		$data['get_all_award'] = $this->frontend_model->get_all_about_us_content_award();
		$data['main_page'] = 'about';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');

	}

	function apply_free_trail_class()
	{
		$this->load->model('course_model', 'course');
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			$this->course->apply_free_trail_class();
			$this->session->set_userdata('success', 'Redquest Successfully Send.');
			redirect($this->agent->referrer());
		}
	}

	function request_demo_1()
	{
		$this->load->model('course_model', 'course');
		$this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			if ($this->course->request_demo_1()) {
				$this->session->set_userdata('success', 'Redquest Successfully Send.');
				redirect(base_url() . 'thank-you');
			} else {
				$this->session->set_userdata('error', "Category Added Faild");
				redirect($this->agent->referrer());
			}
		}
	}

	function apply_live_video_class_from_branch()
	{
		$this->load->model('course_model', 'course');
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			$this->course->apply_live_video_class_from_branch();
			$name = $this->input->post('f_name') . ' ' . $this->input->post('l_name');
			$this->session->set_userdata('upsell_name', $name);
			$this->session->set_userdata('upsell_email', $this->input->post('email'));
			$this->session->set_userdata('upsell_mob', $this->input->post('mobile'));
			// $session_id = session_id();
			// $this->video->submit_registration_form($session_id);
			redirect(base_url() . 'upsell/free-digital-marketing-course');

			// $this->session->set_userdata('success', 'Redquest Successfully Send.');
			// redirect($this->agent->referrer());
		}
	}

	function apply_demo_class_from_branch()
	{
		$this->load->model('course_model', 'course');
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			$this->course->apply_demo_class_from_branch();
			$this->session->set_userdata('success', 'Redquest Successfully Send.');
			redirect(base_url() . 'thank-you');
		}
	}

	function request_a_batch()
	{
		$this->load->model('course_model', 'course');
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			$this->course->request_a_batch();
			$this->session->set_userdata('success', 'Redquest Successfully Send.');
			redirect($this->agent->referrer());
		}
	}

	function get_price()
	{
		$this->load->model('course_model', 'course');
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			$this->course->get_price();
			$this->session->set_userdata('success', 'Redquest Successfully Send.');
			redirect($this->agent->referrer());
		}
	}

	function apply_new_reg()
	{
		$this->load->model('course_model', 'course');
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			$this->course->apply_new_reg();
			$this->session->set_userdata('success', 'Redquest Successfully Send.');
			redirect(base_url() . 'thank-you');
		}
	}

	function apply_customize_training()
	{
		$this->load->model('course_model', 'course');
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			$this->course->apply_customize_training();
			$this->session->set_userdata('success', 'Redquest Successfully Send.');
			redirect(base_url() . 'thank-you');
		}
	}

	function thank_you()
	{
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['page'] = $this->frontend_model->get_book_demo_thank_you_page();
		$data['heading'] = $this->frontend_model->get_all_heading_and_sub_heading();
		$this->load->view('front/include/header', $data);
		$this->load->view('front/thank_you');
		$this->load->view('front/include/footer');
	}

	function download_syllabus_pdf()
	{
		$this->load->model('course_model', 'course');
		if ($this->course->download_syllabus()) {
			$courses = $this->course->get_pdf_by_id_and_class($this->input->post('course'));


			echo base_url() . $courses->curriculum_pdf;
		}
	}

	function download_syllabus()
	{
		$this->load->model('course_model', 'course');
		// $this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		// $this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		// $this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		// $this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		// if ($this->form_validation->run() == FALSE)
		//       {
		//           $this->session->set_userdata('error', 'Required Filed Must be Filed');
		//          // redirect($this->agent->referrer());
		//       }
		//       else
		//       {
		if ($this->course->download_syllabus()) {
			$course = $this->course_model->get_syllabus_by_id_and_class($this->input->post('course'));

			if ($this->input->post('class') == 1) {
				echo base_url() . $course->syllabus;
			} else {
				echo base_url() . $course->online_syllabus;
				//$this->file_download(base_url().$course->online_syllabus, 'Syllabus.pdf');
			}
		}

		//}
	}

	function file_download($file_name, $name)
	{
		$this->load->helper('download');
		$data = file_get_contents($file_name);
		force_download($name, $data);
	}

	function submit_course_review()
	{
		$this->load->model('course_model', 'course');
		$this->form_validation->set_rules('rate', 'Rating', 'required|xss_clean');
		$this->form_validation->set_rules('comments', 'Comment', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			if ($this->course->submit_course_review()) {
				$this->session->set_userdata('success', 'Comment Successfull Submitted ');
				redirect($this->agent->referrer());
			} else {
				$this->session->set_userdata('error', 'Comment Submit Failed');
				redirect($this->agent->referrer());
			}
		}
	}

	function submit_branch_review()
	{
		$this->form_validation->set_rules('rate', 'Rating', 'required|xss_clean');
		$this->form_validation->set_rules('comments', 'Comment', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			if ($this->branch->submit_branch_review()) {
				$this->session->set_userdata('success', 'Comment Successfull Submitted ');
				redirect($this->agent->referrer());
			} else {
				$this->session->set_userdata('error', 'Comment Submit Failed');
				redirect($this->agent->referrer());
			}
		}
	}

	function apply_demo_video_class()
	{
		$this->load->model('course_model', 'course');
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			$this->course->apply_free_demo_class();
			$this->session->set_userdata('success', 'Redquest Successfully Send.');
			redirect($this->agent->referrer());
		}
	}

	function branch_details($id)
	{
		$data['branch'] = $this->branch->get_branch_by_id($id);
		$data['title'] = $data['branch']->name;
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();

		$data['testi_schedule'] = $this->branch->get_alltesti();
		//$data['count_course'] = $this->course_model->count_lession_by_course($data['id_course']->id);
		//$data['all_letest_course'] = $this->course_model->get_all_letest_course_for_course_page($data['id_course']->id);
		//$data['all_top_course'] = $this->course_model->get_all_letest_course_for_course_page_2($data['id_course']->id);
		$data['heading'] = $this->frontend_model->get_all_heading_and_sub_heading();
		$data['video_image'] = $this->frontend_model->get_front_video_image();
		$data['cta'] = $this->frontend_model->get_cta_content();
		$data['all_reviews'] = $this->branch->get_all_active_review_by_branch_id($data['branch']->id);
		$data['branch_id'] = $data['branch']->id;
		$data['main_page'] = 'branch_details';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');

		// echo '<pre>';
		// print_r($data['branch']);

	}

	function event_booking()
	{
		$this->form_validation->set_rules('name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			echo 401;
		} else {
			$data = $this->event_model->event_booking();
			if ($data) {
				redirect(base_url() . 'event/thank_you/' . $data);
			} else {
				echo 402;
			}
		}
	}

	public function all_products($slug)
	{
		$this->load->model('products_model');
		$data['title'] = 'Products';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['all_product'] = $this->products_model->get_all_products_with_category($slug);
		$data['main_page'] = 'all_product';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');

		//$this->load->view('home');
	}

	function product($slug)
	{
		// $this->load->model('products_model');
		// $data['title'] = 'Products';
		// $data['app_setting'] = $this->setting_model->get_all_app_setting();
		// $data['visual_setting'] = $this->setting_model->get_visual_setting();
		// $data['product'] = $this->products_model->get_prd_by_slug($slug);
		// $data['all_prd_fr_image'] = $this->products_model->get_all_front_image_by_prd_id($data['product']->prd_id);
		// $data['all_prd_bc_image'] = $this->products_model->get_all_back_image_by_prd_id($data['product']->prd_id);
		// $data['main_page'] = 'product/index';
		// $this->load->view('front/include/header', $data);
		// $this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');

	

		$data['title'] = 'Products';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['product'] = $this->Product_model->get_by_slug($slug);
		$data['sections'] = $this->Product_section_model->get_sections($data['product']['prd_id']);

		$this->load->view('front/'.$data['product']['prd_theme'].'/index', $data);

	}

	function request_for_product()
	{
		$this->load->model('products_model');
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		$this->form_validation->set_rules('pin_code', 'Pin Code', 'required|xss_clean');
		$this->form_validation->set_rules('address', 'Address', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			if ($this->input->post('prd_inq_id')) {
				$this->products_model->request_for_product_update($this->input->post('prd_inq_id'));
				$last_id = $this->input->post('prd_inq_id');
			} else {
				$last_id = $this->products_model->request_for_product();
			}
			if ($last_id) {
				$prd_details = $this->products_model->get_product_by_id($this->input->post('prd_id'));
				if ($prd_details->advance_payment) {
					$amount = $prd_details->advance_payment;
				} else {
					$amount = $this->input->post('price');
				}

				$app_setting = $this->setting_model->get_all_app_setting();
				$this->session->set_userdata('prd_name',  $this->input->post('f_name') . ' ' . $this->input->post('l_name'));
				$this->session->set_userdata('prd_email',  $this->input->post('email'));
				$this->session->set_userdata('prd_mobile',  $this->input->post('mobile'));
				$this->session->set_userdata('prd_id',  $this->input->post('prd_id'));
				$this->session->set_userdata('prd_price',  $this->input->post('price'));
				$this->session->set_userdata('prd_last_id',  $last_id);
				$this->session->set_userdata('package_id',  $this->input->post('package_id'));
				$rand = "RAOR" . date("Ymd") . rand(1000, 9999);
				$order_id = $rand;
				$api = new Api($app_setting->rozar_key_id, $app_setting->rozar_key_secret);
				$razorpayOrder = $api->order->create(array(
					'receipt'         => $order_id,
					'amount'          => $amount * 100,
					'currency'        => 'INR',
					'payment_capture' => 1
				));
				$amount = $razorpayOrder['amount'];
				$razorpayOrderId = $razorpayOrder['id'];
				$_SESSION['razorpay_order_id'] = $razorpayOrderId;
				$_SESSION['recharge_id'] = $order_id;
				$_SESSION['amount'] = $amount;
				$raz_pay_data = $this->rozr_pay_prepareData_prd_pay($amount, $razorpayOrderId, $order_id);
				$this->load->view('rezorpay_payment_prd_payment', array('data' => $raz_pay_data));
			} else {
				$this->session->set_userdata('error', 'Please try Again');
				redirect($this->agent->referrer());
			}
		}
	}

	function rozr_pay_verify_product_payment()
	{
		$app_setting = $this->setting_model->get_all_app_setting();
		$success = true;
		$error = "payment_failed";
		if (empty($_POST['razorpay_payment_id']) === false) {
			$api = new Api($app_setting->rozar_key_id, $app_setting->rozar_key_secret);
			try {
				$attributes = array(
					'razorpay_order_id' => $_SESSION['razorpay_order_id'],
					'razorpay_payment_id' => $_POST['razorpay_payment_id'],
					'razorpay_signature' => $_POST['razorpay_signature']
				);
				$api->utility->verifyPaymentSignature($attributes);
			} catch (SignatureVerificationError $e) {
				$success = false;
				$error = 'Razorpay_Error : ' . $e->getMessage();
			}
		}
		if ($success === true) {
			if ($this->session->userdata('prd_name')) {
				$this->load->model('products_model');
				$info['prd_inq_payment'] 					= 1;
				$info['prd_inq_pay_id'] 					= $_POST['razorpay_payment_id'];
				$info['prd_inq_pay_amount'] 				= $_SESSION['amount'] / 100;
				$info['package_id'] 						= $this->session->userdata('package_id');
				if ($this->products_model->update_request_prd_payment_data($info, $this->session->userdata('prd_last_id'))) {
					$this->session->set_userdata('success_page', 'Yes');
					$this->session->set_userdata('success', 'Wow ! Congrats,Your your order is Confirm with us');

					$password = rand();
					$data_payment = [
						'name' 			=> $this->session->userdata('prd_name'),
						'email' 		=> $this->session->userdata('prd_email'),
						'mobile' 		=> $this->session->userdata('prd_mobile'),
						'role' 			=> 'User',
						'password' 		=> hash("sha256", $password),
						'product' 		=> $this->session->userdata('prd_id'),
						'created_at'	=> date('Y-m-d h:i:s'),
						'prd_last_pay_id'	=> $this->session->userdata('prd_last_id')
					];
					if ($this->auth_model->insert_user_data_prd_payment($data_payment)) {
						$pw = $this->auth_model->check_password($this->session->userdata('prd_mobile'), $password);
						$rand = rand();
						$user = array(
							'bcount_sess_id' => $pw['id'],
							'bcount_sess_mobile' 	=> $this->session->userdata('prd_mobile'),
							'bcount_sess_email' 	=> $this->session->userdata('prd_email'),
							'bcount_sess_role' 		=> 'User',
							'bcount_sess_status' 	=> 'Active',
							'bcount_sess_logged_in' => true,
							'bcount_sess_token' 	=> rand(),
							'bcount_sess_app_id' 	=> $this->config->item('app_key')
						);
						$this->auth_model->active_token($pw['id'], $user['bcount_sess_token']);
						$this->auth_model->active_session_id($pw['id'], $rand);
						$this->session->set_userdata($user);
						redirect(base_url() . 'admin/admin/index');
					}

					// redirect(base_url().'thank-you/'.$this->session->userdata('prd_id'));
				} else {
					$this->session->set_userdata('error', 'Transaction Done But System Error. Please Contact Support Team.');
					redirect(base_url());
				}
			} else {
				$this->session->set_userdata('error', 'Transaction Done But System Error. Please Contact Support Team.');
				redirect(base_url());
			}
		} else {
			$this->session->set_userdata('error', 'Transaction Faild');
			redirect(base_url());
		}
	}

	public function rozr_pay_prepareData_prd_pay($amount, $razorpayOrderId, $order_id)
	{
		$app_setting = $this->setting_model->get_all_app_setting();
		$data = array(
			"key" => $app_setting->rozar_key_id,
			"amount" => $amount,
			"name" => $order_id,
			"description" => $app_setting->application_name,
			"image" => base_url() . $app_setting->header_logo,
			"prefill" => array(
				"name"  => $this->session->userdata('prd_name'),
				"email"  => $this->session->userdata('prd_email'),
				"contact" => $this->session->userdata('prd_mobile'),
			),
			"notes"  => array(
				"address"  => "Hello World",
				"merchant_order_id" => rand(),
			),
			"theme"  => array(
				"color"  => "#F37254"
			),
			"order_id" => $razorpayOrderId,
		);
		return $data;
	}

	function download_product_brochure()
	{
		$this->load->model('products_model', 'product');
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			// redirect($this->agent->referrer());
		} else {
			if ($this->product->download_product_brochure()) {
				$data = $this->product->get_browser_by_prd_id($this->input->post('prd_id'));
				echo base_url() . $data->brochure;
			}
		}
	}

	function request_for_product_admin_demo()
	{
		$this->load->model('products_model', 'product');
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('prd_adm_email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('prd_adm_mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			if ($this->product->request_for_product_admin_demo()) {
				$this->session->set_userdata('success_page', 'Yes');
				$this->session->set_userdata('success', 'Request Successfully Send');
				redirect(base_url() . 'thank-you/' . $this->input->post('prd_adm_prd_id'));
			} else {
				$this->session->set_userdata('error', 'Request Sending Failed');
				redirect($this->agent->referrer());
			}
		}
	}

	function thank_you_product($prd_id)
	{

		$this->load->model('products_model');
		$data['title'] = 'Thank You';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['page'] = $this->products_model->get_thank_you_page_details_by_prd_id($prd_id);
		// $this->load->view('front/include/header', $data);
		// $this->load->view('front/thank_you_product');
		// $this->load->view('front/include/footer');

		$data['main_page'] = 'thank_you_product';
		$this->load->view('front/index', $data);
	}

	function extra_page($slug)
	{

		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['page'] = $this->frontend_model->get_page_by_slug($slug);
		$data['title'] = $data['page']->name;
		$data['main_page'] = 'extra_page';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');

	}

	function spin_data()
	{
		$result = $this->db->get('spin_data')->result();
		header('Content-type: application/json');
		$res = [];
		foreach ($result as $key => $value) {
			$res[$key]["probability"] = 20;
			$res[$key]["type"] = "string";
			$res[$key]["value"] = $value->spin_text;
			$res[$key]["win"] = $value->spin_win;
			$res[$key]["resultText"] = $value->spin_result;
			$res[$key]["userData"] = array("score" => 10);
		}
		$data = [
			"colorArray" => ["#364C62", "#F1C40F", "#E67E22", "#E74C3C", "#95A5A6", "#16A085", "#27AE60", "#2980B9", "#8E44AD", "#2C3E50"],
			"segmentValuesArray" => $res,
			"svgWidth" => 1224,
			"svgHeight" => 768,
			"wheelStrokeColor" => "#D0BD0C",
			"wheelStrokeWidth" => 18,
			"wheelSize" => 660,
			"wheelTextOffsetY" => 80,
			"wheelTextColor" => "#EDEDED",
			"wheelTextSize" => "2.3em",
			"wheelImageOffsetY" => 40,
			"wheelImageSize" => 50,
			"centerCircleSize" => 360,
			"centerCircleStrokeColor" => "#F1DC15",
			"centerCircleStrokeWidth" => 12,
			"centerCircleFillColor" => "#EDEDED",
			"segmentStrokeColor" => "#E2E2E2",
			"segmentStrokeWidth" => 4,
			"centerX" => 622,
			"centerY" => 384,
			"hasShadows" => true,
			"numSpins" => 1,
			"spinDestinationArray" => [],
			"minSpinDuration" => 6,
			"gameOverText" => "I HOPE YOU ENJOYED",
			"invalidSpinText" => "INVALID SPIN. PLEASE SPIN AGAIN.",
			"introText" => "YOU HAVE TO<br>SPIN IT <span style='color:#F282A9;'>1</span> WIN IT!",
			"hasSound" => true,
			"gameId" => "9a0232ec06bc431114e2a7f3aea03bbe2164f1aa",
			"clickToSpin" => true,
			// "spinDirection" => "ccw",
			// "disabledText" => "You have no more spins today",

		];
		echo json_encode($data);
	}

	function add_spin_result()
	{
		$course_id = $this->session->userdata('course_id');
		$get_cookie = get_cookie('course_id_' . $course_id);
		if (!$get_cookie) {
			$cookie = array(
				'name'   => 'course_id_' . $course_id,
				'value'  => $this->input->post('win_count'),
				'expire' => strtotime("+1 year"),
				'prefix' => ''
			);
			$this->input->set_cookie($cookie);
		}
		return true;
	}

	function course_payment()
	{
		$app_setting = $this->setting_model->get_all_app_setting();
		$this->session->set_userdata('name',  $this->input->post('f_name') . ' ' . $this->input->post('l_name'));
		$this->session->set_userdata('email',  $this->input->post('email'));
		$this->session->set_userdata('mobile',  $this->input->post('mobile'));
		$this->session->set_userdata('branch',  $this->input->post('branch'));
		$this->session->set_userdata('course',  $this->input->post('course'));
		$this->session->set_userdata('class',  $this->input->post('class'));
		$this->session->set_userdata('price',  $this->input->post('price'));
		$rand = "RAOR" . date("Ymd") . rand(1000, 9999);
		$order_id = $rand;
		$amount = 1000;
		$api = new Api($app_setting->rozar_key_id, $app_setting->rozar_key_secret);
		$razorpayOrder = $api->order->create(array(
			'receipt'         => $order_id,
			'amount'          => $amount * 100,
			'currency'        => 'INR',
			'payment_capture' => 1
		));
		$amount = $razorpayOrder['amount'];
		$razorpayOrderId = $razorpayOrder['id'];
		$_SESSION['razorpay_order_id'] = $razorpayOrderId;
		$_SESSION['recharge_id'] = $order_id;
		$_SESSION['amount'] = $amount;
		$raz_pay_data = $this->rozr_pay_prepareData($amount, $razorpayOrderId, $order_id);
		$this->load->view('rezorpay_payment', array('data' => $raz_pay_data));
	}

	public function rozr_pay_prepareData($amount, $razorpayOrderId, $order_id)
	{
		$app_setting = $this->setting_model->get_all_app_setting();
		$data = array(
			"key" => $app_setting->rozar_key_id,
			"amount" => $amount,
			"name" => $order_id,
			"description" => $app_setting->application_name,
			"image" => base_url() . $app_setting->header_logo,
			"prefill" => array(
				"name"  => $this->session->userdata('name'),
				"email"  => $this->session->userdata('email'),
				"contact" => $this->session->userdata('mobile'),
			),
			"notes"  => array(
				"address"  => "Hello World",
				"merchant_order_id" => rand(),
			),
			"theme"  => array(
				"color"  => "#F37254"
			),
			"order_id" => $razorpayOrderId,
		);
		return $data;
	}

	function rozr_pay_verify_course_payment()
	{
		$app_setting = $this->setting_model->get_all_app_setting();
		$success = true;
		$error = "payment_failed";
		if (empty($_POST['razorpay_payment_id']) === false) {
			$api = new Api($app_setting->rozar_key_id, $app_setting->rozar_key_secret);
			try {
				$attributes = array(
					'razorpay_order_id' => $_SESSION['razorpay_order_id'],
					'razorpay_payment_id' => $_POST['razorpay_payment_id'],
					'razorpay_signature' => $_POST['razorpay_signature']
				);
				$api->utility->verifyPaymentSignature($attributes);
			} catch (SignatureVerificationError $e) {
				$success = false;
				$error = 'Razorpay_Error : ' . $e->getMessage();
			}
		}
		if ($success === true) {
			$info['name'] 				= $this->session->userdata('name');
			$info['email'] 				= $this->session->userdata('email');
			$info['mobile'] 			= $this->session->userdata('mobile');
			$info['branch_id'] 			= $this->session->userdata('branch');
			$info['course'] 			= $this->session->userdata('course');
			$info['course_type'] 		= $this->session->userdata('class');
			$info['payment_amount'] 	= 1000;
			$info['created_at'] 		= date('Y-m-d h:i:s');
			$info['status'] 			= 'Active';
			$info['role'] 				= 'Student';
			if ($this->user_model->add_course_reg_student($info)) {
				$this->session->set_userdata('success', "Registration Successfull Complete. Please Contact Selected Branch");
				redirect(base_url());
			} else {
				$this->session->set_userdata('error', 'Transaction Done But Registration Failed. Please Contact Selected Branch.');
				redirect(base_url());
			}
		} else {
			$this->session->set_userdata('error', 'Transaction Faild');
			// redirect(base_url());
		}
	}

	function contact()
	{
		$data['title'] = 'Contact';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'contact';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function submit_contact_form()
	{
		$this->form_validation->set_rules('contact_name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('contact_email', 'Email', 'required|xss_clean');
		$this->form_validation->set_rules('contact_mobile', 'mobile', 'required|xss_clean');
		$this->form_validation->set_rules('contact_msg', 'Message', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			if ($this->setting_model->submit_contact_form()) {
				$this->session->set_userdata('success', 'Request Successfull Submitted');
				redirect($this->agent->referrer());
			} else {
				$this->session->set_userdata('error', 'Request Submit Failed');
				redirect($this->agent->referrer());
			}
		}
	}

	function ebook($id)
	{
		$data['title'] = 'Contact';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['slug'] = $id;
		$this->load->view('front/include/header', $data);
		$this->load->view('front/view_for_ebook');
		$this->load->view('front/include/footer');
	}

	function upsell_page($slug)
	{
		$this->load->model('upsell_model', 'upsell');
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['page'] = $this->upsell->get_page_by_slug($slug);
		$data['all_pass_details'] = $this->upsell->all_pass_details_by_page_id($data['page']->page_id);
		$data['slug'] = $slug;
		$this->load->view('front/include/header', $data);
		$this->load->view('front/upsell_page');
		$this->load->view('front/include/footer');
	}

	function upsell_thank_you_page($slug)
	{
		$this->load->model('upsell_model', 'upsell');
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['page'] = $this->upsell->get_thank_page_by_slug($slug);
		$this->load->view('front/include/header', $data);
		$this->load->view('front/upsell_thank_you_page');
		$this->load->view('front/include/footer');
	}

	function upsell_thank_you_page_page($slug)
	{
		$name = $this->session->userdata('upsell_name');
		$email = $this->session->userdata('upsell_email');
		$mob = $this->session->userdata('upsell_mob');
		if ($name) {
			redirect('https://academy.dotcomvidya.com/login/register_api?name=' . $name . '&email=' . $email . '&mob=' . $mob);
		} else {
			redirect(base_url() . 'upsell/' . $slug);
		}
	}

	function upsell_payment($slug)
	{
		$name = $this->session->userdata('upsell_name');
		$email = $this->session->userdata('upsell_email');
		$mob = $this->session->userdata('upsell_mob');
		if ($name) {
			$this->load->model('upsell_model', 'upsell');
			$data = $this->upsell->get_page_by_slug($slug);
			if ($data) {
				$app_setting = $this->setting_model->get_all_app_setting();
				$this->session->set_userdata('upsell_id', $data->page_id);
				if ($data->page_discount_price) {
					$amount = $data->page_discount_price;
				} else {
					$amount = $data->page_main_price;
				}
				$rand = "RAOR" . date("Ymd") . rand(1000, 9999);
				$order_id = $rand;
				$api = new Api($app_setting->rozar_key_id, $app_setting->rozar_key_secret);
				$razorpayOrder = $api->order->create(array(
					'receipt'         => $order_id,
					'amount'          => $amount * 100,
					'currency'        => 'INR',
					'payment_capture' => 1
				));
				$amount = $razorpayOrder['amount'];
				$razorpayOrderId = $razorpayOrder['id'];
				$_SESSION['razorpay_order_id'] = $razorpayOrderId;
				$_SESSION['recharge_id'] = $order_id;
				$_SESSION['amount'] = $amount;
				$raz_pay_data = $this->rozr_pay_prepareData_2($amount, $razorpayOrderId, $order_id);
				$this->load->view('rezorpay_payment_by_upsell', array('data' => $raz_pay_data));
			} else {
				redirect(base_url());
			}
		} else {
			redirect(base_url() . 'upsell/' . $slug);
		}
	}

	public function rozr_pay_prepareData_2($amount, $razorpayOrderId, $order_id)
	{
		$app_setting = $this->setting_model->get_all_app_setting();
		$data = array(
			"key" => $app_setting->rozar_key_id,
			"amount" => $amount,
			"name" => $order_id,
			"description" => $app_setting->application_name,
			"image" => base_url() . $app_setting->header_logo,
			"prefill" => array(
				"name"  => $this->session->userdata('upsell_name'),
				"email"  => $this->session->userdata('upsell_email'),
				"contact" => $this->session->userdata('upsell_mob'),
			),
			"notes"  => array(
				"address"  => "Hello World",
				"merchant_order_id" => rand(),
			),
			"theme"  => array(
				"color"  => "#F37254"
			),
			"order_id" => $razorpayOrderId,
		);
		return $data;
	}

	function rozr_pay_verify_upsell_payment()
	{
		$app_setting = $this->setting_model->get_all_app_setting();
		$success = true;
		$error = "payment_failed";
		if (empty($_POST['razorpay_payment_id']) === false) {
			$api = new Api($app_setting->rozar_key_id, $app_setting->rozar_key_secret);
			try {
				$attributes = array(
					'razorpay_order_id' => $_SESSION['razorpay_order_id'],
					'razorpay_payment_id' => $_POST['razorpay_payment_id'],
					'razorpay_signature' => $_POST['razorpay_signature']
				);
				$api->utility->verifyPaymentSignature($attributes);
			} catch (SignatureVerificationError $e) {
				$success = false;
				$error = 'Razorpay_Error : ' . $e->getMessage();
			}
		}
		if ($success === true) {
			if ($this->session->userdata('upsell_name')) {
				$this->load->model('upsell_model', 'upsell');
				$info['upsell_pay_name'] 			= $this->session->userdata('upsell_name');
				$info['upsell_pay_email'] 			= $this->session->userdata('upsell_email');
				$info['upsell_pay_mob'] 			= $this->session->userdata('upsell_mob');
				$info['upsell_pay_page_id'] 		= $this->session->userdata('upsell_id');
				$info['upsell_pay_pay_id'] 			= $_POST['razorpay_payment_id'];
				$info['upsell_pay_amount'] 			= $_SESSION['amount'] / 100;
				$info['upsell_pay_date'] 			= date('Y-m-d');
				if ($this->upsell->add_upsell_payment_data($info)) {
					redirect('https://academy.dotcomvidya.com/login/register_api?name=' . $this->session->userdata('upsell_name') . '&email=' . $this->session->userdata('upsell_email') . '&mob=' . $this->session->userdata('upsell_mob'));
				} else {
					$this->session->set_userdata('error', 'Transaction Done But Registration Failed. Please Contact Support Team.');
					redirect(base_url());
				}
			} else {
				$this->session->set_userdata('error', 'Transaction Done But Registration Failed. Please Contact Support Team.');
				redirect(base_url());
			}
		} else {
			$this->session->set_userdata('error', 'Transaction Faild');
			redirect(base_url());
		}
	}

	public function add_prd_wlcome_form_inq_data()
	{
		$this->form_validation->set_rules('inq_name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('inq_email', 'Email', 'required|xss_clean');
		$this->form_validation->set_rules('inq_mob', 'mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			$this->load->model('products_model', 'product');
			if ($this->product->add_prd_wlcome_form_inq_data()) {

				$this->load->helper('cookie');
				$cookie = array(
					'name'   => 'prd_inq',
					'value'  => '557528',
					'expire' => '86400',
					'secure' => TRUE
				);

				$this->input->set_cookie($cookie, TRUE);
				redirect($this->agent->referrer());
			} else {
				$this->session->set_userdata('error', 'Data Submit Failed. Please try Again');
				redirect($this->agent->referrer());
			}
		}
	}

	function add_new_subscriber()
	{
		$this->load->model('subscriber_model', 'subscriber');

		$data['email'] = $this->input->post('email');
		$data['date'] = date('Y-m-d');

		if ($this->subscriber->subscriber_entry($data)) {
			$this->session->set_userdata('success', 'You are Now Our Subscriber');
			redirect($this->agent->referrer());
		} else {
			$this->session->set_userdata('error', 'Email Id Already Exits');
			redirect($this->agent->referrer());
		}
	}

	function serp_preview_tool()
	{
		$data['title'] = 'SERP Preview Tools';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'serp_preview_tool';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function get_pin_code_details($pin_code)
	{
		$this->load->library('shiprocket');
		$post['postcode'] = $pin_code;
		$pin_code_details = $this->shiprocket->postcode($post);

		$area = '';
		foreach ($pin_code_details['postcode_details']['locality'] as $key => $value) {
			$area .= '<option value="' . $value . '">' . $value . '</option>';
		}
		$output = [
			'city' => $pin_code_details['postcode_details']['city'],
			'state' => $pin_code_details['postcode_details']['state'],
			'area' => $area,
		];

		echo json_encode($output);
	}

	function submit_check_out($prd_id, $price, $package)
	{
		$this->session->set_userdata('checkout_prd',  $prd_id);
		$this->session->set_userdata('checkout_prd_price',  $price);
		$this->session->set_userdata('checkout_prd_package_id',  $package);

		redirect(base_url() . 'checkout');
	}

	function checkout_page()
	{
		if ($this->session->userdata('checkout_prd')) {
			$data['app_setting'] = $this->setting_model->get_all_app_setting();
			$data['visual_setting'] = $this->setting_model->get_visual_setting();
			$data['page'] = $this->frontend_model->get_book_demo_thank_you_page();
			$this->load->view('front/include/header', $data);
			$this->load->view('front/checkout_page');
			$this->load->view('front/include/footer');
		} else {
			redirect($this->agent->referrer());
		}
	}

	function online_slug_generator()
	{
		$data['title'] = 'Online Slug Generator';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'online_slug_generator';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function xml_sitemap_generator()
	{
		$data['title'] = 'Sitemap Generator';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'xml_sitemap_generator';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function utm_builder()
	{
		$data['title'] = 'UTM Builder';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'utm_builder';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function generate_sitemap()
	{
		include "sitemap-generator.php";
		$url 				= $this->input->post('url');
		$last_modification 	= $this->input->post('last_modification');
		$changefreq 		= $this->input->post('changefreq');
		$priority 			= $this->input->post('priority');

		$smg = new SitemapGenerator($this->data($url, $last_modification, $changefreq, $priority));
		$data = $smg->GenerateSitemap();

		echo $data;
	}

	function data($url, $last_modification, $changefreq, $priority)
	{
		return array(
			// Site to crawl and create a sitemap for.
			// <Syntax> https://www.your-domain-name.com/ or http://www.your-domain-name.com/
			"SITE_URL" => $url,

			// Boolean for crawling external links.
			// <Example> *Domain = https://www.student-laptop.nl* , *Link = https://www.google.com* <When false google will not be crawled>
			"ALLOW_EXTERNAL_LINKS" => false,

			// Boolean for crawling element id links.
			// <Example> <a href="#section"></a> will not be crawled when this option is set to false
			"ALLOW_ELEMENT_LINKS" => false,

			// If set the crawler will only index the anchor tags with the given id.
			// If you wish to crawl all links set the value to ""
			// <Example> <a id="internal-link" href="/info"></a> When CRAWL_ANCHORS_WITH_ID is set to "internal-link" this link will be crawled
			// but <a id="external-link" href="https://www.google.com"></a> will not be crawled.
			"CRAWL_ANCHORS_WITH_ID" => "",

			// Array with absolute links or keywords for the pages to skip when crawling the given SITE_URL.
			// <Example> https://student-laptop.nl/info/laptops or you can just input student-laptop.nl/info/ and it will not crawl anything in that directory
			// Try to be as specific as you can so you dont skip 300 pages
			"KEYWORDS_TO_SKIP" => array(),

			// Location + filename where the sitemap will be saved.
			"SAVE_LOC" => "sitemap.xml",

			// Static priority value for sitemap
			"PRIORITY" => $priority,

			// Static update frequency
			"CHANGE_FREQUENCY" => $changefreq,

			// Date changed (today's date)
			"LAST_UPDATED" => $last_modification,
		);
	}

	function video_form_submit()
	{
		$this->load->model('products_model', 'product');
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			// redirect($this->agent->referrer());
		} else {
			echo $this->product->video_form_submit();
		}
	}

	function data_saved_for_first_pay()
	{
		$this->load->model('products_model', 'product');
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			// redirect($this->agent->referrer());
		} else {
			echo $this->product->data_saved_for_first_pay();
		}
	}

	function website_word_counter()
	{
		$data['title'] = 'Website Word Counter';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'website_word_counter';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}


	function get_website_content()
	{
		$contents = file_get_contents($this->input->post('url'));
		$search = array(
			'@<script[^>]*?>.*?</script>@si',
			'@<head>.*?</head>@siU',
			'@<style[^>]*?>.*?</style>@siU',
			'@<![\s\S]*?--[ \t\n\r]*>@'
		);
		$contents = preg_replace($search, '', $contents);
		$result = array_count_values(
			str_word_count(
				strip_tags($contents),
				1
			)
		);
		echo array_sum($result);
	}

	function character_counter()
	{
		$data['title'] = 'Character Counter';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'character_counter';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function testimonial($slug)
	{
		$data['title'] = 'Testimonial';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['testimonial'] = $this->frontend_model->get_all_cat_with_testi_image_by_id($slug);
		$this->load->view('front/include/header', $data);
		$this->load->view('front/testimonial');
		$this->load->view('front/include/footer');
	}

	function speed_test()
	{
		$data['title'] = 'Speed test';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'speed_test';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function up_batch_payment($id, $batch_id)
	{
		$this->db->select('id, title, course_adv_payment, slug');
		$this->db->where('rand_id', $id);
		$course_details = $this->db->get('course')->row();
		$this->session->set_userdata('b_course_id',  $course_details->id);
		$this->session->set_userdata('b_course_name',  $course_details->title);
		$this->session->set_userdata('b_course_payment',  $course_details->course_adv_payment);
		$this->session->set_userdata('b_course_batch_id',  $batch_id);
		redirect(base_url() . 'asb/' . $course_details->slug . '/' . $batch_id);
	}

	function checkout_batch_payment($slug, $batch_id)
	{
		if (!$this->session->userdata('b_course_id')) {
			$this->db->select('id, title, course_adv_payment, slug');
			$this->db->where('slug', $slug);
			$course_details = $this->db->get('course')->row();
			$this->session->set_userdata('b_course_id',  $course_details->id);
			$this->session->set_userdata('b_course_name',  $course_details->title);
			$this->session->set_userdata('b_course_payment',  $course_details->course_adv_payment);
			$this->session->set_userdata('b_course_batch_id',  $batch_id);
		}
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['page'] = $this->frontend_model->get_book_demo_thank_you_page();
		$this->load->view('front/include/header', $data);
		$this->load->view('front/checkout_batch_page');
		$this->load->view('front/include/footer');
	}

	function request_for_course()
	{
		$this->load->model('products_model');
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		$this->form_validation->set_rules('pin_code', 'Pin Code', 'required|xss_clean');
		$this->form_validation->set_rules('address', 'Address', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			// if($this->input->post('prd_inq_id'))
			// {
			// 	$this->products_model->request_for_product_update($this->input->post('prd_inq_id'));
			// 	$last_id = $this->input->post('prd_inq_id');
			// }
			// else
			// {
			// 	$last_id = $this->products_model->request_for_product();
			// }
			$last_id = $this->course_model->add_for_course_pay_data();
			if ($last_id) {
				$this->db->select('id,title, online_training_has_discount, online_training_price, online_training_discount, course_adv_payment');
				$this->db->where('id', $this->session->userdata('b_course_id'));
				$course = $this->db->get('course')->row();

				if ($course->course_adv_payment) {
					if ($course->online_training_has_discount == 1) {
						$amt = $course->online_training_discount;
						$amount = $course->course_adv_payment;
						$rest = $course->online_training_discount - $course->course_adv_payment;
					} else {
						$amt = $course->online_training_price;
						$amount = $course->course_adv_payment;
						$rest = $course->online_training_price - $course->course_adv_payment;
					}
				} else {
					if ($course->online_training_has_discount == 1) {
						$amt = $course->online_training_discount;
						$amount = $course->online_training_discount;
						$rest = 0;
					} else {
						$amt = $course->online_training_price;
						$amount = $course->online_training_price;
						$rest = 0;
					}
				}

				$app_setting = $this->setting_model->get_all_app_setting();
				$this->session->set_userdata('c_user_name',  $this->input->post('f_name') . ' ' . $this->input->post('l_name'));
				$this->session->set_userdata('user_email',  $this->input->post('email'));
				$this->session->set_userdata('user_mobile',  $this->input->post('mobile'));
				$this->session->set_userdata('course_id',  $this->input->post('course_id'));
				$this->session->set_userdata('course_price',  $amount);
				$this->session->set_userdata('course_name',  $course->title);
				$this->session->set_userdata('course_last_id',  $last_id);

				$this->session->set_userdata('branch_id',  $this->input->post('branch'));
				// $this->session->set_userdata('course_id',  $this->input->post('batch_time'));
				// $this->session->set_userdata('course_id',  $this->input->post('branch'));
				// $this->session->set_userdata('course_id',  $this->input->post('course_id'));

				$rand = "RAOR" . date("Ymd") . rand(1000, 9999);
				$order_id = $rand;
				$api = new Api($app_setting->rozar_key_id, $app_setting->rozar_key_secret);
				$razorpayOrder = $api->order->create(array(
					'receipt'         => $order_id,
					'amount'          => $amount * 100,
					'currency'        => 'INR',
					'payment_capture' => 1
				));
				$amount = $razorpayOrder['amount'];
				$razorpayOrderId = $razorpayOrder['id'];
				$_SESSION['razorpay_order_id'] = $razorpayOrderId;
				$_SESSION['recharge_id'] = $order_id;
				$_SESSION['amount'] = $amount;
				$raz_pay_data = $this->rozr_pay_prepareData_course_pay($amount, $razorpayOrderId, $order_id);
				$this->load->view('rezorpay_payment_course_payment', array('data' => $raz_pay_data));
			} else {
				$this->session->set_userdata('error', 'Please try Again');
				redirect($this->agent->referrer());
			}
		}
	}

	function rozr_pay_verify_payment_course()
	{
		$app_setting = $this->setting_model->get_all_app_setting();
		$success = true;
		$error = "payment_failed";
		if (empty($_POST['razorpay_payment_id']) === false) {
			$api = new Api($app_setting->rozar_key_id, $app_setting->rozar_key_secret);
			try {
				$attributes = array(
					'razorpay_order_id' => $_SESSION['razorpay_order_id'],
					'razorpay_payment_id' => $_POST['razorpay_payment_id'],
					'razorpay_signature' => $_POST['razorpay_signature']
				);
				$api->utility->verifyPaymentSignature($attributes);
			} catch (SignatureVerificationError $e) {
				$success = false;
				$error = 'Razorpay_Error : ' . $e->getMessage();
			}
		}
		if ($success === true) {
			if ($this->session->userdata('course_name')) {
				$info['course_inq_payment'] 				= 1;
				$info['course_inq_pay_id'] 					= $_POST['razorpay_payment_id'];
				$info['course_inq_pay_amount'] 				= $_SESSION['amount'] / 100;
				if ($this->course_model->update_request_course_payment_data($info, $this->session->userdata('course_last_id'))) {
					$this->session->set_userdata('success_page', 'Yes');
					$this->session->set_userdata('success', 'Wow ! Congrats,Your your order is Confirm with us');

					$password = rand();
					$data_payment = [
						'name' 					=> $this->session->userdata('c_user_name'),
						'email' 				=> $this->session->userdata('user_email'),
						'mobile' 				=> $this->session->userdata('user_mobile'),
						'role' 					=> 'User',
						'password' 				=> hash("sha256", $password),
						'course' 				=> $this->session->userdata('course_id'),
						'created_at'			=> date('Y-m-d h:i:s'),
						'course_pay_last_id'	=> $this->session->userdata('course_last_id'),
						'branch_id'				=> $this->session->userdata('branch_id'),
					];
					if ($this->auth_model->insert_user_data_prd_payment($data_payment)) {
						$pw = $this->auth_model->check_password($this->session->userdata('user_mobile'), $password);
						$rand = rand();
						$user = array(
							'bcount_sess_id' 		=> $pw['id'],
							'bcount_sess_mobile' 	=> $this->session->userdata('user_mobile'),
							'bcount_sess_email' 	=> $this->session->userdata('user_email'),
							'bcount_sess_role' 		=> 'User',
							'bcount_sess_status' 	=> 'Active',
							'bcount_sess_logged_in' => true,
							'bcount_sess_token' 	=> rand(),
							'bcount_sess_app_id' 	=> $this->config->item('app_key')
						);
						$this->auth_model->active_token($pw['id'], $user['bcount_sess_token']);
						$this->auth_model->active_session_id($pw['id'], $rand);
						$this->session->set_userdata($user);
						redirect(base_url() . 'admin/admin/index');
					}

					// redirect(base_url().'thank-you/'.$this->session->userdata('prd_id'));
				} else {
					$this->session->set_userdata('error', 'Transaction Done But System Error. Please Contact Support Team.');
					// redirect(base_url());
				}
			} else {
				$this->session->set_userdata('error', 'Transaction Done But System Error. Please Contact Support Team.');
				// redirect(base_url());
			}
		} else {
			$this->session->set_userdata('error', 'Transaction Faild');
			redirect(base_url());
		}
	}

	public function rozr_pay_prepareData_course_pay($amount, $razorpayOrderId, $order_id)
	{
		$app_setting = $this->setting_model->get_all_app_setting();
		$data = array(
			"key" => $app_setting->rozar_key_id,
			"amount" => $amount,
			"name" => $order_id,
			"description" => $app_setting->application_name,
			"image" => base_url() . $app_setting->header_logo,
			"prefill" => array(
				"name"  => $this->session->userdata('user_name'),
				"email"  => $this->session->userdata('user_email'),
				"contact" => $this->session->userdata('user_mobile'),
			),
			"notes"  => array(
				"address"  => "Hello World",
				"merchant_order_id" => rand(),
			),
			"theme"  => array(
				"color"  => "#F37254"
			),
			"order_id" => $razorpayOrderId,
		);
		return $data;
	}
	function image_compress()
	{
		$data['title'] = 'Image Compressor';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'image_compress';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	// function compress_image()
	// {
	// 	if(!empty($_FILES['image']['name']))
	//        {
	//        	$img_nme = uniqid().$_FILES['image']['name'];
	//            $this->load->library('image_lib');
	//            $_FILES['file']['name'] = $_FILES['image']['name'];
	//            $_FILES['file']['type'] = $_FILES['image']['type'];
	//            $_FILES['file']['tmp_name'] = $_FILES['image']['tmp_name'];
	//            $_FILES['file']['error'] = $_FILES['image']['error'];
	//            $_FILES['file']['size'] = $_FILES['image']['size'];

	//            // Set preference
	//            $config['upload_path'] = 'uploads/'; 
	//            $config['allowed_types'] = 'jpg|jpeg|png|gif|svg';
	//            $config['max_size'] = '20000'; // max_size in kb
	//            $config['file_name'] = $img_nme;
	//            $this->load->library('upload',$config); 
	//            $this->upload->initialize($config);

	//            // File upload
	//            if($this->upload->do_upload('file'))
	//            {
	//            	$data = getimagesize('uploads/'.$img_nme);

	//            	$w = $data[0]; 
	//    			$h = $data[1]; 
	//    			$n_w = $data[0];
	//    			$n_h = $data[1];
	//    			$source_ratio = $w / $h;
	//    			$new_ratio = $n_w / $n_h;
	//              	$uploadData = $this->upload->data();
	//              	if($source_ratio != $new_ratio)
	//              	{
	//              		$config['image_library'] = 'gd2';
	//              		$config['source_image'] = $uploadData['full_path'];
	//              		$config['maintain_ratio'] = FALSE;

	//              		if($new_ratio > $source_ratio || (($new_ratio == 1) && ($source_ratio < 1))){
	// 		            $config['width'] = $w;
	// 		            $config['height'] = round($w/$new_ratio);
	// 		            $config['y_axis'] = round(($h - $config['height'])/2);
	// 		            $config['x_axis'] = 0;

	// 		        } else {

	// 		            $config['width'] = round($h * $new_ratio);
	// 		            $config['height'] = $h;
	// 		            $size_config['x_axis'] = round(($w - $config['width'])/2);
	// 		            $size_config['y_axis'] = 0;
	// 		        }
	// 		        $this->image_lib->initialize($config);
	//    				$this->image_lib->crop();
	//    				$this->image_lib->clear();
	//              	}
	//              	$config['image_library'] = 'gd2';
	// 		    $config['source_image'] = $uploadData['full_path'];
	// 		    $config['new_image'] = $uploadData['full_path'];
	// 		    $config['maintain_ratio'] = TRUE;
	// 		    $config['width'] = $n_w;
	// 		    $config['height'] = $n_h;
	//              	$this->image_lib->initialize($config);
	//              	 if (!$this->image_lib->resize()){
	// 		        echo $this->image_lib->display_errors();
	// 		    } else {

	// 		        echo base_url().'uploads/'.$uploadData['file_name'];

	// 		    }

	//                  // $configer =  array(
	//                  //   'image_library'   => 'gd2',
	//                  //   'source_image'    =>  ,
	//                  //   'maintain_ratio'  =>  true,
	//                  //   'quality'         =>  10,
	//                  //   'width'           =>   - 100,
	//                  //   'height'          =>  - 100,
	//                  // );

	//                  // $this->image_lib->initialize($configer);
	//                  // $this->image_lib->crop();
	//                  // $this->image_lib->clear();
	//            }

	//        }

	// }

	function compress_image()
	{
		$uploadTo 		= "uploads/";
		$allowImageExt 	= array('jpg', 'png', 'jpeg', 'gif', 'PNG', 'svg');
		$imageName 		= $_FILES['image']['name'];
		$tempPath		= $_FILES["image"]["tmp_name"];
		$imageQuality	= 60;
		$basename 		= basename($imageName);
		$originalPath 	= $uploadTo . $basename;
		$imageExt 		= pathinfo($originalPath, PATHINFO_EXTENSION);
		$main_size		= filesize($_FILES['image']['tmp_name']);

		if (empty($imageName)) {
			$error = "Please Select files..";
			echo $error;
		} elseif (($_FILES['image']['size'] >= 5097152) || ($_FILES["image"]["size"] == 0)) {
			echo 'File too large. File must be less than 5 megabytes.';
		} else {

			if (in_array($imageExt, $allowImageExt)) {
				$compressedImage = $this->compress_image_data($tempPath, $originalPath, $imageQuality);
				if ($compressedImage) {

					$sizeMain = round($main_size / 1024);
					$sizeSecond = round(filesize($compressedImage) / 1024);
					$per = (($sizeMain - $sizeSecond) * 100) / $sizeMain;
					echo '<div class="row text-center mt-5">
						<div class="col-sm-12">
							<a href="' . base_url() . 'uploads/' . $imageName . '" download class="btn btn-lg text-white"><i class="fa fa-download"></i> &nbsp;Download Compressd Image</a>
						</div>
					</div>
					<div class="row  mt-5">
						<div class="col-sm-12 text-center">
							<h5 style="font-weight:400">Your Images are now ' . substr($per, 0, 2) . '% smaller!</h5>
							<h5><b>' . $sizeMain . ' KB to ' . $sizeSecond . ' KB</b></h5>
							<div class="bg-white rounded-lg p-5 shadow">
						        <h2 class="h6 font-weight-bold text-center mb-4">Overall Saved</h2>
					        	<div class="progress mx-auto" data-value="' . substr($per, 0, 2) . '">
						          	<span class="progress-left">
						            	<span class="progress-bar border-primary"></span>
						          	</span>
						          	<span class="progress-right">
						            	<span class="progress-bar border-primary"></span>
						          	</span>
						          	<div class="progress-value w-100 h-100 rounded-circle d-flex align-items-center justify-content-center">
						            	<div class="h2 font-weight-bold">' . substr($per, 0, 2) . '<sup class="small">%</sup></div>
						          	</div>
						        </div>
					      	</div>
						</div>
					</div>';
				} else {
					echo 4;
				}
			} else {
				echo 3;
			}
		}
	}
	function compress_image_data($tempPath, $originalPath, $imageQuality)
	{

		// Get image info 
		$imgInfo = getimagesize($tempPath);
		$mime = $imgInfo['mime'];

		// Create a new image from file 
		switch ($mime) {
			case 'image/jpeg':
				$image = imagecreatefromjpeg($tempPath);
				break;
			case 'image/png':
				$image = imagecreatefrompng($tempPath);
				break;
			case 'image/PNG':
				$image = imagecreatefrompng($tempPath);
				break;
			case 'image/gif':
				$image = imagecreatefromgif($tempPath);
				break;
			default:
				$image = imagecreatefromjpeg($tempPath);
		}

		// Save image 
		imagejpeg($image, $originalPath, $imageQuality);
		imagejpeg($image, $originalPath, $imageQuality);
		imagejpeg($image, $originalPath, $imageQuality);
		imagejpeg($image, $originalPath, $imageQuality);
		// Return compressed image 
		return $originalPath;
	}

	function google_ad_preview()
	{
		$data['title'] = 'Google Ad Preview';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'google_ad_preview';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function twitter_post_counting_tool()
	{
		$data['title'] = 'Twitter Post Counting Tool';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'twitter_post_counting_tool';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function all_branch()
	{
		$data['title'] = 'All Branch';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['heading'] = $this->frontend_model->get_all_heading_and_sub_heading();
		$data['main_page'] = 'all_branch';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function get_dist_by_state_id()
	{
		echo $this->user_model->get_dist_by_state_id($this->input->post('state'));
	}

	function get_area_by_dist_id()
	{
		echo $this->user_model->get_area_by_dist_id($this->input->post('dist'));
	}

	function get_branch_by_area()
	{
		echo $this->user_model->get_branch_by_area($this->input->post('area'));
	}

	function all_faq()
	{
		$this->load->model('faq_model');
		$data['title'] = 'FAQ';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['get_all_faq_category'] = $this->faq_model->get_all_faq_category();
		$this->load->view('front/include/header', $data);
		$this->load->view('front/all_faq');
		$this->load->view('front/include/footer');
	}

	function daya_free_live_class($slug)
	{
		$data['title'] = '7 Days Free Live Class';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['slug'] = $slug;
		$this->load->view('front/include/header', $data);
		$this->load->view('front/daya_free_live_class');
		$this->load->view('front/include/footer');
	}

	function google_algorithm_guide()
	{
		$data['title'] = 'Google Algorithm Guide';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['all_google_guide'] = $this->frontend_model->get_all_google_guide();
		$data['heading'] = $this->frontend_model->get_all_heading_and_sub_heading();
		$data['main_page'] = 'google_algorithm_guide';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}
	function apply_new_reg_live_class()
	{
		$this->load->model('live_class_page_model', 'live');
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			if ($this->live->apply_new_reg_live_class()) {
				redirect(base_url() . "thank-you-trail/" . $this->input->post('live_class_inq_class_id'));
			} else {
				$this->session->set_userdata('error', 'System Error Please Try Again');
				redirect($this->agent->referrer());
			}
		}
	}

	function thank_you_trail($id)
	{
		$this->load->model('live_class_page_model', 'live');
		$data['title'] = 'Thank You';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['page'] = $this->live->get_page_main_details($id);
		$this->load->view('front/include/header', $data);
		$this->load->view('front/thank_you_trail');
		$this->load->view('front/include/footer');
	}

	function tool_recommended()
	{
		$data['title'] = 'Tool Recommended';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['all_tool_recommended'] = $this->frontend_model->get_all_recommended_tools();
		$data['main_page'] = 'tool_recommended';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function under_construction()
	{
		$data['title'] = 'Under Construction';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$this->load->view('front/under_construction', $data);
	}

	function certificate_verification()
	{
		$data['title'] = 'Certificate Verification';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'certificate_verification';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function online_exam()
	{
		$data['title'] = 'Online Exam';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'online_exam';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function video()
	{

		$url = isset($_GET['url']) ? $_GET['url'] : null;

		$youtube = new \YouTube\YouTubeDownloader();
		try {
			$links = $youtube->getDownloadLinks($url);

			$best = $links->getFirstCombinedFormat();

			if ($best) {
				echo json_decode($this->send_json($best->url));
			} else {
				echo $this->send_json(['error' => 'No links found']);
			}
		} catch (\YouTube\Exception\YouTubeException $e) {

			echo $this->send_json([
				'error' => $e->getMessage()
			]);
		}
	}

	function get_img_for_url($value = '')
	{
		$youtube = new \YouTube\YouTubeStreamer();
		$youtube->stream($url);
	}

	function send_json($data)
	{
		header('Content-Type: application/json');
		return json_encode($data, JSON_PRETTY_PRINT);
		exit;
	}

	function submit_upciming_batch_data()
	{
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			if ($this->frontend_model->submit_upciming_batch_data()) {
				$cookie = array(
					'name'   => 557529,
					'value'  => 557529,
					'expire' => strtotime("+1 year"),
					'prefix' => ''
				);
				$this->input->set_cookie($cookie);
				redirect($this->agent->referrer());
			} else {
				$this->session->set_userdata('error', 'System Error Please Try Again');
				redirect($this->agent->referrer());
			}
		}
	}

	function submit_upciming_batch_demo_class()
	{
		$this->form_validation->set_rules('f_name', 'First Name', 'required|xss_clean');
		$this->form_validation->set_rules('l_name', 'Last Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			if ($this->frontend_model->submit_upciming_batch_demo_class()) {
				$this->session->set_userdata('success_form', 'Your application successfully submited,Join our WhatsApp group to start your demo class.');
				redirect($this->agent->referrer());
			} else {
				$this->session->set_userdata('error', 'System Error Please Try Again');
				redirect($this->agent->referrer());
			}
		}
	}

	function become_a_franchise()
	{
		$data['title'] = 'Become A Franchise';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['page'] = $this->frontend_model->get_all_franchise_page();
		$data['all_testi'] = $this->frontend_model->get_all_fran_page_testimonials();
		$data['main_page'] = 'become_a_franchise';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function sub_fran_form()
	{
		$this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		$this->form_validation->set_rules('state', 'State', 'required|xss_clean');
		$this->form_validation->set_rules('city', 'City', 'required|xss_clean');
		$this->form_validation->set_rules('pin_code', 'Pin Code', 'required|xss_clean');
		$this->form_validation->set_rules('dist', 'Dist', 'required|xss_clean');
		$this->form_validation->set_rules('address', 'Address', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			if ($this->frontend_model->sub_fran_page_form()) {
				$this->session->set_userdata('success', 'Your application successfully submited. We will Contact You Shortly.');
				redirect($this->agent->referrer());
			} else {
				$this->session->set_userdata('error', 'System Error Please Try Again');
				redirect($this->agent->referrer());
			}
		}
	}

	function sub_career_sub_form()
	{
		$this->form_validation->set_rules('name', 'Name', 'required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email|xss_clean');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|xss_clean');
		$this->form_validation->set_rules('state', 'State', 'required|xss_clean');
		$this->form_validation->set_rules('city', 'City', 'required|xss_clean');
		$this->form_validation->set_rules('pin_code', 'Pin Code', 'required|xss_clean');
		$this->form_validation->set_rules('dist', 'Dist', 'required|xss_clean');
		$this->form_validation->set_rules('address', 'Address', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE) {
			$this->session->set_userdata('error', 'Required Filed Must be Filed');
			redirect($this->agent->referrer());
		} else {
			if ($this->frontend_model->sub_career_sub_form()) {
				$this->session->set_userdata('success', 'Your application successfully submited. We will Contact You Shortly.');
				redirect($this->agent->referrer());
			} else {
				$this->session->set_userdata('error', 'System Error Please Try Again');
				redirect($this->agent->referrer());
			}
		}
	}

	function hire_talent()
	{
		$data['title'] = 'Hire Talent';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['page'] = $this->frontend_model->get_all_hire_talent_page();
		$data['get_all_company_logo'] = $this->frontend_model->get_all_hire_talent_company_image();
		$data['all_testimonials'] = $this->frontend_model->get_all_hire_talent_testimonials();
		$data['all_category'] = $this->frontend_model->get_all_hire_category();
		$data['main_page'] = 'hire_talent';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function digital_marketing_career_opportunities()
	{
		$data['title'] = 'Hire Talent';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['page'] = $this->frontend_model->get_all_career_opportunities_page();
		$data['all_slider'] = $this->frontend_model->get_all_career_opportunities_page_slider();
		$data['all_current_op'] = $this->frontend_model->get_all_career_opportunities_current_placements();
		$data['all_partner'] = $this->frontend_model->get_all_career_opportunities_placements_partner();
		$data['all_testi'] = $this->frontend_model->get_all_career_opportunities_testimonial();
		// $this->load->view('front/include/header', $data);
		$data['main_page'] = 'career_opportunities';
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}
	function schema_markup_generator()
	{
		$data['title'] = 'Schema Markup Generator';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'schema_markup_generator';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function image_generator_3d()
	{
		$data['title'] = 'Schema Markup Generator';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = '3d_image_generator';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function demo_html()
	{
		$data['title'] = 'Schema Markup Generator';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'demo_html';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
		// $this->load->view('front/include/footer');
	}

	function master_class()
	{
		$data['title'] = 'Master Class';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['all_flag_course'] = $this->course_model->get_flag_course();
		$data['main_page'] = 'masterclass';
		$this->load->view('front/index', $data);
		$this->output_compression->compress_output();
	}

	// function ibast()
	// {
	// 	$data['title'] = 'I-Bast';
	//     $data['app_setting'] = $this->setting_model->get_all_app_setting();
	//     $data['visual_setting'] = $this->setting_model->get_visual_setting();
	// 	$data['all_flag_course'] = $this->course_model->get_flag_course(); 
	//     $data['main_page'] = 'ibast';
	//     $this->load->view('front/index', $data);
	// }

	function ibast_page($slug)
	{
		$data['mainData'] = $this->course_model->get_ibast_page_by_slug($slug);
		$data['title'] = $data['mainData']->ibast_meta_title;
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'ibast';
		$this->load->view('front/index', $data);
		$this->output_compression->compress_output();
	}

	function ibast_details_page($slug)
	{
		$data['mainData'] = $this->course_model->get_ibast_details_page_by_slug($slug);
		$data['title'] = $data['mainData']->ibd_meta_title;
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['all_flag_course'] = $this->course_model->get_flag_course();
		$data['main_page'] = 'ibast_details';
		$this->load->view('front/index', $data);
		$this->output_compression->compress_output();
	}

	function mock_test()
	{
		$data['title'] = 'Mock Test';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'mock_test';
		$this->load->view('front/index', $data);
		$this->output_compression->compress_output();
	}

	function master_class_details($slug)
	{
		$data['mainData'] = $this->course_model->get_master_class_by_slug($slug);
		$data['title'] = $data['mainData']->class_meta_title;
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['all_slider'] = $this->course_model->get_all_master_class_slider_by_course_id($data['mainData']->class_id);
		$data['all_review'] = $this->course_model->get_all_master_class_review_by_course_id($data['mainData']->class_id);
		$data['all_course'] = $this->course_model->get_all_master_class_course_by_main_course_id($data['mainData']->class_id);
		$data['all_flag_course'] = $this->course_model->get_flag_course();
		$data['main_page'] = 'masterclass';
		$this->load->view('front/index', $data);
		// $this->output_compression->compress_output();
	}

	function master_class_details_page($slug)
	{
		$data['data'] = $this->course_model->get_all_master_class_course_by_slug($slug);
		$data['title'] = $data['data']->mc_course__meta_title;
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['all_review'] = $this->course_model->get_all_master_class_review_by_course_id($data['data']->mc_course_main_id);
		$data['main_page'] = 'masterclassDetails';
		$this->load->view('front/index', $data);
		// $this->output_compression->compress_output();
	}

	function fetch_master_class_video()
	{
		$video_id = $this->input->post('video_id');
		$videoData = file_get_contents($video_id);
		$base64Video = base64_encode($videoData);

		echo json_encode(['videoData' => $base64Video]);
	}

	function submit_master_class_form()
	{
		$link = $this->input->post('actual_link') . '?g=1';
		redirect($link);
	}

	function course_demo()
	{
		$data['title'] = 'Demo Course';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['get_all_company_logo'] = $this->frontend_model->get_all_company_logo();
		$data['all_current_op'] = $this->frontend_model->get_all_career_opportunities_current_placements();
		$data['main_page'] = 'course_demo';
		$this->load->view('front/index', $data);
	}

	function submit_lead()
	{
		$data = [
			'lead_name' => $this->input->post('lead_name'),
			'lead_mobile' => $this->input->post('lead_mobile'),
			'lead_email' => $this->input->post('lead_email'),
			'lead_course' => $this->input->post('lead_course'),
			'lead_mode' => $this->input->post('lead_mode'),
			'lead_date' => date('Y-m-d')
		];

		$status = $this->db->insert('lead_management', $data);
		if ($status) {
			$data['lead_session'] = true;
			$this->session->set_userdata($data);
			echo true;
		} else {
			echo false;
		}
	}

	function course_bundle_details($slug)
	{
		$data['title'] = 'Bundle Course';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['data'] = $this->course_model->get_bundle_details_by_slug($slug);
		$data['all_current_op'] = $this->frontend_model->get_all_career_opportunities_current_placements();
		$data['main_page'] = 'bundle_course';
		$this->load->view('front/index', $data);
	}

	function new_page()
	{
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['slider'] = $this->frontend_model->get_all_slider_by_id();
		$data['get_all_company_logo'] = $this->frontend_model->get_all_company_logo();
		$data['all_flag_course'] = $this->course_model->get_flag_course();
		$data['get_all_award'] = $this->frontend_model->get_all_media_spotlight();
		$data['all_testimonials'] = $this->frontend_model->get_all_testi_category();
		$data['all_are_you'] = $this->frontend_model->get_all_are_you();
		$data['about_us'] = $this->frontend_model->get_short_about_us();
		$data['get_all_stacks'] = $this->frontend_model->get_all_stacks();
		$data['section_2'] = $this->frontend_model->get_front_video();
		$data['section_3'] = $this->frontend_model->get_video_page_1_details();
		$data['section_4'] = $this->frontend_model->get_video_page_2_details();
		$data['heading'] = $this->frontend_model->get_all_heading_and_sub_heading();
		$data['category_all'] = $this->category_model->get_all_cat_for_cat_page();
		$data['all_current_op'] = $this->frontend_model->get_all_career_opportunities_current_placements();
		$data['get_all_counting'] = $this->frontend_model->get_all_counting();

		$spcial_cat = [];
		$all_special_category = $this->category_model->get_specialist_category();

		foreach ($all_special_category as $key => $sp_cat) {
			$spcial_cat[] = $sp_cat->id;
		}

		$data['all_specialist_cat'] = $spcial_cat;
		$data['main_page'] = 'new_home_page';
		$this->load->view('front/index', $data);
	}

	public function getProgramsByCategory()
	{
		$categoryId = $this->input->post('category_id');
		if ($categoryId != 'All') {

			$this->db->order_by('course_is_tranding', 'desc');
			$this->db->where_in('course_category', $categoryId);
			$all_course = $this->db->get('course_new')->result();

			$this->db->where_in('id', $categoryId);
			$category = $this->db->get('category')->row();

			$catName = $category->name;
		} else {
			$this->db->order_by('course_is_tranding', 'desc');
			$all_course = $this->db->get('course_new')->result();

			$catName = 'All Course';
		}

		$course_status = false;

		if ($all_course) {
			$html = '';
			foreach ($all_course as $key => $course) {

				$this->db->where('status', 1);
				$this->db->where('id', $course->course_category);
				$cat_details = $this->db->get('category')->row();

				$this->db->where('status', 1);
				$this->db->where('id', $course->course_sub_category);
				$sub_cat_details = $this->db->get('category')->row();

				if ($cat_details && $sub_cat_details) {
					$course_status = true;
					$html .= '<div class="col-md-4 programm-card-width">';
					if ($course->course_is_tranding == 1) {
						$html .= '<span class="badge badge-success tranding-course-badge"><b>🔥&nbsp;Trending</b></span>';
					}

					$html .= '<div class="card program-card">
						<img src="' . base_url($course->course_image) . '" class="card-img-top" alt="Program Image">
						<div class="card-body course-price-details">
							<a href="' . base_url('course/' . $course->course_slug) . '" class="program-card-title text-center">' . mb_strimwidth($course->course_heading, 0, 30, "...") . '</a>';

					if ($course->course_theme == 'theme_1') {
						if ($cat_details->price) {
							$discountPercentage = round((($course->course_in_class_main_price - $cat_details->price) / $course->course_in_class_main_price) * 100);
							$html .= '<h4 class="text-center">
									<b>₹' . $cat_details->price  . '</b>
									<del class="fs-14 me-1 ms-1">₹' . $course->course_in_class_main_price . '</del>
									<span class="badge">' . $discountPercentage . '% OFF</span>
									</h4>';
						} else {
							if ($course->course_in_class_dicount_price > 0) {
								$discountPercentage = round((($course->course_in_class_main_price - $course->course_in_class_dicount_price) / $course->course_in_class_main_price) * 100);
								$html .= '<h4 class="text-center">
												<b>₹' . $course->course_in_class_dicount_price . '</b>
												<del class="fs-14 me-1 ms-1">₹' . $course->course_in_class_main_price . '</del>
												<span class="badge">' . $discountPercentage . '% OFF</span>
												</h4>';
							} else {
								$html .= '<h4 class="text-center">
												<b>₹' . $course->course_in_class_main_price . '</b>
												</h4>';
							}
						}
					} elseif ($course->course_theme == 'theme_2') {

						error_reporting(0);
						if ($cat_details->price) {
							$discountPercentage = round((($course->course_online_main_price - $cat_details->price) / $course->course_online_main_price) * 100);
							$html .= '<h4 class="text-center">
									<b>₹' . $cat_details->price . '</b>
									<del class="fs-14 me-1 ms-1">₹' . $course->course_online_main_price . '</del>
									<span class="badge">' . $discountPercentage . '% OFF</span>
									</h4>';
						} else {
							if ($course->course_is_free == 1) {
								$html .= '<h4 class="text-center">
											<b class="text-success">Free</b>
											<del class="fs-14 me-1 ms-1">₹' . $course->course_online_main_price . '</del>
											<span class="badge">100% OFF</span>
											</h4>';
							} elseif ($course->course_onine_dicount_price > 0) {
								$discountPercentage = round((($course->course_online_main_price - $course->course_onine_dicount_price) / $course->course_online_main_price) * 100);
								$html .= '<h4 class="text-center">
											<b>₹' . $course->course_onine_dicount_price . '</b>
											<del class="fs-14 me-1 ms-1">₹' . $course->course_online_main_price . '</del>
											<span class="badge">' . $discountPercentage . '% OFF</span>
											</h4>';
							} else {
								$html .= '<h4 class="text-center">
											<b>₹' . $course->course_online_main_price . '</b>
											</h4>';
							}
						}
					} elseif ($course->course_theme == 'theme_3') {

						error_reporting(0);
						if ($cat_details->price) {
							$discountPercentage = round((($course->course_online_main_price - $cat_details->price) / $course->course_online_main_price) * 100);
							$html .= '<h4 class="text-center">
									<b>₹' . $cat_details->price . '</b>
									<del class="fs-14 me-1 ms-1">₹' . $course->course_online_main_price . '</del>
									<span class="badge">' . $discountPercentage . '% OFF</span>
									</h4>';
						} else {
							if ($course->course_is_free == 1) {
								$html .= '<h4 class="text-center">
											<b class="text-success">Free</b>
											<del class="fs-14 me-1 ms-1">₹' . $course->course_online_main_price . '</del>
											<span class="badge">100% OFF</span>
											</h4>';
							} elseif ($course->course_onine_dicount_price > 0) {
								$discountPercentage = round((($course->course_online_main_price - $course->course_onine_dicount_price) / $course->course_online_main_price) * 100);
								$html .= '<h4 class="text-center">
											<b>₹' . $course->course_onine_dicount_price . '</b>
											<del class="fs-14 me-1 ms-1">₹' . $course->course_online_main_price . '</del>
											<span class="badge">' . $discountPercentage . '% OFF</span>
											</h4>';
							} else {
								$html .= '<h4 class="text-center">
											<b>₹' . $course->course_online_main_price . '</b>
											</h4>';
							}
						}
					}

					if ($course->course_theme == 'theme_1') {
						$html .= '<div class="mt-3 text-center">
										<a href="javascript:void(0)" onclick="openDownloadBrochureModal(' . $course->course_id . ', \'' . base_url($course->course_pdf_browser) . '\')" class="program-detail__cta"><i class="fa fa-download"></i>&nbsp;&nbsp; Download Brochure</a>
							</div>
							<div >
							<a class="program-detail__cta_2 text-center mt-4 text-white" href="' . base_url('course/' . $course->course_slug) . '" ><i class="fa fa-eye"></i>&nbsp;&nbsp;View Course</a>
							</div>
							</div>';
					} elseif ($course->course_theme == 'theme_2') {

						$is_purchased = false;
						$is_session  = false;
						if ($this->session->userdata('bcount_sess_logged_in') === true) {
							$is_purchased = $this->course_model->course_is_purchased($this->session->userdata('bcount_sess_id'), $course->course_id);
							$is_session  = true;
						}

						if (!$is_purchased) {
							if ($course->course_is_free == 1) {
								if ($is_session) {
									$url = base_url() . 'course/enrolement/' . $course->course_slug . '/' . $course->course_id;
								} else {
									$url = base_url() . 'register/course/' . $course->course_slug . '/' . $course->course_id;
								}
								$html .= '<div >
											<a class="program-detail__cta_2 text-center mt-4 text-white" href="' . $url . '" class="text-white"><i class="fa fa-user-plus"></i>&nbsp;&nbsp;Enrol this Course</a>
										</div>';
							} else {

								if ($is_session) {
									$url = base_url() . 'course/buy_now/' . $course->course_slug . '/' . $course->course_id;
								} else {
									$url = base_url() . 'register/course/' . $course->course_slug . '/' . $course->course_id;
								}
								// $html .= '<div>
								// 			<a class="program-detail__cta_2 text-center mt-4 text-white" href="' . $url . '" class="text-white"><i class="fa fa-shopping-cart"></i>&nbsp;&nbsp;Buy Now</a>
								// 		</div>';
							}
						} else {
							$html .= '<div><a href="' . base_url('admin/admin/lesson/' . $course->course_slug . '/' . $course->course_id) . '" class="program-detail__cta_2 text-center mt-4 text-white"><i class="fa fa-eye"></i>&nbsp;&nbsp;Go to Course</a></div>';
						}


						$html .= '<div>
									<a href="' . base_url('course/' . $course->course_slug) . '" class="program-detail__cta mt-3 text-center"> <i class="fa fa-eye"></i>&nbsp;&nbsp;View Course</a>
								</div>';
					} elseif ($course->course_theme == 'theme_3') {
						$html .= '
							<div >
							<a class="program-detail__cta_2 text-center mt-4 text-white" href="' . base_url('course/' . $course->course_slug) . '" >Khow More</a>
							</div>
							</div>';
					}


					$html .= '</div>
						</div>
					</div>
				</div>';
				}
			}


			// echo '<pre>';
			// print_r($html);
			$data = [
				'html' => $html,
				'category' => $catName
			];
			echo json_encode($data);
		} else {
			$data = [
				'html' => '<div class="col-md-4 programm-card-width">
                  <div class="card program-card"><b>Oops! No Course Found</b></div></div>',
				'category' => $catName
			];
			echo json_encode($data);
		}
	}

	function get_course_curriculum($id)
	{
		$i = 1;
		$total_lession = 0;
		$sections = $this->course_model->get_section('course', $id)->result_array();

		$output = '<div class="card-body">
		
		<div class="panel-group1" id="accordion2">
		<div class="row">';

		foreach ($sections as $key => $section) {
			$output .= '<div class="col-md-6 col-12 mb-3">';
			$output .= '<div class="panel panel-default mb-4 border p-0 panel-colored">';
			$output .= '<div class="panel-heading1">';
			$output .= '<h4 class="panel-title1">';
			$output .= '<a class="accordion-toggle collapsed" data-bs-toggle="collapse" data-parent="#accordion2" href="#collapse_' . $i . '" aria-expanded="false">';
			$output .= '<div class="d-flex justify-content-between">';
			$output .= '<div>' . $i . '. ' . $section['title'] . '</div>';
			$output .= '<div class="d-flex me-3">';

			// Resource count
			$this->db->where('section_id', $section['id']);
			$lessonIDs = array_column($this->db->get('lesson')->result_array(), 'id');

			$all_resource = $this->db->select('b.rc_name')
				->from('resource_files a')
				->join('resource_category b', 'b.rc_id = a.category_id')
				->where_in('a.lesson_id', $lessonIDs)
				->get()->result();

			$resource_counts = [];
			foreach ($all_resource as $resource) {
				$resource_counts[$resource->rc_name] = ($resource_counts[$resource->rc_name] ?? 0) + 1;
			}

			foreach ($resource_counts as $category => $count) {
				$output .= "<span class='ms-auto me-2 ms-3 pe-2 border-end text-14px fw-400 d-flex'>
									<div class='project-count-number me-2'>$count</div>
									<div class='project_name d-flex align-items-center'>$category</div>
								</span>";
			}

			// Lessons count
			$lesson_count = $this->course_model->get_lessons('section', $section['id'])->num_rows();
			$total_lession += $lesson_count;
			$output .= "<span class='ms-auto me-2 ms-3 pe-2 text-14px fw-400 d-flex'>
								<div class='project-count-number me-2'>$lesson_count</div>
								<div class='project_name d-flex align-items-center'>Lession</div>
							</span>";

			$output .= '</div></div></a></h4></div>';

			// Accordion body
			$output .= '<div id="collapse_' . $i . '" class="panel-collapse active collapse" role="tabpanel" aria-expanded="false">';
			$output .= '<div class="panel-body bg-white">';
			$output .= '<ul class="ac-lecture">';

			$lessons = $this->course_model->get_lessons('section', $section['id'])->result_array();
			foreach ($lessons as $lesson) {
				$output .= '<li>';

				if ($lesson['video_type'] == 'YouTube' && $lesson['is_free'] == 1) {
					$output .= '<a href="javascript:void(0)" onclick="openVideoModel(\'' . $lesson['video_url'] . '\')" class="checkPropagation">';
				} else {
					$output .= '<a href="#" class="checkPropagation">';
				}

				// Lesson icon + title
				$output .= '<span class="d-flex align-items-center">';
				if ($lesson['lesson_type'] == 'other' || $lesson['lesson_type'] == 'text') {
					$output .= '<i class="fa-regular far fa-file-alt me-3"></i>';
				} elseif ($lesson['lesson_type'] == 'quiz') {
					$output .= '<i class="fa-regular far fa-question-circle me-3"></i>' . get_phrase('Quiz');
				} elseif ($lesson['lesson_type'] == 'audio') {
					$output .= '<i class="fa-regular far fa-file-audio me-3"></i>' . get_phrase('Audio');
				} else {
					$output .= '<i class="fa-regular far fa-file-video me-3"></i>' . get_phrase('Video');
				}
				$output .= $lesson['title'];
				$output .= '</span>';

				// Video extra info
				if ($lesson['lesson_type'] == 'video') {
					$output .= '<div class="d-flex justify-content-center">';
					if ($lesson['is_free'] == 1) {
						$output .= '<span class="badge badge-success badge-pill me-3"><i class="fa fa-eye text-white"></i>Preview</span>';
					}
					$output .= '<div>' . substr($lesson['duration'], 3) . ' min</div>';
					$output .= '</div>';
				}

				$output .= '</a>';
				$output .= '</li>';
			}

			$output .= '</ul></div></div></div></div>'; // end body + collapse + panel
			$i++;
		}

		$output .= '</div></div></div>';

		echo $output;
	}

	// student enrole free course
	function enrole_free_course($slug, $id)
	{
		if ($this->session->userdata('bcount_sess_logged_in') === true) {
			$this->db->where('course_slug', $slug);
			$this->db->where('course_id', $id);
			$course = $this->db->get('course_new')->row();

			if (!$course) {
				redirect($this->agent->referrer());
			} elseif ($course->course_is_free != 1) {
				redirect($this->agent->referrer());
			} else {
				$this->load->model('student_model');
				$this->student_model->enrole_free_course($course->course_id);
				redirect(base_url() . 'admin//course/my_course');
			}
		} else {
			redirect($this->agent->referrer());
		}
	}

	public function course_buy_now()
	{
		if (!$this->session->userdata('bcount_sess_logged_in')) {
			redirect($this->agent->referrer());
		}

		$cart = $this->cart->contents();
		if (empty($cart)) {
			$this->session->set_flashdata('error', 'Your cart is empty.');
			redirect(base_url('cart'));
		}

		$total = 0;
		$course_data = [];
		foreach ($cart as $item) {
			// Skip discount row
			if (isset($item['options']['type']) && $item['options']['type'] === 'fbt_discount') {
				$total += $item['price']; // will be negative
				continue;
			}

			// Fetch actual course object for processing
			$course = $this->db->where('course_id', $item['id'])->get('course_new')->row();
			if ($course && $course->course_is_free != 1) {
				$total += $item['price'];
				$course_data[] = $course;
			}
		}

		if ($total <= 0 || empty($course_data)) {
			$this->session->set_flashdata('error', 'Invalid cart contents.');
			redirect(base_url('cart'));
		}

		// Razorpay order create
		$app_setting = $this->setting_model->get_all_app_setting();
		$order_id = "RAOR" . date("Ymd") . rand(1000, 9999);

		$api = new Api($app_setting->rozar_key_id, $app_setting->rozar_key_secret);
		$razorpayOrder = $api->order->create([
			'receipt'         => $order_id,
			'amount'          => $total * 100,
			'currency'        => 'INR',
			'payment_capture' => 1
		]);

		$_SESSION['razorpay_order_id'] = $razorpayOrder['id'];
		$_SESSION['recharge_id'] = $order_id;
		$_SESSION['amount'] = $razorpayOrder['amount'];
		$_SESSION['purchase_courses'] = $course_data;

		$raz_pay_data = $this->rozr_pay_prepareData_for_course_purchase(
			$razorpayOrder['amount'],
			$razorpayOrder['id'],
			$order_id,
			(count($course_data) > 1 ? "FBT/Bundle Course Purchase" : $course_data[0]->course_heading)
		);

		$this->load->view('rezorpay_payment_for_course_purchase', ['data' => $raz_pay_data]);
	}


	public function rozr_pay_prepareData_for_course_purchase($amount, $razorpayOrderId, $order_id, $description = "Course Purchase")
	{
		$app_setting = $this->setting_model->get_all_app_setting();
		return [
			"key" => $app_setting->rozar_key_id,
			"amount" => $amount,
			"name" => $order_id,
			"description" => $description,
			"image" => base_url($app_setting->header_logo),
			"prefill" => [
				"name" => 'Course Purchase',
				"email" => user()->email,
				"contact" => user()->mobile,
			],
			"notes" => [
				"address" => "Online Course",
				"merchant_order_id" => rand(),
			],
			"theme" => [
				"color" => "#F37254"
			],
			"order_id" => $razorpayOrderId,
		];
	}


	public function rozr_pay_verify_payment_course_purchase()
	{
		$app_setting = $this->setting_model->get_all_app_setting();
		$success = true;

		if (!empty($_POST['razorpay_payment_id'])) {
			try {
				$api = new Api($app_setting->rozar_key_id, $app_setting->rozar_key_secret);
				$api->utility->verifyPaymentSignature([
					'razorpay_order_id' => $_SESSION['razorpay_order_id'],
					'razorpay_payment_id' => $_POST['razorpay_payment_id'],
					'razorpay_signature' => $_POST['razorpay_signature']
				]);
			} catch (SignatureVerificationError $e) {
				$success = false;
				$this->session->set_flashdata('error', 'Payment verification failed: ' . $e->getMessage());
				redirect(base_url('cart'));
			}
		}

		if ($success) {
			$this->load->model('student_model');
			foreach ($_SESSION['purchase_courses'] as $course) {
				$this->student_model->enrole_free_course($course->course_id);
			}

			$this->cart->destroy(); // clear cart after successful purchase
			$this->session->set_flashdata('success', 'Payment successful. Courses enrolled.');
			redirect(base_url('admin/course/my_course'));
		}
	}


	//fbt course buy
	function course_fbt_buy($id)
	{
		if ($this->session->userdata('bcount_sess_logged_in') === false) {
			redirect($this->agent->referrer());
		}

		$this->db->where('course_id', $id);
		$course = $this->db->get('course_new')->row();

		if (!$course) {
			redirect($this->agent->referrer());
		} elseif ($course->course_is_free == 1) {
			redirect($this->agent->referrer());
		} else {


			$price = $course->course_fbt_price;


			$app_setting = $this->setting_model->get_all_app_setting();
			$rand = "RAOR" . date("Ymd") . rand(1000, 9999);
			$order_id = $rand;
			$api = new Api($app_setting->rozar_key_id, $app_setting->rozar_key_secret);
			$razorpayOrder = $api->order->create(array(
				'receipt'         => $order_id,
				'amount'          => $price * 100,
				'currency'        => 'INR',
				'payment_capture' => 1
			));
			$amount = $razorpayOrder['amount'];
			$razorpayOrderId = $razorpayOrder['id'];
			$_SESSION['razorpay_order_id'] = $razorpayOrderId;
			$_SESSION['recharge_id'] = $order_id;
			$_SESSION['amount'] = $amount;
			$_SESSION['purchase_course'] = $course;
			$raz_pay_data = $this->rozr_pay_prepareData_for_course_fbt_purchase($amount, $razorpayOrderId, $order_id);
			$this->load->view('rezorpay_payment_for_course_fbt_purchase', array('data' => $raz_pay_data));
		}
	}

	public function rozr_pay_prepareData_for_course_fbt_purchase($amount, $razorpayOrderId, $order_id)
	{
		$app_setting = $this->setting_model->get_all_app_setting();
		$data = array(
			"key" => $app_setting->rozar_key_id,
			"amount" => $amount,
			"name" => $order_id,
			"description" => $app_setting->application_name,
			"image" => base_url() . $app_setting->header_logo,
			"prefill" => array(
				"name"  => 'Course Purchase',
				"email"  => user()->email,
				"contact" => user()->mobile,
			),
			"notes"  => array(
				"address"  => "Hello World",
				"merchant_order_id" => rand(),
			),
			"theme"  => array(
				"color"  => "#F37254"
			),
			"order_id" => $razorpayOrderId,
		);
		return $data;
	}

	function rozr_pay_verify_payment_course_fbt_purchase()
	{

		$app_setting = $this->setting_model->get_all_app_setting();
		$success = true;
		$error = "payment_failed";
		if (empty($_POST['razorpay_payment_id']) === false) {
			$api = new Api($app_setting->rozar_key_id, $app_setting->rozar_key_secret);
			try {
				$attributes = array(
					'razorpay_order_id' => $_SESSION['razorpay_order_id'],
					'razorpay_payment_id' => $_POST['razorpay_payment_id'],
					'razorpay_signature' => $_POST['razorpay_signature']
				);
				$api->utility->verifyPaymentSignature($attributes);
			} catch (SignatureVerificationError $e) {
				$success = false;
				$error = 'Razorpay_Error : ' . $e->getMessage();
			}
		}
		if ($success === true) {
			$course = $_SESSION['purchase_course'];

			foreach (json_decode($course->course_fbt) as $key => $value) {

				$this->student_model->enrole_free_course($value);
			}


			$this->load->model('student_model');
			$this->student_model->enrole_free_course($course->course_id);

			redirect(base_url() . 'admin//course/my_course');
		} else {
			$this->session->set_userdata('error', 'Transaction Faild');
			redirect(base_url());
		}
	}

	public function add_to_cart()
	{
		$id = $this->input->post('id');
		// Get course details
		$this->db->where('course_id', $id); // Use $id instead of $fbt
		$course = $this->db->get('course_new')->row();

		// Get category details
		$this->db->where('id', $course->course_category);
		$cat_details = $this->db->get('category')->row();

		// Determine price
		if ($cat_details && $cat_details->price) {
			$price = $cat_details->price;
		} else {
			if ($course->course_onine_dicount_price) {
				$price = $course->course_onine_dicount_price;
			} else {
				$price = $course->course_online_main_price;
			}
		}

		// Check if already in cart
		$cart = $this->cart->contents();
		foreach ($cart as $item) {
			if ($item['id'] == $id) {
				echo 2;
				return;
			}
		}

		$cart_id = rand();

		// Insert to cart
		$insert_data = array(
			'id' => $id,
			'name' => $course->course_heading,
			'price' => $price,
			'qty' => 1,
			'options' => array(
				'thumbnail' => $course->course_image,
				'cart_id'  => $cart_id,
			)
		);

		$this->cart->insert($insert_data);
		$this->session->set_userdata('success', 'Course Added to Cart');
		echo 1;
	}

	public function add_fbt_to_cart()
	{
		$course_ids = $this->input->post('course_ids'); // e.g., [101, 102, 103]
		$bundle_price = $this->input->post('bundle_price');

		if (!is_array($course_ids)) {
			echo json_encode(['status' => 'error']);
			return;
		}

		$total_original = 0;
		$cart = $this->cart->contents();
		$added = [];

		foreach ($course_ids as $id) {
			$exists = false;
			foreach ($cart as $item) {
				if ($item['id'] == $id) {
					$exists = true;
					break;
				}
			}
			if ($exists) continue;

			// Get course
			$course = $this->db->where('course_id', $id)->get('course_new')->row();
			if (!$course) continue;

			// Category price or course price
			$cat = $this->db->where('id', $course->course_category)->get('category')->row();
			$price = ($cat && $cat->price) ? $cat->price : (($course->course_onine_dicount_price) ? $course->course_onine_dicount_price : $course->course_online_main_price);

			$total_original += $price;

			// Add to cart
			$this->cart->insert([
				'id' => $id,
				'name' => $course->course_heading,
				'price' => $price,
				'qty' => 1,
				'options' => [
					'thumbnail' => $course->course_image,
					'fbt_group' => 'fbt_' . implode('_', $course_ids)
				]
			]);

			$added[] = $id;
		}

		// Calculate discount and insert as separate item
		$discount = $total_original - $bundle_price;
		if ($discount > 0) {
			$this->cart->insert([
				'id' => 'fbt_discount_' . time(),
				'name' => 'FBT Bundle Discount',
				'price' => -$discount, // Negative value
				'qty' => 1,
				'options' => [
					'type' => 'fbt_discount',
					'fbt_group' => 'fbt_' . implode('_', $course_ids)
				]
			]);
		}

		echo json_encode([
			'status' => 'success',
			'added_courses' => $added,
			'discount_applied' => $discount
		]);
	}

	public function remove($rowid)
	{
		$cart = $this->cart->contents();

		// Step 1: Get the group this item belongs to (if any)
		$removed_item = $cart[$rowid];
		$group_id = isset($removed_item['options']['fbt_group']) ? $removed_item['options']['fbt_group'] : null;

		// Step 2: Remove the item
		$this->cart->remove($rowid);

		// Step 3: If it's part of FBT, check if any other items from same group remain
		if ($group_id) {
			$group_items_left = 0;
			foreach ($this->cart->contents() as $item) {
				if (
					isset($item['options']['fbt_group']) &&
					$item['options']['fbt_group'] === $group_id &&
					(!isset($item['options']['type']) || $item['options']['type'] !== 'fbt_discount') // skip discount row
				) {
					$group_items_left++;
				}
			}

			// Step 4: If some (but not all) removed, remove the discount row too
			if ($group_items_left < 3) { // you can also count the original bundle length from DB
				foreach ($this->cart->contents() as $item) {
					if (
						isset($item['options']['type']) &&
						$item['options']['type'] === 'fbt_discount' &&
						$item['options']['fbt_group'] === $group_id
					) {
						$this->cart->remove($item['rowid']);
						break;
					}
				}
			}
		}

		$this->session->set_flashdata('success', 'Item removed from cart');
		redirect('cart'); // or reload the current cart page
	}



	function cart_page()
	{
		$data['title'] = 'Cart';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['visual_setting'] = $this->setting_model->get_visual_setting();
		$data['main_page'] = 'cart_page';
		// $this->load->view('front/include/header', $data);
		$this->load->view('front/index', $data);
	}

	function prd_page()
	{
		$this->load->view('front/prd_theme_2/index');
	}
}












/* End of file Home.php */
/* Location: ./application/controllers/Home.php */