<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends Home_Core_Controller {

	public function index()
	{
        $this->load->helper('string');
        $error = '';
        if(isset($_POST['sign_in'])) {

        $this->form_validation->set_rules('mobile', 'Mobile No', 'required');
          if ($this->form_validation->run() === false) {
            $this->session->set_userdata('errors', validation_errors());
            redirect(base_url().'login');
          }else{

               $mobile = $this->input->post('mobile',true);
               $password = $this->input->post('password',true);

                $un = $this->auth_model->check_mobile($mobile);
                if(!$un) {
                    $error = 'Mobile No is wrong!';
                    $this->session->set_userdata('error',$error);
                    redirect(base_url().'login');
                } else {
                    $check_status = $this->auth_model->check_status($mobile);

                    if($check_status->num_rows() == 0) {
                        $error = 'Invalid Account';
                        $this->session->set_userdata('error',$error);
                        redirect(base_url().'login');
                    }
                    else
                    {
                        
                        $pw = $this->auth_model->check_password($mobile,$password);
                        if(!$pw)
                        {
                            $error = 'Password is wrong!';
                            $this->session->set_userdata('error',$error);
                            redirect(base_url().'login');
                        }
                        else
                        {
                            $rand = rand();
                            $user = array(
                            'bcount_sess_id' => $pw['id'],
                            'bcount_sess_mobile' => $pw['mobile'],
                            'bcount_sess_email' => $pw['email'],
                            'bcount_sess_role' => $pw['role'],
                            'bcount_sess_status' => $pw['status'],
                            'bcount_sess_logged_in' => true,
                            'bcount_sess_token' => random_string('alnum', 8),
                            'bcount_sess_app_id' => $this->config->item('app_key')
                            );
                            $this->auth_model->active_token($pw['id'], $user['bcount_sess_token']);
                            $this->auth_model->active_session_id($pw['id'], $rand);
                            $this->session->set_userdata($user);
                            redirect(base_url());

                        }
                        
                    }
                }
                
            }
        } 
        else 
        {
            if($this->session->userdata('bcount_sess_logged_in')) 
            {
                redirect(base_url());
            }
            else
            {
                $data['title'] = 'Login Now';
        		$data['app_setting'] = $this->setting_model->get_all_app_setting();
                //$this->output->cache(1);		
        		$this->load->view('login', $data);
            }
        }
    
	}

    public function admin_login()
    {
        $this->load->helper('string');
        $error = '';
        if(isset($_POST['sign_in'])) {

        $this->form_validation->set_rules('mobile', 'Mobile No', 'required');
          if ($this->form_validation->run() === false) {
            $this->session->set_userdata('errors', validation_errors());
            redirect(base_url().'admin-login');
          }else{

               $mobile = $this->input->post('mobile',true);
               $password = $this->input->post('password',true);

                $un = $this->auth_model->check_mobile($mobile);
                if(!$un) {
                    $error = 'Mobile No is wrong!';
                    $this->session->set_userdata('error',$error);
                    redirect(base_url().'admin-login');
                } else {
                    $check_status = $this->auth_model->check_status($mobile);

                    if($check_status->num_rows() == 0) {
                        $error = 'Invalid Account';
                        $this->session->set_userdata('error',$error);
                        redirect(base_url().'admin-login');
                    }
                    else
                    {
                        
                        $pw = $this->auth_model->check_password($mobile,$password);
                        if(!$pw)
                        {
                            $error = 'Password is wrong!';
                            $this->session->set_userdata('error',$error);
                            redirect(base_url().'admin-login');
                        }
                        else
                        {
                            if($pw['role'] == "Employee")
                            {
                                if($pw['assign_ip'] == $this->input->ip_address())
                                {
                                    $working_info = [
                                        'working_report_emp_id'             => $pw['id'],
                                        'working_report_login_time_was'     => $pw['login_time'],
                                        'working_report_login_time'         => date('H:i:s'),
                                        'working_report_log_out_time_was'   => $pw['logout_time'],
                                        'working_report_working_hrs'        => $pw['working_hrs'],
                                        'working_report_date'               => date('Y-m-d'),
                                    ];
                                    $this->db->insert('employee_working_report', $working_info);
                                }
                            }
                            $rand = rand();
                            $user = array(
                            'bcount_sess_id' => $pw['id'],
                            'bcount_sess_mobile' => $pw['mobile'],
                            'bcount_sess_email' => $pw['email'],
                            'bcount_sess_role' => $pw['role'],
                            'bcount_sess_status' => $pw['status'],
                            'bcount_sess_logged_in' => true,
                            'bcount_sess_token' => random_string('alnum', 8),
                            'bcount_sess_app_id' => $this->config->item('app_key')
                            );
                            $this->auth_model->active_token($pw['id'], $user['bcount_sess_token']);
                            $this->auth_model->active_session_id($pw['id'], $rand);
                            $this->session->set_userdata($user);
                            redirect(base_url().'admin/admin/index');

                        }
                        
                    }
                }
                
            }
        } 
        else 
        {
            if($this->session->userdata('bcount_sess_logged_in')) 
            {
                redirect(base_url().'admin/admin');
            }
            else
            {
                $data['title'] = 'Login Now';
                $data['app_setting'] = $this->setting_model->get_all_app_setting();
                //$this->output->cache(1);      
                $this->load->view('admin_login', $data);
            }
        }
    
    }

    public function forgot_password()
    {
        $data['title'] = 'Forgot Password';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        //$this->output->cache(1);
        $this->load->view('forgot_password', $data);
    }

}

/* End of file Login.php */
/* Location: ./application/controllers/Login.php */