<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Register extends Home_Core_Controller
{

    public function index()
    {
        $this->load->helper('string');
        if (isset($_POST['sign_in'])) {
        } else {
            if ($this->session->userdata('bcount_sess_logged_in')) {
                redirect(base_url() . 'admin/admin/dashboard');
            } else {
                $data['title'] = 'Registrar Now';
                $data['app_setting'] = $this->setting_model->get_all_app_setting();
                $this->load->view('register', $data);
            }
        }
    }

    public function register_for_course_page()
    {
        $this->load->helper('string');
        if (isset($_POST['sign_in'])) {
        } else {
            if ($this->session->userdata('bcount_sess_logged_in')) {
                redirect(base_url() . 'admin/admin');
            } else {
                $this->load->model('course_model');
                $data['title'] = 'Registrar Now';
                $data['app_setting'] = $this->setting_model->get_all_app_setting();
                // $data['course'] = $this->course_model->get_course_by_id_for_lms($id)->row();
                $this->load->view('register', $data);
            }
        }
    }

    public function register_for_fbt_course_page($slug, $id)
    {
        $this->load->helper('string');
        if (isset($_POST['sign_in'])) {
        } else {
            if ($this->session->userdata('bcount_sess_logged_in')) {
                redirect(base_url() . 'admin/admin/dashboard');
            } else {
                $this->load->model('course_model');
                $data['title'] = 'Registrar Now';
                $data['app_setting'] = $this->setting_model->get_all_app_setting();
                $data['course'] = $this->course_model->get_course_by_id_for_lms($id)->row();
                $this->load->view('register', $data);
            }
        }
    }

    public function student_registration()
    {

        $name = $this->input->post('name');
        $mobile = $this->input->post('mobile');
        $password = $this->input->post('password');

        // Check if mobile already exists
        if ($this->auth_model->check_phone($mobile)->row()) {
            echo json_encode(['status' => 'error', 'message' => 'Mobile number already registered']);
            return;
        }

        // Insert user
        $data = [
            'name' => $name,
            'mobile' => $mobile,
            'password' => hash("sha256", $password),
            'role' => 'Student',
            'status' => 'Active',
            'created_at' => date('Y-m-d H:i:s'),

        ];

        $insert = $this->user_model->register_user($data);

        if ($insert) {

            $pw = $this->auth_model->get_user_by_id($insert);

            $this->load->helper('string');
            $rand = rand();
            $user = array(
                'bcount_sess_id' => $pw->id,
                'bcount_sess_mobile' => $pw->mobile,
                'bcount_sess_email' => $pw->email,
                'bcount_sess_name' => $pw->name,
                'bcount_sess_role' => $pw->role,
                'bcount_sess_status' => $pw->status,
                'bcount_sess_token' => random_string('alnum', 8),
                'bcount_sess_app_id' => $this->config->item('app_key'),
                'bcount_sess_logged_in' => true,
            );
            $this->auth_model->active_token($pw->id, $user['bcount_sess_token']);
            $this->auth_model->active_session_id($pw->id, $rand);
            $this->session->set_userdata($user);

            echo json_encode(['status' => 'success', 'message' => 'Registration successful']);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Registration failed']);
        }
    }
}

/* End of file Register.php */
/* Location: ./application/controllers/Register.php */