<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Blog extends Admin_Core_Controller {

	public function __construct()
    {
        parent::__construct();
        check_permission('blog');
    }

    
    public function blog_category()
	{
		$data['title'] = 'Blog Category';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['blog_category'] = $this->blog_model->get_all_blog_category();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/blog/category', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function add_new_category()
    {
		if ($this->blog_model->add_new_category()) {
	        $this->session->set_userdata('success', "Category Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Category Added Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function update_blog_category()
    {
		if ($this->blog_model->update_blog_category()) {
	        $this->session->set_userdata('success', "Category Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Category Updated Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function delete_category($id)
    {
    	$blog = $this->blog_model->get_blog_by_category($id);
      	if($blog)
      	{
      		$this->session->set_userdata('error', "Catgeory Used in Blog. Please Change First");
		    redirect($this->agent->referrer());
      	}
      	else
      	{
			if ($this->blog_model->delete_category($id)) {
		        $this->session->set_userdata('success', "Category Successfully Delete");
		        redirect($this->agent->referrer());
		    } else {
		        $this->session->set_userdata('error', "Category Added Delete");
		        redirect($this->agent->referrer());
		    }
		}
    }

    

	public function add_new_blog()
	{
		$data['title'] = 'New Blog';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['blog_category'] = $this->blog_model->get_all_blog_category();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/blog/add_new_blog', $data);
		$this->load->view('admin/include/footer', $data);
	}

	 public function new_blog_add()
    {
		if ($this->blog_model->new_blog_add()) {
	        $this->session->set_userdata('success', "Blog Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Blog Added Faild");
	        redirect($this->agent->referrer());
	    }
	    
    }

    public function view_all_blog()
	{
		$data['title'] = 'View All Blog';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['get_all_blog'] = $this->blog_model->get_all_blog();
		$data['blog_category'] = $this->blog_model->get_all_blog_category();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/blog/view_all_blog', $data);
		$this->load->view('admin/include/footer', $data);
	}

	 public function update_blog()
    {
		if ($this->blog_model->update_blog()) {
	        $this->session->set_userdata('success', "Blog Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Blog Updated Faild");
	        redirect($this->agent->referrer());
	    }
	    
    }

    public function delete_blog($id)
    {
		if ($this->blog_model->delete_blog($id)) {
	        $this->session->set_userdata('success', "Blog Successfully Delete");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Blog Delete Faild");
	        redirect($this->agent->referrer());
	    }
	    
    }

    

	

    

	

	

	

}

/* End of file Blog.php */
/* Location: ./application/controllers/blog/Blog.php */