<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Branch extends Admin_Core_Controller {

	public function __construct()
    {
        parent::__construct();
        check_permission('branch');
        $this->load->model('branch_model', 'branch');
    }

	public function add_new_branch()
	{
		$data['title'] = 'Add New Branch';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/branch/add_new_branch', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function add_branch()
	{
        if ($this->branch->add_branch()) {
            $this->session->set_userdata('success', "Branch Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Branch Added Faild");
            redirect($this->agent->referrer());
        }
	}

	public function view_all_branch()
	{
		$data['title'] = 'View All Branch';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['all_branch'] = $this->branch->get_all_branch();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/branch/view_all_branch', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function edit($id)
	{
		$data['title'] = 'Edit Branch';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['branch'] = $this->branch->get_branch_by_id_id($id);
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/branch/edit', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function update()
	{
        if ($this->branch->update()) {
            $this->session->set_userdata('success', "Branch Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Branch Updated Faild");
            redirect($this->agent->referrer());
        }
	}

	

	public function delete($id)
	{
        if ($this->branch->delete($id)) {
            $this->session->set_userdata('success', "Branch Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Branch Deleted Faild");
            redirect($this->agent->referrer());
        }
	}

	public function batches_shedule()
	{
		$data['title'] = 'Batches Shedule';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['all_branch'] = $this->branch->get_all_branch();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/branch/batches_shedule', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function add_schedule()
	{
        if ($this->branch->add_schedule()) {
            $this->session->set_userdata('success', "Schedule Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Schedule Added Faild");
            redirect($this->agent->referrer());
        }
	}

	public function view_branch_shedule()
	{
		$data['title'] = 'View All Branch Shedule';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['get_all_branch_shedule'] = $this->branch->get_all_branch_shedule();
		$data['all_branch'] = $this->branch->get_all_branch();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/branch/branch_shedule', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function update_shedule()
	{
        if ($this->branch->update_shedule()) {
            $this->session->set_userdata('success', "Shedule Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Shedule Updated Faild");
            redirect($this->agent->referrer());
        }
	}

	public function delete_shedule($id)
	{
        if ($this->branch->delete_shedule($id)) {
            $this->session->set_userdata('success', "Shedule Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Shedule Deleted Faild");
            redirect($this->agent->referrer());
        }
	}

	public function students_testimonial()
	{
		$data['title'] = 'Student Testimonial';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['all_branch'] = $this->branch->get_all_branch();
		$data['get_all_students_testimonial'] = $this->branch->get_all_students_testimonial();
		
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/branch/students_testimonial', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function add_students_testimonial()
	{
        if ($this->branch->add_students_testimonial()) {
            $this->session->set_userdata('success', "Testimonial Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Testimonial Added Faild");
            redirect($this->agent->referrer());
        }
	}

	public function delete_testimonials($id)
	{
        if ($this->branch->delete_testimonials($id)) {
            $this->session->set_userdata('success', "Testimonial Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Testimonial Deleted Faild");
            redirect($this->agent->referrer());
        }
	}

	public function update_testi_headigng()
	{
        if ($this->branch->update_testi_headigng()) {
            $this->session->set_userdata('success', "Heading Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Heading Updated Faild");
            redirect($this->agent->referrer());
        }
	}

	public function update_batches_shedule()
	{
        if ($this->branch->update_batches_shedule()) {
            $this->session->set_userdata('success', "Heading Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Heading Updated Faild");
            redirect($this->agent->referrer());
        }
	}

	function get_pin_code_details_for_edit()
    {
    	$pin_code = $this->input->post('pin_code');
    	$areas = $this->input->post('area');
    	$this->load->library('shiprocket');
    	$post['postcode'] =$pin_code;
    	$pin_code_details = $this->shiprocket->postcode($post);

    	$area= '';
        foreach ($pin_code_details['postcode_details']['locality'] as $key => $value)
        {
             $area .= '<option '.(($value==$areas)?'selected="selected"':"").' value="'.$value.'">'.$value.'</option>'; 
        } 
        $output = [
            'city' => $pin_code_details['postcode_details']['city'],
            'state' => $pin_code_details['postcode_details']['state'],
            'area' => $area,
        ];

        echo json_encode($output);

    }

	

	

	

	

	


	

	

	

	

	

	

	
}

/* End of file Admin.php */
/* Location: ./application/controllers/Admin/Admin.php */