<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Buyer_management extends Admin_Core_Controller {

    public function __construct()
    {
        parent::__construct();
        check_permission('student_management');
        $this->load->model('products_model');
    }
    

    public function add_new_buyer()
    {
        $data['title'] = 'Add New Buyer';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['visual_setting'] = $this->setting_model->get_visual_setting();
        $data['get_all_prd'] = $this->products_model->get_all_prd_for_buyer_add();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/buyer/add_new_buyer');
        $this->load->view('admin/include/footer');
    }

    public function view_all_buyer()
    {
        $data['title'] = 'Class Room Quotation';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['visual_setting'] = $this->setting_model->get_visual_setting();
        $data['get_all_buyer'] = $this->products_model->get_all_buyer();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/buyer/view_all_buyer');
        $this->load->view('admin/include/footer');
    }

    

     public function new_student_add()
    {
        if ($this->student_model->new_student_add()) {
            $this->session->set_userdata('success', "Student Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Student Added Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete($id)
    {
        if ($this->student_model->delete($id)) {
            $this->session->set_userdata('success', "Student Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Student Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_student($id)
    {
        $data['title'] = 'Update Student';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['visual_setting'] = $this->setting_model->get_visual_setting();
        $data['get_all_branch'] = $this->branch_model->get_all_branch();
        $data['get_all_course'] = $this->course_model->get_all_course();
        $data['student'] = $this->student_model->get_student_by_id($id);
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/buyer/update_student');
        $this->load->view('admin/include/footer');
    }

    public function update_student_add()
    {
        if ($this->student_model->update_student()) {
            $this->session->set_userdata('success', "Student Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Student Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    

    

    

    
   


}

/* End of file Events.php */
/* Location: ./application/views/front/Events.php */