<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Career_opportunities extends Admin_Core_Controller {

	public function __construct()
    {
        parent::__construct();
        check_permission('frontend_setting');
    }

	public function view_career_opportunities_page()
	{
		$data['title'] = 'Career Opportunities Page';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['data'] = $this->frontend_model->get_all_career_opportunities_page();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/career_opportunities_page');
		$this->load->view('admin/include/footer');
	}

    public function update_page()
    {
		if ($this->frontend_model->career_opportunities_update_page()) {
	        $this->session->set_userdata('success', "Data Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function page_slider()
    {
    	$data['title'] = 'Career Opportunities Page';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['all_slider'] = $this->frontend_model->get_all_career_opportunities_page_slider();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/career_page_slider');
		$this->load->view('admin/include/footer');
    }

    function add_new_slider()
    {
    	if ($this->frontend_model->career_opportunities_add_new_slider()) {
	        $this->session->set_userdata('success', "Slider Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Slider Added Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function update_slider($id)
    {
    	if ($this->frontend_model->career_opportunities_update_slider($id)) {
	        $this->session->set_userdata('success', "Slider Successfully Update");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Slider Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function delete_slider($id)
    {
    	if ($this->frontend_model->career_opportunities_delete_slider($id)) {
	        $this->session->set_userdata('success', "Slider Successfully Delete");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Slider Delete Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function current_placements()
    {
        $data['title'] = 'Career Opportunities Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['all_placement'] = $this->frontend_model->get_all_career_opportunities_current_placements();    
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/fontend_setting/current_placements');
        $this->load->view('admin/include/footer');
    }

    function add_new_current_placements()
    {
        if ($this->frontend_model->career_opportunities_add_new_current_placements()) {
            $this->session->set_userdata('success', "Placement Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Placement Added Faild");
            redirect($this->agent->referrer());
        }
    }

    function update_current_placements($id)
    {
        if ($this->frontend_model->career_opportunities_update_current_placements($id)) {
            $this->session->set_userdata('success', "Placement Successfully Update");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Placement Update Faild");
            redirect($this->agent->referrer());
        }
    }

    function delete_current_placements($id)
    {
        if ($this->frontend_model->career_opportunities_delete_current_placements($id)) {
            $this->session->set_userdata('success', "Placement Successfully Delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Placement Delete Faild");
            redirect($this->agent->referrer());
        }
    }

    function placements_partner()
    {
    	$data['title'] = 'Career Opportunities Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['all_partner'] = $this->frontend_model->get_all_career_opportunities_placements_partner();    
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/fontend_setting/placements_partner');
        $this->load->view('admin/include/footer');
    }

    function add_new_partner_image()
    {
    	if ($this->frontend_model->career_opportunities_add_partner_image()) {
            $this->session->set_userdata('success', "Partner Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Partner Added Faild");
            redirect($this->agent->referrer());
        }
    }

    function update_partner_image($id)
    {
    	if ($this->frontend_model->career_opportunities_update_partner_image($id)) {
            $this->session->set_userdata('success', "Partner Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Partner Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    function delete_partner_image($id)
    {
    	if ($this->frontend_model->career_opportunities_delete_partner_image($id)) {
            $this->session->set_userdata('success', "Partner Successfully Delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Partner Delete Faild");
            redirect($this->agent->referrer());
        }
    }

    function all_testimonials()
    {
    	$data['title'] = 'Career Opportunities Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['all_testi'] = $this->frontend_model->get_all_career_opportunities_testimonial();    
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/fontend_setting/all_testimonials');
        $this->load->view('admin/include/footer');
    }

    function add_new_testimonilas()
    {
    	if ($this->frontend_model->career_opportunities_add_testimonilas()) {
            $this->session->set_userdata('success', "Testimonial Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Testimonial Added Faild");
            redirect($this->agent->referrer());
        }
    }

    function update_testimonials($id)
    {
    	if ($this->frontend_model->career_opportunities_update_testimonials($id)) {
            $this->session->set_userdata('success', "Testimonial Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Testimonial Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    function delete_testimonial($id)
    {
    	if ($this->frontend_model->career_opportunities_delete_testimonial($id)) {
            $this->session->set_userdata('success', "Testimonial Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Testimonial Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

    function career_application()
    {
        $data['title'] = 'Career Opportunities Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['all_fran_app'] = $this->frontend_model->get_all_career_opportunities_form();    
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/fontend_setting/career_application');
        $this->load->view('admin/include/footer');
    }
   
	
}
