<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Category extends Admin_Core_Controller {

	public function __construct()
    {
        
        parent::__construct();
        check_permission('course_category');
    }

	public function add_new_category()
	{
		$data['title'] = 'New Category';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['get_all_category_name'] = $this->category_model->get_all_category_name();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/category/add_new_category', $data);
		$this->load->view('admin/include/footer', $data);
	}

	//Application Setting update
	public function new_category_add()
	{
        if ($this->category_model->new_category_add()) {
            $this->session->set_userdata('success', "Catgory Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Catgory Added Faild");
            redirect($this->agent->referrer());
        }
	}

	public function view_all_category($offset=0)
	{
		$data['title'] = 'View All Category';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
        $config['base_url'] = base_url().'admin/category/view_all_category';
        $config["total_rows"] = $this->category_model->get_category_count();
        $config["per_page"] = 10; 
        $config['num_links'] = 5;
        $config['full_tag_open'] = '<ul class="pagination pagination-sm m-0 float-right">';
        $config['full_tag_close'] = '</ul>';
        $config['num_tag_open'] = '<li class="page-item">';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="page-item active"><a  class="page-link">';
        $config['cur_tag_close'] = '</a></li>';
        $config['prev_tag_open'] = '<li class="page-item">';
        $config['prev_tag_close'] = '<li>';
        $config['next_tag_open'] = '<li class="page-item">';
        $config['next_tag_close'] = '</li>';
        $config['prev_link'] = '&laquo;';

        $config['prev_tag_open'] = '<li class="page-item">';
        $config['prev_tag_close'] = '</li>';

        $config['next_link'] = '&raquo;';
        $config['next_tag_open'] = '<li class="page-item">';
        $config['next_tag_close'] = '</li>';
        $config['attributes'] = array('class' => 'page-link');
        $this->pagination->initialize($config);
        $data['product_pagination'] = $this->pagination->create_links();
        $data['get_all_category'] = $this->category_model->get_all_category_pageing($config['per_page'], $offset);


		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/category/view_all_category', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function active_category($id)
    {
     	if ($this->category_model->active_category($id)) {
            $this->session->set_userdata('success', "Catgory Successfully Activate");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Catgory Activation Faild");
            redirect($this->agent->referrer());
        }
    }

    public function deactive_category($id)
    {
     	if ($this->category_model->deactive_category($id)) {
            $this->session->set_userdata('success', "Catgory Successfully Deactivate");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Catgory Deactivation Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete_category($id)
    {

     	if ($this->category_model->delete_category($id)) {
            $this->session->set_userdata('success', "Catgory Successfully Delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Catgory Delete Faild");
            redirect($this->agent->referrer());
        }
        
    }
	public function update_category_details()
	    {
	        if ($this->category_model->update_category_details()) {
	            $this->session->set_userdata('success', "Category Successfully Updated");
	            redirect($this->agent->referrer());
	        } else {
	            $this->session->set_userdata('error', "Category Update Faild");
	            redirect($this->agent->referrer());
	        }
	    }
	function fetch_all_sub_category()
     {
      if($this->input->post('category_id'))
      {
       echo $this->category_model->fetch_all_sub_category($this->input->post('category_id'));
      }
     }

    function fetch_all_child_sub_category()
     {
      if($this->input->post('sub_category'))
      {
       echo $this->category_model->fetch_all_child_sub_category($this->input->post('sub_category'));
      }
     }

     function fetch_all_varient()
     {
      if($this->input->post('category_id'))
      {
       echo $this->category_model->fetch_all_varient($this->input->post('category_id'));
      }
     }
     
     function fetch_category_comission()
     {
      if($this->input->post('category_id'))
      {
       echo $this->category_model->fetch_category_comission($this->input->post('category_id'));
      }
     }

    public function request_new_category()
    {
      $data['title'] = 'Request Category';
      $data['app_setting'] = $this->setting_model->get_all_app_setting(); 
      $data['get_all_category_name'] = $this->category_model->get_all_category_name();
      $data['get_all_varient'] = $this->varient_model->get_all_varient();
      $this->load->view('admin/include/header', $data);
      $this->load->view('admin/category/request_new_category', $data);
      $this->load->view('admin/include/footer', $data);
    }

    public function pending_category()
    {
      $data['title'] = 'Pending Category';
      $data['app_setting'] = $this->setting_model->get_all_app_setting();
      $data['get_all_category_name'] = $this->category_model->get_all_category_name();
      $data['get_all_category'] = $this->category_model->get_all_category_name();
      $data['get_all_varient'] = $this->varient_model->get_all_varient();
      $this->load->view('admin/include/header', $data);
      $this->load->view('admin/category/pending_category', $data);
      $this->load->view('admin/include/footer', $data);
    }

     function fetch_all_category_for_admin_panel()
     {
       echo $this->category_model->fetch_all_category_for_admin_panel($this->input->post('category_id'));
     }

    

    


     
}

