<?php
defined('BASEPATH') or exit('No direct script access allowed');
require './vendor/autoload.php';

use Razorpay\Api\Api;
use Razorpay\Api\Errors\SignatureVerificationError;

class Course extends Admin_Core_Controller
{

    public function __construct()
    {
        parent::__construct();
        // check_permission('course');
    }

    public function add_new_course()
    {
        $data['title'] = 'Add New Course';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['get_all_category_name'] = $this->category_model->get_all_cat_for_cat_page();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/course/add_new_course');
        $this->load->view('admin/include/footer');
    }

    public function add_course()
    {
        if ($course_id = $this->course_model->add_course()) {
            $this->session->set_userdata('success', "Course Successfully Added");
            redirect(base_url() . 'admin/course/edit_course/' . $course_id);
        } else {
            $this->session->set_userdata('error', "Course Added Faild");
            redirect($this->agent->referrer());
        }
    }

    public function view_all_course()
    {
        $data['title'] = 'View All Course';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['get_all_course'] = $this->course_model->get_all_course_for_admin_panel();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/course/view_all_course');
        $this->load->view('admin/include/footer');
    }

    public function edit_course($id)
    {
        $data['title'] = 'Edit Course';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['course'] = $this->course_model->get_course($id);
        $data['get_all_category_name'] = $this->category_model->get_all_cat_for_cat_page();
        $data['all_resource'] = $this->course_model->get_all_course_resource();
        
        if ($data['course']->course_theme == 'theme_1') {
            $this->load->view('admin/include/header', $data);
            $this->load->view('admin/course/edit_course_theme_1');
            $this->load->view('admin/include/footer');
        } elseif ($data['course']->course_theme == 'theme_2') {
            $data['all_course'] = $this->course_model->get_all_course_for_fbt($id, $data['course']->course_category);
            $this->load->view('admin/include/header', $data);
            $this->load->view('admin/course/edit_course_theme_2');
            $this->load->view('admin/include/footer');
        } elseif ($data['course']->course_theme == 'theme_3') {
            $data['all_course'] = $this->course_model->get_all_course_for_theme_3($id);
            $this->load->view('admin/include/header', $data);
            $this->load->view('admin/course/edit_course_theme_3');
            $this->load->view('admin/include/footer');
        }
    }

    function upload_course_certified_for_data()
    {
        echo $this->course_model->upload_course_certified_for_data();
    }

    public function delete_course_certified_data($id, $key)
    {
        if ($this->course_model->delete_course_certified_data_by_key($id, $key)) {
            $this->session->set_userdata('success', "Data Successfully delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Data delete Faild");
            redirect($this->agent->referrer());
        }
    }

    function upload_course_certification_for_data()
    {
        echo $this->course_model->upload_course_certification_for_data();
    }

    public function delete_course_certification_data($id, $key)
    {
        if ($this->course_model->delete_course_certification_data_by_key($id, $key)) {
            $this->session->set_userdata('success', "Data Successfully delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Data delete Faild");
            redirect($this->agent->referrer());
        }
    }

    function upload_course_marketing_tools_for_data()
    {
        echo $this->course_model->upload_course_marketing_tools_for_data();
    }

    public function delete_course__marketing_tools_data($id, $key)
    {
        if ($this->course_model->delete_course__marketing_tools_data_by_key($id, $key)) {
            $this->session->set_userdata('success', "Data Successfully delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Data delete Faild");
            redirect($this->agent->referrer());
        }
    }

    function upload_course_ai_tools_for_data()
    {
        echo $this->course_model->upload_course_ai_tools_for_data();
    }

    public function delete_course_ai_tools_data($id, $key)
    {
        if ($this->course_model->delete_course_ai_tools_data_by_key($id, $key)) {
            $this->session->set_userdata('success', "Data Successfully delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Data delete Faild");
            redirect($this->agent->referrer());
        }
    }

    function upload_course_hiring_partner_for_data()
    {
        echo $this->course_model->upload_course_hiring_partner_for_data();
    }

    public function delete_course_hiring_partner_data($id, $key)
    {
        if ($this->course_model->delete_course_hiring_partner_data_by_key($id, $key)) {
            $this->session->set_userdata('success', "Data Successfully delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Data delete Faild");
            redirect($this->agent->referrer());
        }
    }

    function upload_course_whats_include_for_data()
    {
        echo $this->course_model->upload_course_whats_include_for_data();
    }

    public function delete_whats_include_partner_data($id, $key)
    {
        if ($this->course_model->delete_whats_include_partner_data_by_key($id, $key)) {
            $this->session->set_userdata('success', "Data Successfully delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Data delete Faild");
            redirect($this->agent->referrer());
        }
    }

    function upload_course_learning_methodology_for_data()
    {
        echo $this->course_model->upload_course_learning_methodology_for_data();
    }

    public function delete_learning_methodology_data($id, $key)
    {
        if ($this->course_model->delete_learning_methodology_data_by_key($id, $key)) {
            $this->session->set_userdata('success', "Data Successfully delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Data delete Faild");
            redirect($this->agent->referrer());
        }
    }





    function update_course($id)
    {
        if ($this->course_model->update_course($id)) {
            $this->session->set_userdata('success', "Course Successfully Update");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Course Update Faild");
            redirect($this->agent->referrer());
        }
    }

    function update_course_theme_2($id)
    {
        if ($this->course_model->update_course_theme_2($id)) {
            $this->session->set_userdata('success', "Course Successfully Update");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Course Update Faild");
            redirect($this->agent->referrer());
        }
    }

    public function course_delete($id)
    {
        if ($this->course_model->course_delete($id)) {
            $this->session->set_userdata('success', "Course Successfully delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Course delete Faild");
            redirect($this->agent->referrer());
        }
    }





    // public function edit_course($id)
    // {
    //     if($_POST['title'])
    //     {
    //         if ($this->course_model->edit_course($id)) {
    //             $this->session->set_userdata('success', "Course Successfully Updated");
    //             // redirect($this->agent->referrer());
    //         } else {
    //             $this->session->set_userdata('error', "Course Updated Faild");
    //             // redirect($this->agent->referrer());
    //         }
    //     }
    //     else
    //     {
    //         redirect($this->agent->referrer());
    //     }
    // }

    public function all_course_inquery()
    {
        $data['title'] = 'All Course Inquery';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['course_inq'] = $this->course_model->get_all_course_inq();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/course/all_course_inquery');
        $this->load->view('admin/include/footer');
    }


    public function course_lession()
    {
        $data['title'] = 'Course Lession';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['get_all_course'] = $this->course_model->get_all_course();
        $data['get_all_lession'] = $this->course_model->get_all_lession();

        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/course/course_lession');
        $this->load->view('admin/include/footer');
    }


    public function add_new_lession()
    {
        if ($this->course_model->add_new_lession()) {
            $this->session->set_userdata('success', "Lession Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Lession Added Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_lession()
    {
        if ($this->course_model->update_lession()) {
            $this->session->set_userdata('success', "Lession Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Lession Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete_lession($id)
    {
        if ($this->course_model->delete_lession($id)) {
            $this->session->set_userdata('success', "Lession Successfully delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Lession delete Faild");
            redirect($this->agent->referrer());
        }
    }

    public function course_faq()
    {
        $data['title'] = 'Course FAQ';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['get_all_course'] = $this->course_model->get_all_course();
        $data['get_all_faq'] = $this->course_model->get_all_faq();

        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/course/course_faq');
        $this->load->view('admin/include/footer');
    }


    public function add_new_course_faq()
    {
        if ($this->course_model->add_new_course_faq()) {
            $this->session->set_userdata('success', "FAQ Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "FAQ Added Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_course_faq()
    {
        if ($this->course_model->update_course_faq()) {
            $this->session->set_userdata('success', "FAQ Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "FAQ Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete_course_faq($id)
    {
        if ($this->course_model->delete_course_faq($id)) {
            $this->session->set_userdata('success', "FAQ Successfully delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "FAQ delete Faild");
            redirect($this->agent->referrer());
        }
    }

    public function live_video_class_application()
    {
        $data['title'] = 'Live Video Class';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['get_all_application'] = $this->course_model->get_all_apply_live_video_class();

        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/course/live_video_class_application');
        $this->load->view('admin/include/footer');
    }

    public function demo_class_application()
    {
        $data['title'] = 'Demo Class Application';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['get_all_application'] = $this->course_model->get_all_apply_free_demo_class();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/course/demo_class_application');
        $this->load->view('admin/include/footer');
    }

    function spin_setting()
    {
        $data['title'] = 'Spin Setting';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['spin_details'] = $this->course_model->get_spin_details();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/course/spin_setting');
        $this->load->view('admin/include/footer');
    }

    function update_spin_data()
    {
        if ($this->course_model->update_spin_data()) {
            $this->session->set_userdata('success', "Data Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Data Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    function online_reg_student()
    {
        $data['title'] = 'Online Reg. Student';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['all_student'] = $this->course_model->get_all_online_reg_student();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/course/online_reg_student');
        $this->load->view('admin/include/footer');
    }

    function all_download_syllabus()
    {
        $data['title'] = 'Demo Class Application';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['get_all_application'] = $this->course_model->get_all_download_syllabus();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/course/all_download_syllabus');
        $this->load->view('admin/include/footer');
    }

    function my_courses()
    {
        $data['title'] = 'My Course';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();

        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/course/my_course');
        $this->load->view('admin/include/footer');
    }

    function pay_due_amount($id)
    {
        $course_id      = user()->course;
        $course_last_id = user()->course_pay_last_id;
        $this->db->select('a.title, a.image, a.duration, a.course_adv_payment, a.online_training_price, a.online_training_discount, b.*');
        $this->db->from('course a');
        $this->db->join('course_inquery b', 'b.course_inq_course_id = a.id', 'left');
        $this->db->where('a.id', $course_id);
        $this->db->where('b.course_inq_id', $course_last_id);
        $course = $this->db->get()->row();
        $this->session->set_userdata('course_last_id',  $id);
        $this->session->set_userdata('last_payment', $course->course_inq_pay_amount);
        if ($course->online_training_discount) {
            $main_p =  $course->online_training_discount;
        } else {
            $main_p = $course->online_training_price;
        };

        $amounts =  $main_p - $course->course_inq_pay_amount;


        $app_setting = $this->setting_model->get_all_app_setting();
        $rand = "RAOR" . date("Ymd") . rand(1000, 9999);
        $order_id = $rand;
        $api = new Api($app_setting->rozar_key_id, $app_setting->rozar_key_secret);
        $razorpayOrder = $api->order->create(array(
            'receipt'         => $order_id,
            'amount'          => $amounts * 100,
            'currency'        => 'INR',
            'payment_capture' => 1
        ));
        $amount = $razorpayOrder['amount'];
        $razorpayOrderId = $razorpayOrder['id'];
        $_SESSION['razorpay_order_id'] = $razorpayOrderId;
        $_SESSION['recharge_id'] = $order_id;
        $_SESSION['amount'] = $amount;
        $raz_pay_data = $this->rozr_pay_prepareData_prd_pay($amount, $razorpayOrderId, $order_id);
        $this->load->view('rezorpay_due_course_prd_payment', array('data' => $raz_pay_data));
    }

    public function rozr_pay_prepareData_prd_pay($amount, $razorpayOrderId, $order_id)
    {
        $app_setting = $this->setting_model->get_all_app_setting();
        $data = array(
            "key" => $app_setting->rozar_key_id,
            "amount" => $amount,
            "name" => $order_id,
            "description" => $app_setting->application_name,
            "image" => base_url() . $app_setting->header_logo,
            "prefill" => array(
                "name"  => user()->name,
                "email"  => user()->email,
                "contact" => user()->mobile,
            ),
            "notes"  => array(
                "address"  => "Hello World",
                "merchant_order_id" => rand(),
            ),
            "theme"  => array(
                "color"  => "#F37254"
            ),
            "order_id" => $razorpayOrderId,
        );
        return $data;
    }

    function rozr_pay_verify_due_course_pay()
    {
        $app_setting = $this->setting_model->get_all_app_setting();
        $success = true;
        $error = "payment_failed";
        if (empty($_POST['razorpay_payment_id']) === false) {
            $api = new Api($app_setting->rozar_key_id, $app_setting->rozar_key_secret);
            try {
                $attributes = array(
                    'razorpay_order_id' => $_SESSION['razorpay_order_id'],
                    'razorpay_payment_id' => $_POST['razorpay_payment_id'],
                    'razorpay_signature' => $_POST['razorpay_signature']
                );
                $api->utility->verifyPaymentSignature($attributes);
            } catch (SignatureVerificationError $e) {
                $success = false;
                $error = 'Razorpay_Error : ' . $e->getMessage();
            }
        }
        if ($success === true) {

            $amt = $_SESSION['amount'] / 100;
            $main_amt = $amt + $this->session->userdata('last_payment');
            $info['course_inq_payment']                 = 1;
            $info['course_inq_pay_id']                  = $_POST['razorpay_payment_id'];
            $info['course_inq_pay_amount']              = $main_amt;
            if ($this->course_model->update_request_course_payment_data($info, $this->session->userdata('course_last_id'))) {
                $this->session->set_userdata('success_page', 'Yes');
                $this->session->set_userdata('success', 'Wow ! Congrats,Your your order is Confirm with us');
                redirect(base_url() . 'admin/course/my_courses');
            } else {
                $this->session->set_userdata('error', 'Transaction Done But System Error. Please Contact Support Team.');
                redirect(base_url() . 'admin/course/my_courses');
            }
        } else {
            $this->session->set_userdata('error', 'Transaction Faild');
            redirect(base_url() . 'admin/course/my_courses');
        }
    }

    function delete_ass_pdf($id)
    {
        echo $this->course_model->delete_ass_pdf($id);
    }

    function delete_mini_pdf($id)
    {
        echo $this->course_model->delete_mini_pdf($id);
    }

    // Course Section & Lession Start

    public function sections($param1 = "", $param2 = "", $param3 = "")
    {
        if ($param2 == 'add') {
            $this->course_model->add_section($param1);
            $this->session->set_userdata('success', get_phrase('section_has_been_added_successfully'));
        } elseif ($param2 == 'edit') {
            $this->course_model->edit_section($param3);
            $this->session->set_userdata('success', get_phrase('section_has_been_updated_successfully'));
        } elseif ($param2 == 'delete') {
            $this->course_model->delete_section($param1, $param3);
            $this->session->set_userdata('success', get_phrase('section_has_been_deleted_successfully'));
        }
        redirect(base_url() . 'admin/course/edit_course/' . $param1);
    }

    public function ajax_sort_section()
    {
        $section_json = $this->input->post('itemJSON');
        $this->course_model->sort_section($section_json);
    }

    public function ajax_sort_lesson()
    {
        $lesson_json = $this->input->post('itemJSON');
        $this->course_model->sort_lesson($lesson_json);
    }

    public function lessons($course_id = "", $param1 = "", $param2 = "")
    {
        if ($param1 == 'add') {
            $this->course_model->add_lesson();
            $this->session->set_userdata('success', get_phrase('lesson_has_been_added_successfully'));
            redirect(base_url() . 'admin/course/edit_course/' . $course_id);
        } elseif ($param1 == 'edit') {
            $this->course_model->edit_lesson($param2);
            $this->session->set_userdata('success', get_phrase('lesson_has_been_updated_successfully'));
            redirect(base_url() . 'admin/course/edit_course/' . $course_id);
        } elseif ($param1 == 'delete') {
            $this->course_model->delete_lesson($param2);
            $this->session->set_userdata('success', get_phrase('lesson_has_been_deleted_successfully'));
            redirect(base_url() . 'admin/course/edit_course/' . $course_id);
        } elseif ($param1 == 'filter') {
            redirect('admin/lessons/' . $this->input->post('course_id'));
        }
        // $page_data['page_name'] = 'lessons';
        // $page_data['lessons'] = $this->crud_model->get_lessons('course', $course_id);
        // $page_data['course_id'] = $course_id;
        // $page_data['page_title'] = get_phrase('lessons');
        // $this->load->view('backend/index', $page_data);
        redirect(base_url() . 'admin/course/edit_course/' . $course_id);
    }

    public function quizes($course_id = "", $action = "", $quiz_id = "")
    {

        if ($action == 'add') {
            $this->course_model->add_quiz($course_id);
            $this->session->set_userdata('success', get_phrase('quiz_has_been_added_successfully'));
        } elseif ($action == 'edit') {
            $this->course_model->edit_quiz($quiz_id);
            $this->session->set_userdata('success', get_phrase('quiz_has_been_updated_successfully'));
        } elseif ($action == 'delete') {
            $this->course_model->delete_section($course_id, $quiz_id);
            $this->session->set_userdata('success', get_phrase('quiz_has_been_deleted_successfully'));
        }
        redirect(base_url() . 'admin/course/edit_course/' . $course_id);
    }

    // Manage Quize Questions
    public function quiz_questions($quiz_id = "", $action = "", $question_id = "")
    {
        $quiz_details = $this->course_model->get_lessons('lesson', $quiz_id)->row_array();

        $quiz_details = $this->course_model->get_lessons('lesson', $quiz_id)->row_array();

        if ($action == 'add' || $action == 'edit') {
            echo $this->course_model->manage_quiz_questions($quiz_id, $question_id, $action);
        } elseif ($action == 'delete') {
            $response = $this->course_model->delete_quiz_question($question_id);
            $this->session->set_userdata('success', get_phrase('question_has_been_deleted'));
            redirect(base_url() . 'admin/course/edit_course/' . $quiz_details['course_id']);
        }
    }

    // AJAX PORTION
    // this function is responsible for managing multiple choice question
    function manage_multiple_choices_options()
    {
        $page_data['number_of_options'] = $this->input->post('number_of_options');
        $this->load->view('admin/manage_multiple_choices_options', $page_data);
    }

    function quiz_fields_type_wize()
    {
        $page_data['question_type'] = $this->input->post('question_type');
        $this->load->view('admin/quiz_fields_type_wize', $page_data);
    }

    public function ajax_sort_question()
    {
        $question_json = $this->input->post('itemJSON');
        $this->course_model->sort_question($question_json);
    }

    function resource_files($param1 = "", $param2 = "")
    {
        if ($param1 == 'add') {
            if (isset($_FILES['resource_file']['name']) && $_FILES['resource_file']['name'] != "") {
                $data['file_name'] = random(20) . '.' . pathinfo($_FILES['resource_file']['name'], PATHINFO_EXTENSION);
                move_uploaded_file($_FILES['resource_file']['tmp_name'], 'uploads/resource_files/' . $data['file_name']);
            }

            $data['title'] = $this->input->post('title');
            $data['category_id'] = $this->input->post('category_id');
            $data['lesson_id'] = $param2;
            $data['created_at'] = time();
            $this->db->insert('resource_files', $data);

            $response['replace'] = ['elem' => '.resource_file_content', 'content' => $this->load->view('admin/resource_files', ['param2' => $param2], true)];
            echo json_encode($response);
        } elseif ($param1 == 'update') {
            $file_details = $this->db->get_where('resource_files', ['id' => $param2])->row_array();
            if (isset($_FILES['resource_file']['name']) && $_FILES['resource_file']['name'] != "") {
                if (file_exists('uploads/resource_files/' . $file_details['file_name']) && $file_details['file_name']) {
                    unlink('uploads/resource_files/' . $file_details['file_name']);
                }
                $data['file_name'] = random(20) . '.' . pathinfo($_FILES['resource_file']['name'], PATHINFO_EXTENSION);
                move_uploaded_file($_FILES['resource_file']['tmp_name'], 'uploads/resource_files/' . $data['file_name']);
            }

            $data['title'] = $this->input->post('title');
            $data['updated_at'] = time();
            $this->db->where('id', $param2);
            $this->db->update('resource_files', $data);

            $response['replace'] = ['elem' => '.resource_file_content', 'content' => $this->load->view('admin/resource_files', ['param2' => $file_details['lesson_id']], true)];
            echo json_encode($response);
        } elseif ($param1 == 'delete') {
            $file_details = $this->db->get_where('resource_files', ['id' => $param2])->row_array();
            if (file_exists('uploads/resource_files/' . $file_details['file_name']) && $file_details['file_name']) {
                unlink('uploads/resource_files/' . $file_details['file_name']);
            }

            $this->db->where('id', $param2);
            $this->db->delete('resource_files');

            $response['replace'] = ['elem' => '.resource_file_content', 'content' => $this->load->view('admin/resource_files', ['param2' => $file_details['lesson_id']], true)];
            $response['success'] = get_phrase('Resource deleted successfully');
            $response['fadeOut'] = '#resource_file_' . $file_details['id'];
            echo json_encode($response);
        }
    }

    public function ajax_get_video_details()
    {
        $this->load->model('video_model');

        $video_details = $this->video_model->getVideoDetails($_POST['video_url']);
        if (is_array($video_details)) {
            echo $video_details['duration'];
        }
    }

    //Mark this lesson as completed automatically
    function update_watch_history_with_duration()
    {
        echo $this->course_model->update_watch_history_with_duration();
    }

    // Mark this lesson as completed codes
    function update_watch_history_manually()
    {
        echo $this->course_model->update_watch_history_manually();
    }

    // Course Section & Lession Start

    /**
     * Bundle Course Start
     */
    function view_bundle_course()
    {
        $data['title'] = 'Resource Category';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['all_data'] = $this->course_model->get_all_bundle_course();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/course/all_bundle_course');
        $this->load->view('admin/include/footer');
    }

    function add_new_bundle()
    {
        $data['title'] = 'Resource Category';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/course/add_new_bundle');
        $this->load->view('admin/include/footer');
    }

    function add_bundle()
    {
        if ($bundle_id = $this->course_model->add_bundle()) {
            $this->session->set_userdata('success', "Bundle Successfully Added");
            redirect(base_url() . 'admin/course/edit_bundle/' . $bundle_id);
        } else {
            $this->session->set_userdata('error', "Bundle Added Faild");
            redirect($this->agent->referrer());
        }
    }

    function edit_bundle($id)
    {
        $data['title'] = 'Resource Category';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['data'] = $this->course_model->get_bundle_course_by_id($id);
        $data['all_course'] = $this->course_model->get_all_course_for_admin_panel();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/course/edit_bundle');
        $this->load->view('admin/include/footer');
    }

    function update_bundle($id)
    {
        if ($this->course_model->update_bundle($id)) {
            $this->session->set_userdata('success', "Bundle Successfully Updated");
            redirect(base_url() . 'admin/course/view_bundle_course');
        } else {
            $this->session->set_userdata('error', "Bundle Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    function upload_bundle_blueprint_form_data()
    {
        echo $this->course_model->upload_bundle_blueprint_form_data();
    }

    public function delete_bundle_bluprint_data($id, $key)
    {
        if ($this->course_model->delete_bundle_bluprint_data($id, $key)) {
            $this->session->set_userdata('success', "Data Successfully delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Data delete Faild");
            redirect($this->agent->referrer());
        }
    }
    /**
     * Bundle Course End
     */

    /**
     * Resource Category Start
     */
    function all_resource_category()
    {
        $data['title'] = 'Resource Category';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['all_data'] = $this->course_model->get_all_resource_category();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/course/resource_category');
        $this->load->view('admin/include/footer');
    }

    function add_new_resource_category()
    {
        if ($this->course_model->add_new_resource_category()) {
            $this->session->set_userdata('success', "Category Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Category Added Faild");
            redirect($this->agent->referrer());
        }
    }

    function update_resource_category($id)
    {
        if ($this->course_model->update_resource_category($id)) {
            $this->session->set_userdata('success', "Category Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Category Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    function delete_recource_category($id)
    {
        if ($this->course_model->delete_recource_category($id)) {
            $this->session->set_userdata('success', "Category Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Category Deleted Faild");
            redirect($this->agent->referrer());
        }
    }
    /**
     * Resource Category ENd
     */

    /**
     * Course Resource Start
     */

    function all_course_resource()
    {
        $data['title'] = 'Resource Category';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['all_data'] = $this->course_model->get_all_course_resource();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/course/course_resource');
        $this->load->view('admin/include/footer');
    }

    function add_course_resource()
    {
        if ($this->course_model->add_course_resource()) {
            $this->session->set_userdata('success', "Resource Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Resource Added Faild");
            redirect($this->agent->referrer());
        }
    }

    function update_course_resource($id)
    {
        if ($this->course_model->update_course_resource($id)) {
            $this->session->set_userdata('success', "Resource Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Resource Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    function delete_course_resource($id)
    {
        if ($this->course_model->delete_course_resource($id)) {
            $this->session->set_userdata('success', "Resource Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Resource Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

    /**
     * Course Resource End
     */


    /**
     * LMS Course Start
     */
    function my_course()
    {
        $data['title'] = 'My Course';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['enrolments'] = $this->course_model->get_course_by_studement_enrole();
        $this->load->view('admin/student_lms/include/header', $data);
        $this->load->view('admin/student_lms/my_course');
        $this->load->view('admin/student_lms/include/footer');
    }

    function forum($id)
    {
        $this->load->model('addons/course_forum_model');

        $data['title'] = 'Forum';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['starting_value'] = 1000;
        $data['course_id'] = $id;
        $data['questions'] = $this->course_forum_model->get_course_wise_limited_questions($id, 10)->result_array();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/course/forum');
        $this->load->view('admin/include/footer');
    }
    /**
     * LMS Course End
     */

    public function download_curriculum($course_id)
    {
        $sections = $this->course_model->get_section('course', $course_id)->result_array();
        $lines = [];

        $i = 1;
        foreach ($sections as $section) {
            $lines[] = $i . '. ' . $section['title'];

            // Fetch lessons in this section
            $lessons = $this->course_model->get_lessons('section', $section['id'])->result_array();
            $j = 1;
            foreach ($lessons as $lesson) {
                $numbering = $i . '.' . $j;
                $icon = strtoupper($lesson['lesson_type']); // Optional: show type
                $title = $lesson['title'];
                $duration = ($lesson['lesson_type'] == 'video') ? ' (' . substr($lesson['duration'], 3) . ' min)' : '';
                $lines[] = '    ├─ ' . $numbering . ' [' . $icon . '] ' . $title . $duration;
                $j++;
            }

            $lines[] = ''; // blank line for spacing
            $i++;
        }

        // Convert lines to CRLF for Notepad compatibility
        $file_content = implode("\r\n", $lines);

        // Set headers for file download
        header('Content-Type: text/plain');
        header('Content-Disposition: attachment; filename="curriculum_export.txt"');
        header('Content-Length: ' . strlen($file_content));
        echo $file_content;
        exit;
    }
}

/* End of file Admin.php */
/* Location: ./application/controllers/Admin/Admin.php */