<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ebook extends Admin_Core_Controller {

    public function __construct()
    {
        parent::__construct();
        check_permission('ebook');
    }
    

    public function add_new_ebook()
    {
        $data['title'] = 'Add New E-book';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['visual_setting'] = $this->setting_model->get_visual_setting();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/ebook/add_new_ebook');
        $this->load->view('admin/include/footer');
    }

    public function view_all_ebook()
    {
        $data['title'] = 'view All E-Book';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['visual_setting'] = $this->setting_model->get_visual_setting();
        $data['get_all_ebook'] = $this->ebook_model->get_all_ebook();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/ebook/view_all_ebook');
        $this->load->view('admin/include/footer');
    }

    

     public function add_new_events()
    {
        if ($this->event_model->add_new_events()) {
            $this->session->set_userdata('success', "Event Successfully Added");
          //  redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Event Added Faild");
           // redirect($this->agent->referrer());
        }
    }

    function build_new_page($id)
    {
        $data['title'] = 'Events';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['visual_setting'] = $this->setting_model->get_visual_setting();
        $data['ebook'] = $this->ebook_model->get_ebook_by_id($id);
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/ebook/build_new_page');
        $this->load->view('admin/include/footer');
    }

    public function add_page()
    {
        if ($this->ebook_model->add_page()) {
            $this->session->set_userdata('success', "Page Successfully Added");
            redirect(base_url().'admin/ebook/view_all_ebook');
        } else {
            $this->session->set_userdata('error', "Page Added Faild");
            redirect($this->agent->referrer());
        }
    }

    function update_ebook_page($id)
    {
        $data['title'] = 'Update Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting(); 
        $data['page'] = $this->ebook_model->get_build_page_by_ebook_id($id);      
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/ebook/update_build_page');
        $this->load->view('admin/include/footer');
    }

    function update_page($id)
    {
        if ($this->ebook_model->update_page($id)) {
            $this->session->set_userdata('success', "Page Successfully Updated");
            redirect(base_url().'admin/ebook/view_all_ebook');
        } else {
            $this->session->set_userdata('error', "Page Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    function page_pass_details()
    {
        $data['title'] = 'Vip Pass Details';
        $data['app_setting'] = $this->setting_model->get_all_app_setting(); 
        $data['all_pass_details'] = $this->ebook_model->all_pass_details();  
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/ebook/page_pass_details');
        $this->load->view('admin/include/footer');
    }

    function add_new_pass()
    {
        $data['title'] = 'Add Pass';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();     
        $data['all_page'] = $this->ebook_model->all_event_main_page_for_pass();   
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/ebook/add_new_pass', $data);
        $this->load->view('admin/include/footer', $data);
    }

    function add_new_vip_pass()
    {
        if ($this->ebook_model->add_new_vip_pass()) {
            $this->session->set_userdata('success', "Pass Successfully Added");
            redirect(base_url().'admin/ebook/page_pass_details');
        } else {
            $this->session->set_userdata('error', "Pass Added Faild");
            redirect($this->agent->referrer());
        }
    }

    function edit_pass_details($id)
    {
        $data['title'] = 'Update Pass Details';
        $data['app_setting'] = $this->setting_model->get_all_app_setting(); 
        $data['pass_details'] = $this->ebook_model->get_pass_details_by_id($id);     
        $data['all_page'] = $this->ebook_model->all_event_main_page_for_pass();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/ebook/edit_pass_details', $data);
        $this->load->view('admin/include/footer', $data);
    }

    function update_vip_pass_details($id)
    {
        if ($this->ebook_model->update_vip_pass_details($id)) {
            $this->session->set_userdata('success', "Pass Successfully Updated");
            redirect(base_url().'admin/ebook/page_pass_details');
        } else {
            $this->session->set_userdata('error', "Pass Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    function delete_pass_details($id)
    {
        if ($this->ebook_model->delete_pass_details($id)) {
            $this->session->set_userdata('success', "Pass Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Pass Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

    function thank_you_page()
    {
        $data['title'] = 'Thank You Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting(); 
        $data['all_thank_page'] = $this->ebook_model->all_thank_you_page();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/ebook/thank_you_page', $data);
        $this->load->view('admin/include/footer', $data);
    }

    function add_new_thank_you_page()
    {
        $data['title'] = 'Add Thanks Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting(); 
        $data['all_page'] = $this->ebook_model->all_event_main_page_for_pass();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/ebook/add_new_thank_you_page', $data);
        $this->load->view('admin/include/footer', $data);
    }

    function add_thanks_page()
    {
        if ($this->ebook_model->add_thanks_page()) {
            $this->session->set_userdata('success', "Thanks Page Successfully Added");
            redirect(base_url().'admin/ebook/thank_you_page');
        } else {
            $this->session->set_userdata('error', "Thanks Page Added Faild");
            redirect($this->agent->referrer());
        }
    }

    function edit_thanks_page($id)
    {
        $data['title'] = 'Edit Thanks Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting(); 
        $data['thank_page'] = $this->ebook_model->get_thank_page_by_id($id); 
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/ebook/edit_thanks_page', $data);
        $this->load->view('admin/include/footer', $data);
    }

    function update_thanks_page($id)
    {
        if ($this->ebook_model->update_thanks_page($id)) {
            $this->session->set_userdata('success', "Thanks Page Successfully Updated");
            redirect(base_url().'admin/ebook/thank_you_page');
        } else {
            $this->session->set_userdata('error', "Thanks Page Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    function delete_thank_page($id)
    {
        if ($this->ebook_model->delete_thank_page($id)) {
            $this->session->set_userdata('success', "Thanks Page Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Thanks Page Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

    
   


}

/* End of file Events.php */
/* Location: ./application/views/front/Events.php */