<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Editor extends Admin_Core_Controller {

	public function __construct()
    {
        parent::__construct();
        check_permission('editor');
    }

	public function view_editor()
	{
		$data['title'] = 'Add New Page';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$this->load->view('admin/dynamic_editor/builder', $data);
	}

	public function view_editor_page()
	{
		$data['title'] = 'View Page';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$this->load->view('admin/dynamic_editor/view', $data);
	}

	public function add_new_content()
    {
		if ($this->editor_model->add_new_content()) 
		{
	         echo "The page Successfully Saved";
	    } 
	    else 
	    {
	        echo "Failed";
	    }
    }

    public function update_content()
    {
		if ($this->editor_model->update_content()) 
		{
	         echo "The page Successfully Updated";
	    } 
	    else 
	    {
	        echo "Failed";
	    }
    }

    public function add_image()
    {
		if ($image = $this->editor_model->add_image()) 
		{
			if($image == 2)
			{
	         echo "Sorry, there was an error uploading your file.";
			}
			else
			{
				echo json_encode($image);
			}
	    } 
    }

    public function add_content_image()
    {
		if ($image = $this->editor_model->add_content_image()) 
		{
			if($image == 1)
			{
	         echo "Image Successfully Added";
			}
			elseif($image == 2)
			{
				echo "Sorry, there was an error uploading your file.";
			}
			else
			{
				echo 'Sorry, only JPG, JPEG, PNG, GIF, & PDF files are allowed to upload.';
			}
	    } 
    }

    public function clearContent()
    {
		$clear = $this->input->post('clear');

		if ('clear' === $clear) {
		    if (isset($_SESSION["page"])) {
		        unset($_SESSION["title"]);
		        unset($_SESSION["page"]);
		        session_destroy();
		        echo '<script>localStorage.clear();'
		        . 'location.reload(true);</script>';
		    } else {
		        echo '<script>localStorage.clear();'
		        . 'location.reload(true)</script>';
		    }
		    // remove PHPSESSID from browser
		    if (isset($_COOKIE[session_name()])) {
		        setcookie(session_name(), "", time() - 3600, " / ");
		        // clear session from globals
		        $_SESSION = array();
		        // clear session from disk
		        session_destroy();
		    }
		}
    }


	public function delete_page($id)
    {
        if ($this->event_model->delete_page($id)) {
            $this->session->set_userdata('success', "Event Successfully Delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Event Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

//------------------------Ebook Start ---------------------------------
    public function view_editor_for_ebook()
	{
		$data['title'] = 'Add New Page';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$this->load->view('admin/dynamic_editor/builder_for_ebook', $data);
	}

	public function add_image_for_ebook()
    {
		if ($image = $this->editor_model->add_image_for_ebook()) 
		{
			if($image == 2)
			{
	         echo "Sorry, there was an error uploading your file.";
			}
			else
			{
				echo json_encode($image);
			}
	    } 
    }

    public function view_editor_page_for_ebook()
	{
		$data['title'] = 'View Page';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$this->load->view('admin/dynamic_editor/view_for_ebook', $data);
	}

	public function add_new_content_for_ebook()
    {
		if ($this->editor_model->add_new_content_for_ebook()) 
		{
	         echo "The page Successfully Saved";
	    } 
	    else 
	    {
	        echo "Failed";
	    }
    }

    public function update_content_for_ebook()
    {
		if ($this->editor_model->update_content_for_ebook()) 
		{
	         echo "The page Successfully Updated";
	    } 
	    else 
	    {
	        echo "Failed";
	    }
    }

    public function add_content_image_for_ebook()
    {
		if ($image = $this->editor_model->add_content_image_for_ebook()) 
		{
			if($image == 1)
			{
	         echo "Image Successfully Added";
			}
			elseif($image == 2)
			{
				echo "Sorry, there was an error uploading your file.";
			}
			else
			{
				echo 'Sorry, only JPG, JPEG, PNG, GIF, & PDF files are allowed to upload.';
			}
	    } 
    }

    

    public function delete_page_for_ebook($id)
    {
        if ($this->ebook_model->delete_page_for_ebook($id)) {
            $this->session->set_userdata('success', "Event Successfully Delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Event Deleted Faild");
            redirect($this->agent->referrer());
        }
    }


    

}

/* End of file Admin.php */
/* Location: ./application/controllers/Admin/Admin.php */