<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Employee_management extends Admin_Core_Controller {

    public function __construct()
    {
        parent::__construct();
        check_permission('emp_management');
        $this->load->model('employee_model');
    }
    
    public function view_all_employee()
    {
        $data['title'] = 'All Employee';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['visual_setting'] = $this->setting_model->get_visual_setting();
        $data['get_all_employee'] = $this->employee_model->get_all_employee_for_admin();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/employee/view_all_employee');
        $this->load->view('admin/include/footer');
    }

    public function add_new_employee()
    {
        $data['title'] = 'Add New Employee';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['visual_setting'] = $this->setting_model->get_visual_setting();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/employee/add_new_employee');
        $this->load->view('admin/include/footer');
    }

    
     public function new_employee_add()
    {
        if ($this->employee_model->new_employee_add()) {
            $this->session->set_userdata('success', "Employee Successfully Added");
            redirect(base_url().'admin/employee_management/view_all_employee');
        } else {
            $this->session->set_userdata('error', "Employee Added Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete($id)
    {
        if ($this->employee_model->delete($id)) {
            $this->session->set_userdata('success', "Employee Successfully Deleted");
            redirect(base_url().'admin/employee_management/view_all_employee');
        } else {
            $this->session->set_userdata('error', "Employee Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_employee($id)
    {
        $data['title'] = 'Update Employee';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['visual_setting'] = $this->setting_model->get_visual_setting();
        $data['employee'] = $this->employee_model->get_employee_by_id($id);
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/employee/update_employee');
        $this->load->view('admin/include/footer');
    }

    public function update_employee_add()
    {
        if ($this->employee_model->update_employee()) {
            $this->session->set_userdata('success', "Employee Successfully Updated");
            redirect(base_url().'admin/employee_management/view_all_employee');
        } else {
            $this->session->set_userdata('error', "Employee Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    function get_employee_report($id)
    {
        $data['title'] = 'Working Hours';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['visual_setting'] = $this->setting_model->get_visual_setting();
        $data['all_report'] = $this->employee_model->view_all_working_hours_by_emp_id($id);
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/report/all_working_hours_report_by_user');
        $this->load->view('admin/include/footer');
    }

    function update_emp_time()
    {
        if ($this->employee_model->update_emp_time()) {
            $this->session->set_userdata('success', "Employee Time Updated");
            redirect(base_url().'admin/employee_management/view_all_employee');
        } else {
            $this->session->set_userdata('error', "Employee Time Faild");
            redirect($this->agent->referrer());
        }
    }

    

    

    

    
   


}

/* End of file Events.php */
/* Location: ./application/views/front/Events.php */