<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Faq extends Admin_Core_Controller {

	public function __construct()
    {

        parent::__construct();
        $this->load->model('faq_model');
    }

	public function faq_category()
	{
		$data['title'] = 'FAQ Category';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['get_all_faq_category'] = $this->faq_model->get_all_faq_category();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/faq/faq_category', $data);
		$this->load->view('admin/include/footer', $data);
	}

	//Application Setting update
	 public function add_new_faq_category()
    {
    	if ($this->faq_model->add_new_faq_category()) {
            $this->session->set_userdata('success', "Category Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Category Added Faild");
            redirect($this->agent->referrer());
        }
    }

     public function update_faq_category_details()
    {
    	if ($this->faq_model->update_faq_category_details()) {
            $this->session->set_userdata('success', "Category Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Category Updated Faild");
            redirect($this->agent->referrer());
        }
    }


	public function delete_faq_category($id)
    {
    	
    	if ($this->faq_model->delete_faq_category($id)) {
            $this->session->set_userdata('success', "Category Successfully Delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Category Delete Faild");
            redirect($this->agent->referrer());
        }
	    
    }

    public function faq_details()
	{
		$data['title'] = 'FAQ Details';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['get_all_faq_category'] = $this->faq_model->get_all_faq_category();
        $data['get_all_faq_content']=$this->faq_model->get_all_faq_content();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/faq/faq_details', $data);
		$this->load->view('admin/include/footer', $data);
	}

	 public function add_new_faq_content()
    {
    	if ($this->faq_model->add_new_faq_content()) {
            $this->session->set_userdata('success', "Content Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Added Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_faq_content_details()
    {
        if ($this->faq_model->update_faq_content_details()) {
            $this->session->set_userdata('success', "Content Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    
     public function delete_faq($id)
    {
        if ($this->faq_model->delete_faq($id)) {
            $this->session->set_userdata('success', "Content Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete_faq_content($key, $id)
    {
        if ($this->faq_model->delete_faq_content($key, $id)) {
            $this->session->set_userdata('success', "Content Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Deleted Faild");
            redirect($this->agent->referrer());
        }
    }


    

	

	


}
