<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Franchise extends Admin_Core_Controller {

	public function __construct()
    {
        parent::__construct();
        check_permission('frontend_setting');
    }

	public function view_franchise_page()
	{
		$data['title'] = 'Franchise Page';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['data'] = $this->frontend_model->get_all_franchise_page();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/franchise_page');
		$this->load->view('admin/include/footer');
	}

    public function update_page()
    {
		if ($this->frontend_model->franchise_update_page()) {
	        $this->session->set_userdata('success', "Data Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function franchise_testimonials()
    {
    	$data['title'] = 'Franchise Testimonials';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['all_fran_page'] = $this->frontend_model->get_all_fran_page_testimonials();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/franchise_testimonials');
		$this->load->view('admin/include/footer');
    }

    function add_new_testimonilas()
    {
    	if ($this->frontend_model->add_new_fran_page_testimonilas()) {
	        $this->session->set_userdata('success', "Testimonial Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Testimonial Added Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function update_testimonials($id)
    {
    	if ($this->frontend_model->fran_page_testimonilas_update($id)) {
	        $this->session->set_userdata('success', "Testimonial Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Testimonial Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function delete_testimonial($id)
    {
    	if ($this->frontend_model->fran_page_delete_testimonial($id)) {
	        $this->session->set_userdata('success', "Testimonial Successfully Deleted");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Testimonial Deleted Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function franchise_application()
    {
    	$data['title'] = 'Franchise Testimonials';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['all_fran_app'] = $this->frontend_model->get_all_franchise_application();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/franchise_application');
		$this->load->view('admin/include/footer');
    }
	
}
