<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Frontend_setting extends Admin_Core_Controller {

	public function __construct()
    {
        parent::__construct();
        check_permission('frontend_setting');
    }

	public function slider()
	{
		$data['title'] = 'Slider';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['slider'] = $this->frontend_model->get_all_slider_by_id();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/slider', $data);
		$this->load->view('admin/include/footer', $data);
	}

    public function update_slider()
    {
		if ($this->frontend_model->update_slider()) {
	        $this->session->set_userdata('success', "Slider Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Slider Update Faild");
	        redirect($this->agent->referrer());
	    }
    }
	

	

    public function counting()
	{
		$data['title'] = 'Counting';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['get_all_counting'] = $this->frontend_model->get_all_counting();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/counting', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function add_new_counting()
    {
    	
		if ($this->frontend_model->add_new_counting()) {
	        $this->session->set_userdata('success', "Data Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function update_counting()
    {
    	
		if ($this->frontend_model->update_counting()) {
	        $this->session->set_userdata('success', "Data Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function delete_counting($id)
    {
		if ($this->frontend_model->delete_counting($id)) {
	        $this->session->set_userdata('success', "Data Successfully Deleted");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Deleted Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function are_you()
	{
		$data['title'] = 'Are You Section';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['get_all_are_you'] = $this->frontend_model->get_all_are_you();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/are_you', $data);
		$this->load->view('admin/include/footer', $data);
	}

	
	public function add_new_are_you()
    {
		if ($this->frontend_model->add_new_are_you()) {
	        $this->session->set_userdata('success', "Data Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Added Faild");
	        redirect($this->agent->referrer());
	    }
    }

    
    public function update_are_you()
    {
    	
		if ($this->frontend_model->update_are_you()) {
	        $this->session->set_userdata('success', "Data Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function delete_are_you($id)
    {
		if ($this->frontend_model->delete_are_you($id)) {
	        $this->session->set_userdata('success', "Data Successfully Deleted");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Deleted Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function short_about_us()
	{
		$data['title'] = 'Short About Us';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['about_us'] = $this->frontend_model->get_short_about_us();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/short_about_us', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function update_new_about_us()
    {
		if ($this->frontend_model->update_new_about_us()) {
	        $this->session->set_userdata('success', "Data Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function stacks()
	{
		$data['title'] = 'Stacks';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['get_all_stacks'] = $this->frontend_model->get_all_stacks();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/stacks', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function add_new_stacks()
    {
		if ($this->frontend_model->add_new_stacks()) {
	        $this->session->set_userdata('success', "Data Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Added Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function update_stacks()
    {
		if ($this->frontend_model->update_stacks()) {
	        $this->session->set_userdata('success', "Data Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function delete_stack($id)
    {
		if ($this->frontend_model->delete_stack($id)) {
	        $this->session->set_userdata('success', "Data Successfully Deleted");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Deleted Faild");
	        redirect($this->agent->referrer());
	    }
    }

    
    public function front_video()
	{
		$data['title'] = 'Front Video';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['video'] = $this->frontend_model->get_front_video();
		// $data['video_image'] = $this->frontend_model->get_front_video_image();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/front_video', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function update_front_video()
    {
		if ($this->frontend_model->update_front_video()) {
	        $this->session->set_userdata('success', "Data Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function cta_section()
	{
		$data['title'] = 'CTA';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['cta'] = $this->frontend_model->get_cta_content();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/cta_section', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function update_cta_content()
    {
		if ($this->frontend_model->update_cta_content()) {
	        $this->session->set_userdata('success', "Data Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function trainee_reviews()
	{
		$data['title'] = 'Trainee Reviews';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['trainee_reviews'] = $this->frontend_model->get_front_trainee_reviews();
		$data['video_url_1'] = $this->frontend_model->get_front_video_trainee_reviews();
		$data['video_url_2'] = $this->frontend_model->get_front_video_trainee_reviews_video_url_2();
		
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/trainee_reviews', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function update_trainee_reviews()
    {
		if ($this->frontend_model->update_trainee_reviews()) {
	        $this->session->set_userdata('success', "Data Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function learner_in_social_media()
	{
		$data['title'] = 'Learner in Social Media';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['all_social_media_info'] = $this->frontend_model->get_all_social_media_info();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/learner_in_social_media', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function add_new_social_media_info()
    {
		if ($this->frontend_model->add_new_social_media_info()) {
	        $this->session->set_userdata('success', "Data Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Added Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function update_social_media_info()
    {
		if ($this->frontend_model->update_social_media_info()) {
	        $this->session->set_userdata('success', "Data Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

     public function delete_social_media_info($id)
    {
		if ($this->frontend_model->delete_social_media_info($id)) {
	        $this->session->set_userdata('success', "Data Successfully Deleted");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Deleted Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function social_comment_image()
	{
		$data['title'] = 'Social Comment Image';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['get_all_social_comment_image'] = $this->frontend_model->get_all_social_comment_image();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/social_comment_image', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function insert_social_comment_image()
    {
		if ($this->frontend_model->insert_social_comment_image()) {
	        $this->session->set_userdata('success', "Data Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Added Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function delete_social_comment_image($id)
    {
		if ($this->frontend_model->delete_social_comment_image($id)) {
	        $this->session->set_userdata('success', "Data Successfully Deleted");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Deleted Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function placed_student()
	{
		$data['title'] = 'Placed Student';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['all_placed_student'] = $this->frontend_model->get_all_placed_student();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/placed_student', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function add_new_placed_student()
    {
		if ($this->frontend_model->add_new_placed_student()) {
	        $this->session->set_userdata('success', "Data Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Added Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function update_placed_student()
    {
		if ($this->frontend_model->update_placed_student()) {
	        $this->session->set_userdata('success', "Data Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function delete_placed_student($id)
    {
		if ($this->frontend_model->delete_placed_student($id)) {
	        $this->session->set_userdata('success', "Data Successfully Deleted");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Deleted Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function company_logo()
	{
		$data['title'] = 'Comnay Logo';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['get_all_company_logo'] = $this->frontend_model->get_all_company_logo();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/company_logo', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function add_new_company_logo()
    {
		if ($this->frontend_model->add_new_company_logo()) {
	        $this->session->set_userdata('success', "Data Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Added Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function delete_company_logo($id)
    {
		if ($this->frontend_model->delete_company_logo($id)) {
	        $this->session->set_userdata('success', "Data Successfully Deleted");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Deleted Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function heading_and_sub_heading()
	{
		$data['title'] = 'Front Video';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['heading'] = $this->frontend_model->get_all_heading_and_sub_heading();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/heading_and_sub_heading', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function update_heading_and_sub_heading()
    {
		if ($this->frontend_model->update_heading_and_sub_heading()) {
	        $this->session->set_userdata('success', "Data Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function feature_for_you()
	{
		$data['title'] = 'Feature For You';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['feature'] = $this->frontend_model->get_all_feature_for_you();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/feature_for_you', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function update_feature_for_you()
    {
        if ($this->frontend_model->update_feature_for_you()) {
            $this->session->set_userdata('success', "Section Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function download_app_section()
	{
		$data['title'] = 'Download App';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['feature'] = $this->frontend_model->download_app_section();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/download_app_section', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function update_download_app_section()
    {
        if ($this->frontend_model->update_download_app_section()) {
            $this->session->set_userdata('success', "Section Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    

	public function add_about_us_section_1()
    {
        if ($this->frontend_model->add_about_us_section_1()) {
            $this->session->set_userdata('success', "Section 1 Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function add_about_us_section_2_i()
    {
        if ($this->frontend_model->add_about_us_section_2_i()) {
            $this->session->set_userdata('success', "Section 2 Successfully Updated");
            redirect($this->agent->referrer().'#head_2');
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function add_about_us_section_2_ii()
    {
        if ($this->frontend_model->add_about_us_section_2_ii()) {
            $this->session->set_userdata('success', "Section 2 Content Successfully Added");
            redirect($this->agent->referrer().'#head_2_c');
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete_section_2_content($id)
    {
        if ($this->frontend_model->delete_section_2_content($id)) {
            $this->session->set_userdata('success', "Section 2 Content Successfully Delete");
            redirect($this->agent->referrer().'#head_2_c');
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_about_us_section_2_ii()
    {
        if ($this->frontend_model->update_about_us_section_2_ii()) {
            $this->session->set_userdata('success', "Section 2 Content Successfully Updated");
            redirect($this->agent->referrer().'#head_2_c');
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function add_about_us_section_3()
    {
        if ($this->frontend_model->add_about_us_section_3()) {
            $this->session->set_userdata('success', "Section 3 Content Successfully Updated");
            redirect($this->agent->referrer().'#head_3');
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function add_about_us_section_4_i()
    {
        if ($this->frontend_model->add_about_us_section_4_i()) {
            $this->session->set_userdata('success', "Section 4 Successfully Updated");
            redirect($this->agent->referrer().'#head_4_c');
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function add_about_us_section_4_ii()
    {
        if ($this->frontend_model->add_about_us_section_4_ii()) {
            $this->session->set_userdata('success', "Section 4 Content Successfully Added");
            redirect($this->agent->referrer().'#head_4_c');
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete_section_4_content($id)
    {
        if ($this->frontend_model->delete_section_4_content($id)) {
            $this->session->set_userdata('success', "Section 4 Content Successfully Deleted");
            redirect($this->agent->referrer().'#head_4_c');
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_about_us_section_4_ii()
    {
        if ($this->frontend_model->update_about_us_section_4_ii()) {
            $this->session->set_userdata('success', "Section 4 Content Successfully Updated");
            redirect($this->agent->referrer().'#head_4_c');
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function add_about_us_section_5()
    {
        if ($this->frontend_model->add_about_us_section_5()) {
            $this->session->set_userdata('success', "Section 5 Content Successfully Added");
            redirect($this->agent->referrer().'#head_5');
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete_section_5_content($id)
    {
        if ($this->frontend_model->delete_section_5_content($id)) {
            $this->session->set_userdata('success', "Section 5 Content Successfully Deleted");
            redirect($this->agent->referrer().'#head_5');
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_about_us_section_5()
    {
        if ($this->frontend_model->update_about_us_section_5()) {
            $this->session->set_userdata('success', "Section 5 Content Successfully Updated");
            redirect($this->agent->referrer().'#head_5');
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function add_about_us_section_6_i()
    {
        if ($this->frontend_model->add_about_us_section_6_i()) {
            $this->session->set_userdata('success', "Section 6 Content Successfully Updated");
            redirect($this->agent->referrer().'#head_6');
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function add_about_us_section_6_ii()
    {
        if ($this->frontend_model->add_about_us_section_6_ii()) {
            $this->session->set_userdata('success', "Section 6 Content Successfully Added");
            redirect($this->agent->referrer().'#head_6');
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete_section_6_ii_content($id)
    {
        if ($this->frontend_model->delete_section_6_ii_content($id)) {
            $this->session->set_userdata('success', "Section 6 Content Successfully Deleted");
            redirect($this->agent->referrer().'#head_6');
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_about_us_section_6_ii()
    {
        if ($this->frontend_model->update_about_us_section_6_ii()) {
            $this->session->set_userdata('success', "Section 6 Content Successfully Updated");
            redirect($this->agent->referrer().'#head_6');
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }


    public function add_about_us_section_timeline()
    {
        if ($this->frontend_model->add_about_us_section_timeline()) {
            $this->session->set_userdata('success', "Timeline Content Successfully Added");
            redirect($this->agent->referrer().'#head_7');
        } else {
            $this->session->set_userdata('error', "Timeline Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete_section_timeline_content($id)
    {
        if ($this->frontend_model->delete_section_timeline_content($id)) {
            $this->session->set_userdata('success', "Timeline Content Successfully Deleted");
            redirect($this->agent->referrer().'#head_7');
        } else {
            $this->session->set_userdata('error', "Timeline Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_about_us_section_timeline($id)
    {
        if ($this->frontend_model->update_about_us_section_timeline($id)) {
            $this->session->set_userdata('success', "Timeline Content Successfully Updated");
            redirect($this->agent->referrer().'#head_7');
        } else {
            $this->session->set_userdata('error', "Timeline Updated Faild");
            redirect($this->agent->referrer());
        }
    }
    
    function update_brain_behind()
    {
    	if ($this->frontend_model->update_brain_behind()) {
            $this->session->set_userdata('success', "Content Successfully Updated");
            redirect($this->agent->referrer().'#head_8');
        } else {
            $this->session->set_userdata('error', "Content Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function add_about_us_section_award()
    {
        if ($this->frontend_model->add_about_us_section_award()) {
            $this->session->set_userdata('success', "Award Content Successfully Added");
            redirect($this->agent->referrer().'#head_9');
        } else {
            $this->session->set_userdata('error', "Award Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete_section_award_content($id)
    {
        if ($this->frontend_model->delete_section_award_content($id)) {
            $this->session->set_userdata('success', "Award Content Successfully Deleted");
            redirect($this->agent->referrer().'#head_9');
        } else {
            $this->session->set_userdata('error', "Award Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_about_us_section_award($id)
    {
        if ($this->frontend_model->update_about_us_section_award($id)) {
            $this->session->set_userdata('success', "Award Content Successfully Updated");
            redirect($this->agent->referrer().'#head_9');
        } else {
            $this->session->set_userdata('error', "Award Updated Faild");
            redirect($this->agent->referrer());
        }
    }
    


    

    public function about_us()
	{
		$data['title'] = 'About Us';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['content_1'] = $this->frontend_model->get_all_about_us_content_1();
		$data['content_2'] = $this->frontend_model->get_all_about_us_content_2_i();
		$data['content_2_i'] = $this->frontend_model->get_all_about_us_content_2_ii();
		$data['content_3'] = $this->frontend_model->get_all_about_us_content_3();
		$data['content_4'] = $this->frontend_model->get_all_about_us_content_4_i();
		$data['content_4_i'] = $this->frontend_model->get_all_about_us_content_4_ii();
		$data['content_5'] = $this->frontend_model->get_all_about_us_content_5();
		$data['content_6_i'] = $this->frontend_model->get_all_about_us_content_6_i();
		$data['content_6_ii'] = $this->frontend_model->get_all_about_us_content_6_ii();
		$data['all_timeline'] = $this->frontend_model->get_all_about_us_content_timeline();
		$data['brain'] = $this->frontend_model->get_brain_behiend();
		$data['get_all_award'] = $this->frontend_model->get_all_about_us_content_award();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/about_us', $data);
		$this->load->view('admin/include/footer', $data);
	}


	public function video_page_1()
	{
		$data['title'] = 'Video Page 1';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['video_1'] = $this->frontend_model->get_video_page_1_details();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/video_1', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function update_video_page_1()
    {
		if ($this->frontend_model->update_video_page_1()) {
	        $this->session->set_userdata('success', "Data Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function video_page_2()
	{
		$data['title'] = 'Video Page 1';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['video_2'] = $this->frontend_model->get_video_page_2_details();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/video_2', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function update_video_page_2()
    {
		if ($this->frontend_model->update_video_page_2()) {
	        $this->session->set_userdata('success', "Data Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Update Faild");
	        redirect($this->agent->referrer());
	    }
    }
    public function extra_page()
	{
		$data['title'] = 'Page Setting';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['get_all_page'] = $this->frontend_model->get_all_page();	
		
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/page_setting', $data);
		$this->load->view('admin/include/footer', $data);
	}

	function add_new_page()
	{
		$data['title'] = 'Add New Page';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/add_new_page', $data);
		$this->load->view('admin/include/footer', $data);
	}

	function page_add()
	{
		if ($this->frontend_model->page_add()) {
	        $this->session->set_userdata('success', "Page Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Page Added Faild");
	        redirect($this->agent->referrer());
	    }
	}

     public function update_page()
    {
		if ($this->frontend_model->update_page()) {
	        $this->session->set_userdata('success', "Page Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Page Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function update_extra_page($id)
	{
		$data['title'] = 'Update Page';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['page'] = $this->frontend_model->get_page_by_id($id);	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/update_extra_page', $data);
		$this->load->view('admin/include/footer', $data);
	}
	function delete_page($id)
	{
		if ($this->frontend_model->delete_page($id)) {
	        $this->session->set_userdata('success', "Page Successfully Deleted");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Page Deleted Faild");
	        redirect($this->agent->referrer());
	    }
	}

	function notification_settings()
	{
		$data['title'] = 'Notification Setting';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['notification'] = $this->frontend_model->get_notification();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/notification_settings');
		$this->load->view('admin/include/footer');
	}

	function update_notification()
	{
		if ($this->frontend_model->update_notification()) {
	        $this->session->set_userdata('success', "Notification Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Notification Updated Faild");
	        redirect($this->agent->referrer());
	    }
	}

	function book_demo_thank_you_page()
	{
		$data['title'] = 'Thank You Page';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['content'] = $this->frontend_model->get_book_demo_thank_you_page();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/book_demo_thank_you_page');
		$this->load->view('admin/include/footer');
	}

	function update_thank_you_page()
	{
		if ($this->frontend_model->update_thank_you_page()) {
	        $this->session->set_userdata('success', "Thank You Page Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Thank You Page Updated Faild");
	        redirect($this->agent->referrer());
	    }
	}

	function all_subscriber()
	{
		$this->load->model('subscriber_model', 'subscriber');
		$data['title'] = 'All Subscribers';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['all_data'] = $this->subscriber->get_all_subscriber();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/all_subscriber');
		$this->load->view('admin/include/footer');
	}

	function delete_subscriber($id)
	{
		$this->load->model('subscriber_model', 'subscriber');
		if ($this->subscriber->delete_subscribers($id)) {
	        $this->session->set_userdata('success', "Subscriber Successfully Deleted");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Subscriber Deleted Faild");
	        redirect($this->agent->referrer());
	    }
	}
    
    function section_on_off()
    {
		$data['title'] = 'Section On Off';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['section_on_off'] = $this->frontend_model->get_all_section_on_off();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/section_on_off');
		$this->load->view('admin/include/footer');
    }

    function change_section_status()
    {
    	if ($this->frontend_model->change_section_status()) {
	        $this->session->set_userdata('success', "Status Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Status Updated Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function all_testimonails()
    {
    	$data['title'] = 'All Testimonails';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['all_category'] = $this->frontend_model->get_all_testi_category();	
		$data['all_testimonials'] = $this->frontend_model->get_all_testimonials();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/all_testimonails');
		$this->load->view('admin/include/footer');
    }

    function add_new_testi_category()
    {
    	if ($this->frontend_model->add_new_testi_category()) {
	        $this->session->set_userdata('success', "Category Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Category Added Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function delete_testi_category($id)
    {
    	if ($this->frontend_model->delete_testi_category($id)) {
	        $this->session->set_userdata('success', "Category Successfully Deleted");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Category Deleted Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function update_testi_category()
    {
    	if ($this->frontend_model->update_testi_category()) {
	        $this->session->set_userdata('success', "Category Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Category Updated Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function add_new_testimonilas()
    {
    	if ($this->frontend_model->add_new_testimonilas()) {
	        $this->session->set_userdata('success', "testimonials Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "testimonials Added Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function update_testi_section()
    {
    	if ($this->frontend_model->update_testi_section()) {
	        $this->session->set_userdata('success', "testimonials Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "testimonials Updated Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function delete_testi_section($id)
    {
    	if ($this->frontend_model->delete_testi_section($id)) {
	        $this->session->set_userdata('success', "testimonials Successfully Deleted");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "testimonials Deleted Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function upcoming_batches()
    {
    	$data['title'] = 'All Batches';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['all_upcoming_batches'] = $this->frontend_model->get_all_upcoming_batches();	
		$data['all_upcoming_contact'] = $this->frontend_model->get_all_upcoming_batches_contact_details();	
		$data['all_upcoming_demo_class'] = $this->frontend_model->get_all_upcoming_batches_demo_class();	
		$data['all_course'] = $this->course_model->get_all_course_for_upcoming_batch();	
		
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/upcoming_batches');
		$this->load->view('admin/include/footer');
    }

    function add_new_batch()
    {
    	if ($this->frontend_model->add_new_batch()) {
	        $this->session->set_userdata('success', "Batch Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Batch Added Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function update_batch_details()
    {
    	if ($this->frontend_model->update_batch_details()) {
	        $this->session->set_userdata('success', "Batch Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Batch Updated Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function delete_upcoming_batch($id)
    {
    	if ($this->frontend_model->delete_upcoming_batch($id)) {
	        $this->session->set_userdata('success', "Batch Successfully Delete");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Batch Delete Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function batch_training()
    {
    	$data['title'] = 'All Batches Training';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['all_training_batches'] = $this->frontend_model->get_all_batch_training();
		$data['all_training_inquiry'] = $this->course_model->get_all_training_inquiry();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/batch_training');
		$this->load->view('admin/include/footer');
    }

    function add_new_batch_training()
    {
    	if ($this->frontend_model->add_new_batch_training()) {
	        $this->session->set_userdata('success', "Training Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Training Added Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function update_batch_training_details()
    {
    	if ($this->frontend_model->update_batch_training_details()) {
	        $this->session->set_userdata('success', "Training Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Training Updated Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function delete_training_batch($id)
    {
    	if ($this->frontend_model->delete_training_batch($id)) {
	        $this->session->set_userdata('success', "Training Successfully Delete");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Training Delete Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function google_algorithm_guide()
    {
    	$data['title'] = 'Google Algorithm Guide';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['all_google_guide'] = $this->frontend_model->get_all_google_guide();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/google_algorithm_guide');
		$this->load->view('admin/include/footer');
    }


    function add_new_google_guide()
    {
    	if ($this->frontend_model->add_new_google_guide()) {
	        $this->session->set_userdata('success', "Algorithm Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Algorithm Added Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function update_google_guide()
    {
    	if ($this->frontend_model->update_google_guide()) {
	        $this->session->set_userdata('success', "Algorithm Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Algorithm Updated Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function delete_algorithm_data($id)
    {
    	if ($this->frontend_model->delete_algorithm_data($id)) {
	        $this->session->set_userdata('success', "Algorithm Successfully Delete");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Algorithm Delete Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function recommended_tools()
    {
    	$data['title'] = 'Recommended Tools';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['all_recommended_tools'] = $this->frontend_model->get_all_recommended_tools();
		$data['all_category'] = $this->frontend_model->get_all_recommended_tools_category();	
		
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/recommended_tools');
		$this->load->view('admin/include/footer');
    }

    function add_new_recommended_tool_category()
    {
    	if ($this->frontend_model->add_new_recommended_tool_category()) {
	        $this->session->set_userdata('success', "Category Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Category Added Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function update_recommended_tool_category($id)
    {
    	if ($this->frontend_model->update_recommended_tool_category($id)) {
	        $this->session->set_userdata('success', "Category Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Category Updated Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function delete_recommended_tools_category($id)
    {
    	if ($this->frontend_model->delete_recommended_tools_category($id)) {
	        $this->session->set_userdata('success', "Category Successfully Delete");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Category Delete Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function add_new_recommended_tool()
    {
    	if ($this->frontend_model->add_new_recommended_tool()) {
	        $this->session->set_userdata('success', "Tools Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Tools Added Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function update_recommended_tool($id)
    {
    	if ($this->frontend_model->update_recommended_tool($id)) {
	        $this->session->set_userdata('success', "Tools Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Tools Updated Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function delete_recommended_tools($id)
    {
    	if ($this->frontend_model->delete_recommended_tools($id)) {
	        $this->session->set_userdata('success', "Tools Successfully Delete");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Tools Delete Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function tool_seo()
    {
    	$data['title'] = 'Tools SEO';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['tool_seo'] = $this->frontend_model->get_all_tool_seo();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/tool_seo');
		$this->load->view('admin/include/footer');
    }

    function update_tool_seo()
    {
    	if ($this->frontend_model->update_tool_seo()) {
	        $this->session->set_userdata('success', "Content Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Content Updated Faild");
	        redirect($this->agent->referrer());
	    }
    }
}
