<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Hire_talent extends Admin_Core_Controller {

	public function __construct()
    {
        parent::__construct();
        check_permission('frontend_setting');
    }

	public function view_hire_talent_page()
	{
		$data['title'] = 'Career Opportunities Page';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();
		$data['data'] = $this->frontend_model->get_all_hire_talent_page();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/fontend_setting/view_hire_talent_page');
		$this->load->view('admin/include/footer');
	}

    public function update_page()
    {
		if ($this->frontend_model->hire_talent_update_page()) {
	        $this->session->set_userdata('success', "Data Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Data Update Faild");
	        redirect($this->agent->referrer());
	    }
    }

    function hire_partner_image()
    {
        $data['title'] = 'Career Opportunities Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['get_all_company_logo'] = $this->frontend_model->get_all_hire_talent_company_image();  
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/fontend_setting/hire_partner_image');
        $this->load->view('admin/include/footer');
    }

    function add_new_company_logo()
    {
        if ($this->frontend_model->add_new_hire_talent_company_image()) {
            $this->session->set_userdata('success', "Data Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Data Update Faild");
            redirect($this->agent->referrer());
        }
    }

    function delete_company_logo($id)
    {
        if ($this->frontend_model->hire_talent_delete_company_image($id)) {
            $this->session->set_userdata('success', "Data Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Data Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

    function all_testimonials()
    {
        $data['title'] = 'Career Opportunities Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['all_testimonials'] = $this->frontend_model->get_all_hire_talent_testimonials();  
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/fontend_setting/hire_partner_testimonials');
        $this->load->view('admin/include/footer');
    }

    function add_new_testimonilas()
    {
        if ($this->frontend_model->hire_talent_add_new_testimonilas()) {
            $this->session->set_userdata('success', "Data Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Data Added Faild");
            redirect($this->agent->referrer());
        }
    }

    function update_testimonials($id)
    {
        if ($this->frontend_model->hire_talent_update_testimonials($id)) {
            $this->session->set_userdata('success', "Data Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Data Updated Faild");
            redirect($this->agent->referrer());
        }
    }
    function delete_testimonial($id)
    {
        if ($this->frontend_model->hire_talent_delete_testimonial($id)) {
            $this->session->set_userdata('success', "Data Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Data Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

    function hire_category()
    {
        $data['title'] = 'Career Opportunities Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['all_hire_category'] = $this->frontend_model->get_all_hire_category();  
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/fontend_setting/hire_category');
        $this->load->view('admin/include/footer');
    }

    function add_new_category_content()
    {
        if ($this->frontend_model->add_new_category_content()) {
            $this->session->set_userdata('success', "Data Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Data Added Faild");
            redirect($this->agent->referrer());
        }
    }

    function update_hire_category($id)
    {
        $data['title'] = 'Career Opportunities Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['category'] = $this->frontend_model->get_hire_category_by_id($id);  
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/fontend_setting/update_hire_category');
        $this->load->view('admin/include/footer');
    }

    function update_hire_category_data($id)
    {
         if ($this->frontend_model->update_hire_category($id)) {
            $this->session->set_userdata('success', "Data Successfully Update");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Data Update Faild");
            redirect($this->agent->referrer());
        }
    }

    function delete_hire_category($id)
    {
        if ($this->frontend_model->delete_hire_category($id)) {
            $this->session->set_userdata('success', "Data Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Data Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

}
