<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ibast extends Admin_Core_Controller {

    public function __construct()
    {
        parent::__construct();
        check_permission('ebook');
    }
    

 
    // Ibast Main Page Start
    public function view_all_page()
    {
        $data['title'] = 'View All Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['get_all_page'] = $this->course_model->get_all_ibast_page();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/ibast/view_all_page');
        $this->load->view('admin/include/footer');
    }

    function add_new_page()
    {
        $data['title'] = 'Add New Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/ibast/add_new_page');
        $this->load->view('admin/include/footer');
    }
    
    public function add_ibast_page()
    {
        if ($this->course_model->add_ibast_page()) {
            $this->session->set_userdata('success', "Page Successfully Added");
            redirect(base_url().'admin/ibast/view_all_page');
        } else {
            $this->session->set_userdata('error', "Page Added Faild");
           redirect($this->agent->referrer());
        }
    }

    function update_ibast_page($id)
    {
        $data['title'] = 'Update Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['data'] = $this->course_model->get_ibast_page_by_id($id);
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/ibast/update_ibast_page');
        $this->load->view('admin/include/footer');
    }

    function edit_ibast_page($id)
    {
        if ($this->course_model->edit_ibast_page($id)) {
            $this->session->set_userdata('success', "Page Successfully Updated");
            redirect(base_url().'admin/ibast/view_all_page');
        } else {
            $this->session->set_userdata('error', "Page Updated Faild");
           redirect($this->agent->referrer());
        }
    }

    function delete_ibast_page($id)
    {
        if ($this->course_model->delete_ibast_page($id)) {
            $this->session->set_userdata('success', "Page Successfully Deleted");
            edirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Page Deleted Faild");
           redirect($this->agent->referrer());
        }
    }
    // Ibast Main Page End

    //////////////////////////////////////////////////////////////////////////////////////////

    // Ibast Details Page Start

    function view_all_details_page()
    {
        $data['title'] = 'View All Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['get_all_page'] = $this->course_model->get_all_ibast_details_page();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/ibast/view_all_details_page');
        $this->load->view('admin/include/footer');
    }

    function add_new_details_page()
    {
        $data['title'] = 'Add New Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['all_course'] = $this->course_model->get_all_ibast_page();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/ibast/add_new_details_page');
        $this->load->view('admin/include/footer');
    }

    function add_ibast_details_page()
    {
        if ($this->course_model->add_ibast_details_page()) {
            $this->session->set_userdata('success', "Page Successfully Added");
            redirect(base_url().'admin/ibast/view_all_details_page');
        } else {
            $this->session->set_userdata('error', "Page Added Faild");
           redirect($this->agent->referrer());
        }
    }

    function update_ibast_details_page($id)
    {
        $data['title'] = 'Update Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['all_course'] = $this->course_model->get_all_ibast_page();
        $data['data'] = $this->course_model->get_ibast_details_page_by_id($id);
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/ibast/update_details_page');
        $this->load->view('admin/include/footer');
    }

    function edit_ibast_details_page($id)
    {
        if ($this->course_model->edit_ibast_details_page($id)) {
            $this->session->set_userdata('success', "Page Successfully Updated");
            redirect(base_url().'admin/ibast/view_all_details_page');
        } else {
            $this->session->set_userdata('error', "Page Updated Faild");
           redirect($this->agent->referrer());
        }
    }

    // Ibast Details Page End

    
    

}
