<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Lab_page extends Admin_Core_Controller {

	public function __construct()
    {
        parent::__construct();
        $this->load->model('lab_page_model', 'lab');
        check_permission('lab_page');
        
    }

   
	public function section_1()
    {
        $this->load->library('cryptojsaes');
        $data['title'] = 'Section 1';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['section_1'] = $this->lab->get_section_1();
        $data['video'] = $this->cryptojsaes->decrypt($data['section_1']->video_url, '1683593671');
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/lab_page/section_1');
        $this->load->view('admin/include/footer');
    }

    public function update_section_1()
    {
        if ($this->lab->update_section_1()) {
            $this->session->set_userdata('success', "Section Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function section_2()
    {
        $data['title'] = 'Section 2';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['section_2'] = $this->lab->get_section_2();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/lab_page/section_2');
        $this->load->view('admin/include/footer');
    }

    public function update_section_2()
    {
        if ($this->lab->update_section_2()) {
            $this->session->set_userdata('success', "Section Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Section Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function section_3()
    {
        $data['title'] = 'Section 3';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['section_3'] = $this->lab->get_all_section_3_content();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/lab_page/section_3');
        $this->load->view('admin/include/footer');
    }

    public function add_new_section_3_content()
    {
        if ($this->lab->add_new_section_3_content()) {
            $this->session->set_userdata('success', "Content Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Added Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_section_3_content()
    {
        if ($this->lab->update_section_3()) {
            $this->session->set_userdata('success', "Content Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Updated Faild");
            redirect($this->agent->referrer());
        }
    }

     public function delete_section_3($id)
    {
        if ($this->lab->delete_section_3($id)) {
            $this->session->set_userdata('success', "Content Successfully Delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Delete Faild");
            redirect($this->agent->referrer());
        }
    }

    public function section_4()
    {
        $data['title'] = 'Section 4';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['section_4_i'] = $this->lab->get_all_section_4_i();
        $data['section_4_ii'] = $this->lab->get_section_4_content_ii();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/lab_page/section_4');
        $this->load->view('admin/include/footer');
    }

    public function update_section_4_content_i()
    {
        if ($this->lab->update_section_4_content_i()) {
            $this->session->set_userdata('success', "Content Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function add_new_section_4_content_ii()
    {
        if ($this->lab->add_new_section_4_content_ii()) {
            $this->session->set_userdata('success', "Content Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Added Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_section_4_content_ii()
    {
        if ($this->lab->update_section_4_content_ii()) {
            $this->session->set_userdata('success', "Content Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Updated Faild");
            redirect($this->agent->referrer());
        }
    }

     public function delete_section_4_content_ii($id)
    {
        if ($this->lab->delete_section_4_content_ii($id)) {
            $this->session->set_userdata('success', "Content Successfully Delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Delete Faild");
            redirect($this->agent->referrer());
        }
    }

    public function section_5()
    {
        $data['title'] = 'Section 5';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['section_5'] = $this->lab->get_all_section_5_content();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/lab_page/section_5');
        $this->load->view('admin/include/footer');
    }

    public function add_new_section_4_content()
    {
        if ($this->lab->add_new_section_4_content()) {
            $this->session->set_userdata('success', "Content Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Added Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_section_4_content()
    {
        if ($this->lab->update_section_4_content()) {
            $this->session->set_userdata('success', "Content Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Updated Faild");
            redirect($this->agent->referrer());
        }
    }


    public function section_6()
    {
        $data['title'] = 'FAQ Details';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['get_all_faq_content']=$this->lab->get_all_faq_content();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/lab_page/faq/faq_details', $data);
        $this->load->view('admin/include/footer');
    }

     public function add_new_faq_content()
    {
        if ($this->lab->add_new_faq_content()) {
            $this->session->set_userdata('success', "Content Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Added Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_faq_content_details()
    {
        if ($this->lab->update_faq_content_details()) {
            $this->session->set_userdata('success', "Content Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    
     public function delete_faq($id)
    {
        if ($this->lab->delete_faq($id)) {
            $this->session->set_userdata('success', "Content Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete_faq_content($key, $id)
    {
        if ($this->lab->delete_faq_content($key, $id)) {
            $this->session->set_userdata('success', "Content Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

    public function section_7()
    {
        $data['title'] = 'Section 7';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['section_7']=$this->lab->get_all_lab_page_section_7();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/lab_page/section_7', $data);
        $this->load->view('admin/include/footer');
    }

     public function add_new_section_7()
    {
        if ($this->lab->add_new_section_7()) {
            $this->session->set_userdata('success', "Content Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Added Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete_new_section_7($key)
    {
        if ($this->lab->delete_new_section_7($key)) {
            $this->session->set_userdata('success', "Content Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_new_section_7()
    {
        if ($this->lab->update_new_section_7()) {
            $this->session->set_userdata('success', "Content Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function section_8()
    {
        $data['title'] = 'Section 8';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['section_8']=$this->lab->get_all_lab_page_section_8();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/lab_page/section_8', $data);
        $this->load->view('admin/include/footer');
    }

    public function add_new_section_8()
    {
        if ($this->lab->add_new_section_8()) {
            $this->session->set_userdata('success', "Content Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Added Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete_new_section_8($key)
    {
        if ($this->lab->delete_new_section_8($key)) {
            $this->session->set_userdata('success', "Content Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Content Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

    public function inquery()
    {
        $data['title'] = 'All Inquery';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['inquery_details']=$this->lab->get_all_inquery();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/lab_page/inquery', $data);
        $this->load->view('admin/include/footer');
    }

    

    

    

    

    

    

    

    

    

    

    


    

    


    
    


    

    

    
	

	


   

 

    

}










/* End of file Home.php */
/* Location: ./application/controllers/Home.php */