<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Master_class extends Admin_Core_Controller {

    public function __construct()
    {
        parent::__construct();
        check_permission('ebook');
    }
    

 
    // Master Class Page Start
    public function view_all_page()
    {
        $data['title'] = 'View All Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['get_all_page'] = $this->course_model->get_all_master_class_page();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/master_class/view_all_page');
        $this->load->view('admin/include/footer');
    }

    function add_new_page()
    {
        $data['title'] = 'Add New Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/master_class/add_new_page');
        $this->load->view('admin/include/footer');
    }
    
    public function add_master_class_page()
    {
        if ($this->course_model->add_master_class_page()) {
            $this->session->set_userdata('success', "Page Successfully Added");
            redirect(base_url().'admin/master_class/view_all_page');
        } else {
            $this->session->set_userdata('error', "Page Added Faild");
           redirect($this->agent->referrer());
        }
    }

    function update_master_class_page($id)
    {
        $data['title'] = 'Update Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['data'] = $this->course_model->get_master_class_by_id($id);
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/master_class/update_master_class_page');
        $this->load->view('admin/include/footer');
    }

    function edit_master_class_page($id)
    {
        if ($this->course_model->edit_master_class_page($id)) {
            $this->session->set_userdata('success', "Page Successfully Updated");
            redirect(base_url().'admin/master_class/view_all_page');
        } else {
            $this->session->set_userdata('error', "Page Updated Faild");
           redirect($this->agent->referrer());
        }
    }

    function delete_master_class_page($id)
    {
        if ($this->course_model->delete_master_class_page($id)) {
            $this->session->set_userdata('success', "Page Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Page Deleted Faild");
           redirect($this->agent->referrer());
        }
    }
    // Master Class Page End

    // Master Class Slider Start

    function view_all_slider()
    {
        $data['title'] = 'View All Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['all_data'] = $this->course_model->get_all_master_class_slider();
        $data['get_all_course'] = $this->course_model->get_all_master_class_page();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/master_class/view_all_slider');
        $this->load->view('admin/include/footer');
    }

    function add_new_master_class_slider()
    {
        if ($this->course_model->add_new_master_class_slider()) {
            $this->session->set_userdata('success', "Slider Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Slider Added Faild");
           redirect($this->agent->referrer());
        }
    }

    function delete_master_class_page_slider($id)
    {
        if ($this->course_model->delete_master_class_page_slider($id)) {
            $this->session->set_userdata('success', "Slider Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Slider Deleted Faild");
           redirect($this->agent->referrer());
        }
    }

    // Master Class Slider End

    // Master Class Course Start

    function view_all_course()
    {
        $data['title'] = 'View All Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['get_all_course'] = $this->course_model->get_all_master_class_page();
        $data['all_data'] = $this->course_model->get_all_master_class_course(); 
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/master_class/view_all_course');
        $this->load->view('admin/include/footer');
    }

    function add_new_course()
    {
        $data['title'] = 'Add New Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['get_all_course'] = $this->course_model->get_all_master_class_page();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/master_class/add_new_course');
        $this->load->view('admin/include/footer');
    }

    function add_master_class_course()
    {
        if ($this->course_model->add_master_class_course()) {
            $this->session->set_userdata('success', "Course Successfully Added");
            redirect(base_url().'admin/master_class/view_all_course');
        } else {
            $this->session->set_userdata('error', "Course Added Faild");
           redirect($this->agent->referrer());
        }
    }

    function update_master_class_page_course($id)
    {
        $data['title'] = 'Update Page';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['get_all_course'] = $this->course_model->get_all_master_class_page();
        $data['data'] = $this->course_model->get_all_master_class_course_by_id($id);
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/master_class/update_course_details');
        $this->load->view('admin/include/footer');
    }

    function update_master_class_course($id)
    {
        if ($this->course_model->update_master_class_course($id)) {
            $this->session->set_userdata('success', "Course Successfully Added");
            redirect(base_url().'admin/master_class/view_all_course');
        } else {
            $this->session->set_userdata('error', "Course Added Faild");
           redirect($this->agent->referrer());
        }
    }

    // Master Class Course End

    // Master Class Programmes Start

    function view_all_programmes()
    {
        // $data['title'] = 'View All Page';
        // $data['app_setting'] = $this->setting_model->get_all_app_setting();
        // $data['all_data'] = $this->course_model->get_all_master_class_slider();
        // $this->load->view('admin/include/header', $data);
        // $this->load->view('admin/master_class/view_all_page');
        // $this->load->view('admin/include/footer');
    }

    // Master Class Programmes End

    // Master Class Reviews Start

    function view_all_reviews()
    {
         $data['title'] = 'View All Page';
         $data['app_setting'] = $this->setting_model->get_all_app_setting();
         $data['all_data'] = $this->course_model->get_all_master_class_review();
         $data['get_all_course'] = $this->course_model->get_all_master_class_page();
         $this->load->view('admin/include/header', $data);
         $this->load->view('admin/master_class/view_all_reviews');
         $this->load->view('admin/include/footer');
    }

    function add_new_master_class_review()
    {
        if ($this->course_model->add_new_master_class_review()) {
            $this->session->set_userdata('success', "Review Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Review Added Faild");
           redirect($this->agent->referrer());
        }
    }
    
    function delete_master_class_page_review($id)
    {
        if ($this->course_model->delete_master_class_page_review($id)) {
            $this->session->set_userdata('success', "Review Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Review Deleted Faild");
           redirect($this->agent->referrer());
        }
    }

     // Master Class Reviews End

  
    
    

}
