<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Review extends Admin_Core_Controller {

	public function __construct()
    {
        parent::__construct();
    }

	public function course_review()
	{
		$this->load->model('course_model', 'course');
		$data['title'] = 'Course Review';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['all_review'] = $this->course->get_all_review();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/review/course_review');
		$this->load->view('admin/include/footer');
	}


	public function pending_course_review($id)
    {
    	$this->load->model('course_model', 'course');
		if ($this->course->pending_course_review($id)) {
	        $this->session->set_userdata('success', "Review Pending Successfully Complete");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Review Pending Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function active_course_review($id)
    {
    	$this->load->model('course_model', 'course');
		if ($this->course->active_course_review($id)) {
	        $this->session->set_userdata('success', "Review Active Successfully Complete");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Review Active Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function delete_course_review($id)
    {
    	$this->load->model('course_model', 'course');
		if ($this->course->delete_course_review($id)) {
	        $this->session->set_userdata('success', "Review  Successfully Deleted");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Review Deleted Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function branch_review()
	{
		$this->load->model('branch_model', 'branch');
		$data['title'] = 'Branch Review';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['all_review'] = $this->branch->get_all_review();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/review/branch_review');
		$this->load->view('admin/include/footer');
	}


	public function pending_branch_review($id)
    {
    	$this->load->model('branch_model', 'branch');
		if ($this->branch->pending_branch_review($id)) {
	        $this->session->set_userdata('success', "Review Pending Successfully Complete");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Review Pending Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function active_branch_review($id)
    {
    	$this->load->model('branch_model', 'branch');
		if ($this->branch->active_branch_review($id)) {
	        $this->session->set_userdata('success', "Review Active Successfully Complete");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Review Active Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function delete_branch_review($id)
    {
    	$this->load->model('branch_model', 'branch');
		if ($this->branch->delete_branch_review($id)) {
	        $this->session->set_userdata('success', "Review  Successfully Deleted");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Review Deleted Faild");
	        redirect($this->agent->referrer());
	    }
    }

    

    

	

	
}