<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Role_permission extends Admin_Core_Controller {

	public function __construct()
    {
        parent::__construct();
        check_permission('role_permission');
    }

	public function index()
	{
		$data['title'] = 'Role Permission';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
        $data['role_permission'] = $this->auth_model->get_role_permission();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/role_permission/role_permission', $data);
		$this->load->view('admin/include/footer', $data);
	}

    //Add New Role Permission
    public function add_new_role()
    {
         
        $this->db->where('role_name', $this->input->post('role_name'));
        $role_details = $this->db->get('role_permission')->num_rows();
        if($role_details > 0)
        {
            $this->session->set_userdata('error', "Role Name Already Exits.");
            redirect($this->agent->referrer()); 
        }
        else
        {

            if ($this->auth_model->add_new_role_permission()) {
                $this->session->set_userdata('success', "Role Successfully Added");
                redirect($this->agent->referrer());
            } else {
                $this->session->set_userdata('error', "Role Add Failed");
                redirect($this->agent->referrer());
            }
        }
        
    }
     //Add New Role Permission
    public function delete_role_permission($id)
    {
        if ($this->auth_model->delete_role_permission($id)) {
            $this->session->set_userdata('success', "Role Successfully Delete");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Role Delete Failed");
            redirect($this->agent->referrer());
        }

    }

    //Edit Role Permission
    public function edit_permission($id)
    {
        if($id == 1){
         $this->session->set_userdata('error', "You Dont Have Permission To Access This Page");
         redirect($this->agent->referrer());   
        }
        $data['title'] = "Edit Permission";
        $data['app_setting'] = $this->setting_model->get_all_app_setting(); 
        $data['permission'] = $this->auth_model->get_role_permission_detaild_by_id($id);
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/role_permission/edit_permission', $data);
        $this->load->view('admin/include/footer', $data);
    }

    //Edit Role Permission
    public function update_role_permission()
    {
        
        if($this->input->post('role_id') == 1){
            $this->session->set_userdata('error', "You Dont Have Permission To Change This Page");
            redirect($this->agent->referrer());
        }
        else
        {
            if ($this->auth_model->update_permission_role()) {
                $this->session->set_userdata('success', "Permission Successfully Updated");
                redirect($this->agent->referrer());
            } else {
                $this->session->set_userdata('error', "Permission Update Failed");
                redirect($this->agent->referrer());
            }
        }
        
    }


}
