<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Student_management extends Admin_Core_Controller {

    public function __construct()
    {
        parent::__construct();
        check_permission('student_management');
        $this->load->model('branch_model');
        $this->load->model('student_model');
    }
    

    public function add_new_student()
    {
        $data['title'] = 'Add New Student';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['visual_setting'] = $this->setting_model->get_visual_setting();
        $data['get_all_branch'] = $this->branch_model->get_all_branch();
        $data['get_all_course'] = $this->course_model->get_all_course();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/student/add_new_student');
        $this->load->view('admin/include/footer');
    }

    public function view_all_student()
    {
        $data['title'] = 'Class Room Quotation';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['visual_setting'] = $this->setting_model->get_visual_setting();
        if(user()->role != 'Branch')
        {
            $data['get_all_student'] = $this->student_model->get_all_student_for_admin();
        }
        else
        {
            $data['get_all_student'] = $this->student_model->get_all_student_by_branch(user()->id);
        }
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/student/view_all_student');
        $this->load->view('admin/include/footer');
    }

    

     public function new_student_add()
    {
        if ($this->student_model->new_student_add()) {
            $this->session->set_userdata('success', "Student Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Student Added Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete($id)
    {
        if ($this->student_model->delete($id)) {
            $this->session->set_userdata('success', "Student Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Student Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_student($id)
    {
        $data['title'] = 'Update Student';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['visual_setting'] = $this->setting_model->get_visual_setting();
        $data['get_all_branch'] = $this->branch_model->get_all_branch();
        $data['get_all_course'] = $this->course_model->get_all_course();
        $data['student'] = $this->student_model->get_student_by_id($id);
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/student/update_student');
        $this->load->view('admin/include/footer');
    }

    public function update_student_add()
    {
        if ($this->student_model->update_student()) {
            $this->session->set_userdata('success', "Student Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Student Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    

    

    

    
   


}

/* End of file Events.php */
/* Location: ./application/views/front/Events.php */