<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Support extends Admin_Core_Controller {

	public function __construct()
    {
        parent::__construct();
        
    }

	public function index()
	{
		$data['title'] = 'Support Ticket';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['role_for_tickey_system'] = $this->user_model->get_all_role_for_tickey_system();
		if(user()->role == 'User')
		{
			$data['all_support_ticket'] = $this->user_model->get_support_ticket_by_user_id(user()->id);
		}
		elseif(is_admin() || is_n_admin())
		{
			$data['all_support_ticket'] = $this->user_model->get_all_support_ticket();
		}
		elseif(!is_admin() && !is_n_admin() && !is_user())
		{
			$data['all_support_ticket'] = $this->user_model->get_all_support_ticket_by_role_id(user()->role);
		}
		
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/ticket/support_ticket', $data);
		$this->load->view('admin/include/footer', $data);
	}

	//Application Setting update
	 public function add_new_ticket()
	    {
	        if ($this->user_model->add_new_ticket()) {
	            $this->session->set_userdata('success', "Ticket Successfully Submited");
	            redirect($this->agent->referrer());
	        } else {
	            $this->session->set_userdata('error', "Ticket Submited Faild");
	            redirect($this->agent->referrer());
	        }
	    }

	 public function view_details($ticket_id)
	{
		$data['title'] = 'View Ticket Details';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['get_all_time_zone'] = $this->setting_model->get_all_time_zone();
		$data['wallet_balance'] = $this->user_model->get_wallet_balance_by_user_id(user()->id);
		$data['role_for_tickey_system'] = $this->user_model->get_all_role_for_tickey_system();
		$data['support_ticket'] = $this->user_model->get_all_support_ticket_by_ticket_id($ticket_id);
		$data['all_support_ticket_comment'] = $this->user_model->get_all_support_ticket_comment_by_ticket_id($ticket_id);
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/ticket/view_details', $data);
		$this->load->view('admin/include/footer', $data);
	}

	 public function reply_ticket()
    {
        if ($this->user_model->reply_ticket()) {
            $this->session->set_userdata('success', "Reply Successfully Submit");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Reply Submited Faild");
            redirect($this->agent->referrer());
        }
    }

    function special_prd_fb_group()
    {
    	$data['title'] = 'Special Product Facebook Group';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/ticket/special_prd_fb_group', $data);
		$this->load->view('admin/include/footer', $data);
    }

    function special_course_fb_group()
    {
    	$data['title'] = 'Special Course Facebook Group';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/ticket/special_course_fb_group', $data);
		$this->load->view('admin/include/footer', $data);
    }
	

	
	
}
