<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Upsell extends Admin_Core_Controller {

	public function __construct()
    {
        parent::__construct();
        $this->load->model('upsell_model', 'upsell');
    }

	public function all_upsell_page()
	{
		$data['title'] = 'Upsell Page';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['all_page'] = $this->upsell->all_upsell_page();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/upsell/all_upsell_page', $data);
		$this->load->view('admin/include/footer', $data);
	}

	function add_new_page()
	{
		$data['title'] = 'Add Page';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();		
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/upsell/add_new_page', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function add_page()
	{
        if ($this->upsell->add_page()) {
            $this->session->set_userdata('success', "Page Successfully Added");
            redirect(base_url().'admin/upsell/all_upsell_page');
        } else {
            $this->session->set_userdata('error', "Page Added Faild");
            redirect($this->agent->referrer());
        }
	}

	function edit_page($id)
	{
		$data['title'] = 'Update Page';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['page'] = $this->upsell->get_upsell_page_by_id($id);		
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/upsell/edit_page', $data);
		$this->load->view('admin/include/footer', $data);
	}

	function update_page($id)
	{
		if ($this->upsell->update_page($id)) {
            $this->session->set_userdata('success', "Page Successfully Updated");
            redirect(base_url().'admin/upsell/all_upsell_page');
        } else {
            $this->session->set_userdata('error', "Page Updated Faild");
            redirect($this->agent->referrer());
        }
	}

	function delete_page($id)
	{
		$page_details = $this->upsell->get_upsell_page_pass_details_by_page_id($id);
		if($page_details == 0)
		{
			if ($this->upsell->delete_page()) {
	            $this->session->set_userdata('success', "Page Successfully Deleted");
	            redirect($this->agent->referrer());
	        } else {
	            $this->session->set_userdata('error', "Page Deleted Faild");
	            redirect($this->agent->referrer());
	        }
	    }
	    else
	    {
	    	$this->session->set_userdata('error', "Please Delete Pass Details First");
	        redirect($this->agent->referrer());
	    }
	}

	function upsell_page_pass_details()
	{
		$data['title'] = 'Vip Pass Details';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['all_pass_details'] = $this->upsell->all_pass_details();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/upsell/upsell_page_pass_details', $data);
		$this->load->view('admin/include/footer', $data);
	}

	function add_new_pass()
	{
		$data['title'] = 'Add Pass';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();		
		$data['all_page'] = $this->upsell->all_upsell_page();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/upsell/add_new_pass', $data);
		$this->load->view('admin/include/footer', $data);
	}

	function add_new_vip_pass()
	{
		if ($this->upsell->add_new_vip_pass()) {
            $this->session->set_userdata('success', "Pass Successfully Added");
            redirect(base_url().'admin/upsell/upsell_page_pass_details');
        } else {
            $this->session->set_userdata('error', "Pass Added Faild");
            redirect($this->agent->referrer());
        }
	}

	function edit_pass_details($id)
	{
		$data['title'] = 'Update Pass Details';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['pass_details'] = $this->upsell->get_pass_details_by_id($id);		
		$data['all_page'] = $this->upsell->all_upsell_page();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/upsell/edit_pass_details', $data);
		$this->load->view('admin/include/footer', $data);
	}

	function update_vip_pass_details($id)
	{
		if ($this->upsell->update_vip_pass_details($id)) {
            $this->session->set_userdata('success', "Pass Successfully Updated");
            redirect(base_url().'admin/upsell/upsell_page_pass_details');
        } else {
            $this->session->set_userdata('error', "Pass Updated Faild");
            redirect($this->agent->referrer());
        }
	}

	function delete_pass_details($id)
	{
		if ($this->upsell->delete_pass_details($id)) {
            $this->session->set_userdata('success', "Pass Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Pass Deleted Faild");
            redirect($this->agent->referrer());
        }
	}

	function upsell_thank_you_page()
	{
		$data['title'] = 'Upsell Thank You Page';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['all_thank_page'] = $this->upsell->all_thank_you_page();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/upsell/upsell_thank_you_page', $data);
		$this->load->view('admin/include/footer', $data);
	}

	function add_new_thank_you_page()
	{
		$data['title'] = 'Add Thanks Page';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['all_page'] = $this->upsell->all_upsell_page();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/upsell/add_new_thank_you_page', $data);
		$this->load->view('admin/include/footer', $data);
	}

	function add_thanks_page()
	{
		if ($this->upsell->add_thanks_page()) {
            $this->session->set_userdata('success', "Thanks Page Successfully Added");
            redirect(base_url().'admin/upsell/upsell_thank_you_page');
        } else {
            $this->session->set_userdata('error', "Thanks Page Added Faild");
            redirect($this->agent->referrer());
        }
	}

	function edit_thanks_page($id)
	{
		$data['title'] = 'Edit Thanks Page';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['thank_page'] = $this->upsell->get_thank_page_by_id($id);	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/upsell/edit_thanks_page', $data);
		$this->load->view('admin/include/footer', $data);
	}

	function update_thanks_page($id)
	{
		if ($this->upsell->update_thanks_page($id)) {
            $this->session->set_userdata('success', "Thanks Page Successfully Updated");
            redirect(base_url().'admin/upsell/upsell_thank_you_page');
        } else {
            $this->session->set_userdata('error', "Thanks Page Updated Faild");
            redirect($this->agent->referrer());
        }
	}

	function delete_thank_page($id)
	{
		if ($this->upsell->delete_thank_page($id)) {
            $this->session->set_userdata('success', "Thanks Page Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Thanks Page Deleted Faild");
            redirect($this->agent->referrer());
        }
	}

	function upsell_payment_data()
	{
		$data['title'] = 'upsell Pay Data';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['all_data'] = $this->upsell->get_upsell_payment_data();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/upsell/upsell_payment_data', $data);
		$this->load->view('admin/include/footer', $data);
	}

	
}
