<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Video_page extends Admin_Core_Controller {

	public function __construct()
    {
        parent::__construct();
        $this->load->model('video_page_model', 'video');
        check_permission('video_page');
    }

   
	public function qns_category()
    {
        $data['title'] = 'Qns. Category';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['video_qns'] = $this->video->get_video_qns();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/video/cat_qns');
        $this->load->view('admin/include/footer');
    }

    public function add_new_qns()
    {
        if ($this->video->add_new_qns()) {
            $this->session->set_userdata('success', "Qns. Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Qns. Added Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_qns()
    {
        if ($this->video->update_qns()) {
            $this->session->set_userdata('success', "Qns. Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Qns. Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete_qns($id)
    {
        if ($this->video->delete_qns($id)) {
            $this->session->set_userdata('success', "Qns. Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Qns. Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

    public function video()
    {
        // $this->load->library('cryptojsaes');
        $data['title'] = 'Video';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['all_qns'] = $this->video->get_video_qns();
        $data['all_video'] = $this->video->get_all_video();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/video/video');
        $this->load->view('admin/include/footer');
    }

    public function add_new_video()
    {
        if ($this->video->add_new_video()) {
            $this->session->set_userdata('success', "Video Successfully Added");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Video Added Faild");
            redirect($this->agent->referrer());
        }
    }

    public function update_video()
    {
        if ($this->video->update_video()) {
            $this->session->set_userdata('success', "Video Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Video Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function delete_video($id)
    {
        if ($this->video->delete_video($id)) {
            $this->session->set_userdata('success', "Video Successfully Deleted");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Video Deleted Faild");
            redirect($this->agent->referrer());
        }
    }

    public function intro_video()
    {
        $data['title'] = 'Intro Video';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['video'] = $this->video->get_all_intro_video();
        // $this->load->library('cryptojsaes');
        // $data['video1'] = $this->cryptojsaes->decrypt($data['video']->intro_video, '1683593671');
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/video/intro_video');
        $this->load->view('admin/include/footer');
    }

    public function update_intro_video()
    {
        if ($this->video->update_intro_video()) {
            $this->session->set_userdata('success', "Video Successfully Updated");
            redirect($this->agent->referrer());
        } else {
            $this->session->set_userdata('error', "Video Updated Faild");
            redirect($this->agent->referrer());
        }
    }

    public function registration()
    {
        $data['title'] = 'Registration';
        $data['app_setting'] = $this->setting_model->get_all_app_setting();
        $data['page_reg'] = $this->video->get_all_video_page_reg();
        $this->load->view('admin/include/header', $data);
        $this->load->view('admin/video/registration');
        $this->load->view('admin/include/footer');
    }

    


    

    


    


    


    

    

    
}










/* End of file Home.php */
/* Location: ./application/controllers/Home.php */