<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Widget extends Admin_Core_Controller {

	public function __construct()
    {
        parent::__construct();
        check_permission('widget');
    }

	public function add_new_widget()
	{
		$data['title'] = 'Add New Widget';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/widget/add_new_widget', $data);
		$this->load->view('admin/include/footer', $data);
	}

	public function new_widget()
    {
		if ($this->setting_model->new_widget()) {
	        $this->session->set_userdata('success', "Widget Successfully Added");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Widget Added Faild");
	        redirect($this->agent->referrer());
	    }
    }

    public function view_all_widget()
	{
		$data['title'] = 'View All Widget';
		$data['app_setting'] = $this->setting_model->get_all_app_setting();	
		$data['get_all_widget'] = $this->setting_model->get_all_widget();
		$this->load->view('admin/include/header', $data);
		$this->load->view('admin/widget/view_all_widget', $data);
		$this->load->view('admin/include/footer', $data);
	}

    public function update_widget()
    {
		if ($this->setting_model->update_widget()) {
	        $this->session->set_userdata('success', "Widget Successfully Updated");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Widget Update Failed");
	        redirect($this->agent->referrer());
	    }
    }

    public function delete_widget($id)
    {
		if ($this->setting_model->delete_widget($id)) {
	        $this->session->set_userdata('success', "Widget Successfully Delete");
	        redirect($this->agent->referrer());
	    } else {
	        $this->session->set_userdata('error', "Widget Delete Failed");
	        redirect($this->agent->referrer());
	    }
    }

    

    

	

	

	

}

/* End of file Admin.php */
/* Location: ./application/controllers/Admin/Admin.php */