 <div class="content-wrapper">
   <!-- Content Header (Page header) -->
   <div class="content-header">
     <div class="container-fluid">
       <div class="row mb-2">
         <div class="col-sm-6">
           <h1 class="m-0 text-dark"><?php echo $title ?></h1>
         </div><!-- /.col -->
         <div class="col-sm-6">
           <ol class="breadcrumb float-sm-right">
             <li class="breadcrumb-item"><a href="<?php echo base_url() ?>admin/admin/dashboard">Dashboard</a></li>
             <li class="breadcrumb-item"><a href="#"><?php echo ucwords(str_replace("_", " ", $this->uri->segment(2))); ?></a></li>
             <li class="breadcrumb-item active"><?php echo ucwords(str_replace("_", " ", $title)); ?></li>

           </ol>
         </div><!-- /.col -->
       </div><!-- /.row -->
     </div><!-- /.container-fluid -->
   </div>

   <!-- Main content -->
   <section class="content">
     <div class="container-fluid">
       <!-- Info boxes -->



       <div class="card card-default">
         <div class="card-header">
           <h3 class="card-title"><?php echo $title ?></h3>
           <div class="card-tools">
             <a href="add_new_category" class="btn btn-success"><i class="fa fa-plus" aria-hidden="true"></i> Add Category</a>
           </div>
         </div>


         <!-- /.card-header -->
         <div class="card-body">
           <table id="example3" class="table table-bordered table-striped">
             <thead>
               <tr>
                 <th>id</th>
                 <th>Category Name</th>
                 <th>Parent Category</th>
                 <th>Category Image</th>
                 <th>Category Price</th>
                 <th>Status</th>
                 <th></th>
               </tr>
             </thead>
             <tbody>
               <?php $i = 1;
                foreach ($get_all_category as $key => $category): ?>

                 <?php $parent_category = $this->category_model->get_parent_category_by_id($category->parent_category); ?>
                 <tr>
                   <td><?php echo $i ?></td>
                   <td><?php echo $category->name ?></td>
                   <td><?php if (!empty($parent_category->name)) {
                          echo $parent_category->name;
                        } else {
                          echo 'N/A';
                        } ?> </td>
                   <td>
                     <?php if ($category->image) { ?>
                       <img src="<?php echo base_url(); ?><?php echo $category->image ?>" width="50px;">
                     <?php } else { ?>
                       N/A
                     <?php } ?>
                   </td>
                   <td><?php if ($category->cat_type == 1) {
                          echo $category->price;
                        } else {
                          echo 'N/A';
                        } ?> </td>

                   <td><?php if ($category->status == 1) {
                          echo '<span class="badge badge-success">Active</span>';
                        } else {
                          echo '<span class="badge badge-danger">Hidden</span>';
                        } ?></td>
                   <td class="text-right py-0 align-middle">
                     <div class="btn-group btn-group-sm">
                       <?php if ($category->status == 1): ?>
                         <a href="<?php echo base_url() ?>admin/category/deactive_category/<?php echo $category->id ?>" class="btn btn-success"><i class="fas fa-eye"></i></a>
                       <?php else: ?>
                         <a href="<?php echo base_url() ?>admin/category/active_category/<?php echo $category->id ?>" class="btn btn-warning"><i class="fas fa-low-vision"></i></a>
                       <?php endif; ?>

                       <a href="#" class="btn btn-info" data-toggle="modal" data-target="#update-category<?php echo $category->id ?>"><i class="fas fa-edit"></i></a>
                       <a onclick="return confirm('Are you sure?')" href="<?php echo base_url() ?>admin/category/delete_category/<?php echo $category->id ?>" class="btn btn-danger"><i class="fas fa-trash"></i></a>
                     </div>
                   </td>
                 </tr>
                 <?php $i++; ?>
               <?php endforeach; ?>
             </tbody>
           </table>
         </div>
         <div class="card-footer clearfix">
           <?php echo $product_pagination; ?>

         </div>
       </div><!--/. container-fluid -->
   </section>
   <!-- /.content -->
 </div>
 <style type="text/css">
   .dataTables_info {
     display: none;
   }
 </style>

 <!-- /.content-wrapper -->
 <?php foreach ($get_all_category as $key => $category_details): ?>
   <div class="modal fade" id="update-category<?php echo $category_details->id ?>">
     <div class="modal-dialog">
       <div class="modal-content bg-primary">
         <div class="modal-header">
           <h4 class="modal-title">Update Category</h4>
           <button type="button" class="close" data-dismiss="modal" aria-label="Close">
             <span aria-hidden="true">&times;</span></button>
         </div>
         <?php echo form_open_multipart('admin/category/update_category_details'); ?>
         <div class="modal-body">
           <div class="row">

             <div class="col-md-12">
               <div class="form-group">
                 <label for="inputEmail" class="col-sm-12 col-form-label">Category Name <span class="required">*</span></label>
                 <div class="col-sm-12">
                   <input class="form-control" name="name" placeholder="Enter Category Name" required="required" value="<?php echo $category_details->name ?>">
                 </div>
               </div>
             </div>

             <div class="col-md-12">
               <div class="form-group">
                 <label for="inputEmail" class="col-sm-12 col-form-label">Select Parent Category</label>
                 <div class="col-sm-12">
                   <select class="form-control" name="parent_category" id="category_<?php echo $category_details->id ?>">
                     <option value="">Select Category</option>

                   </select>
                 </div>
               </div>
             </div>
             <script type="text/javascript">
               get_all_category();

               function get_all_category() {
                 var category_id = "<?php echo $category_details->parent_category ?>";

                 $.ajax({
                   url: "<?php echo base_url(); ?>admin/category/fetch_all_category_for_admin_panel",
                   method: "POST",
                   data: {
                     category_id: category_id
                   },
                   success: function(data) {
                     $('#category_<?php echo $category_details->id ?>').html(data);
                   }
                 });

               }
             </script>

             <div class="col-md-12" <?php if ($category_details->parent_category > 0) {
                                      echo 'style="display:none"';
                                    } ?>>
               <div class="form-group">
                 <label for="inputEmail" class="col-sm-12 col-form-label">Show in Front Page<span class="required">*</span></label>
                 <div class="col-sm-12">
                   <select class="form-control" name="front_show" required="">
                     <option value="">Select</option>
                     <option <?php if ($category_details->front_show == 1) {
                                echo 'selected';
                              } ?> value="1">Yes</option>
                     <option <?php if ($category_details->front_show == 0) {
                                echo 'selected';
                              } ?> value="0">No</option>
                   </select>
                 </div>
               </div>
             </div>

             <div class="col-md-12" <?php if ($category_details->parent_category > 0) {
                                      echo 'style="display:none"';
                                    } ?>>
               <div class="form-group">
                 <label for="inputEmail" class="col-sm-12 col-form-label">Price</label>
                 <div class="col-sm-12">
                   <input class="form-control" name="price" type="number" placeholder="Enter Course Price" value="<?php echo $category_details->price; ?>">
                 </div>
               </div>
             </div>

             <div class="col-md-12" <?php if ($category_details->parent_category > 0) {
                                      echo 'style="display:none"';
                                    } ?>>
               <div class="form-group">
                 <label for="inputEmail" class="col-sm-12 col-form-label">Showing in Specialist Category</label>
                 <div class="col-sm-12">
                   <select class="form-control" name="showing_in_specialist_cat" placeholder="Enter Course Price">
                     <option <?php if($category_details->showing_in_specialist_cat == 0){echo 'selected';}?> value="0">No</option>
                     <option <?php if($category_details->showing_in_specialist_cat == 1){echo 'selected';}?> value="1">Yes</option>
                   </select>
                 </div>
               </div>
             </div>

             <div class="col-md-12">
               <div class="form-group">
                 <label for="inputEmail" class="col-sm-12 col-form-label">Category Position<span class="required">*</span></label>
                 <div class="col-sm-12">
                   <input value="<?php echo $category_details->menu_position ?>" type="number" class="form-control" name="menu_position" placeholder="Enter menu Position">
                 </div>
               </div>
             </div>


             <input type="hidden" name="id" value="<?php echo $category_details->id ?>">


             <div class="col-md-12 d-none" <?php if ($category_details->parent_category > 0) {
                                              echo 'style="display:none"';
                                            } ?>>
               <div class="form-group">
                 <label for="inputEmail" class="col-sm-12 col-form-label">Category Image (150px X 150px)</label>
                 <div class="col-sm-12">
                   <input type="file" class="form-control" name="image">
                 </div>
               </div>
             </div>

             <div class="col-md-12 d-none" <?php if ($category_details->parent_category > 0) {
                                              echo 'style="display:none"';
                                            } ?>>
               <div class="form-group">
                 <label for="inputEmail" class="col-sm-12 col-form-label">Preview Image</label>
                 <div class="col-sm-12">
                   <img style="border: 1px solid black" src="<?php echo base_url() ?><?php echo $category_details->image ?>" width="150px;">
                 </div>
               </div>
             </div>
           </div>

         </div>


         <div class="modal-footer justify-content-between">
           <button type="button" class="btn btn-outline-light" data-dismiss="modal">Close</button>
           <button type="submit" class="btn btn-outline-light">Save changes</button>
         </div>
         <?php echo form_close() ?>
       </div>

     </div>
     <!-- /.modal-dialog -->
   </div>

 <?php endforeach; ?>