<!-- Content Wrapper. Contains Course content -->
<div class="content-wrapper">
  <!-- Content Header (Course header) -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>Add New Course</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
            <li class="breadcrumb-item active">Add Course</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>


  <section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-sm-12">
          <div class="card card-default">
            <div class="card-header">
              <h3 class="card-title">Add Course</h3>
            </div>
            <div class="card-body">
              <?php echo form_open_multipart(base_url() . 'admin/course/add_course'); ?>
              <div class="row">
                <div class="col-md-12">
                  <div class="form-group">
                    <label>Course Meta Title</label>
                    <input type="text" name="course_meta_title" class="form-control" placeholder="Enter Course Meta Title">
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label>Course Meta Keywords</label>
                    <textarea type="text" name="course_keywords" class="form-control" placeholder="Enter Course Meta Keywords"></textarea>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label>Course Meta Description</label>
                    <textarea type="text" name="course_meta_description" class="form-control" placeholder="Enter Course Meta Description"></textarea>
                  </div>
                </div>
                <div class="col-md-5">
                  <div class="form-group">
                    <label>Course Category <span class="text-danger">*</span></label>
                    <select type="text" id="category" name="course_category" class="form-control" placeholder="Enter Course Meta Description" required>
                      <option value="">Select</option>
                      <?php foreach ($get_all_category_name as $key => $category): ?>
                        <option value="<?php echo $category->id; ?>"><?php echo $category->name; ?></option>
                      <?php endforeach; ?>
                    </select>
                  </div>
                </div>
                <div class="col-md-5">
                  <div class="form-group">
                    <label><?php echo get_phrase('course_sub_category'); ?> <span class="text-danger">*</span></label>
                    <select type="text" class="form-control" name="course_sub_category" id="sub_category" required>
                      <option value="">Select Sub Category</option>
                    </select>
                  </div>
                </div>
                <div class="col-md-2">
                  <div class="form-group">
                    <label>Course Theme <span class="text-danger">*</span></label>
                    <select type="text" name="course_theme" class="form-control" placeholder="Enter Course Meta Description" required>
                      <option value="">Select</option>
                      <option value="theme_1">Theme 1</option>
                      <option value="theme_2">Theme 2</option>
                      <option value="theme_3">Theme 3</option>
                    </select>
                  </div>
                </div>
                <div class="col-md-5">
                  <div class="form-group">
                    <label>Sub Heading </label>
                    <input type="text" name="course_sub_heading" class="form-control" placeholder="Enter Course Sub Heading" />
                  </div>
                </div>
                <div class="col-md-7">
                  <div class="form-group">
                    <label>Heading <span class="text-danger">*</span></label>
                    <input type="text" name="course_heading" class="form-control" placeholder="Enter Course Heading" required />
                  </div>
                </div>
                <div class="col-md-4">
                  <div class="form-group">
                    <label>Image <span class="text-danger">*</span></label>
                    <input type="file" name="course_image" class="form-control" placeholder="Enter Course Heading" required />
                  </div>
                </div>
                <div class="col-md-8">
                  <div class="form-group">
                    <label>Short Description</label>
                    <input type="text" name="course_sub_heading_2" class="form-control" placeholder="Enter Course Short Description" />
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group">
                    <button class="btn btn-info" type="submit" style="float: right">Add</button>
                  </div>
                </div>
              </div>
              <?php echo form_close(); ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
<script>
  $(document).ready(function() {
    $('#category').change(function() {
      var category_id = $('#category').val();
      if (category_id != '') {
        $.ajax({
          url: "<?php echo base_url(); ?>admin/category/fetch_all_sub_category",
          method: "POST",
          data: {
            category_id: category_id
          },
          success: function(data) {
            $('#sub_category').html(data);
          }
        });
      } else {
        $('#sub_category').html('<option value="">Select</option>');
        $('#child_sub_category').html('<option value="">Select Child Sub Category</option>');
      }
    });
  });
</script>