<div class="checkbox-div-main">
    <?php
    // Decode the JSON string to an array
    $selected_courses = json_decode($data->bundile_courses, true);

    foreach ($all_course as $key => $course):
        // Determine the correct price
        if ($course->course_in_class_dicount_price) {
            $price = $course->course_in_class_dicount_price;
        } else {
            $price = $course->course_in_class_main_price;
        }

        // Check if the current course_id is in the selected courses array
        $isChecked = in_array($course->course_id, $selected_courses);
    ?>
        <div class="col-md-12 checkbox-div">
            <div class="form-group">
                <input type="checkbox" id="course-<?php echo $course->course_id; ?>" class="course-checkbox" name="bundle_courses[]"
                    value="<?php echo $course->course_id; ?>"
                    data-price="<?php echo $price; ?>"
                    <?php echo $isChecked ? 'checked' : ''; ?>>
                <label for="course-<?php echo $course->course_id; ?>" class="course-label">
                    <?php echo $course->course_heading; ?> (&#x20B9;<?php echo $price; ?>)
                </label>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<div class="col-md-12 text-center">
    <h5 id="ttl_price"></h5>
    <h5>Main Price: <b>&#x20B9;<?php echo $data->bundile_price; ?></b></h5>
</div>
<div class="col-md-12 d-none">
    <div class="form-group">
        <input name="org_bundle_price" id="org_bundle_price">
    </div>
</div>

<div class="col-md-5 mt-3">
    <div class="form-group">
        <label>Bundle Main Price</label>
        <input type="text" name="bundile_price" class="form-control" placeholder="Enter Bundle Price" value="<?php echo $data->bundile_price; ?>">
    </div>
</div>
<div class="col-md-7 mt-3">
    <div class="form-group">
        <label>Bundle Money Back Title</label>
        <input type="text" name="bundile_money_back_title" class="form-control" placeholder="Enter Bundle Money back Title" value="<?php echo $data->bundile_money_back_title; ?>">
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const checkboxes = document.querySelectorAll('.course-checkbox');
        const ttlPriceDiv = document.getElementById('ttl_price');
        const ttlPriceVal = document.getElementById('org_bundle_price');

        function updateTotalPrice() {
            let totalPrice = 0;
            checkboxes.forEach(function(checkbox) {
                if (checkbox.checked) {
                    totalPrice += parseFloat(checkbox.getAttribute('data-price'));
                }
            });
            ttlPriceDiv.innerHTML = 'Total Price: <b>&#x20B9;' + totalPrice + '</b>';
            ttlPriceVal.value = totalPrice;
        }

        checkboxes.forEach(function(checkbox) {
            checkbox.addEventListener('change', updateTotalPrice);
        });

        // Initialize total price on page load if any checkbox is checked by default
        updateTotalPrice();
    });
</script>
<style>
    .checkbox-div .form-group {
        display: flex;
        align-items: center;
        margin-bottom: 15px;
        /* Adjust the spacing between form groups */
    }

    .checkbox-div-main {
        border: 2px solid #ddd;
        width: 100%;
        padding: 20px;
        margin-bottom: 20px;
    }

    .checkbox-div .course-checkbox {
        margin-right: 10px;
        /* Space between checkbox and label */
    }

    .checkbox-div .course-label {
        margin: 0;
        /* Ensure no extra margin is added to the label */
        font-weight: normal;
        /* Customize the label font-weight if needed */
    }
</style>