<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>All Course Resource</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
            <li class="breadcrumb-item"><a href="#">Course</a></li>
            <li class="breadcrumb-item active">Course Resource</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <div class="row">

        <div class="col-sm-12">
          <div class="card card-default">
            <div class="card-header">
              <h3 class="card-title">All Resource</h3>
              <div class="card-tools">
                <a href="#" data-toggle="modal" data-target="#resourceModal" class="btn btn-primary btn-sm"><i class="fa fa-plus" aria-hidden="true"></i> Add Resource</a>
              </div>
            </div>
            <div class="card-body">
              <table id="example" class="table table-bordered table-striped">
                <thead>
                  <tr>
                    <th>id</th>
                    <th>Name</th>
                    <th>Description</th>
                    <th>Image</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
                  <?php $i = 1;
                  foreach ($all_data as $key => $data): ?>
                    <tr>
                      <td><?php echo $i ?></td>
                      <td><?php echo $data->cr_name ?></td>
                      <td><?php echo $data->cr_description ?></td>
                      <td><img src="<?php echo base_url(); ?><?php echo $data->cr_image ?>" width="70"></td>
                      <td>
                        <a class="btn btn-success btn-sm" href="#" data-toggle="modal" data-target="#resourceModal_edit_<?php echo $data->cr_id; ?>"><i class="fa fa-edit" aria-hidden="true"></i></a>

                        <a class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')" href="<?php echo base_url() ?>admin/course/delete_course_resource/<?php echo $data->cr_id; ?>"><i class="fa fa-trash" aria-hidden="true"></i></a>
                      </td>
                    </tr>
                    <?php $i++; ?>
                  <?php endforeach; ?>
                </tbody>

              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- /.content -->
</div>

<?php foreach ($all_data as $key => $data): ?>
  <div class="modal fade" id="resourceModal_edit_<?php echo $data->cr_id; ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Update Category</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <?php echo
        form_open_multipart(base_url() . 'admin/course/update_course_resource/' . $data->cr_id);
        ?>
        <div class="modal-body">
          <div class="form-group">
            <label class="col-form-label">Name <span class="text-danger">*</span></label>
            <input type="text" name="cr_name" required class="form-control" placeholder="Enter Resource Name" value="<?php echo $data->cr_name; ?>">
          </div>
          <div class="form-group">
            <label class="col-form-label">Description</label>
            <textarea type="text" name="cr_description" class="form-control" placeholder="Enter Resource Description"><?php echo $data->cr_description; ?></textarea>
          </div>
          <div class="form-group">
            <label class="col-form-label">Image </label>
            <input type="file" name="cr_image" class="form-control" placeholder="Enter Resource Name">
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Save</button>
        </div>
        <?php echo
        form_close();
        ?>
      </div>
    </div>
  </div>
<?php endforeach; ?>

<div class="modal fade" id="resourceModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add Resource</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <?php echo
      form_open_multipart(base_url() . 'admin/course/add_course_resource');
      ?>
      <div class="modal-body">
        <div class="form-group">
          <label class="col-form-label">Name <span class="text-danger">*</span></label>
          <input type="text" name="cr_name" required class="form-control" placeholder="Enter Resource Name">
        </div>
        <div class="form-group">
          <label class="col-form-label">Description</label>
          <textarea type="text" name="cr_description" class="form-control" placeholder="Enter Resource Description"></textarea>
        </div>
        <div class="form-group">
          <label class="col-form-label">Image <span class="text-danger">*</span></label>
          <input type="file" name="cr_image" required class="form-control" placeholder="Enter Resource Name">
        </div>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-primary">Save</button>
      </div>
      <?php echo
      form_close();
      ?>
    </div>
  </div>
</div>