<?php
$sections = $this->course_model->get_section('course', $course_id)->result_array();
?>
<div class="row justify-content-center">
    <div class="col-xl-8 mb-4 text-right mt-3">
        <?php if (count($sections) > 0) : ?>
            <a href="javascript:void(0)" class="btn btn-outline-primary btn-rounded btn-sm ml-1" onclick="showLargeModal('<?php echo base_url('modal/popup/sort_section/' . $course_id); ?>', '<?php echo get_phrase('sort_sections'); ?>')"><i class="mdi mdi-sort-variant"></i> <?php echo get_phrase('sort_sections'); ?></a>
        <?php endif; ?>
        <a href="<?php echo base_url(); ?>admin/course/download_curriculum/<?php echo $course_id; ?>" class="btn btn-outline-primary btn-rounded btn-sm ml-1">Export Lessions</a>
    </div>
    <div class="col-xl-8">
        <div class="row">
            <?php
            $lesson_counter = 0;
            $quiz_counter   = 0;
            foreach ($sections as $key => $section) : ?>
                <div class="col-xl-12">
                    <div class="card bg-light text-seconday on-hover-action mb-2" id="section-<?php echo $section['id']; ?>">
                        <div class="card-body">
                            <h5 class="" class="mb-3" style="min-height: 45px;"><span class="font-weight-light"><?php echo get_phrase('section') . ' ' . ++$key; ?></span>: <?php echo $section['title']; ?>
                                <div class="row justify-content-center alignToTitle float-right display-none" id="widgets-of-section-<?php echo $section['id']; ?>">
                                    <button type="button" class="btn btn-outline-secondary btn-rounded btn-sm" name="button" onclick="showLargeModal('<?php echo base_url('modal/popup/sort_lesson/' . $section['id']); ?>', '<?php echo get_phrase('sort_lessons'); ?>')" ><i class="fa fa-sort"></i> <?php echo get_phrase('sort_lesson'); ?></button>
                                    <button type="button" class="btn btn-outline-secondary btn-rounded btn-sm ml-1" name="button" onclick="showAjaxModal('<?php echo base_url('modal/popup/section_edit/' . $section['id'] . '/' . $course_id); ?>', '<?php echo get_phrase('update_section'); ?>')"><i class="fa fa-edit"></i> <?php echo get_phrase('edit_section'); ?></button>
                                    <button type="button" class="btn btn-outline-secondary btn-rounded btn-sm ml-1" name="button" onclick="confirm_modal('<?php echo base_url('admin/course/sections/' . $course_id . '/delete' . '/' . $section['id']); ?>');"><i class="fa fa-trash"></i> <?php echo get_phrase('delete_section'); ?></button>
                                </div>
                            </h5>
                            <div class="clearfix"></div>
                            <?php
                            $lessons = $this->course_model->get_lessons('section', $section['id'])->result_array();
                            foreach ($lessons as $index => $lesson) : ?>
                                <div class="col-md-12">
                                    <!-- Portlet card -->
                                    <div class="card text-secondary on-hover-action mb-2" id="<?php echo 'lesson-' . $lesson['id']; ?>">
                                        <div class="card-body thinner-card-body">
                                            <div class="card-widgets display-none" id="widgets-of-lesson-<?php echo $lesson['id']; ?>" style="float: right;">
                                                <?php if ($lesson['lesson_type'] == 'quiz') : ?>
                                                    <a href="javascript:void(0)" onclick="showLargeModal('<?php echo base_url('modal/popup/quiz_questions/' . $lesson['id']); ?>', '<?php echo get_phrase('manage_quiz_questions'); ?>')"><i class="fas fa-question"></i></a>
                                                    <a href="javascript:void(0)" onclick="showAjaxModal('<?php echo base_url('modal/popup/quiz_edit/' . $lesson['id'] . '/' . $course_id); ?>', '<?php echo get_phrase('update_quiz_information'); ?>')"><i class="fas fa-edit"></i></a>
                                                <?php else : ?>
                                                    <a href="javascript:;" onclick="showAjaxModal('<?php echo site_url('modal/popup/resource_files/'.$lesson['id']); ?>', '<?php echo get_phrase('Add new resource file'); ?>')" data-toggle="tooltip" title="<?php echo get_phrase('Resource files'); ?>"><i class="fa fa-folder-open"></i></a>

                                                    <a href="javascript:void(0)" onclick="showAjaxModal('<?php echo base_url('modal/popup/lesson_edit/' . $lesson['id'] . '/' . $course_id); ?>', '<?php echo get_phrase('update_lesson'); ?>')"><i class="fas fa-edit"></i></a>
                                                <?php endif; ?>
                                                <a href="javascript:void(0)" onclick="confirm_modal('<?php echo base_url('admin/course/lessons/' . $course_id . '/delete' . '/' . $lesson['id']); ?>');"><i class="fas fa-times"></i></a>
                                            </div>
                                            <h5 class="card-title mb-0">
                                                <span class="font-weight-light">
                                                    <?php
                                                    if ($lesson['lesson_type'] == 'quiz') {
                                                        $quiz_counter++; // Keeps track of number of quiz
                                                        $lesson_type = $lesson['lesson_type'];
                                                    } else {
                                                        $lesson_counter++; // Keeps track of number of lesson
                                                        if ($lesson['attachment_type'] == 'text' || $lesson['attachment_type'] == 'pdf' || $lesson['attachment_type'] == 'doc' || $lesson['attachment_type'] == 'img') {
                                                            $lesson_type = $lesson['attachment_type'];
                                                        } 
                                                        elseif($lesson['attachment_type'] == 'description')
                                                        {
                                                            $lesson_type = 'txt';
                                                        }
                                                        else {
                                                            $lesson_type = 'video';
                                                        }
                                                    }
                                              
                                                    ?>
                                                    <img src="<?php echo base_url('assets/lesson_icon/' . $lesson_type . '.png'); ?>" alt="" height="16">
                                                    <?php echo $lesson['lesson_type'] == 'quiz' ? get_phrase('quiz') . ' ' . $quiz_counter : get_phrase('lesson') . ' ' . $lesson_counter; ?>
                                                </span>: <?php echo $lesson['title']; ?>
                                            </h5>
                                        </div>
                                    </div> <!-- end card-->
                                </div>
                            <?php endforeach; ?>
                        </div> <!-- end card-body-->
                    </div> <!-- end card-->
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>
<style type="text/css">
    .card .card-widgets>a {
        color: inherit;
        font-size: 18px;
        display: inline-block;
        line-height: 1;
    }
</style>