<link rel="stylesheet" href="<?php echo admin_css() ?>plugins/bs-stepper/css/bs-stepper.min.css">
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet" />
<?php error_reporting(0);
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>Edit Course</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
            <li class="breadcrumb-item"><a href="#">Course</a></li>
            <li class="breadcrumb-item active">Edit Course</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <!--  EXAMPLE -->
      <div class="card card-default">
        <div class="card-header">
          <h3 class="card-title">Update Course </h3>
          <div class="card-tools">
            <a href="javascript:void(0)" onclick="showAjaxModal('<?php echo base_url('modal/popup/section_add/' . $course->course_id); ?>', '<?php echo get_phrase('add_new_section'); ?>')" class="btn btn-success btn-sm"><i class="fa fa-plus" aria-hidden="true"></i> Add Section</a>
            <a href="javascript:void(0)" onclick="showAjaxModal('<?php echo base_url('modal/popup/lesson_types/' . $course->course_id); ?>', '<?php echo get_phrase('add_new_lesson'); ?>')" class="btn btn-warning btn-sm"><i class="fa fa-plus" aria-hidden="true"></i> Add Lession</a>
            <a href="javascript:void(0)" class="btn btn-outline-primary btn-rounded btn-sm ml-1" onclick="showAjaxModal('<?php echo site_url('modal/popup/quiz_add/' . $course->course_id); ?>', '<?php echo get_phrase('add_new_quiz'); ?>')"><i class="fa fa-plus"></i> <?php echo get_phrase('add_quiz'); ?></a>

            <a href="<?php echo admin_url() ?>course/view_all_course"><button type="button" class="btn btn-success btn-sm">View All Course</button></a>

          </div>
        </div>
        <div class="card-body">
          <div class="card-body p-0">
            <div class="bs-stepper linear">
              <div class="" role="tablist">
                <!-- your steps here -->
                <div class="row">
                  <div class="col-6 col-md-3">
                    <div class="step active" data-target="#curriculum">
                      <button type="button" class="step-trigger" role="tab" aria-controls="curriculum-part" id="curriculum-part-trigger" aria-selected="true">
                        <span class="bs-stepper-circle">1</span>
                        <span class="bs-stepper-label">Curriculum</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="step " data-target="#basic-part">
                      <button type="button" class="step-trigger" role="tab" aria-controls="basic-part" id="basic-part-trigger" aria-selected="true">
                        <span class="bs-stepper-circle">2</span>
                        <span class="bs-stepper-label">Basic</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#title-part">
                      <button type="button" class="step-trigger" role="tab" id="title-part-trigger" aria-controls="title-part" aria-selected="false">
                        <span class="bs-stepper-circle">3</span>
                        <span class="bs-stepper-label">Title</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#certified-from-part">
                      <button type="button" class="step-trigger" role="tab" id="certified-from-part-trigger" aria-controls="certified-from-part" aria-selected="false">
                        <span class="bs-stepper-circle">4</span>
                        <span class="bs-stepper-label">Certified From</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#key-highlight-part">
                      <button type="button" class="step-trigger" role="tab" id="key-highlight-part-trigger" aria-controls="key-highlight-part" aria-selected="false">
                        <span class="bs-stepper-circle">5</span>
                        <span class="bs-stepper-label">Key Highlight</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#who-this-for-part">
                      <button type="button" class="step-trigger" role="tab" id="who-this-for-part-trigger" aria-controls="who-this-for-part" aria-selected="false">
                        <span class="bs-stepper-circle">6</span>
                        <span class="bs-stepper-label"> Who's This For </span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#course-certification-part">
                      <button type="button" class="step-trigger" role="tab" id="course-certification-part-trigger" aria-controls="course-certification-part" aria-selected="false">
                        <span class="bs-stepper-circle">7</span>
                        <span class="bs-stepper-label"> Course Certification </span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#marketing-tools-part">
                      <button type="button" class="step-trigger" role="tab" id="marketing-tools-part-trigger" aria-controls="marketing-tools-part" aria-selected="false">
                        <span class="bs-stepper-circle">8</span>
                        <span class="bs-stepper-label"> Marketing Tools</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#ai-tools-part">
                      <button type="button" class="step-trigger" role="tab" id="ai-tools-part-trigger" aria-controls="ai-tools-part" aria-selected="false">
                        <span class="bs-stepper-circle">9</span>
                        <span class="bs-stepper-label"> AI Tools</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#hiring-partner-part">
                      <button type="button" class="step-trigger" role="tab" id="hiring-partner-part-trigger" aria-controls="hiring-partner-part" aria-selected="false">
                        <span class="bs-stepper-circle">10</span>
                        <span class="bs-stepper-label"> Hiring Partner</span>
                      </button>
                    </div>
                  </div>

                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#learning-methodology-part">
                      <button type="button" class="step-trigger" role="tab" id="learning-methodology-part-trigger" aria-controls="learning-methodology-part" aria-selected="false">
                        <span class="bs-stepper-circle">11</span>
                        <span class="bs-stepper-label"> Learning Meth.</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#success-stories-part">
                      <button type="button" class="step-trigger" role="tab" id="success-stories-part-trigger" aria-controls="success-stories-part" aria-selected="false">
                        <span class="bs-stepper-circle">12</span>
                        <span class="bs-stepper-label"> Success Stories</span>
                      </button>
                    </div>
                  </div>

                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#how-it-work-part">
                      <button type="button" class="step-trigger" role="tab" id="how-it-work-part-trigger" aria-controls="how-it-work-part" aria-selected="false">
                        <span class="bs-stepper-circle">13</span>
                        <span class="bs-stepper-label"> How it Works</span>
                      </button>
                    </div>
                  </div>

                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#whats-new-part">
                      <button type="button" class="step-trigger" role="tab" id="whats-new-part-trigger" aria-controls="whats-new-part" aria-selected="false">
                        <span class="bs-stepper-circle">14</span>
                        <span class="bs-stepper-label"> Whats New</span>
                      </button>
                    </div>
                  </div>

                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#whats-include-part">
                      <button type="button" class="step-trigger" role="tab" id="whats-include-part-trigger" aria-controls="whats-include-part" aria-selected="false">
                        <span class="bs-stepper-circle">15</span>
                        <span class="bs-stepper-label"> Whats Include</span>
                      </button>
                    </div>
                  </div>

                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#bonus-content-part">
                      <button type="button" class="step-trigger" role="tab" id="bonus-content-part-trigger" aria-controls="bonus-content-part" aria-selected="false">
                        <span class="bs-stepper-circle">16</span>
                        <span class="bs-stepper-label"> Bonus Content</span>
                      </button>
                    </div>
                  </div>

                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#faq-part">
                      <button type="button" class="step-trigger" role="tab" id="faq-part-trigger" aria-controls="faq-part" aria-selected="false">
                        <span class="bs-stepper-circle">17</span>
                        <span class="bs-stepper-label"> FAQ</span>
                      </button>
                    </div>
                  </div>

                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#pricing-part">
                      <button type="button" class="step-trigger" role="tab" id="pricing-part-trigger" aria-controls="pricing-part" aria-selected="false">
                        <span class="bs-stepper-circle">18</span>
                        <span class="bs-stepper-label"> Pricing</span>
                      </button>
                    </div>
                  </div>

                </div>
              </div>
              <?php echo form_open_multipart(base_url() . 'admin/course/update_course/' . $course->course_id); ?>
              <div class="bs-stepper-content">
                <div id="curriculum" class="content active dstepper-block tab-pane" role="tabpanel" aria-labelledby="curriculum-part-trigger">
                  <div class="row justify-content-center video_course">
                    <div class="col-md-12">
                      <?php
                      $this->load->view('admin/course/curriculum', ['course_id' => $course->course_id]);
                      ?>
                    </div>
                  </div>
                  <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button>
                </div>

                <div id="basic-part" class="content tab-pane" role="tabpanel" aria-labelledby="basic-part-trigger">
                  <div class="row">
                    <div class="col-md-8">
                      <div class="form-group">
                        <label>Course Meta Title</label>
                        <input type="text" name="course_meta_title" class="form-control" placeholder="Enter Course Meta Title" value="<?php echo $course->course_meta_title; ?>">
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group">
                        <label>Admission Close</label>
                        <input type="date" name="course_admission_date" class="form-control" placeholder="Enter Course Meta Title" value="<?php echo $course->course_admission_date; ?>">
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Course Meta Keywords</label>
                        <textarea type="text" name="course_keywords" class="form-control" placeholder="Enter Course Meta Keywords"><?php echo $course->course_keywords; ?></textarea>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Course Meta Description</label>
                        <textarea type="text" name="course_meta_description" class="form-control" placeholder="Enter Course Meta Description"><?php echo $course->course_meta_description; ?></textarea>
                      </div>
                    </div>
                    <div class="col-md-5">
                      <div class="form-group">
                        <label>Course Category <span class="text-danger">*</span></label>
                        <select type="text" name="course_category" class="form-control" placeholder="Enter Course Meta Description" id="category" required>
                          <option value="">Select</option>
                          <?php foreach ($get_all_category_name as $key => $category): ?>
                            <option <?php if ($course->course_category == $category->id) {
                                      echo 'selected';
                                    } ?> value="<?php echo $category->id; ?>"><?php echo $category->name; ?></option>
                          <?php endforeach; ?>
                        </select>
                      </div>
                    </div>
                    <div class="col-md-5">
                      <div class="form-group">
                        <label>Course Sub Category <span class="text-danger">*</span></label>
                        <select type="text" name="course_sub_category" id="sub_category" class="form-control" placeholder="Enter Course Meta Description" required>
                          <option value="">Select</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-md-2">
                      <div class="form-group">
                        <label>Course Theme <span class="text-danger">*</span></label>
                        <select type="text" name="course_theme" class="form-control" placeholder="Enter Course Meta Description" required>
                          <option value="">Select</option>
                          <option <?php if ($course->course_theme == 'theme_1') {
                                    echo 'selected';
                                  } ?> value="theme_1">Theme 1</option>
                          <option <?php if ($course->course_theme == 'theme_2') {
                                    echo 'selected';
                                  } ?> value="theme_2">Theme 2</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-md-5">
                      <div class="form-group">
                        <label>Sub Heading </label>
                        <input type="text" name="course_sub_heading" class="form-control" placeholder="Enter Course Sub Heading" value="<?php echo $course->course_sub_heading; ?>" />
                      </div>
                    </div>
                    <div class="col-md-7">
                      <div class="form-group">
                        <label>Heading <span class="text-danger">*</span></label>
                        <input type="text" name="course_heading" class="form-control" placeholder="Enter Course Heading" required value="<?php echo $course->course_heading; ?>" />
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group">
                        <label>Drip Content </label>
                        <select type="text" name="enable_drip_content" class="form-control" placeholder="Enter Course Sub Heading">
                          <option <?php if ($course->enable_drip_content == 1) {
                                    echo 'selected';
                                  } ?> value="1">Yes</option>
                          <option <?php if ($course->enable_drip_content == 0) {
                                    echo 'selected';
                                  } ?> value="0">No</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-md-5">
                      <div class="form-group">
                        <label>PDF Browser</label>
                        <input type="file" name="course_pdf_browser" class="form-control" placeholder="Enter Course Heading" />
                      </div>
                    </div>
                    <div class="col-md-3 pt-5">
                      <?php if (file_exists($course->course_pdf_browser)): ?>
                        <a href="<?php echo base_url(); ?><?php echo $course->course_pdf_browser; ?>" download=""><i class="fa fa-download"></i> PDF Download</a>
                      <?php endif; ?>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Image </label>
                        <input type="file" name="course_image" class="form-control" placeholder="Enter Course Heading" />
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Small Image (400 X 400 px)</label>
                        <input type="file" name="course_small_image" class="form-control" placeholder="Enter Course Heading" />
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Short Description</label>
                        <input type="text" name="course_sub_heading_2" class="form-control" placeholder="Enter Course Short Description" value="<?php echo $course->course_sub_heading_2; ?>" />
                      </div>
                    </div>
                    <div class="col-md-3">
                      <img src="<?php echo base_url(); ?><?php echo $course->course_image; ?>" width="100">
                    </div>
                    <div class="col-md-3">
                      <img src="<?php echo base_url(); ?><?php echo $course->course_small_image; ?>" width="100">
                    </div>
                    <div class="col-md-12 mt-3">
                      <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                      <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button>
                      <button type="submit" class="btn btn-success pull-right">Save</button>
                    </div>
                  </div>
                </div>

                <div id="title-part" class="content tab-pane" role="tabpanel" aria-labelledby="title-part-trigger">
                  <div class="row">

                    <?php
                    $headingData = json_decode($course->course_theme_heading, true);

                    foreach ($headingData as $key => $heading) {
                      // Convert key to a more readable format for label
                      $formattedKey = ucwords(str_replace('_', ' ', $key));

                      // Generate HTML for each title and subtitle
                      foreach ($heading as $subKey => $subValue) {
                        if ($subKey != 'paragraph') {
                          $name = $key . '_' . $subKey;
                          $label = $formattedKey . ' ' . ucwords(str_replace('_', ' ', $subKey));
                          echo '<div class="col-md-12">';
                          echo '<div class="form-group">';
                          echo '<label>' . $label . '</label>';
                          echo '<input type="text" name="' . $name . '" class="form-control" placeholder="Enter ' . $label . '" value="' . $subValue . '">';
                          echo '</div>';
                          echo '</div>';
                        } else {
                          // Generate HTML for paragraph as textarea
                          $name = $key . '_' . $subKey;
                          $label = $formattedKey . ' ' . ucwords(str_replace('_', ' ', $subKey));
                          echo '<div class="col-md-12">';
                          echo '<div class="form-group">';
                          echo '<label>' . $label . '</label>';
                          echo '<textarea name="' . $name . '" class="form-control" placeholder="Enter ' . $label . '">' . $subValue . '</textarea>';
                          echo '</div>';
                          echo '</div>';
                        }
                      }
                      echo '<div class="col-md-12">';
                      echo '<hr/>';
                      echo '</div>';
                    }
                    ?>

                    <div class="col-md-12 mt-3">
                      <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                      <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button>
                      <button type="submit" class="btn btn-success pull-right">Save</button>
                    </div>
                  </div>
                </div>

                <div id="certified-from-part" class="content tab-pane" role="tabpanel" aria-labelledby="certified-from-part-trigger">
                  <div class="row">
                    <div class="col-md-12" id="course_certified_from">
                      <?php //include 'components/course_certified_image_partial_view.php'; 
                      ?>
                      <div class="col-md-12">
                        <div class="form-group row">
                          <div class="col-sm-12">
                            <label>Select Image Title</label>
                          </div>
                          <div class="col-sm-12">
                            <select name="course_certified_from_data[]" multiple class="select2" placeholder="Enter Course Sub Heading" style="width: 100%;" data-placeholder="Select From List">
                              <?php
                              $all_certified_from_data = json_decode($course->course_certified_from_data, true); // Decode the JSON data to an array
                              foreach ($all_resource as $resource):
                                // Check if the current resource ID is in the decoded array
                                $selected = in_array($resource->cr_id, $all_certified_from_data) ? 'selected' : '';
                              ?>
                                <option <?php echo $selected; ?> data-image="<?php echo base_url() . $resource->cr_image; ?>" value="<?php echo $resource->cr_id; ?>">
                                  <?php echo $resource->cr_name; ?>
                                </option>
                              <?php endforeach; ?>
                            </select>

                          </div>
                        </div>
                      </div>
                    </div>

                    <div class="col-md-12 mt-3">
                      <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                      <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button>
                      <button type="submit" class="btn btn-success pull-right">Save</button>
                    </div>
                  </div>
                </div>

                <div id="key-highlight-part" class="content tab-pane" role="tabpanel" aria-labelledby="key-highlight-part-trigger">
                  <div class="row">
                    <div class="col-md-12">
                      <table id="dynamic-table-for-key-highlight" class="dynamic_tab">
                        <thead>
                          <tr>
                            <th width="45%">Stat Title</th>
                            <th width="40%">Stat Sub Title</th>
                            <th><button type="button" class="btn btn-warning" onclick="addRowForkeyHighlight()">Add Row</button></th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php
                          $key_highlight = json_decode($course->course_key_highlight, true);
                          foreach ($key_highlight as $highlight) : ?>
                            <tr>
                              <td>
                                <input required type="text" placeholder="Enter Stat Title" class="form-control" name="highlight_title[]" value="<?php echo $highlight['highlight_title']; ?>">
                              </td>
                              <td>
                                <input required type="text" placeholder="Enter Stat Sub Title" class="form-control" name="highlight_sub_title[]" value="<?php echo $highlight['highlight_sub_title']; ?>">
                              </td>
                              <td><button type="button" class="btn btn-danger" onclick="deleteRowForkeyHighlight(this)">Delete</button></td>
                            </tr>
                          <?php endforeach; ?>
                        </tbody>
                      </table>
                    </div>

                    <div class="col-md-12 mt-3">
                      <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                      <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button>
                      <button type="submit" class="btn btn-success pull-right">Save</button>
                    </div>
                  </div>
                </div>

                <div id="who-this-for-part" class="content tab-pane" role="tabpanel" aria-labelledby="key-highlight-part-trigger">
                  <div class="row">
                    <div class="col-md-12">
                      <table id="dynamic-table-for-who-this-for" class="dynamic_tab">
                        <thead>
                          <tr>
                            <th width="85%">Content Title</th>
                            <th><button type="button" class="btn btn-warning" onclick="addRowForWhoThisFor()">Add Row</button></th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php
                          $who_this_for_data = json_decode($course->course_who_this_for, true);
                          foreach ($who_this_for_data as $who_this_for) : ?>
                            <tr>
                              <td>
                                <input required type="text" placeholder="Enter Title" class="form-control" name="who_this_title[]" value="<?php echo $who_this_for; ?>">
                              </td>
                              <td><button type="button" class="btn btn-danger" onclick="deleteRowForWhoThisFor(this)">Delete</button></td>
                            </tr>
                          <?php endforeach; ?>
                        </tbody>
                      </table>
                    </div>

                    <div class="col-md-12 mt-3">
                      <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                      <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button>
                      <button type="submit" class="btn btn-success pull-right">Save</button>
                    </div>
                  </div>
                </div>

                <div id="course-certification-part" class="content tab-pane" role="tabpanel" aria-labelledby="course-certification-part-trigger">
                  <div class="row">
                    <div class="col-md-12" id="course_certification_from">
                      <?php //include 'components/course_certification_image_partial_view.php'; 
                      ?>
                    </div>
                    <div class="col-md-12">
                      <div class="form-group row">
                        <div class="col-sm-12">
                          <label>Select Image Title</label>
                        </div>
                        <div class="col-sm-12">
                          <select name="course_course_certification[]" multiple class="select2" placeholder="Enter Course Sub Heading" style="width: 100%;" data-placeholder="Select From List">
                            <?php
                            $all_course_course_certification = json_decode($course->course_course_certification, true); // Decode the JSON data to an array
                            foreach ($all_resource as $resource):
                              // Check if the current resource ID is in the decoded array
                              $selected = in_array($resource->cr_id, $all_course_course_certification) ? 'selected' : '';
                            ?>
                              <option <?php echo $selected; ?> data-image="<?php echo base_url() . $resource->cr_image; ?>" value="<?php echo $resource->cr_id; ?>">
                                <?php echo $resource->cr_name; ?>
                              </option>
                            <?php endforeach; ?>
                          </select>

                        </div>
                      </div>
                    </div>

                    <div class="col-md-12 mt-3">
                      <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                      <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button>
                      <button type="submit" class="btn btn-success pull-right">Save</button>
                    </div>
                  </div>
                </div>

                <div id="marketing-tools-part" class="content tab-pane" role="tabpanel" aria-labelledby="marketing-tools-part-trigger">
                  <div class="row">
                    <div class="col-md-12" id="marketing_tools_from">
                      <?php //include 'components/course_marketing_tools_partial_view.php'; 
                      ?>
                    </div>
                    <div class="col-md-12">
                      <div class="form-group row">
                        <div class="col-sm-12">
                          <label>Select Image Title</label>
                        </div>
                        <div class="col-sm-12">
                          <select name="course_marketing_tools[]" multiple class="select2" placeholder="Enter Course Sub Heading" style="width: 100%;" data-placeholder="Select From List">
                            <?php
                            $all_course_marketing_tools = json_decode($course->course_marketing_tools, true); // Decode the JSON data to an array
                            foreach ($all_resource as $resource):
                              // Check if the current resource ID is in the decoded array
                              $selected = in_array($resource->cr_id, $all_course_marketing_tools) ? 'selected' : '';
                            ?>
                              <option <?php echo $selected; ?> data-image="<?php echo base_url() . $resource->cr_image; ?>" value="<?php echo $resource->cr_id; ?>">
                                <?php echo $resource->cr_name; ?>
                              </option>
                            <?php endforeach; ?>
                          </select>

                        </div>
                      </div>
                    </div>

                    <div class="col-md-12 mt-3">
                      <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                      <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button>
                      <button type="submit" class="btn btn-success pull-right">Save</button>
                    </div>
                  </div>
                </div>

                <div id="ai-tools-part" class="content tab-pane" role="tabpanel" aria-labelledby="ai-tools-part-trigger">
                  <div class="row">
                    <div class="col-md-12" id="ai_tools_from">
                      <?php //include 'components/course_ai_tools_partial_view.php'; 
                      ?>
                    </div>
                    <div class="col-md-12">
                      <div class="form-group row">
                        <div class="col-sm-12">
                          <label>Select Image Title</label>
                        </div>
                        <div class="col-sm-12">
                          <select name="course_ai_tools[]" multiple class="select2" placeholder="Enter Course Sub Heading" style="width: 100%;" data-placeholder="Select From List">
                            <?php
                            $all_course_ai_tools = json_decode($course->course_ai_tools, true); // Decode the JSON data to an array
                            foreach ($all_resource as $resource):
                              // Check if the current resource ID is in the decoded array
                              $selected = in_array($resource->cr_id, $all_course_ai_tools) ? 'selected' : '';
                            ?>
                              <option <?php echo $selected; ?> data-image="<?php echo base_url() . $resource->cr_image; ?>" value="<?php echo $resource->cr_id; ?>">
                                <?php echo $resource->cr_name; ?>
                              </option>
                            <?php endforeach; ?>
                          </select>

                        </div>
                      </div>
                    </div>

                    <div class="col-md-12 mt-3">
                      <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                      <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button>
                      <button type="submit" class="btn btn-success pull-right">Save</button>
                    </div>
                  </div>
                </div>

                <div id="hiring-partner-part" class="content tab-pane" role="tabpanel" aria-labelledby="hiring-partner-part-trigger">
                  <div class="row">
                    <div class="col-md-12" id="hiring_partner_from">
                      <?php //include 'components/course_hiring_partner_partial_view.php'; 
                      ?>
                    </div>

                    <div class="col-md-12">
                      <div class="form-group row">
                        <div class="col-sm-12">
                          <label>Select Image Title</label>
                        </div>
                        <div class="col-sm-12">
                          <select name="course_hiring_partner[]" multiple class="select2" placeholder="Enter Course Sub Heading" style="width: 100%;" data-placeholder="Select From List">
                            <?php
                            $all_course_hiring_partner = json_decode($course->course_hiring_partner, true); // Decode the JSON data to an array
                            foreach ($all_resource as $resource):
                              // Check if the current resource ID is in the decoded array
                              $selected = in_array($resource->cr_id, $all_course_hiring_partner) ? 'selected' : '';
                            ?>
                              <option <?php echo $selected; ?> data-image="<?php echo base_url() . $resource->cr_image; ?>" value="<?php echo $resource->cr_id; ?>">
                                <?php echo $resource->cr_name; ?>
                              </option>
                            <?php endforeach; ?>
                          </select>

                        </div>
                      </div>
                    </div>

                    <div class="col-md-12 mt-3">
                      <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                      <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button>
                      <button type="submit" class="btn btn-success pull-right">Save</button>
                    </div>
                  </div>
                </div>

                <div id="learning-methodology-part" class="content tab-pane" role="tabpanel" aria-labelledby="hiring-partner-part-trigger">
                  <div class="row">
                    <div class="col-md-12" id="learning_methodology_from">
                      <?php //include 'components/course_learning_methodology_partial_view.php'; 
                      ?>
                    </div>
                    <div class="col-md-12">
                      <div class="form-group row">
                        <div class="col-sm-12">
                          <label>Learning Methodology Content</label>
                        </div>
                        <div class="col-sm-12">
                          <select name="course_learning_methodology[]" multiple class="select2" placeholder="Enter Course Sub Heading" style="width: 100%;" data-placeholder="Select From List">
                            <?php
                            $all_learning_methodology = json_decode($course->course_learning_methodology, true); // Decode the JSON data to an array
                            foreach ($all_resource as $resource):
                              // Check if the current resource ID is in the decoded array
                              $selected = in_array($resource->cr_id, $all_learning_methodology) ? 'selected' : '';
                            ?>
                              <option <?php echo $selected; ?> data-image="<?php echo base_url() . $resource->cr_image; ?>" value="<?php echo $resource->cr_id; ?>">
                                <?php echo $resource->cr_name; ?>
                              </option>
                            <?php endforeach; ?>
                          </select>

                        </div>
                      </div>
                    </div>
                    <div class="col-md-12 mt-3">
                      <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                      <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button>
                      <button type="submit" class="btn btn-success pull-right">Save</button>
                    </div>
                  </div>
                </div>

                <div id="success-stories-part" class="content tab-pane" role="tabpanel" aria-labelledby="success-stories-part-trigger">
                  <div class="row">
                    <div class="col-md-12">
                      <table id="dynamic-table-for-success-strories" class="dynamic_tab">
                        <thead>
                          <tr>
                            <th width="85%">Video URL</th>
                            <th><button type="button" class="btn btn-warning" onclick="addRowForSuccessStrories()">Add Row</button></th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php
                          $success_stories = json_decode($course->course_success_stories, true);
                          foreach ($success_stories as $stories) : ?>
                            <tr>
                              <td>
                                <input required type="text" placeholder="Enter Video URL" class="form-control" name="course_success_stories[]" value="<?php echo $stories; ?>">
                              </td>
                              <td><button type="button" class="btn btn-danger" onclick="deleteRowForSuccessStrories(this)">Delete</button></td>
                            </tr>
                          <?php endforeach; ?>
                        </tbody>
                      </table>
                    </div>

                    <div class="col-md-12 mt-3">
                      <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                      <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button>
                      <button type="submit" class="btn btn-success pull-right">Save</button>
                    </div>
                  </div>
                </div>

                <div id="how-it-work-part" class="content tab-pane" role="tabpanel" aria-labelledby="how-it-work-part-trigger">
                  <div class="row">
                    <div class="col-md-12">
                      <div class="form-group">
                        <label>Video URL</label>
                        <input type="text" name="course_how_it_work" class="form-control" placeholder="Enter Course Video URL" value="<?php echo $course->course_how_it_work; ?>">
                      </div>
                    </div>

                    <div class="col-md-12 mt-3">
                      <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                      <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button>
                      <button type="submit" class="btn btn-success pull-right">Save</button>
                    </div>
                  </div>
                </div>

                <div id="whats-new-part" class="content tab-pane" role="tabpanel" aria-labelledby="whats-new-part-trigger">
                  <div class="row">
                    <div class="col-md-12">
                      <table id="dynamic-table-for-whats-new" class="dynamic_tab">
                        <thead>
                          <tr>
                            <th width="85%">Content</th>
                            <th><button type="button" class="btn btn-warning" onclick="addRowForWhatsNew()">Add Row</button></th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php
                          $all_whats_new = json_decode($course->course_whats_new, true);
                          foreach ($all_whats_new as $whats_new) : ?>
                            <tr>
                              <td>
                                <input required type="text" placeholder="Enter Content" class="form-control" name="course_whats_new[]" value="<?php echo $whats_new; ?>">
                              </td>
                              <td><button type="button" class="btn btn-danger" onclick="deleteRowForWhatsNew(this)">Delete</button></td>
                            </tr>
                          <?php endforeach; ?>
                        </tbody>
                      </table>
                    </div>

                    <div class="col-md-12 mt-3">
                      <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                      <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button>
                      <button type="submit" class="btn btn-success pull-right">Save</button>
                    </div>
                  </div>
                </div>

                <div id="whats-include-part" class="content tab-pane" role="tabpanel" aria-labelledby="whats-include-part-trigger">
                  <div class="row">
                    <div class="col-md-12" id="whats_include_from">
                      <?php include 'components/course_whats_include_partial_view.php'; ?>
                    </div>

                    <div class="col-md-12 mt-3">
                      <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                      <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button>
                      <button type="submit" class="btn btn-success pull-right">Save</button>
                    </div>
                  </div>
                </div>

                <div id="bonus-content-part" class="content tab-pane" role="tabpanel" aria-labelledby="bonus-content-part-trigger">
                  <div class="row">
                    <div class="col-md-8">
                      <div class="form-group row">
                        <div class="col-sm-12">
                          <label>Bonus Content Image</label>
                        </div>
                        <div class="col-sm-12">
                          <select name="course_bonus_content_image" class="select2" placeholder="Enter Course Sub Heading" style="width: 100%;" data-placeholder="Select From List">
                            <option value="">Select From List</option>
                            <?php
                            $bonus_content_image = $course->course_bonus_content_image; // Decode the JSON data to an array
                            foreach ($all_resource as $resource):
                              // Check if the current resource ID is in the decoded array
                              $selected = in_array($resource->cr_id, $bonus_content_image) ? 'selected' : '';
                            ?>
                              <option <?php if ($course->course_bonus_content_image == $resource->cr_id) {
                                        echo 'selected';
                                      }; ?> data-image="<?php echo base_url() . $resource->cr_image; ?>" value="<?php echo $resource->cr_id; ?>">
                                <?php echo $resource->cr_name; ?>
                              </option>
                            <?php endforeach; ?>
                          </select>

                        </div>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <?php
                      $this->db->where('cr_id', $bonus_content_image);
                      $bonusImg = $this->db->get('course_resource')->row();
                      ?>
                      <img src="<?php echo base_url(); ?><?php echo $bonusImg->cr_image; ?>" width="70px">
                    </div>
                    <div class="col-md-12">
                      <table id="dynamic-table-for-bonus-content" class="dynamic_tab">
                        <thead>
                          <tr>
                            <th width="85%">Content</th>
                            <th><button type="button" class="btn btn-warning" onclick="addRowForBonusContent()">Add Row</button></th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php
                          $all_bonus_content = json_decode($course->course_bonus_content, true);
                          foreach ($all_bonus_content as $bonus_content) : ?>
                            <tr>
                              <td>
                                <input required type="text" placeholder="Enter Content" class="form-control" name="course_bonus_content[]" value="<?php echo $bonus_content; ?>">
                              </td>
                              <td><button type="button" class="btn btn-danger" onclick="deleteRowForBonusContent(this)">Delete</button></td>
                            </tr>
                          <?php endforeach; ?>
                        </tbody>
                      </table>
                    </div>

                    <div class="col-md-12 mt-3">
                      <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                      <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button>
                      <button type="submit" class="btn btn-success pull-right">Save</button>
                    </div>
                  </div>
                </div>

                <div id="faq-part" class="content tab-pane" role="tabpanel" aria-labelledby="faq-part-trigger">
                  <div class="row">
                    <div class="col-md-12">
                      <!-- <table id="dynamic-table-for-faq" class="dynamic_tab">
                        <thead>
                          <tr>
                            <th width="40%">Qns</th>
                            <th width="45%">Ans.</th>
                            <th><button type="button" class="btn btn-warning" onclick="addRowForFaq()">Add Row</button></th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php
                          $all_course_faq = json_decode($course->course_faq, true);
                          foreach ($all_course_faq as $faq) : ?>
                            <tr>
                              <td>
                                <input required type="text" placeholder="Enter Qns" class="form-control" name="faq_qns[]" value="<?php echo $faq['faq_qns']; ?>">
                              </td>
                              <td>
                                <input required type="text" placeholder="Enter Ans" class="form-control" name="faq_ans[]" value="<?php echo $faq['faq_ans']; ?>">
                              </td>
                              <td><button type="button" class="btn btn-danger" onclick="deleteRowForFaq(this)">Delete</button></td>
                            </tr>
                          <?php endforeach; ?>
                        </tbody>
                      </table> -->
                      <div id="faq-container">
                        <?php 
                        $faqData = json_decode($course->course_faq, true);
                        if (!empty($faqData)) : ?>
                          <?php foreach ($faqData as $categoryIndex => $category) : ?>
                            <div class="category-block">
                              <input type="text" name="category[<?= $categoryIndex ?>][name]" value="<?= htmlspecialchars($category['category']) ?>" placeholder="Enter Category" class="form-control category-input">
                              <table class="faq-table">
                                <tbody>
                                  <?php if (!empty($category['faqs'])) : ?>
                                    <?php foreach ($category['faqs'] as $faqIndex => $faq) : ?>
                                      <tr>
                                        <td>
                                          <input type="text" name="category[<?= $categoryIndex ?>][faqs][<?= $faqIndex ?>][qns]" value="<?= htmlspecialchars($faq['qns']) ?>" placeholder="Enter Qns" class="form-control">
                                        </td>
                                        <td>
                                          <input type="text" name="category[<?= $categoryIndex ?>][faqs][<?= $faqIndex ?>][ans]" value="<?= htmlspecialchars($faq['ans']) ?>" placeholder="Enter Ans" class="form-control">
                                        </td>
                                        <td>
                                          <button type="button" class="btn btn-danger" onclick="deleteFaqRow(this)">Delete</button>
                                        </td>
                                      </tr>
                                    <?php endforeach; ?>
                                  <?php endif; ?>
                                </tbody>
                              </table>
                              <button type="button" class="btn btn-primary" onclick="addFaqRow(this)">Add FAQ</button>
                            </div>
                          <?php endforeach; ?>
                        <?php else : ?>
                          <!-- Show an empty category block if no data is found -->
                          <div class="category-block">
                            <input type="text" name="category[0][name]" placeholder="Enter Category" class="form-control category-input">
                            <table class="faq-table">
                              <tbody>
                                <tr>
                                  <td>
                                    <input type="text" name="category[0][faqs][0][qns]" placeholder="Enter Qns" class="form-control">
                                  </td>
                                  <td>
                                    <input type="text" name="category[0][faqs][0][ans]" placeholder="Enter Ans" class="form-control">
                                  </td>
                                  <td>
                                    <button type="button" class="btn btn-danger" onclick="deleteFaqRow(this)">Delete</button>
                                  </td>
                                </tr>
                              </tbody>
                            </table>
                            <button type="button" class="btn btn-primary" onclick="addFaqRow(this)">Add FAQ</button>
                          </div>
                        <?php endif; ?>
                      </div>

                      <button type="button" class="btn btn-success" onclick="addCategoryBlock()">Add Category</button>


                      <script>
                        // Function to add a new FAQ row within a category
                        // Function to add a new FAQ row within a category
                        function addFaqRow(button) {
                          var table = button.previousElementSibling.querySelector('tbody');
                          var newRow = table.insertRow(table.rows.length);

                          var cell1 = newRow.insertCell(0);
                          var cell2 = newRow.insertCell(1);
                          var cell3 = newRow.insertCell(2);

                          // Extract category index safely
                          var categoryInput = button.closest('.category-block').querySelector('.category-input');
                          var match = categoryInput.name.match(/\d+/);
                          var categoryIndex = match ? match[0] : '0'; // Default to '0' if not found

                          var faqIndex = table.rows.length - 1; // Ensure correct FAQ index

                          cell1.innerHTML = `<input type="text" name="category[${categoryIndex}][faqs][${faqIndex}][qns]" placeholder="Enter Qns" class="form-control">`;
                          cell2.innerHTML = `<input type="text" name="category[${categoryIndex}][faqs][${faqIndex}][ans]" placeholder="Enter Ans" class="form-control">`;
                          cell3.innerHTML = '<button type="button" class="btn btn-danger" onclick="deleteFaqRow(this)">Delete</button>';
                        }

                        // Function to delete a FAQ row and reindex remaining FAQs
                        function deleteFaqRow(button) {
                          var table = button.closest('tbody');
                          var row = button.closest('tr');
                          row.remove();

                          // Re-index remaining FAQ rows in the category
                          reindexFaqs(table);
                        }

                        // Function to reindex FAQ fields after deletion
                        function reindexFaqs(table) {
                          var categoryBlock = table.closest('.category-block');
                          var categoryIndex = categoryBlock.dataset.index;
                          var rows = table.querySelectorAll('tr');

                          rows.forEach((row, faqIndex) => {
                            row.querySelector('input[name^="category"]').name = `category[${categoryIndex}][faqs][${faqIndex}][qns]`;
                            row.querySelector('input[name^="category"]').nextElementSibling.name = `category[${categoryIndex}][faqs][${faqIndex}][ans]`;
                          });
                        }

                        // Function to add a new category block
                        function addCategoryBlock() {
                          var container = document.getElementById('faq-container');
                          var categoryIndex = container.querySelectorAll('.category-block').length;

                          var newCategoryBlock = document.createElement('div');
                          newCategoryBlock.className = 'category-block';
                          newCategoryBlock.dataset.index = categoryIndex; // Store index for reference

                          newCategoryBlock.innerHTML = `
                              <input type="text" name="category[${categoryIndex}][name]" placeholder="Enter Category" class="form-control category-input">
                              <table class="faq-table">
                                  <tbody>
                                      <tr>
                                          <td>
                                              <input type="text" name="category[${categoryIndex}][faqs][0][qns]" placeholder="Enter Qns" class="form-control">
                                          </td>
                                          <td>
                                              <input type="text" name="category[${categoryIndex}][faqs][0][ans]" placeholder="Enter Ans" class="form-control">
                                          </td>
                                          <td>
                                              <button type="button" class="btn btn-danger" onclick="deleteFaqRow(this)">Delete</button>
                                          </td>
                                      </tr>
                                  </tbody>
                              </table>
                              <button type="button" class="btn btn-primary" onclick="addFaqRow(this)">Add FAQ</button>
                          `;

                          container.appendChild(newCategoryBlock);
                        }
                      </script>
                    </div>

                    <div class="col-md-12 mt-3">
                      <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                      <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button>
                      <button type="submit" class="btn btn-success pull-right">Save</button>
                    </div>
                  </div>
                </div>

                <div id="pricing-part" class="content tab-pane" role="tabpanel" aria-labelledby="basic-part-trigger">
                  <div class="row">
                    <div class="col-md-12">
                      <h4>Pricing</h4>
                      <hr />
                    </div>
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>In Class Main Price </label>
                        <input type="number" name="course_in_class_main_price" class="form-control" placeholder="Enter Course In Class Main Price" value="<?php echo $course->course_in_class_main_price; ?>">
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>In Class Disocunt Price </label>
                        <input type="number" name="course_in_class_dicount_price" class="form-control" placeholder="Enter Course In Class Disocunt Price" value="<?php echo $course->course_in_class_dicount_price; ?>">
                      </div>
                    </div>

                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Online Main Price </label>
                        <input type="number" name="course_online_main_price" class="form-control" placeholder="Enter Course Online Main Price" value="<?php echo $course->course_online_main_price; ?>">
                      </div>
                    </div>
                    <div class="col-md-3">
                      <div class="form-group">
                        <label>Online Disocunt Price </label>
                        <input type="number" name="course_onine_dicount_price" class="form-control" placeholder="Enter Course Online Disocunt Price" value="<?php echo $course->course_onine_dicount_price; ?>">
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Reserve Seat Price </label>
                        <input type="number" name="course_reserve_seat_price" class="form-control" placeholder="Enter Course Reserve Seat Price" value="<?php echo $course->course_reserve_seat_price; ?>">
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Course Duration (Month) </label>
                        <input type="number" name="course_duration" class="form-control" placeholder="Enter Course Duration" value="<?php echo $course->course_duration; ?>">
                      </div>
                    </div>
                    <div class="col-md-12">
                      <h4>EMI</h4>
                      <hr />
                    </div>
                    <?php $emiDetails = json_decode($course->course_emi_details, true); ?>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>EMI Duration (Month) </label>
                        <input type="number" name="emi_duration" class="form-control" placeholder="Enter Course EMI Duration" value="<?php echo $emiDetails['emi_duration']; ?>">
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>EMI Price (Month) </label>
                        <input type="number" name="emi_price" class="form-control" placeholder="Enter Course EMI Price" value="<?php echo $emiDetails['emi_price']; ?>">
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group">
                        <label>EMI Partner Image </label>
                        <input type="file" name="course_emi_partner" class="form-control" placeholder="Enter Course EMI Price">
                      </div>
                    </div>
                    <div class="col-md-8">
                      <div class="form-group">
                        <label>EMI Content </label>
                        <input type="text" name="emi_content" class="form-control" placeholder="Enter Course EMI Content" value="<?php echo $emiDetails['emi_content']; ?>">
                      </div>
                    </div>
                    <div class="col-md-4">
                      <img src="<?php echo base_url(); ?><?php echo $course->course_emi_partner; ?>" width="70px">
                    </div>


                    <div class="col-md-12 mt-3">
                      <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                      <!-- <button type="button" class="btn btn-info" onclick="stepper.next()">Next</button> -->
                      <button type="submit" class="btn btn-success pull-right">Save</button>
                    </div>
                  </div>
                </div>

              </div>
              <?php echo
              form_close();
              ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>

<style>
  .category-block {
    margin-bottom: 20px;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 5px;
  }

  .faq-table {
    width: 100%;
    margin-bottom: 10px;
  }

  .faq-table td {
    padding: 5px;
  }

  .category-input {
    margin-bottom: 10px;
    font-weight: bold;
  }
</style>

<?php $this->load->view('admin/course/components/course_modal'); ?>
<?php $this->load->view('admin/course/components/ajax_function'); ?>
<?php $this->load->view('admin/modal'); ?>
<script src="<?php echo admin_css() ?>plugins/bs-stepper/js/bs-stepper.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
<script type="text/javascript">
  $(document).ready(function() {
    function formatOption(option) {
      if (!option.id) {
        return option.text;
      }
      var img = $(option.element).data('image');
      var $option = $(
        '<span><img src="' + img + '" class="img-flag" style="width: 20px; height: 20px; margin-right: 10px;" /> ' + option.text + '</span>'
      );
      return $option;
    }

    $('.select2').select2({
      placeholder: "Enter Course Sub Heading",
      templateResult: formatOption,
      templateSelection: formatOption,
      allowClear: true,
      escapeMarkup: function(markup) {
        return markup;
      } // Allows HTML markup to be returned
    });
  });

  document.addEventListener('DOMContentLoaded', function() {
    var stepper = new Stepper(document.querySelector('.bs-stepper'));

    document.querySelectorAll('.step-trigger').forEach(button => {
      button.addEventListener('click', function() {
        var target = this.parentElement.getAttribute('data-target');

        // Hide all tab panes
        document.querySelectorAll('.tab-pane').forEach(tabPane => {
          tabPane.classList.remove('show', 'active');
        });

        // Show the corresponding tab pane
        document.querySelector(target).classList.add('show', 'active');

        // Remove 'active' class from all steps
        document.querySelectorAll('.step').forEach(step => {
          step.classList.remove('active');
        });

        // Add 'active' class to the current step
        this.parentElement.classList.add('active');

        // Update the stepper
        stepper.to(parseInt(this.querySelector('.bs-stepper-circle').textContent));
      });
    });
  });
  $(document).ready(function() {
    $('#category').change(function() {
      var category_id = $('#category').val();
      if (category_id != '') {
        $.ajax({
          url: "<?php echo base_url(); ?>admin/category/fetch_all_sub_category",
          method: "POST",
          data: {
            category_id: category_id
          },
          success: function(data) {
            $('#sub_category').html(data);
          }
        });
      } else {
        $('#sub_category').html('<option value="">Select</option>');
        $('#child_sub_category').html('<option value="">Select Child Sub Category</option>');
      }
    });
    get_sub_category(<?php echo $course->course_category; ?>, <?php echo $course->course_sub_category; ?>)
  });

  function get_sub_category(category_id, selected_value) {
    console.log(category_id);
    if (category_id != '') {
      $.ajax({
        url: "<?php echo base_url(); ?>admin/category/fetch_all_sub_category",
        method: "POST",
        data: {
          category_id: category_id
        },
        success: function(data) {
          $('#sub_category').html(data);

          // Check if a selected_value is provided and set it as selected
          if (selected_value !== '') {
            $('#sub_category').val(selected_value);
          }
        }
      });
    } else {
      $('#sub_category').html('<option value="">Select</option>');
      $('#child_sub_category').html('<option value="">Select Child Sub Category</option>');
    }
  }
</script>

<style>
  .tab-pane {
    display: none !important;
  }

  .tab-pane.active {
    display: block !important;
  }

  .dynamic_tab {
    width: 100%;
    border-collapse: collapse;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
  }

  .dynamic_tab th {
    background-color: #4CAF50;
    color: white;
  }

  .dynamic_tab th,
  .dynamic_tab td {
    padding: 12px;
    text-align: left;
    border-bottom: 1px solid #ddd;
  }

  .select2-container--default .select2-selection--multiple .select2-selection__choice {
    color: #000;
  }

  .select2-container .select2-selection--single {
    height: 40px !important;
  }

  .select2-container--default .select2-selection--single .select2-selection__arrow {
    top: 7px;
  }
</style>