<link rel="stylesheet" href="<?php echo admin_css() ?>plugins/bs-stepper/css/bs-stepper.min.css">

<?php
$errors = $this->session->userdata('errors');
if (isset($errors)) {
?>
  <script>
    swal("Oops", "<?php echo $errors ?>", "error")
  </script>
  <?php echo $errors ?>
<?php
  $this->session->unset_userdata('errors');
}
$error = $this->session->userdata('error');
if (isset($error)) {
?>
  <script>
    swal("Oops", "<?php echo $error ?>", "error")
  </script>
<?php
  $this->session->unset_userdata('error');
}
$success = $this->session->userdata('success');
if (isset($success)) {
?>
  <script>
    swal({
      title: "Done!",
      text: "<?php echo $success ?>",
      icon: "success",
    });
  </script>
<?php
  $this->session->unset_userdata('success');
}
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>Edit Course</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
            <li class="breadcrumb-item active">Edit Course</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <!--  EXAMPLE -->
      <div class="card card-default">
        <div class="card-header">
          <div class="card-tools">
            <a href="javascript:void(0)" onclick="showAjaxModal('<?php echo base_url('modal/popup/section_add/' . $course->id); ?>', '<?php echo get_phrase('add_new_section'); ?>')" class="btn btn-success btn-sm"><i class="fa fa-plus" aria-hidden="true"></i> Add Section</a>
            <a href="javascript:void(0)" onclick="showAjaxModal('<?php echo base_url('modal/popup/lesson_types/' . $course->id); ?>', '<?php echo get_phrase('add_new_lesson'); ?>')" class="btn btn-warning btn-sm"><i class="fa fa-plus" aria-hidden="true"></i> Add Lession</a>

            <a href="<?php echo admin_url() ?>course/view_all_course"><button type="button" class="btn btn-success btn-sm">View All Course</button></a>

          </div>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
          <div class="card-body p-0">
            
            <div class="bs-stepper linear">
              <div class="" role="tablist">
                <!-- your steps here -->
                <div class="row">
                  <div class="col-6 col-md-3">
                    <div class="step active" data-target="#curriculum">
                      <button type="button" class="step-trigger" role="tab" aria-controls="curriculum-part" id="curriculum-part-trigger" aria-selected="true">
                        <span class="bs-stepper-circle">1</span>
                        <span class="bs-stepper-label">Curriculum</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="step " data-target="#basic-part">
                      <button type="button" class="step-trigger" role="tab" aria-controls="logins-part" id="logins-part-trigger" aria-selected="true" disabled="disabled">
                        <span class="bs-stepper-circle">2</span>
                        <span class="bs-stepper-label">Basic</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#additional-part">
                      <button type="button" class="step-trigger" role="tab" aria-controls="information-part" aria-selected="false" disabled="disabled">
                        <span class="bs-stepper-circle">3</span>
                        <span class="bs-stepper-label">Requirements</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#shiping-part">
                      <button type="button" class="step-trigger" role="tab" aria-controls="information-part" aria-selected="false" disabled="disabled">
                        <span class="bs-stepper-circle">4</span>
                        <span class="bs-stepper-label">Outcomes</span>
                      </button>
                    </div>
                  </div>

                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#pricing">
                      <button type="button" class="step-trigger" role="tab" aria-controls="information-part" aria-selected="false" disabled="disabled">
                        <span class="bs-stepper-circle">5</span>
                        <span class="bs-stepper-label">Pricing</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#media">
                      <button type="button" class="step-trigger" role="tab" aria-controls="information-part" aria-selected="false" disabled="disabled">
                        <span class="bs-stepper-circle">6</span>
                        <span class="bs-stepper-label">Media</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#check_out">
                      <button type="button" class="step-trigger" role="tab" aria-controls="information-part" aria-selected="false" disabled="disabled">
                        <span class="bs-stepper-circle">7</span>
                        <span class="bs-stepper-label">Check Out Page</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#seo">
                      <button type="button" class="step-trigger" role="tab" aria-controls="information-part" aria-selected="false" disabled="disabled">
                        <span class="bs-stepper-circle">8</span>
                        <span class="bs-stepper-label">SEO</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#trainer_profile">
                      <button type="button" class="step-trigger" role="tab" aria-controls="information-part" aria-selected="false" disabled="disabled">
                        <span class="bs-stepper-circle">9</span>
                        <span class="bs-stepper-label">Trainer Profile</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#project">
                      <button type="button" class="step-trigger" role="tab" aria-controls="information-part" aria-selected="false" disabled="disabled">
                        <span class="bs-stepper-circle">10</span>
                        <span class="bs-stepper-label">Certi & Assig & Project</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#review_video">
                      <button type="button" class="step-trigger" role="tab" aria-controls="information-part" aria-selected="false" disabled="disabled">
                        <span class="bs-stepper-circle">11</span>
                        <span class="bs-stepper-label">Review video</span>
                      </button>
                    </div>
                  </div>
                  <div class="col-6 col-md-3">
                    <div class="line"></div>
                    <div class="step" data-target="#finish">
                      <button type="button" class="step-trigger" role="tab" aria-controls="information-part" aria-selected="false" disabled="disabled">
                        <span class="bs-stepper-circle">12</span>
                        <span class="bs-stepper-label">Finish</span>
                      </button>
                    </div>
                  </div>
                </div>
              </div>
              <div class="bs-stepper-content">
                <div id="curriculum" class="content active dstepper-block" role="tabpanel" aria-labelledby="curriculum-part-trigger">
                  <button type="button" class="btn btn-primary mb-3" onclick="stepper.next()">Next</button>
                  <div class="row justify-content-center video_course">
                    <div class="col-md-12">
                      <?php
                      $this->load->view('admin/course/curriculum', ['course_id' => $course->id]);
                      ?>
                    </div>
                  </div>
                </div>
              
                <div id="basic-part" class="content" role="tabpanel" aria-labelledby="logins-part-trigger">
                  <div class="row justify-content-center">
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="course_title"><?php echo get_phrase('course_title'); ?> <span class="required">*</span> </label>
                        <div class="col-md-10">
                          <input type="text" class="form-control" id="course_title" name="title" placeholder="<?php echo get_phrase('enter_course_title'); ?>" required value="<?php echo $course->title; ?>">
                        </div>
                      </div>
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="course_short_name"><?php echo get_phrase('course_short_title'); ?> <span class="required">*</span> </label>
                        <div class="col-md-10">
                          <input type="text" class="form-control" id="course_short_name" name="course_short_name" placeholder="<?php echo get_phrase('enter_course_short_title'); ?>" required="" value="<?php echo $course->course_short_name; ?>">
                        </div>
                      </div>
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="short_description"><?php echo get_phrase('short_description'); ?></label>
                        <div class="col-md-10">
                          <textarea name="short_description" id="short_description" class="form-control"><?php echo $course->short_description; ?></textarea>
                        </div>
                      </div>
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="description"><?php echo get_phrase('description'); ?></label>
                        <div class="col-md-10">
                          <textarea name="description" id="description" class="form-control text-editor"><?php echo $course->description; ?></textarea>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="form-group row mb-3">
                    <label class="col-md-2 col-form-label" for="level"><?php echo get_phrase('level'); ?></label>
                    <div class="col-md-10">
                      <select class="form-control " data-toggle="" name="level" id="level">
                        <option <?php if ($course->level == 'beginner') {
                                  echo 'selected';
                                } ?> value="beginner"><?php echo get_phrase('beginner'); ?></option>
                        <option <?php if ($course->level == 'advanced') {
                                  echo 'selected';
                                } ?> value="advanced"><?php echo get_phrase('advanced'); ?></option>
                        <option <?php if ($course->level == 'intermediate') {
                                  echo 'selected';
                                } ?> value="intermediate"><?php echo get_phrase('intermediate'); ?></option>
                      </select>
                    </div>
                  </div>
                  <div class="form-group row mb-3">
                    <label class="col-md-2 col-form-label" for="level"><?php echo get_phrase('is_this_flag_course'); ?></label>
                    <div class="col-md-10">
                      <select class="form-control " data-toggle="" name="flagship_course">
                        <option <?php if ($course->flagship_course == 0) {
                                  echo 'selected';
                                } ?> value="0"><?php echo get_phrase('no'); ?></option>
                        <option <?php if ($course->flagship_course == 1) {
                                  echo 'selected';
                                } ?> value="1"><?php echo get_phrase('Yes'); ?></option>
                      </select>
                    </div>
                  </div>
                  <div class="form-group row mb-3">
                    <label class="col-md-2 col-form-label" for="description"><?php echo get_phrase('upload_syllabus_pdf'); ?> </label>
                    <div class="col-md-10">
                      <input name="syllabus" class="form-control" type="file">
                      <span style="font-size:12px">(if Yout leave it black 'Download Syllabus' button hide form course details page)</span>
                      <?php if ($course->syllabus) : ?>
                        <br />
                        <span><a target="_blank" href="<?php echo base_url() ?><?php echo $course->syllabus ?>">Download Syllabus</a></span>
                      <?php endif; ?>
                    </div>
                  </div>
                  <div class="form-group row mb-3">
                    <label class="col-md-2 col-form-label" for="description"><?php echo get_phrase('upload_Curriculum_pdf'); ?> </label>
                    <div class="col-md-10">
                      <input name="curriculum_pdf" class="form-control" type="file">
                      <span style="font-size:12px">(if Yout leave it black 'Download' button hide in course details page)</span>
                      <?php if ($course->curriculum_pdf) : ?>
                        <br />
                        <span><a target="_blank" href="<?php echo base_url() ?><?php echo $course->curriculum_pdf ?>">Download</a></span>
                      <?php endif; ?>



                    </div>
                  </div>
                  <div class="form-group row mb-3">
                    <div class="offset-md-2 col-md-10">
                      <div class="custom-control custom-checkbox">
                        <input type="checkbox" class="custom-control-input" name="is_top_course" <?php if ($course->is_top_course == 1) {
                                                                                                    echo 'checked';
                                                                                                  } ?> id="is_top_course" value="1">
                        <label class="custom-control-label" for="is_top_course"><?php echo get_phrase('check_if_this_course_is_top_course'); ?></label>
                      </div>
                    </div>
                  </div>
                  <div class="form-group row mb-3">
                    <label class="col-md-2 col-form-label" for="product_title"><?php echo get_phrase('Special FB Group'); ?> </label>
                    <div class="col-md-10">
                      <input type="text" class="form-control" name="special_fb_group" placeholder="Enter Special Facebook Group Link" value="<?php echo $course->special_fb_group ?>">
                    </div>
                  </div>
                  <div class="form-group row mb-3">
                    <label class="col-md-2 col-form-label" for="product_title"><?php echo get_phrase('Special Whatsapp Group'); ?> </label>
                    <div class="col-md-10">
                      <input type="number" class="form-control" name="special_whatsapp_group" placeholder="Enter Special Whatsapp Group Number" value="<?php echo $course->special_whatsapp_group ?>">
                    </div>
                  </div>
                  <div class="form-group row mb-3">
                    <label class="col-md-2 col-form-label" for="product_title">Book Demo Video</label>
                    <div class="col-md-10">
                      <input type="text" class="form-control" name="cook_demo_video" placeholder="Enter Book Demo Video URL" value="<?php echo $course->cook_demo_video ?>">
                    </div>
                  </div>
                  <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                  <button type="button" class="btn btn-primary" onclick="stepper.next()">Next</button>
                  <button type="submit" class="btn btn-success pull-right">Save</button>
                </div> <!-- end col -->


                <div id="additional-part" class="content" role="tabpanel" aria-labelledby="information-part-trigger">
                  <div class="row justify-content-center">
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="requirements"><?php echo get_phrase('requirements'); ?></label>
                        <div class="col-md-10">
                          <div id="requirement_area">
                            <?php if (count(json_decode($course->requirements)) > 0) : ?>
                              <?php
                              $counter = 0;
                              foreach (json_decode($course->requirements) as $requirement) : ?>
                                <?php if ($counter == 0) :
                                  $counter++; ?>
                                  <div class="d-flex mt-2">
                                    <div class="flex-grow-1 px-3">
                                      <div class="form-group">
                                        <input type="text" class="form-control" name="requirements[]" id="requirements" placeholder="<?php echo get_phrase('provide_requirements'); ?>" value="<?php echo $requirement; ?>">
                                      </div>
                                    </div>
                                    <div class="">
                                      <button type="button" class="btn btn-success btn-sm" style="" name="button" onclick="appendRequirement()"> <i class="fa fa-plus"></i> </button>
                                    </div>
                                  </div>
                                <?php else : ?>
                                  <div class="d-flex mt-2">
                                    <div class="flex-grow-1 px-3">
                                      <div class="form-group">
                                        <input type="text" class="form-control" name="requirements[]" id="requirements" placeholder="<?php echo get_phrase('provide_requirements'); ?>" value="<?php echo $requirement; ?>">
                                      </div>
                                    </div>
                                    <div class="">
                                      <button type="button" class="btn btn-danger btn-sm" style="margin-top: 0px;" name="button" onclick="removeRequirement(this)"> <i class="fa fa-minus"></i> </button>
                                    </div>
                                  </div>
                                <?php endif; ?>
                              <?php endforeach; ?>
                            <?php else : ?>
                              <div class="d-flex mt-2">
                                <div class="flex-grow-1 px-3">
                                  <div class="form-group">
                                    <input type="text" class="form-control" name="requirements[]" id="requirements" placeholder="<?php echo get_phrase('provide_requirements'); ?>">
                                  </div>
                                </div>
                                <div class="">
                                  <button type="button" class="btn btn-success btn-sm" style="" name="button" onclick="appendRequirement()"> <i class="fa fa-plus"></i> </button>
                                </div>
                              </div>
                            <?php endif; ?>
                          </div>
                          <div id="blank_requirement_field">
                            <div class="d-flex mt-2">
                              <div class="flex-grow-1 px-3">
                                <div class="form-group">
                                  <input type="text" class="form-control" name="requirements[]" id="requirements" placeholder="<?php echo get_phrase('provide_requirements'); ?>">
                                </div>
                              </div>
                              <div class="">
                                <button type="button" class="btn btn-danger btn-sm" style="margin-top: 0px;" name="button" onclick="removeRequirement(this)"> <i class="fa fa-minus"></i> </button>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                  <button type="button" class="btn btn-primary" onclick="stepper.next()">Next</button>
                  <button type="submit" name="submitForm" class="btn btn-success pull-right">Save</button>
                </div>


                <div id="shiping-part" class="content" role="tabpanel" aria-labelledby="information-part-trigger">
                  <div class="row justify-content-center">
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="outcomes"><?php echo get_phrase('outcomes'); ?></label>
                        <div class="col-md-10">
                          <div id="outcomes_area">
                            <?php if (count(json_decode($course->outcomes)) > 0) : ?>
                              <?php
                              $counter = 0;
                              foreach (json_decode($course->outcomes) as $outcome) : ?>
                                <?php if ($counter == 0) :
                                  $counter++; ?>
                                  <div class="d-flex mt-2">
                                    <div class="flex-grow-1 px-3">
                                      <div class="form-group">
                                        <input type="text" class="form-control" name="outcomes[]" placeholder="<?php echo get_phrase('provide_outcomes'); ?>" value="<?php echo $outcome; ?>">
                                      </div>
                                    </div>
                                    <div class="">
                                      <button type="button" class="btn btn-success btn-sm" name="button" onclick="appendOutcome()"> <i class="fa fa-plus"></i> </button>
                                    </div>
                                  </div>
                                <?php else : ?>
                                  <div class="d-flex mt-2">
                                    <div class="flex-grow-1 px-3">
                                      <div class="form-group">
                                        <input type="text" class="form-control" name="outcomes[]" placeholder="<?php echo get_phrase('provide_outcomes'); ?>" value="<?php echo $outcome; ?>">
                                      </div>
                                    </div>
                                    <div class="">
                                      <button type="button" class="btn btn-danger btn-sm" style="margin-top: 0px;" name="button" onclick="removeOutcome(this)"> <i class="fa fa-minus"></i> </button>
                                    </div>
                                  </div>
                                <?php endif; ?>
                              <?php endforeach; ?>
                            <?php else : ?>
                              <div class="d-flex mt-2">
                                <div class="flex-grow-1 px-3">
                                  <div class="form-group">
                                    <input type="text" class="form-control" name="outcomes[]" placeholder="<?php echo get_phrase('provide_outcomes'); ?>">
                                  </div>
                                </div>
                                <div class="">
                                  <button type="button" class="btn btn-success btn-sm" name="button" onclick="appendOutcome()"> <i class="fa fa-plus"></i> </button>
                                </div>
                              </div>
                            <?php endif; ?>
                            <div id="blank_outcome_field">
                              <div class="d-flex mt-2">
                                <div class="flex-grow-1 px-3">
                                  <div class="form-group">
                                    <input type="text" class="form-control" name="outcomes[]" id="outcomes" placeholder="<?php echo get_phrase('provide_outcomes'); ?>">
                                  </div>
                                </div>
                                <div class="">
                                  <button type="button" class="btn btn-danger btn-sm" style="margin-top: 0px;" name="button" onclick="removeOutcome(this)"> <i class="fa fa-minus"></i> </button>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>

                  <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                  <button type="button" class="btn btn-primary" onclick="stepper.next()">Next</button>
                  <button type="submit" name="submitForm" class="btn btn-success pull-right">Save</button>
                </div>


                <div id="pricing" class="content" role="tabpanel" aria-labelledby="information-part-trigger">
                  <div class="row justify-content-center">
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <div class="offset-md-2 col-md-10">
                          <div class="custom-control custom-checkbox">
                            <input type="checkbox" class="custom-control-input" name="is_free_course" id="is_free_course" value="1" onclick="togglePriceFields(this.id)" <?php if ($course->is_free_course == 1) {
                                                                                                                                                                            echo 'checked';
                                                                                                                                                                          } ?>>
                            <label class="custom-control-label" for="is_free_course"><?php echo get_phrase('check_if_this_is_a_free_course'); ?></label>
                          </div>
                        </div>
                      </div>

                      <div class="paid-course-stuffs">
                        <div class="form-group row mb-3">
                          <label class="col-md-2 col-form-label" for="price"><?php echo get_phrase('course_duration') ?></label>
                          <div class="col-md-10">
                            <input type="text" class="form-control" name="duration" placeholder="<?php echo get_phrase('enter_course_duration'); ?>" value="<?php echo $course->duration; ?>">
                          </div>
                        </div>
                        <div class="form-group row mb-3">
                          <label class="col-md-2 col-form-label" for="price"><?php echo get_phrase('course_time_daily_or_monthly') ?></label>
                          <div class="col-md-10">
                            <select type="text" class="form-control" name="couse_time">
                              <option <?php if ($course->couse_time == 1) {
                                        echo 'selected';
                                      } ?> value="1">Daily</option>
                              <option <?php if ($course->couse_time == 2) {
                                        echo 'selected';
                                      } ?> value="2">Monthly</option>
                            </select>
                          </div>
                        </div>
                        <div class="form-group row mb-3">
                          <label class="col-md-2 col-form-label" for="price"><?php echo get_phrase('course_time') ?></label>
                          <div class="col-md-10">
                            <input type="text" class="form-control" name="time" placeholder="<?php echo get_phrase('enter_course_time_ex._2__hrs'); ?>" value="<?php echo $course->time; ?>">
                          </div>
                        </div>
                        <div class="form-group row mb-3">
                          <label class="col-md-2 col-form-label" for="price"><?php echo get_phrase('course_price') ?></label>
                          <div class="col-md-10">
                            <input type="number" class="form-control" id="price" name="price" placeholder="<?php echo get_phrase('in_class_training_course_price'); ?>" min="0" value="<?php echo $course->price; ?>">
                          </div>
                        </div>

                        <div class="form-group row mb-3 ">
                          <div class="offset-md-2 col-md-10">
                            <div class="custom-control custom-checkbox">
                              <input type="checkbox" class="custom-control-input" name="discount_flag" id="discount_flag" value="1" <?php if ($course->discount_flag == 1) {
                                                                                                                                      echo 'checked';
                                                                                                                                    } ?>>
                              <label class="custom-control-label" for="discount_flag"><?php echo get_phrase('check_if_this_in_class_training_course_has_discount'); ?></label>
                            </div>
                          </div>
                        </div>

                        <div class="form-group row mb-3 ">
                          <label class="col-md-2 col-form-label" for="discounted_price"><?php echo get_phrase('discounted_price') ?></label>
                          <div class="col-md-10">
                            <input type="number" class="form-control" name="discounted_price" id="discounted_price" onkeyup="calculateDiscountPercentage(this.value)" min="0" value="<?php echo $course->discounted_price; ?>">

                          </div>
                        </div>

                        <div class="form-group row mb-3">
                          <label class="col-md-2 col-form-label" for="price"><?php echo get_phrase('online_training_course_price') ?></label>
                          <div class="col-md-10">
                            <input type="number" class="form-control" id="price_1" name="online_training_price" placeholder="<?php echo get_phrase('enter_course_course_price'); ?>" min="0" value="<?php echo $course->online_training_price; ?>">
                          </div>
                        </div>

                        <div class="form-group row mb-3 ">
                          <div class="offset-md-2 col-md-10">
                            <div class="custom-control custom-checkbox">
                              <input type="checkbox" class="custom-control-input" name="online_training_has_discount" id="discount_flag_1" value="1" <?php if ($course->online_training_has_discount == 1) {
                                                                                                                                                        echo 'checked';
                                                                                                                                                      } ?>>
                              <label class="custom-control-label" for="discount_flag_1"><?php echo get_phrase('check_if_this_online_training_course_has_discount'); ?></label>
                            </div>
                          </div>
                        </div>

                        <div class="form-group row mb-3 ">
                          <label class="col-md-2 col-form-label" for="discounted_price_1"><?php echo get_phrase('discounted_price') ?></label>
                          <div class="col-md-10">
                            <input type="number" class="form-control" name="online_training_discount" id="discounted_price_1" onkeyup="calculateDiscountPercentage_1(this.value)" min="0" value="<?php echo $course->online_training_discount; ?>">

                          </div>
                        </div>
                        <div class="form-group row mb-3">
                          <label class="col-md-2 col-form-label" for="price"><?php echo get_phrase('course Advance Payment') ?></label>
                          <div class="col-md-10">
                            <input type="number" class="form-control" name="course_adv_payment" placeholder="<?php echo get_phrase('enter_course_Advance Payment'); ?>" value="<?php echo $course->course_adv_payment; ?>">
                          </div>
                        </div>

                      </div>
                    </div> <!-- end col -->
                  </div> <!-- end row -->

                  <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                  <button type="button" class="btn btn-primary" onclick="stepper.next()">Next</button>
                  <button type="submit" name="submitForm" class="btn btn-success pull-right">Save</button>
                </div>

                <div id="media" class="content" role="tabpanel" aria-labelledby="information-part-trigger">
                  <div class="row justify-content-center">
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="course_overview_provider"><?php echo get_phrase('course_overview_provider'); ?></label>
                        <div class="col-md-10">
                          <select class="form-control " data-toggle="" name="course_overview_provider" id="course_overview_provider">
                            <option value="youtube" <?php if ($course->course_overview_provider == 'youtube') echo 'selected'; ?>><?php echo get_phrase('youtube'); ?></option>
                            <option value="vimeo" <?php if ($course->course_overview_provider == 'vimeo') echo 'selected'; ?>><?php echo get_phrase('vimeo'); ?></option>
                            <option <?php if ($course->course_overview_provider == 'html5') echo 'selected'; ?> value="html5"><?php echo get_phrase('HTML5'); ?></option>
                          </select>
                        </div>
                      </div>
                    </div> <!-- end col -->
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="course_overview_url"><?php echo get_phrase('course_overview_url'); ?></label>
                        <div class="col-md-10">
                          <input type="text" class="form-control" name="course_overview_url" id="course_overview_url" placeholder="E.g: https://www.youtube.com/watch?v=oBtf8Yglw2w" value="<?php echo $course->video_url ?>">
                        </div>
                      </div>
                    </div> <!-- end col -->
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="course_overview_url"><?php echo get_phrase('course_image'); ?></label>
                        <div class="col-md-10">
                          <input type="file" class="form-control" name="image">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="course_overview_url"><?php echo get_phrase('course_image_preview'); ?></label>
                        <div class="col-md-10">
                          <img src="<?php echo base_url() ?><?php echo $course->image ?>" width="150px">
                        </div>
                      </div>
                    </div><!-- end col -->
                    <!-- this portion will be generated theme wise from the theme-config.json file Starts-->
                    <!-- this portion will be generated theme wise from the theme-config.json file Ends-->
                  </div> <!-- end row -->
                  <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                  <button type="button" class="btn btn-primary" onclick="stepper.next()">Next</button>
                  <button type="submit" name="submitForm" class="btn btn-success pull-right">Save</button>
                </div>

                <div id="check_out" class="content" role="tabpanel" aria-labelledby="information-part-trigger">
                  <div class="row justify-content-center">
                    <!-- end col -->
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label"><?php echo get_phrase('Checkout Page Heading'); ?> <span class="required">*</span></label>
                        <div class="col-md-10">
                          <input name="checkout_heading" class="form-control" placeholder="Enter Checkout Page Heading" required value="<?php echo $course->checkout_heading ?>">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label"><?php echo get_phrase('Checkout Page Sub-Heading'); ?> <span class="required">*</span></label>
                        <div class="col-md-10">
                          <input name="checkout_sub_heading" class="form-control" placeholder="Enter Checkout Page Sub-Heading" required value="<?php echo $course->checkout_sub_heading ?>">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label"><?php echo get_phrase('Checkout Page Video Or image'); ?> <span class="required">*</span></label>
                        <div class="col-md-10">
                          <select onchange="checkout_video_or_image_status(this.value)" name="checkout_video_or_image" class="form-control" required>
                            <option <?php if ($course->checkout_sub_heading == 1) {
                                      echo 'selected';
                                    } ?> value="1">Video</option>
                            <option <?php if ($course->checkout_sub_heading == 2) {
                                      echo 'selected';
                                    } ?> value="2">Image</option>
                          </select>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12" id="iframe">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label"><?php echo get_phrase('Checkout Page Video'); ?> <span class="required">*</span></label>
                        <div class="col-md-10">
                          <textarea name="checkout_iframe" id="checkout_iframe" class="form-control" placeholder="Enter Checkout Page Youtube Link" required><?php echo $course->checkout_iframe ?></textarea>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12" id="image">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label"><?php echo get_phrase('Checkout Page Image'); ?> <span class="required">*</span></label>
                        <div class="col-md-10">
                          <input type="file" name="checkout_image" id="checkout_image" class="form-control">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label"><?php echo get_phrase('Checkout Page Description'); ?></label>
                        <div class="col-md-10">
                          <textarea name="checkout_description" class="form-control"><?php echo $course->checkout_description ?></textarea>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label"><?php echo get_phrase('Checkout Page Money back Sub-Heading'); ?> <span class="required">*</span></label>
                        <div class="col-md-10">
                          <input name="checkout_money_sub_heading" class="form-control" placeholder="Enter Checkout Page Money back Sub-Heading" required value="<?php echo $course->checkout_money_sub_heading ?>">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label"><?php echo get_phrase('Checkout Page Money back Heading'); ?> <span class="required">*</span></label>
                        <div class="col-md-10">
                          <input name="checkout_money_heading" class="form-control" placeholder="Enter Checkout Page Money back Heading" required value="<?php echo $course->checkout_money_heading ?>">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label"><?php echo get_phrase('Checkout Page Money back Description'); ?> <span class="required">*</span></label>
                        <div class="col-md-10">
                          <textarea name="checkout_money_description" class="form-control" placeholder="Enter Checkout Page Money back Description" required><?php echo $course->checkout_money_description ?></textarea>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label"><?php echo get_phrase('Checkout Page Money Back Image'); ?> <span class="required">*</span></label>
                        <div class="col-md-10">
                          <input type="file" name="checkout_money_image" class="form-control">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label"><?php echo get_phrase('Checkout Page head Code'); ?> <span class="required">*</span></label>
                        <div class="col-md-10">
                          <textarea placeholder="Enter Head Code" name="checkout_head_code" class="form-control"><?php echo $course->checkout_head_code ?></textarea>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label"><?php echo get_phrase('Checkout Page Plans Title'); ?> <span class="required">*</span></label>
                        <div class="col-md-10">
                          <input placeholder="Enter Plans Title" name="checkout_plan_title" class="form-control" value="<?php echo $course->checkout_plan_title ?>">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label"><?php echo get_phrase('Preview Checkout Page Money Back Image'); ?> </label>
                        <div class="col-md-10">
                          <img src="<?php echo base_url() ?><?php echo $course->checkout_money_image ?>" alt="" width="70px">
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="outcomes"><?php echo get_phrase('Plans'); ?></label>
                        <div class="col-md-10">
                          <div id="plans_area">
                            <?php if (count(json_decode($course->checkout_plans_title)) > 0) : ?>
                              <?php
                              $sst = 0;
                              foreach (json_decode($course->checkout_plans_title) as $oto => $plans_title) :
                              ?>
                                <?php if ($sst == 0) :
                                  $sst++; ?>
                                  <div class="d-flex mt-2">
                                    <div class="flex-grow-1 px-3">
                                      <div class="form-group">
                                        <input type="text" class="form-control" name="checkout_plans_title[]" placeholder="<?php echo get_phrase('Plans Title'); ?>" value="<?php echo  $plans_title ?>">
                                      </div>
                                      <div class="form-group">
                                        <textarea type="text" class="form-control" name="checkout_plans_description[]" placeholder="<?php echo get_phrase('Plans Description'); ?>"><?php echo json_decode($course->checkout_plans_description)[$oto]; ?></textarea>
                                      </div>
                                    </div>
                                    <div class="">
                                      <button type="button" class="btn btn-success btn-sm" name="button" onclick="appendPlans()"> <i class="fa fa-plus"></i> </button>
                                    </div>
                                  </div>
                                <?php else : ?>
                                  <div class="d-flex mt-2">
                                    <div class="flex-grow-1 px-3">
                                      <div class="form-group">
                                        <input type="text" class="form-control" name="checkout_plans_title[]" placeholder="<?php echo get_phrase('Plans Title'); ?>" value="<?php echo  $plans_title ?>">
                                      </div>
                                      <div class="form-group">
                                        <textarea type="text" class="form-control" name="checkout_plans_description[]" placeholder="<?php echo get_phrase('Plans Description'); ?>"><?php echo json_decode($course->checkout_plans_description)[$oto]; ?></textarea>
                                      </div>
                                    </div>
                                    <div class="">
                                      <button type="button" class="btn btn-danger btn-sm" style="margin-top: 0px;" name="button" onclick="removePlans(this)"> <i class="fa fa-minus"></i> </button>
                                    </div>
                                  </div>
                                <?php endif; ?>
                              <?php endforeach; ?>
                            <?php else : ?>
                              <div class="d-flex mt-2">
                                <div class="flex-grow-1 px-3">
                                  <div class="form-group">
                                    <input type="text" class="form-control" name="checkout_plans_title[]" placeholder="<?php echo get_phrase('Plans Title'); ?>">
                                  </div>
                                  <div class="form-group">
                                    <textarea type="text" class="form-control" name="checkout_plans_description[]" placeholder="<?php echo get_phrase('Plans Description'); ?>"></textarea>
                                  </div>
                                </div>
                                <div class="">
                                  <button type="button" class="btn btn-success btn-sm" name="button" onclick="appendPlans()"> <i class="fa fa-plus"></i> </button>
                                </div>
                              </div>
                            <?php endif; ?>
                          </div>
                        </div>
                      </div>
                    </div>


                  </div>
                  <!-- end row -->
                  <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                  <button type="button" class="btn btn-primary" onclick="stepper.next()">Next</button>
                  <button type="submit" name="submitForm" class="btn btn-success pull-right">Save</button>
                </div>


                <div id="seo" class="content" role="tabpanel" aria-labelledby="information-part-trigger">
                  <div class="row justify-content-center">
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="website_keywords"><?php echo get_phrase('meta_title'); ?></label>
                        <div class="col-md-10">
                          <input type="text" class="form-control" name="meta_title" placeholder="<?php echo get_phrase('Enter Meta Title'); ?>" value="<?php echo $course->meta_title ?>" />
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="website_keywords"><?php echo get_phrase('meta_keywords'); ?></label>
                        <div class="col-md-10">
                          <input type="text" class="form-control bootstrap-tag-input" id="meta_keywords" name="meta_keywords" data-role="tagsinput" style="width: 100%;" placeholder="<?php echo get_phrase('write_a_keyword_and_then_press_enter_button'); ?>" value="<?php echo $course->meta_keywords ?>" />
                        </div>
                      </div>
                    </div> <!-- end col -->
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="meta_description"><?php echo get_phrase('meta_description'); ?></label>
                        <div class="col-md-10">
                          <textarea name="meta_description" class="form-control"><?php echo $course->meta_description ?></textarea>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="meta_description"><?php echo get_phrase('schema'); ?></label>
                        <div class="col-md-10">
                          <textarea name="schema" class="form-control"><?php echo $course->schema ?></textarea>
                        </div>
                      </div>
                    </div>
                    <!-- end col -->
                  </div> <!-- end row -->
                  <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                  <button type="button" class="btn btn-primary" onclick="stepper.next()">Next</button>
                  <button type="submit" name="submitForm" class="btn btn-success pull-right">Save</button>
                </div>

                <div id="trainer_profile" class="content" role="tabpanel" aria-labelledby="information-part-trigger">
                  <div class="row justify-content-center">
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="website_keywords"><?php echo get_phrase('Trainer Profile Heading'); ?></label>
                        <div class="col-md-10">
                          <input type="text" class="form-control bootstrap-tag-input" id="meta_keywords" name="trainner_profile_heading" data-role="tagsinput" style="width: 100%;" placeholder="<?php echo get_phrase('Enter Trainer Profile Heading'); ?>" value="<?php echo $course->trainner_profile_heading ?>" />
                        </div>
                      </div>
                    </div> <!-- end col -->
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="meta_description"><?php echo get_phrase('Profile Description'); ?></label>
                        <div class="col-md-10">
                          <textarea name="trainner_profile_content" class="form-control"><?php echo $course->trainner_profile_content ?></textarea>
                        </div>
                      </div>
                    </div> <!-- end col -->
                  </div> <!-- end row -->
                  <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                  <button type="button" class="btn btn-primary" onclick="stepper.next()">Next</button>
                  <button type="submit" name="submitForm" class="btn btn-success pull-right">Save</button>
                </div>

                <div id="project" class="content" role="tabpanel" aria-labelledby="information-part-trigger">
                  <div class="row justify-content-center">
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="meta_description"><?php echo get_phrase('Certification'); ?></label>
                        <div class="col-md-10">
                          <textarea name="certification" class="form-control" id="editor"><?php echo $course->certification ?></textarea>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="meta_description"><?php echo get_phrase('Assignments'); ?></label>
                        <div class="col-md-10">
                          <textarea name="assignments" class="form-control ckeditor" id="editor_2"><?php echo $course->assignments ?></textarea>
                        </div>
                      </div>
                    </div>
                    <div class="col-xl-12">
                      <div class="form-group row mb-3">
                        <label class="col-md-2 col-form-label" for="meta_description"><?php echo get_phrase('Project'); ?></label>
                        <div class="col-md-10">
                          <textarea name="project" class="form-control ckeditor" id="editor_3"><?php echo $course->project ?></textarea>
                        </div>
                      </div>
                    </div>
                  </div>
                  <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                  <button type="button" class="btn btn-primary" onclick="stepper.next()">Next</button>
                  <button type="submit" name="submitForm" class="btn btn-success pull-right">Save</button>
                </div>

                <div id="review_video" class="content" role="tabpanel" aria-labelledby="information-part-trigger">
                  <div class="row justify-content-center">
                    <div class="col-xl-12">
                      <div id="review_area">
                        <?php if (count(json_decode($course->review_video)) > 0) : ?>
                          <?php
                          $counter = 0;
                          foreach (json_decode($course->review_video) as $review_video) : ?>
                            <?php if ($counter == 0) :
                              $counter++; ?>
                              <div class="d-flex mt-2">
                                <div class="flex-grow-1 px-3">
                                  <div class="form-group">
                                    <input type="text" class="form-control" name="review_video[]" placeholder="<?php echo get_phrase('Enter Youtube Video URL'); ?>" value="<?php echo $review_video; ?>">
                                  </div>
                                </div>
                                <div class="">
                                  <button type="button" class="btn btn-success btn-sm" style="" name="button" onclick="removereview()"> <i class="fa fa-plus"></i> </button>
                                </div>
                              </div>
                            <?php else : ?>
                              <div class="d-flex mt-2">
                                <div class="flex-grow-1 px-3">
                                  <div class="form-group">
                                    <input type="text" class="form-control" name="review_video[]" placeholder="<?php echo get_phrase('Enter Youtube Video URL'); ?>" value="<?php echo $review_video; ?>">
                                  </div>
                                </div>
                                <div class="">
                                  <button type="button" class="btn btn-danger btn-sm" style="margin-top: 0px;" name="button" onclick="removereview(this)"> <i class="fa fa-minus"></i> </button>
                                </div>
                              </div>
                            <?php endif; ?>
                          <?php endforeach; ?>
                        <?php else : ?>
                          <div class="d-flex mt-2">
                            <div class="flex-grow-1 px-3">
                              <div class="form-group">
                                <input type="text" class="form-control" name="review_video[]" placeholder="<?php echo get_phrase('Enter Youtube Video URL'); ?>">
                              </div>
                            </div>
                            <div class="">
                              <button type="button" class="btn btn-success btn-sm" style="" name="button" onclick="appendreview()"> <i class="fa fa-plus"></i> </button>
                            </div>
                          </div>
                        <?php endif; ?>
                      </div>

                    </div>
                  </div>
                  <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                  <button type="button" class="btn btn-primary" onclick="stepper.next()">Next</button>
                  <button type="submit" name="submitForm" class="btn btn-success pull-right">Save</button>
                </div>

                <div id="finish" class="content" role="tabpanel" aria-labelledby="information-part-trigger">
                  <div class="row">
                    <div class="col-12">
                      <div class="text-center">
                        <h2 class="mt-0"><i class="mdi mdi-check-all"></i></h2>
                        <h3 class="mt-0"><?php echo get_phrase("thank_you"); ?> !</h3>

                        <p class="w-75 mb-2 mx-auto"><?php echo get_phrase('you_are_just_one_click_away'); ?></p>

                        <div class="mb-3 mt-3">
                          <button type="submit" name="submitForm" class="btn btn-primary text-center"><?php echo get_phrase('submit'); ?></button>
                        </div>
                      </div>
                    </div> <!-- end col -->
                  </div> <!-- end row -->
                  <input type="hidden" name="added_by" value="<?php echo user()->id ?>">
                  <button type="button" class="btn btn-primary" onclick="stepper.previous()">Previous</button>
                </div>
              </div>
            </div>
            <?php echo form_close(); ?>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>

<div id="blank_review_video">
  <div class="d-flex mt-2">
    <div class="flex-grow-1 px-3">
      <div class="form-group">
        <input type="text" class="form-control" name="review_video[]" placeholder="<?php echo get_phrase('Enter Youtube Video URL'); ?>">
      </div>
    </div>
    <div class="">
      <button type="button" class="btn btn-danger btn-sm" style="margin-top: 0px;" name="button" onclick="removereview(this)"> <i class="fa fa-minus"></i> </button>
    </div>
  </div>
</div>
<div id="blank_plans_field">
  <div class="d-flex mt-2">
    <div class="flex-grow-1 px-3">
      <div class="form-group">
        <input type="text" class="form-control" name="checkout_plans_title[]" placeholder="<?php echo get_phrase('Plans Title'); ?>">
      </div>
      <div class="form-group">
        <textarea type="text" class="form-control" name="checkout_plans_description[]" placeholder="<?php echo get_phrase('Plans Description'); ?>"></textarea>
      </div>
    </div>
    <div class="">
      <button type="button" class="btn btn-danger btn-sm" style="margin-top: 0px;" name="button" onclick="removePlans(this)"> <i class="fa fa-minus"></i> </button>
    </div>
  </div>
</div>
<script src="<?php echo admin_css() ?>plugins/bs-stepper/js/bs-stepper.min.js"></script>
<script type="text/javascript">
  // BS-Stepper Init
  document.addEventListener('DOMContentLoaded', function() {
    window.stepper = new Stepper(document.querySelector('.bs-stepper'))
  });
</script>
<script type="text/javascript">
  var blank_outcome = jQuery('#blank_outcome_field').html();
  var blank_requirement = jQuery('#blank_requirement_field').html();
  var blank_plans_field = jQuery('#blank_plans_field').html();
  var blank_review_video = jQuery('#blank_review_video').html();
  jQuery(document).ready(function() {
    jQuery('#blank_outcome_field').hide();
    jQuery('#blank_requirement_field').hide();
    calculateDiscountPercentage($('#discounted_price').val());
    jQuery('#blank_plans_field').hide();
    jQuery('#blank_review_video').hide();
  });

  function appendPlans() {
    jQuery('#plans_area').append(blank_plans_field);
  }

  function removePlans(outcomeElem) {
    jQuery(outcomeElem).parent().parent().remove();
  }

  function appendOutcome() {
    jQuery('#outcomes_area').append(blank_outcome);
  }

  function removeOutcome(outcomeElem) {
    jQuery(outcomeElem).parent().parent().remove();
  }

  function appendreview() {
    jQuery('#review_area').append(blank_review_video);
  }

  function removereview(outcomeElem) {
    jQuery(outcomeElem).parent().parent().remove();
  }

  function appendRequirement() {
    jQuery('#requirement_area').append(blank_requirement);
  }

  function removeRequirement(requirementElem) {
    jQuery(requirementElem).parent().parent().remove();
  }

  function priceChecked(elem) {
    if (jQuery('#discountCheckbox').is(':checked')) {

      jQuery('#discountCheckbox').prop("checked", false);
    } else {

      jQuery('#discountCheckbox').prop("checked", true);
    }
  }

  function topCourseChecked(elem) {
    if (jQuery('#isTopCourseCheckbox').is(':checked')) {

      jQuery('#isTopCourseCheckbox').prop("checked", false);
    } else {

      jQuery('#isTopCourseCheckbox').prop("checked", true);
    }
  }

  function isFreeCourseChecked(elem) {

    if (jQuery('#' + elem.id).is(':checked')) {
      $('#price').prop('required', false);
    } else {
      $('#price').prop('required', true);
    }
  }

  function calculateDiscountPercentage(discounted_price) {
    if (discounted_price > 0) {
      var actualPrice = jQuery('#price').val();
      if (actualPrice > 0) {
        var reducedPrice = actualPrice - discounted_price;
        var discountedPercentage = (reducedPrice / actualPrice) * 100;
        if (discountedPercentage > 0) {
          jQuery('#discounted_percentage').text(discountedPercentage.toFixed(2) + '%');

        } else {
          jQuery('#discounted_percentage').text('<?php echo '0%'; ?>');
        }
      }
    }
  }

  function calculateDiscountPercentage_1(discounted_price) {
    if (discounted_price > 0) {
      var actualPrice = jQuery('#price_1').val();
      if (actualPrice > 0) {
        var reducedPrice = actualPrice - discounted_price;
        var discountedPercentage = (reducedPrice / actualPrice) * 100;
        if (discountedPercentage > 0) {
          jQuery('#discounted_percentage_1').text(discountedPercentage.toFixed(2) + '%');

        } else {
          jQuery('#discounted_percentage_1').text('<?php echo '0%'; ?>');
        }
      }
    }
  }

  function checkout_video_or_image_status(e) {
    if (e == 1) {
      $('#iframe').show();
      $('#image').hide();
      $('#checkout_iframe').attr('required', true);
      $('#checkout_image').attr('required', false);
    } else {
      $('#iframe').hide();
      $('#image').show();
      $('#checkout_iframe').attr('required', false);
      $('#checkout_image').attr('required', true);
    }
  }
</script>

<style media="screen">
  body {
    overflow-x: hidden;
  }

  #image {
    display: none;
  }
</style>
<?php $this->load->view('admin/modal'); ?>