<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>Forum</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
            <li class="breadcrumb-item"><a href="#">Course</a></li>
            <li class="breadcrumb-item active">Forum</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <div class="row">

        <div class="col-sm-12">
          <div class="card card-default">
            <div class="card-header">
              <h3 class="card-title">All Forum Details</h3>
              <div class="card-tools">
                <a href="<?php echo admin_url(); ?>course/add_new_course" class="btn btn-primary btn-sm"><i class="fa fa-plus" aria-hidden="true"></i> Add Course</a>
              </div>
            </div>
            <div class="card-body">
              <?php $forum = &get_instance();
              $forum->load->model('addons/course_forum_model');

              //check from the request
              if (!isset($searching_value)) {
                //this code user for general page
                $number_of_total_questions = $forum->course_forum_model->get_course_wise_all_parent_questions($course_id)->num_rows();
                $questions = $forum->course_forum_model->get_course_wise_limited_questions($course_id)->result_array();
                $searching_value = null;
              } else {
                //this code user for searching page
                $number_of_searching_rows = count($questions);
              }
              ?>
              <div id="question-body">
                <div class="row justify-content-center">
                  <div class="col-md-8 pb-3">
                    <?php if (!isset($searching_value)): ?>
                      <span class="question-header-left mt-2 d-inline-block"><?php echo $number_of_total_questions; ?> <?= site_phrase('questions_in_this_course'); ?>.</span>

                    <?php endif; ?>
                  </div>
                  <?php foreach ($questions as $key => $question):
                    $user_details = $this->user_model->get_all_user($question['user_id'])->row_array();
                    if ($question['upvoted_user_id'] == null || $question['upvoted_user_id'] == 'null') {
                      $upvoted_user_ids = json_encode(array());
                    } else {
                      $upvoted_user_ids = $question['upvoted_user_id'];
                    }
                    if (in_array(user()->id, json_decode($upvoted_user_ids))) {
                      $upvoted_user = true;
                    } else {
                      $upvoted_user = false;
                    }
                    $question_comments = $forum->course_forum_model->get_child_question($question['id']);
                    $commented_user = $forum->course_forum_model->get_child_question($question['id'], user()->id)->num_rows();
                  ?>
                    <div class="col-md-8 border-top user-course-questions py-3 hide-search-processing">
                      <div class="row">
                        <div class="col-md-10 col-lg-10 col-xl-11 cursor-pointer" onclick="question_comments('<?= $question['id']; ?>')">
                          <h6><?= $question['title']; ?></h6>
                          <p class="text-14px"><?= nl2br($question['description']); ?></p>
                        </div>
                        <div class="col-md-2 col-lg-2 col-xl-1 p-0">
                          <button class="border-0 mt-2 icon-upvot-comment <?php if ($upvoted_user == true) {
                                                                            echo 'text-primary';
                                                                          } else {
                                                                            echo 'text-mute';
                                                                          } ?>" onclick="user_vote('<?= $question['id']; ?>', this)"><span id="count-upvote-<?= $question['id']; ?>"><?= count(json_decode($upvoted_user_ids)); ?></span> <i class="far fa-thumbs-up width-10-px m-0"></i></button>

                          <button class="border-0 mt-2 icon-upvot-comment <?php if ($commented_user > 0) {
                                                                            echo 'text-primary';
                                                                          } else {
                                                                            echo 'text-mute';
                                                                          } ?>" onclick="question_comments('<?= $question['id']; ?>')"><span><?= $question_comments->num_rows(); ?></span> <i class="far fa-comment-alt width-10-px m-0"></i></button>
                        </div>
                      </div>
                      <div class="row mt-3">
                        <div class="col-md-12 text-14px">
                          <p class="pe-2">
                            <a class="fw-bold" href="<?= site_url('home/instructor_page/') . $question['user_id']; ?>" target="_blank">
                              <span>
                                <!-- <img class="rounded-circle" src="<?php //echo $this->user_model->get_user_image_url($question['user_id']); 
                                                                      ?>" width="25" height="25"> -->
                              </span>
                              <?= $user_details['name']; ?>
                            </a>
                            <span class="text-muted">
                              , <?= get_past_time($question['date_added']); ?>
                            </span>
                            <a class="float-end text-mute" href="javascript:;" onclick="if(confirm('<?php echo get_phrase('Are you sure?'); ?>')) delete_question('<?= $question['id']; ?>')"><i class="far fa-trash-alt"></i></a>
                          </p>
                        </div>
                      </div>
                    </div>
                  <?php endforeach; ?>

                  <?php if (!isset($searching_value) && $number_of_total_questions > 10):
                    $starting_value = $key + 1; ?>
                    <div class="col-md-8 p-0 hide-search-processing">
                      <a href="javascript:;" class="btn btn-light w-100 fw-bold mt-5" onclick="show_more_questions(this, '<?= $course_id; ?>', '<?= $starting_value; ?>')"><?= site_phrase('show_more'); ?></a>
                    </div>
                  <?php elseif (isset($searching_value) && count($questions) <= 0): ?>
                    <div class="col-md-8 py-5 hide-search-processing">
                      <h5 class="text-center py-5 text-muted"><?php echo site_phrase('there_is_no_data_related_to_your_question'); ?> !!</h5>
                    </div>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- /.content -->
</div>
<script type="text/javascript">
  function user_vote(question_id, e) {
    $.ajax({
      url: '<?= site_url('addons/course_forum/user_vote/'); ?>' + question_id,
      success: function(response) {
        //alert('success');
        var count_upvote_value = $('#count-upvote-' + question_id).text();
        if (response == 'upvoted') {
          $('#count-upvote-' + question_id).html(Number(count_upvote_value) + 1);
          $(e).removeClass('text-mute');
          $(e).addClass('text-primary');
        } else {
          $('#count-upvote-' + question_id).html(Number(count_upvote_value) - 1);
          $(e).removeClass('text-primary');
          $(e).addClass('text-mute');
        }
      }
    });
  }


  function publish_question(course_id) {
    var question_title = $('#questionTitle').val();
    var question_description = $('#questionDescription').val();
    if (question_title != "") {
      $.ajax({
        type: "POST",
        url: "<?= site_url('addons/course_forum/publish_question'); ?>",
        data: {
          title: question_title,
          description: question_description,
          course_id: course_id,
          is_parent: 0
        },
        success: function(response) {
          if (response == 'success') {
            $.ajax({
              url: '<?= site_url('addons/course_forum/load_question_with_ajax/'); ?>' + course_id,
              success: function(response) {
                $('#question-body').html(response);

                swal({
                  title: "Done!",
                  text: "your question has been successfully published",
                  icon: "success",
                });
              }
            });
          }
        },
        error: function(e) {
          console.log(e.responseText)
        }
      });
    } else {
      swal({
        title: "Done!",
        text: "please_write_your_question_title_or_summary",
        icon: "success",
      });
    }
  }

  function load_questions(course_id) {
    $('.remove-active').removeClass('active');
    $('#forum-tab').addClass('active');

    $('#question-body').hide();
    $('#show_questions').show();
    $.ajax({
      url: '<?= site_url('addons/course_forum/load_question_with_ajax/'); ?>' + course_id,
      success: function(response) {
        setTimeout(function() {
          $('#show_questions').hide();
          $('#question-body').show();
          $('#question-body').html(response);
        }, 200);
      }
    });
  }


  function enter_event(event) {
    if (event.keyCode === 13) {
      document.getElementById("searching_btn").click();
    }
  }

  function show_more_questions(e, course_id, starting_value) {
    $(e).hide();
    $('#show_more_loding_icon').show();
    $.ajax({
      url: '<?= site_url('addons/course_forum/show_more_questions/'); ?>' + course_id + '/' + starting_value,
      success: function(response) {
        setTimeout(function() {
          $('#show_more_loding_icon').hide();
          $('#question-body').append(response);
        }, 200);
      }
    });
  }

  function question_comments(question_id) {
    $.ajax({
      url: '<?= site_url('addons/course_forum/question_comments/'); ?>' + question_id,
      success: function(response) {
        $('#question-body').html(response);
      }
    });
  }

  function publish_question_comment(course_id, question_id) {

    var description = $('#questionCommentDescription').val();
    if (description != "") {
      $.ajax({
        type: 'post',
        url: '<?= site_url('addons/course_forum/publish_question_comment/'); ?>' + course_id + '/' + question_id,
        data: {
          description: description
        },
        success: function(response) {
          $('#question-body').html(response);
        },
        error: function(e) {
          console.log(e.responseText)
        }
      });
    }
  }

  function delete_question(question_id, called_from) {
    $.ajax({
      url: '<?= site_url('addons/course_forum/delete_question/'); ?>' + question_id + '/' + called_from,
      success: function(response) {
        $('#question-body').html(response);
      }
    });
  }
</script>
<style>
  .float-end {
    float: right !important;
  }
</style>