
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>View All Course</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
              <li class="breadcrumb-item"><a href="#">Course</a></li>
              <li class="breadcrumb-item active">View All Course</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">

          <div class="col-sm-12">
            <div class="card card-default">
              <div class="card-header">
                <h3 class="card-title">All Course</h3>
                <div class="card-tools">
                  <a href="<?php echo admin_url(); ?>course/add_new_course" class="btn btn-primary btn-sm"><i class="fa fa-plus" aria-hidden="true"></i> Add Course</a>
                </div>
              </div>
                <div class="card-body">
                  <table id="example" class="table table-bordered table-striped">
                    <thead>
                    <tr>
                      <th>id</th>
                      <th>Image</th>
                      <th>Title</th>
                      <th>Category</th>
                      <th>Sub Category</th>
                      <th>Lavel</th>
                      <th></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $i=1; foreach ($get_all_course as $key => $course):?>
                    <tr>
                      <td><?php echo $i ?></td>
                      <td><img src="<?php echo base_url()?><?php echo $course->course_image ?>" width="50px"></td>
                      <td><?php echo $course->course_heading ?></td>
                      <td><?php echo $course->main_category_name ?></td>
                      <td><?php echo $course->sub_category_name ?></td>
                      <td><?php echo ucfirst($course->course_level); ?></td>
                      <td>
                      <a class="btn btn-info btn-sm" target="_blank"  href="<?php echo base_url() ?>admin/course/forum/<?php echo $course->course_id ?>"><i class="fa fa-comments" aria-hidden="true"></i></a>

                        <a class="btn btn-warning btn-sm" target="_blank"  href="<?php echo base_url() ?>/course/<?php echo $course->course_slug ?>"><i class="fa fa-eye" aria-hidden="true"></i></a>

                        <a class="btn btn-success btn-sm"  href="<?php echo base_url() ?>admin/course/edit_course/<?php echo $course->course_id ?>"><i class="fa fa-edit" aria-hidden="true"></i></a>

                        <a class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')" href="<?php echo base_url() ?>admin/course/course_delete/<?php echo $course->course_id ?>"><i class="fa fa-trash" aria-hidden="true"></i></a>
                      </td>
                    </tr>
                    <?php $i++; ?>
                    <?php endforeach; ?>
                    </tbody>
                    
                  </table>
                </div>
              </div>
            </div>
          </div>
      </div>
    </section>
    <!-- /.content -->
  </div>