<?php
    $errors = $this->session->userdata('errors');
    if (isset($errors)) {
        ?>
        <script>
            swal ( "Oops" ,  "<?php echo $errors ?>" ,  "error" )
        </script>
        <?php echo $errors ?>
        <?php
        $this->session->unset_userdata('errors');
    }
    $error = $this->session->userdata('error');
    if (isset($error)) {
        ?>
         <script>
            swal ( "Oops" ,  "<?php echo $error ?>" ,  "error" )
        </script>
        <?php
        $this->session->unset_userdata('error');
    }
    $success = $this->session->userdata('success');
    if (isset($success)) {
        ?>
         <script>
            swal({
          title: "Done!",
          text: "<?php echo $success ?>",
          icon: "success",
        });
        </script>
        <?php
        $this->session->unset_userdata('success');
    }
    ?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>View All Employee</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
              <li class="breadcrumb-item active">View All Employee</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">

          <div class="col-sm-12">
            <div class="card card-default">
              <div class="card-header">
                <h3 class="card-title"><?php echo $title ?></h3>

                <div class="card-tools">
                  <a href="<?php echo admin_url(); ?>employee_management/add_new_employee" class="btn btn-primary btn-sm"><i class="fa fa-plus" aria-hidden="true"></i> Add Employee</a>
                </div>
                
              </div>
                <div class="card-body">
                  <table id="example" class="table table-bordered table-striped">
                    <thead>
                    <tr>
                      <th>id</th>
                      <th>Name</th>
                      <th>Contact Details</th>
                      <th>Working Info</th>
                      <th>Assign IP</th>
                      <th></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $i=1; foreach ($get_all_employee as $key => $Employee):?>
                    <tr>
                      <td><?php echo $i ?></td>
                      <td><?php echo $Employee->name ?></td>
                      <td>
                        Email : <b><?php echo $Employee->email ?></b>
                        <br/>
                        Mob : <b><?php echo $Employee->mobile ?></b>
                      </td>
                      <td>
                        Login Time: <b><?php echo date('h:i A', strtotime($Employee->login_time)); ?></b>
                        <br/> 
                        Logout Time: <b><?php echo date('h:i A', strtotime($Employee->logout_time)); ?></b>
                        <br/>
                        Working hrs. <b><?php echo $Employee->working_hrs ?>hrs.</b>
                        <br/>
                        Mode : <b><?php echo $Employee->mode ?></b>
                        <br/>
                        Role : <b><?php echo $Employee->role ?></b>
                      </td>
                      <td><?php echo $Employee->assign_ip ?></td>
                      <td>
                        <a class="btn btn-info btn-sm" data-toggle="modal" data-target="#exampleModal<?php echo $Employee->id?>" href="#"><i class="fa fa-clock" aria-hidden="true"></i></a>
                        <a class="btn btn-warning btn-sm"  href="<?php echo base_url() ?>admin/Employee_management/get_employee_report/<?php echo $Employee->id ?>"><i class="fa fa-file" aria-hidden="true"></i></a>
                        <a class="btn btn-success btn-sm"  href="<?php echo base_url() ?>admin/Employee_management/update_employee/<?php echo $Employee->id ?>"><i class="fa fa-edit" aria-hidden="true"></i></a>
                        <a class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')" href="<?php echo base_url() ?>admin/employee_management/delete/<?php echo $Employee->id ?>"><i class="fa fa-trash" aria-hidden="true"></i></a>
                      </td>
                    </tr>
                    <?php $i++; ?>
                    <?php endforeach; ?>
                    </tbody>
                    
                  </table>
                </div>
              </div>
            </div>
          </div>
      </div>
    </section>
    <!-- /.content -->
  </div>
<?php $i=1; foreach ($get_all_employee as $key => $Employee):?>
<div class="modal fade" id="exampleModal<?php echo $Employee->id?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Update Employee Login/Logout Time</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <?php echo form_open(base_url().'admin/employee_management/update_emp_time'); ?>
          <div class="form-group">
            <label for="recipient-name" class="col-form-label">Date</label>
            <input type="date" class="form-control" name="working_report_date" required>
          </div>
          <div class="form-group">
            <label for="recipient-name" class="col-form-label">Login/Logout Time</label>
            <input type="time" class="form-control" name="working_report_login_time" required>
          </div>
          <input type="hidden" class="form-control" name="working_report_emp_id" value="<?php echo $Employee->id ?>">
          <input type="hidden" class="form-control" name="working_report_login_time_was" value="<?php echo $Employee->login_time ?>">
          <input type="hidden" class="form-control" name="working_report_log_out_time_was" value="<?php echo $Employee->logout_time ?>">
          <input type="hidden" class="form-control" name="working_report_working_hrs" value="<?php echo $Employee->working_hrs ?>">
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-primary">Update</button>
      </div>
      <?php echo form_close();?>
    </div>
  </div>
</div>
<?php endforeach; ?>