<?php
$errors = $this->session->userdata('errors');
if (isset($errors)) {
?>
  <script>
    swal("Oops", "<?php echo $errors ?>", "error")
  </script>
  <?php echo $errors ?>
<?php
  $this->session->unset_userdata('errors');
}
$error = $this->session->userdata('error');
if (isset($error)) {
?>
  <script>
    swal("Oops", "<?php echo $error ?>", "error")
  </script>
<?php
  $this->session->unset_userdata('error');
}
$success = $this->session->userdata('success');
if (isset($success)) {
?>
  <script>
    swal({
      title: "Done!",
      text: "<?php echo $success ?>",
      icon: "success",
    });
  </script>
<?php
  $this->session->unset_userdata('success');
}
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>All Testimonials</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
            <li class="breadcrumb-item active">Testimonials</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-sm-12">
          <div class="card card-default">
            <div class="card-header">
              <h4 class="card-title">Add New Testimonials</h4>
            </div>
            <!-- /.card-header -->
            <?php echo form_open(base_url() . 'admin/frontend_setting/add_new_testi_category'); ?>
            <div class="card-body">
              <div class="row">
                <div class="col-md-12">
                  <div class="form-group">
                    <label>Testimonials Heading<span class="required">*</span></label>
                    <input type="text" name="t_c_name" class="form-control" placeholder="Enter Testimonials Heading" required="">
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group">
                    <label>Testimonials Description<span class="required">*</span></label>
                    <textarea type="text" name="t_c_title" class="form-control" placeholder="Enter Testimonials Description" required=""></textarea>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label>Testimonials User Name<span class="required">*</span></label>
                    <input type="text" name="t_c_sub_title" class="form-control" placeholder="Enter Sub-title" required="">
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label>Video<span class="required">*</span></label>
                    <input type="text" name="t_c_video" class="form-control" placeholder="Enter Video Link" required="">
                  </div>
                </div>
                <div class="col-md-12">
                  <div class="form-group">
                    <button class="btn btn-info" type="submit" style="float: right">Add</button>
                  </div>
                </div>
                <?php echo form_close(); ?>
              </div>
            </div>
          </div>
        </div>

        <div class="col-sm-12">
          <div class="card card-default">
            <div class="card-header">
              <h4 class="card-title">View All Testmonials</h4>
            </div>
            <div class="card-body">
              <table id="example" class="table table-bordered table-striped">
                <thead>
                  <tr>
                    <th>id</th>
                    <th>Name</th>
                    <th>Heading</th>
                    <th>Description</th>
                    <th>Video</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
                  <?php $i = 1;
                  foreach ($all_category as $key => $category): ?>
                    <tr>
                      <td><?php echo $i ?></td>
                      <td><?php echo $category->t_c_name ?></td>
                      <td><?php echo $category->t_c_title ?></td>
                      <td><?php echo $category->t_c_sub_title ?></td>
                      <td><?php echo $category->t_c_video ?></td>
                      <td><a href="" class="btn btn-info btn-sm" data-toggle="modal" data-target="#update-category<?php echo $category->t_c_id ?>"><i class="fa fa-edit" aria-hidden="true"></i></a>
                        <a class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')" href="<?php echo base_url() ?>admin/frontend_setting/delete_testi_category/<?php echo $category->t_c_id ?>"><i class="fa fa-trash" aria-hidden="true"></i></a>
                      </td>
                    </tr>
                    <?php $i++; ?>
                  <?php endforeach; ?>
                </tbody>

              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- /.content -->
</div>

<?php $i = 1;
foreach ($all_category as $key => $category): ?>
  <div class="modal fade" id="update-category<?php echo $category->t_c_id ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLabel">Update Testimonial</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <?php echo form_open(base_url() . 'admin/frontend_setting/update_testi_category'); ?>
          <div class="col-md-12">
            <div class="form-group">
              <label for="recipient-name" class="col-form-label">Testimonial Heading</label>
              <input type="text" name="t_c_name" class="form-control" value="<?php echo $category->t_c_name ?>" required placeholder="Enter Testimonial Heading">
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-group">
              <label>Testimonial Description<span class="required">*</span></label>
              <textarea type="text" name="t_c_title" class="form-control" placeholder="Enter Testimonial Description" required=""><?php echo $category->t_c_title ?></textarea>
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-group">
              <label>Name<span class="required">*</span></label>
              <input type="text" name="t_c_sub_title" class="form-control" placeholder="Enter Sub-title" required="" value="<?php echo $category->t_c_sub_title ?>">
            </div>
          </div>
          <div class="col-md-12">
            <div class="form-group">
              <label>Video URL<span class="required">*</span></label>
              <input type="text" name="t_c_video" class="form-control" placeholder="Enter Video Link" required="" value="<?php echo $category->t_c_video ?>">
            </div>
          </div>
          <input type="hidden" name="id" class="form-control" value="<?php echo $category->t_c_id ?>">
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Update</button>
        </div>
        <?php echo form_close(); ?>
      </div>
    </div>
  </div>
<?php endforeach; ?>