<?php
    $errors = $this->session->userdata('errors');
    if (isset($errors)) {
        ?>
        <script>
            swal ( "Oops" ,  "<?php echo $errors ?>" ,  "error" )
        </script>
        <?php echo $errors ?>
        <?php
        $this->session->unset_userdata('errors');
    }
    $error = $this->session->userdata('error');
    if (isset($error)) {
        ?>
         <script>
            swal ( "Oops" ,  "<?php echo $error ?>" ,  "error" )
        </script>
        <?php
        $this->session->unset_userdata('error');
    }
    $success = $this->session->userdata('success');
    if (isset($success)) {
        ?>
         <script>
            swal({
          title: "Done!",
          text: "<?php echo $success ?>",
          icon: "success",
        });
        </script>
        <?php
        $this->session->unset_userdata('success');
    }
    ?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Google Algorithm Guide</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
              <li class="breadcrumb-item active">Google Algorithm Guide</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-12">
            <div class="card card-default">
              <div class="card-header">
                <h3 class="card-title">Add New Guide</h3>
              </div>
              <!-- /.card-header -->
              <?php echo form_open(base_url().'admin/frontend_setting/add_new_google_guide'); ?>
              <div class="card-body">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group">
                      <label>Algorithm Title <span class="required">*</span></label>
                      <input type="text" name="algorithm_title" class="form-control" placeholder="Enter Algorithm Title" required>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Algorithm Date <span class="required">*</span></label>
                      <input type="date" name="algorithm_date" class="form-control" placeholder="Enter Algorithm Title" required>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Algorithm Status <span class="required">*</span></label>
                      <select name="algorithm_status" class="form-control" placeholder="Enter Algorithm Title" required>
                        <option value="1">Confirmed</option>
                        <option value="0">Unconfirmed</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="form-group">
                      <label>Algorithm Description <span class="required">*</span></label>
                      <textarea type="text" name="algorithm_description" class="form-control" placeholder="Enter Algorithm Description" required></textarea>
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="form-group">
                    <label for="inputEmail" class="col-sm-12 col-form-label">Algorithm Links Text & Links<span class="required">*</span></label>
                    <div class="table-responsive">
                       <table class="table table-bordered" id="dynamic_field">
                          <tr>
                            <td>
                                <input type="text" name="algorithm_link_text[]" class="form-control name_list" placeholder="Enter Algorithm Link Text" required="" />
                            </td>
                            <td>
                                <input type="text" name="algorithm_link_url[]" class="form-control name_list" placeholder="Enter Algorithm Link Url" required="" />
                            </td>
                            <td>
                              <button type="button" name="add" id="add" class="btn btn-primary">+</button>
                            </td>
                          </tr>
                       </table>
                    </div>
                 </div>
                </div>
                  
                  <div class="col-md-12">
                    <div class="form-group">
                      <button class="btn btn-info" type="submit" style="float: right">Add</button>
                    </div>
                  </div>
                  <?php echo form_close(); ?>
                </div>
              </div>
            </div>
          </div>
      </div>
    </section>
<script type="text/javascript">
  $(document).ready(function(){  
        var i=1;  
        $('#add').click(function(){  
             i++;  
             $('#dynamic_field').append('<tr id="row'+i+'"><td><input type="text" name="algorithm_link_text[]" class="form-control name_list" placeholder="Enter Algorithm Link Text" required="" /></td><td><input type="text" name="algorithm_link_url[]" class="form-control name_list" placeholder="Enter Algorithm Link Url" required="" /></td><td><button type="button" name="remove" id="'+i+'" class="btn btn-danger btn_remove">X</button></td></tr>');  
        });  
        $(document).on('click', '.btn_remove', function(){  
             var button_id = $(this).attr("id");   
             $('#row'+button_id+'').remove();  
        });  
   });  
</script>



    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-12">
            <div class="card card-default">
              <div class="card-header">
                <h4>View All Algorithm</h4>
                
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example" class="table table-bordered table-striped">
                    <thead>
                    <tr>
                      <th>id</th>
                      <th>Title</th>  
                      <th>Date</th>  
                      <th>Status</th>  
                      <th></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $i=1; foreach ($all_google_guide as $key => $guide):?>
                    <tr>
                      <td><?php echo $i ?></td>
                      <td><?php echo $guide->algorithm_title ?></td>
                      <td><?php echo $guide->algorithm_date ?></td>
                      <td>
                        <?php if($guide->algorithm_status == 1): ?>
                          <span class="badge badge-success">Confirmed</span>
                        <?php else: ?>
                          <span class="badge badge-danger">Unconfirmed</span>
                        <?php endif;?>
                      </td>
                      <td><a href="" class="btn btn-info btn-sm" data-toggle="modal" data-target="#update-algorithm<?php echo $guide->algorithm_id ?>"><i class="fa fa-edit" aria-hidden="true"></i></a>
                        <a class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')" href="<?php echo base_url() ?>admin/frontend_setting/delete_algorithm_data/<?php echo $guide->algorithm_id ?>"><i class="fa fa-trash" aria-hidden="true"></i></a></td>
                    </tr>
                    <?php $i++; ?>
                    <?php endforeach; ?>
                    </tbody>
                    
                  </table>
                </div>
            </div>
          </div>
      </div>
    </section>
    <!-- /.content -->
  </div>

 <?php $i=1; foreach ($all_google_guide as $key => $guide):?>
<div class="modal fade" id="update-algorithm<?php echo $guide->algorithm_id ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Update Algorithm</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <?php echo form_open(base_url().'admin/frontend_setting/update_google_guide'); ?>
        <div class="row">
          <div class="col-md-12">
              <div class="form-group">
                <label>Algorithm Title <span class="required">*</span></label>
                <input type="text" name="algorithm_title" class="form-control" placeholder="Enter Algorithm Title" required value="<?php echo $guide->algorithm_title ?>">
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label>Algorithm Date <span class="required">*</span></label>
                <input type="date" name="algorithm_date" class="form-control" placeholder="Enter Algorithm Title" required value="<?php echo $guide->algorithm_date ?>">
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label>Algorithm Status <span class="required">*</span></label>
                <select name="algorithm_status" class="form-control" placeholder="Enter Algorithm Title" required>
                  <option <?php if($guide->algorithm_status == 1){echo 'selected';} ?> value="1">Confirmed</option>
                  <option <?php if($guide->algorithm_status == 0){echo 'selected';} ?> value="0">Unconfirmed</option>
                </select>
              </div>
            </div>
            <div class="col-md-12">
              <div class="form-group">
                <label>Algorithm Description <span class="required">*</span></label>
                <textarea type="text" name="algorithm_description" class="form-control" placeholder="Enter Algorithm Description" required><?php echo $guide->algorithm_description ?></textarea>
              </div>
            </div>
          <div class="col-md-12">
            <div class="form-group">
              <label for="inputEmail" class="col-sm-12 col-form-label">Algorithm Links Text & Links</label>
              <div class="table-responsive">
                 <table class="table table-bordered" id="dynamic_field<?php echo $guide->algorithm_id ?>">
                  <?php foreach (json_decode($guide->algorithm_link_text) as $key => $content):?>
                    <tr>
                      <td>
                        <input type="text" name="algorithm_link_text[]" class="form-control name_list" placeholder="Enter Content" value="<?php echo $content ?>" />
                        <input type="text" name="algorithm_link_url[]" class="form-control name_list" placeholder="Enter Content" value="<?php echo json_decode($guide->algorithm_link_url)[$key]; ?>" />
                      </td>
                      <td><button type="button" name="remove" id="old_<?php echo $i?>" class="btn btn-danger btn_remove_<?php echo $i?>" onclick="removeRequirement(this)">X</button></td>
                    </tr>
                  <?php endforeach; ?>
                  <tr>
                       <td width="90%"></td>
                       <td><button type="button" name="add" class="add<?php echo $guide->algorithm_id ?> btn btn-success">+</button></td>
                    </tr>
                 </table>
              </div>
           </div>
          </div>
        </div>
          <input type="hidden" name="id" class="form-control" value="<?php echo $guide->algorithm_id ?>">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary">Update</button>
      </div>
      <?php echo form_close(); ?>
    </div>
  </div>
</div>
  <script type="text/javascript">
  $(document).ready(function(){  
        var i=1;  
        $('.add<?php echo $guide->algorithm_id ?>').click(function(){  
             i++;  
             $('#dynamic_field<?php echo $guide->algorithm_id ?>').append('<tr id="row'+i+'"><td><input type="text" name="algorithm_link_text[]" class="form-control name_list" placeholder="Enter Algorithm Link Text" required="" /><input type="text" name="algorithm_link_url[]" class="form-control name_list" placeholder="Enter Algorithm Link Url" required="" /></td><td><button type="button" name="remove" id="'+i+'" class="btn btn-danger btn_remove">X</button></td></tr>');  
        });  
        $(document).on('click', '.btn_remove', function(){  
             var button_id = $(this).attr("id");   
             $('#row'+button_id+'').remove();  
        });  

       
   });  
</script>
<?php $i++; ?>
<?php endforeach; ?>
<script type="text/javascript">
  function removeRequirement(requirementElem) {
  jQuery(requirementElem).parent().parent().remove();
}
</script>