<?php
    $errors = $this->session->userdata('errors');
    if (isset($errors)) {
        ?>
        <script>
            swal ( "Oops" ,  "<?php echo $errors ?>" ,  "error" )
        </script>
        <?php echo $errors ?>
        <?php
        $this->session->unset_userdata('errors');
    }
    $error = $this->session->userdata('error');
    if (isset($error)) {
        ?>
         <script>
            swal ( "Oops" ,  "<?php echo $error ?>" ,  "error" )
        </script>
        <?php
        $this->session->unset_userdata('error');
    }
    $success = $this->session->userdata('success');
    if (isset($success)) {
        ?>
         <script>
            swal({
          title: "Done!",
          text: "<?php echo $success ?>",
          icon: "success",
        });
        </script>
        <?php
        $this->session->unset_userdata('success');
    }
    ?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Recommended Tools</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
              <li class="breadcrumb-item active">Recommended Tools</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-6">
            <div class="card card-default">
              <div class="card-header">
                <h3 class="card-title">Add New Category</h3>
              </div>
              <!-- /.card-header -->
              <?php echo form_open(base_url().'admin/frontend_setting/add_new_recommended_tool_category'); ?>
              <div class="card-body">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group">
                      <label>Category Name <span class="required">*</span></label>
                      <input type="text" name="t_cat_name" class="form-control" placeholder="Enter Category Name" required>
                    </div>
                  </div>
                </div>
                  <div class="col-md-12">
                    <div class="form-group">
                      <button class="btn btn-info" type="submit" style="float: right">Add</button>
                    </div>
                  </div>
                  <?php echo form_close(); ?>
                </div>
              </div>
            </div>
         
          <div class="col-sm-6">
            <div class="card card-default">
              <div class="card-header">
                <h4>View All Category</h4>
              </div>
              <div class="card-body">
                <table id="example" class="table table-bordered table-striped">
                    <thead>
                    <tr>
                      <th>id</th>
                      <th>Name</th>
                      <th></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $i=1; foreach ($all_category as $key => $cat):?>
                    <tr>
                      <td><?php echo $i ?></td>
                      <td><?php echo $cat->t_cat_name ?></td>
                      <td><a href="" class="btn btn-info btn-sm" data-toggle="modal" data-target="#update-category<?php echo $cat->t_cat_id ?>"><i class="fa fa-edit" aria-hidden="true"></i></a>
                        <a class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')" href="<?php echo base_url() ?>admin/frontend_setting/delete_recommended_tools_category/<?php echo $cat->t_cat_id ?>"><i class="fa fa-trash" aria-hidden="true"></i></a></td>
                    </tr>
                    <?php $i++; ?>
                    <?php endforeach; ?>
                    </tbody>
                  </table>
                </div>
            </div>
          </div>
      </div>
    </section>
    <?php $i=1; foreach ($all_category as $key => $cat):?>
    <div class="modal fade" id="update-category<?php echo $cat->t_cat_id ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLabel">Update Category</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <?php echo form_open(base_url().'admin/frontend_setting/update_recommended_tool_category/'.$cat->t_cat_id); ?>
              <div class="row">
                <div class="col-md-12">
                  <div class="form-group">
                    <label>Category Name <span class="required">*</span></label>
                    <input type="text" name="t_cat_name" class="form-control" placeholder="Enter Tool Title" required value="<?php echo $cat->t_cat_name ?>">
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
              <button type="submit" class="btn btn-primary">Update</button>
            </div>
          <?php echo form_close(); ?>
        </div>
      </div>
    </div>
     
    <?php $i++; ?>
    <?php endforeach; ?>


    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-12">
            <div class="card card-default">
              <div class="card-header">
                <h3 class="card-title">Add New Tools</h3>
              </div>
              <!-- /.card-header -->
              <?php echo form_open_multipart(base_url().'admin/frontend_setting/add_new_recommended_tool'); ?>
              <div class="card-body">
                <div class="row">
                  <div class="col-md-5">
                    <div class="form-group">
                      <label>Tool Category <span class="required">*</span></label>
                      <select type="text" name="tool_cat_id" class="form-control" placeholder="Enter Tool Title" required>
                        <option value="">Select A Category</option>
                        <?php $i=1; foreach ($all_category as $key => $cat):?>
                          <option value="<?php echo $cat->t_cat_id ; ?>"><?php echo $cat->t_cat_name ; ?></option>
                        <?php endforeach; ?>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-7">
                    <div class="form-group">
                      <label>Tool Title <span class="required">*</span></label>
                      <input type="text" name="tool_name" class="form-control" placeholder="Enter Tool Title" required>
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="form-group">
                      <label>Tool Image <span class="required">*</span></label>
                      <input type="file" name="tool_image" class="form-control" placeholder="Enter Tool Title" required>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Tool Description <span class="required">*</span></label>
                      <textarea type="text" name="tool_description" class="form-control" placeholder="Enter Tool Description" required></textarea>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Tool Button Heading <span class="required">*</span></label>
                      <textarea type="text" name="tool_btn_heading" class="form-control" placeholder="Enter Tool Button Heading" required></textarea>
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="form-group">
                      <label>Tool Coupon Code </label>
                      <input type="text" name="tool_coupon_code" class="form-control" placeholder="Enter Tool Coupon Code">
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Tool URL<span class="required">*</span></label>
                      <input type="text" name="tool_btn_url" class="form-control" placeholder="Enter Tool URL" required>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Tool Timer<span class="required">*</span></label>
                      <input type="date" name="tool_timer" class="form-control" placeholder="Enter Tool URL" required>
                    </div>
                  </div>
                </div>
                  
                  <div class="col-md-12">
                    <div class="form-group">
                      <button class="btn btn-info" type="submit" style="float: right">Add</button>
                    </div>
                  </div>
                  <?php echo form_close(); ?>
                </div>
              </div>
            </div>
          </div>
      </div>
    </section>


    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-12">
            <div class="card card-default">
              <div class="card-header">
                <h4>View All Tools</h4>
              </div>
              <div class="card-body">
                <table id="example" class="table table-bordered table-striped">
                    <thead>
                    <tr>
                      <th>id</th>
                      <th>Image</th>  
                      <th>Title</th>
                      <th>Coupon Code</th>
                      <th>Last Date</th> 
                      <th>Category</th> 
                      <th></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $i=1; foreach ($all_recommended_tools as $key => $tools):?>
                    <tr>
                      <td><?php echo $i ?></td>
                      <td><img src="<?php echo base_url() ?><?php echo $tools->tool_image ?>" width="50px"></td>
                      <td><?php echo $tools->tool_name ?></td>
                      <td><?php echo $tools->tool_coupon_code ?></td>
                      <td><?php echo $tools->tool_timer ?></td>
                      <td><?php echo $tools->t_cat_name ?></td>
                      <td><a href="" class="btn btn-info btn-sm" data-toggle="modal" data-target="#update-tool<?php echo $tools->tool_id ?>"><i class="fa fa-edit" aria-hidden="true"></i></a>
                        <a class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')" href="<?php echo base_url() ?>admin/frontend_setting/delete_recommended_tools/<?php echo $tools->tool_id ?>"><i class="fa fa-trash" aria-hidden="true"></i></a></td>
                    </tr>
                    <?php $i++; ?>
                    <?php endforeach; ?>
                    </tbody>
                    
                  </table>
                </div>
            </div>
          </div>
      </div>
    </section>
    <!-- /.content -->
  </div>

<?php $i=1; foreach ($all_recommended_tools as $key => $tools):?>
<div class="modal fade" id="update-tool<?php echo $tools->tool_id ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Update Tools</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <?php echo form_open_multipart(base_url().'admin/frontend_setting/update_recommended_tool/'.$tools->tool_id); ?>
          <div class="row">
            <div class="col-md-12">
              <div class="form-group">
                <label>Tool Category <span class="required">*</span></label>
                <select type="text" name="tool_cat_id" class="form-control" placeholder="Enter Tool Title" required>
                  <option value="">Select A Category</option>
                  <?php $i=1; foreach ($all_category as $key => $cat):?>
                    <option <?php if($cat->t_cat_id == $tools->tool_cat_id){echo 'selected';}?> value="<?php echo $cat->t_cat_id ; ?>"><?php echo $cat->t_cat_name ; ?></option>
                  <?php endforeach; ?>
                </select>
              </div>
            </div>
            <div class="col-md-12">
              <div class="form-group">
                <label>Tool Title <span class="required">*</span></label>
                <input type="text" name="tool_name" class="form-control" placeholder="Enter Tool Title" required value="<?php echo $tools->tool_name ?>">
              </div>
            </div>
            <div class="col-md-12">
              <div class="form-group">
                <label>Tool Image </label>
                <input type="file" name="tool_image" class="form-control" placeholder="Enter Tool Title">
              </div>
            </div>
            <div class="col-md-12">
              <div class="form-group">
                <label>Tool Image Preview</label><br/>
                <img src="<?php echo base_url() ?><?php echo $tools->tool_image ?>" width="50px">
              </div>
            </div>
            <div class="col-md-12">
              <div class="form-group">
                <label>Tool Description <span class="required">*</span></label>
                <textarea type="text" name="tool_description" class="form-control" placeholder="Enter Tool Description" required><?php echo $tools->tool_description ?></textarea>
              </div>
            </div>
            <div class="col-md-12">
              <div class="form-group">
                <label>Tool Button Heading <span class="required">*</span></label>
                <textarea type="text" name="tool_btn_heading" class="form-control" placeholder="Enter Tool Button Heading" required><?php echo $tools->tool_btn_heading ?></textarea>
              </div>
            </div>
            <div class="col-md-12">
              <div class="form-group">
                <label>Tool Coupon Code </label>
                <input type="text" name="tool_coupon_code" class="form-control" placeholder="Enter Tool Coupon Code" value="<?php echo $tools->tool_coupon_code ?>">
              </div>
            </div>
            <div class="col-md-12">
              <div class="form-group">
                <label>Tool URL<span class="required">*</span></label>
                <input type="text" name="tool_btn_url" class="form-control" placeholder="Enter Tool URL" required value="<?php echo $tools->tool_btn_url ?>">
              </div>
            </div>
            <div class="col-md-12">
              <div class="form-group">
                <label>Tool Timer<span class="required">*</span></label>
                <input type="date" name="tool_timer" class="form-control" placeholder="Enter Tool URL" required value="<?php echo $tools->tool_timer ?>">
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Update</button>
        </div>
      <?php echo form_close(); ?>
    </div>
  </div>
</div>
 
<?php $i++; ?>
<?php endforeach; ?>
