<?php
    $errors = $this->session->userdata('errors');
    if (isset($errors)) {
        ?>
        <script>
            swal ( "Oops" ,  "<?php echo $errors ?>" ,  "error" )
        </script>
        <?php echo $errors ?>
        <?php
        $this->session->unset_userdata('errors');
    }
    $error = $this->session->userdata('error');
    if (isset($error)) {
        ?>
         <script>
            swal ( "Oops" ,  "<?php echo $error ?>" ,  "error" )
        </script>
        <?php
        $this->session->unset_userdata('error');
    }
    $success = $this->session->userdata('success');
    if (isset($success)) {
        ?>
         <script>
            swal({
          title: "Done!",
          text: "<?php echo $success ?>",
          icon: "success",
        });
        </script>
        <?php
        $this->session->unset_userdata('success');
    }
    ?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Stacks</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
              <li class="breadcrumb-item active">Stacks</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-4">
            <div class="card card-default">
              <div class="card-header">
                <h4>Add New Stacks</h4>
                
              </div>
              <!-- /.card-header -->
              <?php echo form_open(base_url().'admin/lab_page/add_new_section_4_content'); ?>
              <div class="card-body">
                <div class="row">
                  <div class="col-md-12">
                    <div class="form-group">
                      <label>Icon<span class="required">*</span></label>
                      <select class="form-control select2icon font-awsom" name="icon"  required="required">
                        <option value="">Select Icon</option>
                         <?php $this->load->view('admin/include/fafa_icon_select') ?>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="form-group">
                      <label>Category<span class="required">*</span></label>
                      <select type="text" name="section" class="form-control" placeholder="Enter Content" required="">
                        <option value="">Select Category</option>
                        <option value="1">General Features</option>
                        <option value="2">Standard eCommerce</option>
                        <option value="3">Social Media Login & Sharing</option>
                        <option value="4">Multiple Payment Gateways</option>
                        <option value="5">Shipping Option</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="form-group">
                      <label>Content<span class="required">*</span></label>
                      <input type="text" name="content" class="form-control" placeholder="Enter Content" required="">
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="form-group">
                       <label for="inputEmail" class="col-sm-12 col-form-label">Color</label>
                       <div class="input-group my-colorpicker2 site_color_1 colorpicker-element" data-colorpicker-id="2">
                        <input type="text" name="color" class="form-control" data-original-title="" title="">
                        <div class="input-group-append">
                          <span class="input-group-text"><i class="fas fa-square fa_1"></i></span>
                        </div>
                      </div>
                    </div>
                  </div>
                 
                  <div class="col-md-12">
                    <div class="form-group">
                      <button class="btn btn-info" type="submit" style="float: right">Add</button>
                    </div>
                  </div>
                  <?php echo form_close(); ?>
                </div>
              </div>
            </div>
          </div>
          <script type="text/javascript">
            $(function () {
               $('.site_color_1').colorpicker()
                  $('.site_color_1').on('colorpickerChange', function(event) {
                    $('.site_color_1 .fa_1').css('color', event.color.toString());
                  });
                });
          </script>
          
          <div class="col-sm-8">
            <div class="card card-default">
              <div class="card-header">
                <h4>View Stacks</h4>
                
              </div>
                <div class="card-body">
                  <table id="example" class="table table-bordered table-striped">
                    <thead>
                    <tr>
                      <th>id</th>
                      <th>Icon</th>
                      <th>Category</th>
                      <th>Content</th>
                      <th>Color</th>
                      <th></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $i=1; foreach ($section_5 as $key => $stacks):?>
                    <tr>
                      <td><?php echo $i ?></td>
                      <td><span style="color: <?php echo  $stacks->color; ?>;">Color</span></td>
                      <td><?php 
                      if($stacks->section == 1)
                      {
                        echo 'General Features';
                      }
                      elseif($stacks->section == 2)
                      {
                         echo 'Standard eCommerce';
                      }
                      elseif($stacks->section == 3)
                      {
                         echo 'Social Media Login & Sharing';
                      }
                      elseif($stacks->section == 4)
                      {
                         echo 'Multiple Payment Gateways';
                      }
                      elseif($stacks->section == 5)
                      {
                         echo 'Shipping Option';
                      } ?>
                      </td>
                      <td><?php echo  $stacks->content; ?></td>
                      <td><i class="fa <?php echo  $stacks->icon; ?>"></i></td>

                      <td><a href="" class="btn btn-info btn-sm" data-toggle="modal" data-target="#update-stacks<?php echo $stacks->id ?>"><i class="fa fa-edit" aria-hidden="true"></i></a>
                        <a class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')" href="<?php echo base_url() ?>admin/lab_page/delete_section_3/<?php echo $stacks->id ?>"><i class="fa fa-trash" aria-hidden="true"></i></a></td>
                    </tr>
                    <?php $i++; ?>
                    <?php endforeach; ?>
                    </tbody>
                    
                  </table>
                </div>
              </div>
            </div>
          </div>
      </div>
    </section>
    <!-- /.content -->
  </div>
<?php $i=1; foreach ($section_5 as $key => $stacks):?>
<div class="modal fade" id="update-stacks<?php echo $stacks->id ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Update Content</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <?php echo form_open(base_url().'admin/lab_page/update_section_4_content'); ?>
          <div class="form-group">
            <label>Icon<span class="required">*</span></label>
            <select class="form-control font-awsom" name="icon"  required="required">
              <option value="">Select Icon</option>
               <?php $this->load->view('admin/include/fafa_icon_select', ['icon' => $stacks->icon]) ?>
            </select>
          </div>
            <div class="col-md-12">
              <div class="form-group">
                <label>Category<span class="required">*</span></label>
                <select type="text" name="section" class="form-control" placeholder="Enter Content" required="">
                  <option value="">Select Category</option>
                  <option <?php if($stacks->section == 1){echo 'selected';} ?> value="1">General Features</option>
                  <option <?php if($stacks->section == 2){echo 'selected';} ?> value="2">Standard eCommerce</option>
                  <option <?php if($stacks->section == 3){echo 'selected';} ?> value="3">Social Media Login & Sharing</option>
                  <option <?php if($stacks->section == 4){echo 'selected';} ?> value="4">Multiple Payment Gateways</option>
                  <option <?php if($stacks->section == 5){echo 'selected';} ?> value="5">Shipping Option</option>
                </select>
              </div>
            </div>
            <div class="col-md-12">
              <div class="form-group">
                <label>Content<span class="required">*</span></label>
                <input type="text" name="content" class="form-control" placeholder="Enter Content" required="" value="<?php echo $stacks->content; ?>">
              </div>
            </div>
            <div class="col-md-12">
              <div class="form-group">
                 <label for="inputEmail" class="col-sm-12 col-form-label">Color</label>
                 <div class="input-group my-colorpicker2 site_color_2_<?php echo $i; ?> colorpicker-element" data-colorpicker-id="2">
                    <input type="text" name="color" value="<?php echo $stacks->color ?>" class="form-control"  data-original-title="" title="">

                    <div class="input-group-append">
                      <span class="input-group-text"><i style="color: <?php echo $stacks->color ?>" class="fas fa-square fa_2_<?php echo $i; ?>"></i></span>
                    </div>
                  </div>
              </div>
            </div>
            <input type="hidden" name="id" class="form-control" value="<?php echo $stacks->id ?>">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary">Update</button>
      </div>
      <?php echo form_close(); ?>
    </div>
  </div>
</div>
<script type="text/javascript">
  $(function () {
  $('.site_color_2_<?php echo $i; ?>').colorpicker()
    $('.site_color_2_<?php echo $i; ?>').on('colorpickerChange', function(event) {
      $('.site_color_2_<?php echo $i; ?> .fa_2_<?php echo $i; ?>').css('color', event.color.toString());
    });
  })
</script>
<?php endforeach; ?>