<div class="content-wrapper">

  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <style>
    :root {
      --ink: #1a1a1a;
      --muted: #5b6770;
      --bg: #fcfcfd;
      --border: #e0e3eb;
      --primary: #0f2449;
      --accent: #f0f6ff;
    }

    * {
      box-sizing: border-box
    }

    body {
      margin: 0;
      font-family: Inter, system-ui, Arial, sans-serif;
      color: var(--ink);
      background: var(--bg)
    }

    .toolbar {
      display: flex;
      gap: .5rem;
      padding: 12px;
      border-bottom: 1px solid var(--border);
      background: #fff;
      position: sticky;
      top: 0;
      z-index: 10
    }

    .btn {
      border: 1px solid var(--border);
      background: #fff;
      border-radius: 8px;
      padding: .45rem .75rem;
      cursor: pointer;
      font-weight: 600;
      display: flex;
      align-items: center;
      gap: .4rem
    }

    .btn.primary {
      background: var(--primary);
      border-color: var(--primary);
      color: #fff
    }

    .wrap {
      max-width: 850px;
      margin: 20px auto;
      padding: 0 15px 60px
    }

    .invoice {
      background: #fff;
      border: 1px solid var(--border);
      border-radius: 16px;
      overflow: hidden;
      box-shadow: 0 8px 25px rgba(0, 0, 0, .05)
    }

    .banner {
      background: #b7d2ff;
      padding: 20px;
      position: relative
    }

    .logo {
      width: 100px;
      height: 100px;
      border-radius: 12px;
      background: #fff;
      border: 1px solid var(--border);
      display: grid;
      place-items: center;
      cursor: pointer;
      overflow: hidden
    }

    .logo img {
      max-width: 100%;
      max-height: 100%;
      object-fit: contain;
      padding: 5px;
    }

    .triangle {
      position: absolute;
      right: -60px;
      top: -40px;
      width: 200px;
      height: 200px;
      background: var(--primary);
      transform: rotate(45deg);
      opacity: .8
    }

    .content {
      padding: 24px
    }

    .row {
      display: flex;
      justify-content: space-between;
      align-items: flex-start;
      margin-bottom: 20px
    }

    .editable[contenteditable="true"]:hover {
      background: #fffa
    }

    .title {
      font-size: 20px;
      font-weight: 700;
      margin: 0
    }

    .muted {
      color: var(--muted);
      font-size: 13px
    }

    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 12px
    }

    th,
    td {
      border: 1px solid var(--border);
      padding: 10px;
      font-size: 14px;
      text-align: left
    }

    th {
      background: var(--primary);
      color: #fff
    }

    input.line {
      width: 100%;
      border: 1px solid var(--border);
      padding: 6px;
      border-radius: 6px;
      font: inherit
    }

    .num {
      max-width: 110px
    }

    .qty {
      max-width: 70px
    }

    .totals {
      display: grid;
      grid-template-columns: 1fr 240px;
      gap: 20px;
      margin-top: 20px
    }

    .panel {
      border: 1px solid var(--border);
      border-radius: 12px;
      overflow: hidden
    }

    .panel .rowx {
      display: flex;
      justify-content: space-between;
      padding: 8px 12px;
      border-bottom: 1px solid var(--border);
      font-size: 14px
    }

    .panel .rowx.total {
      background: var(--accent);
      font-weight: 700
    }

    .footer {
      padding: 16px;
      border-top: 1px dashed var(--border);
      font-size: 12px;
      color: var(--muted)
    }

    @media print {
      .toolbar {
        display: none
      }

      body {
        background: #fff
      }

      .wrap {
        margin: 0;
        padding: 0
      }

      .invoice {
        border: 0;
        box-shadow: none
      }
    }
  </style>

  <div class="toolbar">
    <button class="btn" id="btnPrint">🖨️ Print</button>
    <!-- <button class="btn primary" id="btnPdf">⬇️ Download PDF</button> -->
    <button style="display: none;" class="btn" id="btnAddRow">➕ Add Line</button>
    <button class="btn" id="btnClear">🧹 Clear</button>
  </div>

  <div class="wrap">
    <div id="invoice" class="invoice">
      <input type="file" id="logoInput" accept="image/*" hidden>
      <div class="banner">
        <div id="logoBox" class="logo">
          <img src="<?php echo base_url(); ?>assets/Invoice Logo.png" width="100">
        </div>
        <div class="triangle"></div>
      </div>
      <div class="content">
        <div class="row">
          <div>
            <p>Date: <span id="today"></span></p>
            <p>Invoice No: <span class="editable" contenteditable>#INV-1001</span></p>
          </div>
        </div>

        <div class="row">
          <div style="width: 50%;">
            <h4>Invoice To:</h4>
            <div class="editable"><b><?= !empty($quots_json[0]) ? $quots_json[0] : 'Test Company PVT LTD.' ?></b>
              <br>
              <?= !empty($quots_json[2]) ? $quots_json[2] : 'Address: 374, Test Address, Test City - 000000'; ?>
              <br>
              <?= !empty($quots_json[1]) ? $quots_json[1] : 'Website: websolink.com | Email: web@websolink.com | Phone: +91-8686-99-6767'; ?>
            </div>
          </div>
          <div style="width: 50%; text-align: right">
            <h4>Pay To:</h4>
            <div class="editable"><b><?php echo $app_setting->application_name; ?></b><br><?php echo $app_setting->address; ?><br><?php echo $app_setting->email; ?></div>
          </div>
        </div>

        <table id="items">
          <thead>
            <tr>
              <th>SL</th>
              <th>Description</th>
              <th>Price</th>
              <th>Qty</th>
              <th>Total</th>
            </tr>
          </thead>
          <tbody id="tbody">
            <td>1</td>
            <td><?php echo $data->prd_name; ?></td>
            <td><input class="line num price" type="hidden" step="0.01" value="<?php echo $data->main_price; ?>">₹<?php echo $data->main_price; ?></td>
            <td><input class="line qty" type="hidden" step="1" value="1">1</td>
            <td class="rowTotal">₹<?php echo $data->main_price; ?></td>
          </tbody>
        </table>

        <?php
        $discount = $data->main_price - $data->disocunt_price;
        ?>

        <div class="totals">
          <div>
            <h4>Payment info:</h4>
            <div class="editable"><?php
                                  echo str_replace(",", "<br>", $app_setting->bank_payment_info);
                                  ?></div>
          </div>
          <div class="panel">
            <div class="rowx"><span>Subtotal</span><span id="subtotal">₹0.00</span></div>
            <div class="rowx"><span>Tax (0%)</span><span id="tax">₹0.00</span></div>
            <div class="rowx"><span>Discount</span><span id="discount">₹00.00</span></div>
            <div class="rowx total"><span>Grand Total</span><span id="grand">₹0.00</span></div>
            <?php if ($quote && $quote->emi_months > 1): ?>
              <div class="rowx total"><span>EMI</span><span><?php echo $quote->emi_months; ?> X ₹<?php echo $quote->emi_amount; ?></span></div>
            <?php endif; ?>
          </div>
        </div>

        <div class="footer">
          <div class="editable">
            <b>Terms & Condition</b>
            <?php echo $data->terms_and_condition; ?>
          </div>
        </div>
      </div>
    </div>
  </div>

  <script>
    const tbody = document.getElementById('tbody');

    function money(n) {
      return '₹' + (+n).toFixed(2)
    }

    function addRow(data = {
      desc: 'Item description',
      price: 100,
      qty: 1
    }) {
      const i = tbody.children.length + 1;
      const tr = document.createElement('tr');
      tr.innerHTML = `<td>${i}</td>
        <td><input class='line' value='${data.desc}'/></td>
        <td><input class='line num price' type='number' value='${data.price}'/></td>
        <td><input class='line qty' type='number' value='${data.qty}'/></td>
        <td class='rowTotal'>${money(data.price*data.qty)}</td>
        <td><button class='del'>❌</button></td>`;
      tbody.appendChild(tr);
      tr.querySelectorAll('input').forEach(inp => inp.addEventListener('input', () => {
        updateRow(tr);
        calc();
      }));
      tr.querySelector('.del').addEventListener('click', () => {
        tr.remove();
        renumber();
        calc();
      });
      updateRow(tr);
    }

    function updateRow(tr) {
      const p = parseFloat(tr.querySelector('.price').value) || 0;
      const q = parseFloat(tr.querySelector('.qty').value) || 0;
      tr.querySelector('.rowTotal').textContent = money(p * q);
    }

    function renumber() {
      [...tbody.children].forEach((tr, i) => tr.firstElementChild.textContent = i + 1)
    }

    function calc() {
      let sub = 0;
      [...tbody.children].forEach(tr => {
        const p = parseFloat(tr.querySelector('.price').value) || 0;
        const q = parseFloat(tr.querySelector('.qty').value) || 0;
        sub += p * q;
      });
      const tax = 0;
      const discount = <?php echo $discount; ?>;
      document.getElementById('subtotal').textContent = money(sub);
      document.getElementById('tax').textContent = money(tax);
      document.getElementById('discount').textContent = money(discount);
      document.getElementById('grand').textContent = money(sub - discount);
    }
    document.getElementById('btnAddRow').onclick = () => {
      addRow();
      calc()
    };
    document.getElementById('btnClear').onclick = () => {
      tbody.innerHTML = '';
      calc()
    };
    document.getElementById('btnPrint').onclick = () => window.print();
    // document.getElementById('btnPdf').onclick = () => {
    //   html2pdf().set({
    //     margin: 10,
    //     filename: 'invoice.pdf',
    //     html2canvas: {
    //       scale: 2
    //     },
    //     jsPDF: {
    //       unit: 'mm',
    //       format: 'a4'
    //     }
    //   }).from(document.getElementById('invoice')).save();
    // };
    document.getElementById('today').textContent = new Date().toLocaleDateString();
    // addRow();
    calc();
    // logo upload
    const logoBox = document.getElementById('logoBox');
    const logoInput = document.getElementById('logoInput');
    logoBox.addEventListener('click', () => logoInput.click());
    logoInput.addEventListener('change', () => {
      const f = logoInput.files[0];
      if (!f) return;
      const r = new FileReader();
      r.onload = e => logoBox.innerHTML = `<img src='${e.target.result}'/>`;
      r.readAsDataURL(f)
    });
  </script>


</div>