 <style>
   :root {
     --ink: #0d1b2a;
     --muted: #4f6271;
     --bg: #f7f9fc;
     --white: #fff;
     --primary: #0f2449;
     --primary-600: #0f2449;
     --accent: #e7f0ff;
     --border: #e5e8ef;
   }

   html,
   body {
     margin: 0;
     font-family: Inter, system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, sans-serif;
     color: var(--ink);
     background: var(--bg)
   }


   .toolbar {
     position: sticky;
     top: 0;
     z-index: 20;
     display: flex;
     gap: .5rem;
     align-items: center;
     padding: .75rem;
     backdrop-filter: saturate(1.2) blur(8px);
     background: rgba(255, 255, 255, .8);
     border-bottom: 1px solid var(--border)
   }

   .toolbar .btn {
     appearance: none;
     border: 1px solid var(--border);
     background: var(--white);
     padding: .55rem .8rem;
     border-radius: .65rem;
     font-weight: 600;
     cursor: pointer;
     display: inline-flex;
     gap: .5rem;
     align-items: center
   }

   .btn.primary {
     background: var(--primary);
     border-color: var(--primary);
     color: #fff
   }

   .btn:hover {
     transform: translateY(-1px)
   }

   .wrap {
     max-width: 900px;
     margin: 24px auto;
     padding: 0 16px 80px
   }

   .quote {
     position: relative;
     background: var(--white);
     border: 1px solid var(--border);
     border-radius: 18px;
     overflow: hidden;
     box-shadow: 0 10px 30px rgba(18, 38, 63, .06)
   }

   .brand-band {
     height: 130px;
     background: linear-gradient(135deg, var(--accent), #b7d2ff);
     position: relative;
     overflow: hidden
   }

   .brand-band .logo {
     position: absolute;
     left: 24px;
     top: 18px;
     width: 110px;
     height: 110px;
     border-radius: 16px;
     background: #fff;
     display: grid;
     place-items: center;
     border: 1px solid var(--border);
     cursor: pointer
   }

   .brand-band .logo img {
     max-width: 100%;
     max-height: 100%;
     object-fit: contain;
     border-radius: 14px;
     padding: 0;
   }

   .brand-band .triangle {
     position: absolute;
     right: -80px;
     top: -60px;
     width: 270px;
     height: 270px;
     background: conic-gradient(from 180deg at 50% 50%, var(--primary), var(--primary-600));
     transform: rotate(45deg);
     border-radius: 22px;
     opacity: .85
   }

   .content {
     padding: 24px
   }

   .header-grid {
     display: grid;
     grid-template-columns: 1.4fr .8fr;
     gap: 20px;
     align-items: start
   }

   .company {
     font-size: 14px;
     line-height: 1.35
   }

   .company h1 {
     margin: 0 0 6px;
     font-size: 18px;
     letter-spacing: .2px
   }

   .muted {
     color: var(--muted)
   }

   .rightbox {
     justify-self: end;
     text-align: right
   }

   .rightbox .q-title {
     font-size: 22px;
     font-weight: 800;
     margin: 0 0 4px
   }

   .rightbox .small {
     font-size: 12px
   }

   .editable[contenteditable="true"] {
     outline: 0;
     transition: background .2s
   }

   .editable[contenteditable="true"]:hover {
     background: #fff7
   }

   .section {
     margin-top: 24px;
     border-top: 1px dashed var(--border);
     padding-top: 20px
   }

   .section h3 {
     margin: 0 0 8px;
     font-size: 16px
   }

   .list {
     margin: 0;
     padding-left: 18px
   }

   /* Items table */
   table {
     width: 100%;
     border-collapse: collapse;
     margin-top: 8px
   }

   thead th {
     background: var(--primary);
     color: #fff;
     text-align: left;
     font-size: 13px;
     padding: 10px;
     border-right: 1px solid rgba(255, 255, 255, .25)
   }

   thead th:last-child {
     border-right: 0
   }

   tbody td {
     border-bottom: 1px solid var(--border);
     padding: 10px;
     vertical-align: top
   }

   tbody tr:hover {
     background: #fafcff
   }

   input.line {
     width: 100%;
     border: 1px solid var(--border);
     border-radius: .5rem;
     padding: .5rem .6rem;
     font: inherit
   }

   .num {
     max-width: 120px
   }

   .qty {
     max-width: 70px
   }

   .row-actions {
     display: flex;
     gap: .4rem
   }

   .mini {
     padding: .35rem .55rem;
     font-size: .85rem;
     border-radius: .5rem;
     border: 1px solid var(--border);
     background: #fff;
     cursor: pointer
   }

   .mini.danger {
     color: #b42318;
     border-color: #f3b3ad;
     background: #fff5f4
   }

   .totals {
     display: grid;
     grid-template-columns: 1fr 280px;
     gap: 20px;
     margin-top: 18px;
     align-items: start
   }

   .note {
     font-size: 13px;
     color: var(--muted)
   }

   .panel {
     border: 1px solid var(--border);
     border-radius: 14px;
     overflow: hidden
   }

   .panel .row {
     display: flex;
     justify-content: space-between;
     padding: 10px 12px;
     border-bottom: 1px solid var(--border);
     font-size: 14px
   }

   .panel .row:last-child {
     border-bottom: 0
   }

   .panel .row.total {
     background: var(--accent);
     font-weight: 800
   }

   .grid-2 {
     display: grid;
     grid-template-columns: 1fr 1fr;
     gap: 12px
   }

   .chip {
     display: inline-flex;
     gap: .5rem;
     align-items: center;
     border: 1px solid var(--border);
     background: #fff;
     border-radius: 999px;
     padding: .2rem .6rem;
     font-size: 12px
   }

   .fine {
     font-size: 11px;
     color: var(--muted)
   }

   .footer {
     padding: 18px;
     border-top: 1px dashed var(--border);
     margin-top: 26px;
     color: var(--muted);
     font-size: 12px
   }

   @media print {

     .toolbar,
     .main-footer,
     .main-sidebar,
     .main-header {
       display: none
     }

     body {
       background: #fff
     }

     .wrap {
       padding: 0;
       margin: 0
     }

     .quote {
       border: 0;
       box-shadow: none;
       width: 100%
     }
   }
 </style>

 <div class="content-wrapper">
   <link rel="preconnect" href="https://fonts.googleapis.com">
   <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
   <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
<script src="<?php echo admin_css() ?>plugins/sweetalert/sweetalert2.all.min.js"></script>


   <div class="toolbar">
     <button class="btn" id="btnPrint">🖨️ Print</button>

     <span style="display: none;" class="chip">💱 <label for="currency" class="fine">Currency</label>
       <select id="currency" style="border:0;background:transparent;font-weight:700">
         <option value="₹" selected>₹</option>
         <option value="$">$</option>
         <option value="€">€</option>
         <option value="£">£</option>
       </select>
     </span>
   </div>
   <form id="quoteForm" method="post" action="<?php echo base_url('admin/admin/save_quots'); ?>">
     <div class="wrap">
       <div id="quote" class="quote">
         <div class="brand-band">
           <div class="logo" id="logoBox" title="Click to upload logo (max-height ~110px)">
             <img src="<?php echo base_url(); ?>assets/Invoice Logo.png" width="100">
           </div>
           <div class="triangle"></div>
         </div>

         <div class="content">
           <div class="header-grid">
             <div class="company">
               <h1 class="editable" contenteditable="<?= $quote->status === 'approved' ? 'false' : 'true' ?>">
                 <?= !empty($quots_json[0]) ? $quots_json[0] : 'Test Company PVT LTD.' ?>
               </h1>

               <div class="editable muted" contenteditable="<?= $quote->status === 'approved' ? 'false' : 'true' ?>"><?= !empty($quots_json[1]) ? $quots_json[1] : 'Website: websolink.com | Email: web@websolink.com | Phone: +91-8686-99-6767'; ?></div>

               <div class="editable muted" contenteditable="<?= $quote->status === 'approved' ? 'false' : 'true' ?>"><?= !empty($quots_json[2]) ? $quots_json[2] : 'Address: 374, Test Address, Test City - 000000'; ?></div>

             </div>
             <div class="rightbox">
               <p class="q-title editable" contenteditable="<?= $quote->status === 'approved' ? 'false' : 'true' ?>"><?= !empty($quots_json[3]) ? $quots_json[3] : 'Quote For: Ecommerce Website Quote'; ?></p>
               <div class="small muted editable" contenteditable="<?= $quote->status === 'approved' ? 'false' : 'true' ?>"><?= !empty($quots_json[3]) ? $quots_json[3] : 'Quote # <b>EST-2025-001</b> • Date: <span id="today"></span>'; ?></div>
             </div>
           </div>

           <div class="section">
             <h3>Overview</h3>
             <p class="muted"><?php echo strip_tags($data->prd_short_description); ?></p>
           </div>

           <div class="section">
             <h3>Key Features</h3>
             <ul class="list">
               <?php echo $data->description ?>
             </ul>
           </div>

           <div class="section">
             <h3>Demo</h3>
             <div class="grid-2">
               <div>
                 <div class="fine">Frontend</div>
                 <div><?php echo $data->front_demo_url; ?></div>
               </div>
               <div>
                 <div class="fine">Backend</div>
                 <div><?php echo $data->backend_demo_url; ?>
                   <br>
                   Username : <b><?php echo $data->backend_demo_username; ?></b>
                   <br>
                   Password : <b><?php echo $data->backend_demo_password; ?></b>
                 </div>
               </div>
             </div>
           </div>

           <div class="section">
             <h3>Pricing</h3>
             <table id="items">
               <thead>
                 <tr>
                   <th style="width:48px">SL</th>
                   <th>Description</th>
                   <th style="width:140px">Price</th>
                   <th style="width:90px">Qty</th>
                   <th style="width:140px">Total</th>
                 </tr>
               </thead>
               <tbody id="tbody">
                 <td>1</td>
                 <td><?php echo $data->prd_name; ?></td>
                 <td><input class="line num price" type="number" step="0.01" value="<?php echo $data->main_price; ?>"></td>
                 <td><input class="line qty" type="number" step="1" value="1"></td>
                 <td class="rowTotal">₹<?php echo $data->main_price; ?></td>
               </tbody>
             </table>
             <?php
              $discount = $data->main_price - $data->disocunt_price;
              ?>

             <div class="totals">
               <div>
                 <p class="note">Tip: Click any text to edit. Use “Add Line” to insert more items. Numbers accept decimals. All data is saved to your browser (no server).</p>
                 <div class="grid-2">
                   <label class="chip" style="display: none;">Tax % <input id="taxPct" type="number" class="line num" value="0" min="0" step="0" style="width:90px"></label>
                   <label class="chip">Discount <input id="discount" type="number" class="line num" value="<?php echo $discount; ?>" min="0" step="0" style="width:110px"></label>
                 </div>
                 <div class="grid-2" style="margin-top: 20px;">
                   <label class="chip">EMI Months
                     <button type="button" id="emiMinus">➖</button>
                     <input id="emiMonths" type="number" class="line num" value="<?php echo $quote->emi_months ?? 1; ?>" min="1" step="1" style="width:60px;text-align:center">
                     <button type="button" id="emiPlus">➕</button>
                   </label>
                 </div>
               </div>

               <div class="panel" id="totalsPanel">
                 <div class="row"><span>Subtotal</span><b><span id="subtotal">₹0.00</span></b></div>
                 <div class="row"><span>Tax</span><b><span id="taxAmt">₹0.00</span></b></div>
                 <div class="row"><span>Discount</span><b><span id="discAmt">-₹0.00</span></b></div>
                 <div class="row total"><span>Grand Total</span><b><span id="grand">₹0.00</span></b></div>
                 <div class="row total"><span>Monthly EMI</span><b><span id="emiAmt">₹0.00</span></b></div>
               </div>
             </div>
           </div>

           <div class="section">
             <h3>Technology Specification</h3>
             <div class="grid-2">
               <div style="margin-left: 30px;">
                 <?php echo $data->technical_features; ?>
               </div>

             </div>
           </div>

           <!-- <div class="section">
             <h3>Support & Maintenance</h3>
             <ul class="list editable" contenteditable>
               <li class="editable" contenteditable>Email/Chat support for queries</li>
               <li class="editable" contenteditable>Bug fixes during support window</li>
               <li class="editable" contenteditable>No additional code modification included</li>
             </ul>
           </div> -->


           <div class="footer">
             <div class="">
               <b>Terms & Condition</b>
               <?php echo $data->terms_and_condition; ?>
             </div>
           </div>

           <input type="hidden" name="status" id="status">

           <!-- Hidden fields for saving -->
           <input type="hidden" name="subtotal" id="subtotal_in">
           <input type="hidden" name="tax" id="tax_in">
           <input type="hidden" name="discount" id="discount_in">
           <input type="hidden" name="grand_total" id="grand_in">
           <input type="hidden" name="emi_months" id="emiMonths_in">
           <input type="hidden" name="emi_amount" id="emiAmt_in">
           <input type="hidden" name="lead_id" value="<?php echo $data->lead_id; ?>">

           <?php if(!isset($quote) || (isset($quote->status) && $quote->status == 'draft')): ?>
           <div class="section section-data">
             <button type="submit" class="btn btn-primary" onclick="document.getElementById('status').value='draft'">💾 Save Draft</button>
             <button type="submit" class="btn btn-success" onclick="document.getElementById('status').value='approved'">✅ Approve</button>
           </div>
           <?php endif; ?>


         </div>
       </div>
     </div>
   </form>
   <style>
     .section-data {
       margin-top: 20px;
       display: flex;
       gap: 12px;
       /* spacing between buttons */
     }

     .section .btn {
       font-size: 16px;
       font-weight: 600;
       padding: 10px 18px;
       border: none;
       border-radius: 8px;
       cursor: pointer;
       transition: all 0.3s ease;
       display: flex;
       align-items: center;
       gap: 6px;
       /* spacing between icon and text */
     }

     /* Save Draft */
     .section .btn-primary {
       background-color: #007bff;
       color: #fff;
     }

     .section .btn-primary:hover {
       background-color: #0056b3;
       transform: translateY(-2px);
       box-shadow: 0 4px 8px rgba(0, 123, 255, 0.3);
     }

     /* Approve */
     .section .btn-success {
       background-color: #28a745;
       color: #fff;
     }

     .section .btn-success:hover {
       background-color: #1e7e34;
       transform: translateY(-2px);
       box-shadow: 0 4px 8px rgba(40, 167, 69, 0.3);
     }
   </style>

   <script>
     document.getElementById("quoteForm").addEventListener("submit", function() {
       // find all editable fields
       document.querySelectorAll(".editable").forEach((el, i) => {
         let hidden = document.createElement("input");
         hidden.type = "hidden";
         hidden.name = "editable_fields[" + i + "]";
         hidden.value = el.innerHTML.trim(); // preserve formatting
         this.appendChild(hidden);
       });
     });

     document.addEventListener("DOMContentLoaded", function(event) {
       calc();
     });
     const tbody = document.getElementById('tbody');
     const stateKey = 'quote-state-v1';

     function money(n) {
       const cur = document.getElementById('currency').value || '$';
       const f = new Intl.NumberFormat(undefined, {
         minimumFractionDigits: 2,
         maximumFractionDigits: 2
       });
       return cur + f.format(+n || 0);
     }

     function calc() {
       let sub = 0;
       [...tbody.children].forEach(tr => {
         const price = parseFloat(tr.querySelector('.price').value || 0);
         const qty = parseFloat(tr.querySelector('.qty').value || 0);
         sub += price * qty;
       });

       const taxPct = parseFloat(document.getElementById('taxPct').value || 0);
       const disc = parseFloat(document.getElementById('discount').value || 0);
       const tax = sub * (taxPct / 100);
       const grand = Math.max(sub + tax - disc, 0);

       document.getElementById('subtotal').textContent = money(sub);
       document.getElementById('taxAmt').textContent = money(tax);
       document.getElementById('discAmt').textContent = '-' + money(disc).slice(1);
       document.getElementById('grand').textContent = money(grand);

       // ✅ EMI Calculation
       const emiMonths = parseInt(document.getElementById('emiMonths').value || 1);
       const emi = emiMonths > 0 ? grand / emiMonths : grand;
       document.getElementById('emiAmt').textContent = money(emi);

       // ✅ Fill hidden fields for DB save
       document.getElementById('subtotal_in').value = sub.toFixed(2);
       document.getElementById('tax_in').value = tax.toFixed(2);
       document.getElementById('discount_in').value = disc.toFixed(2);
       document.getElementById('grand_in').value = grand.toFixed(2);
       document.getElementById('emiMonths_in').value = emiMonths;
       document.getElementById('emiAmt_in').value = emi.toFixed(2);
     }

     // ➕ / ➖ EMI months control
     document.getElementById('emiPlus').addEventListener('click', () => {
       const emiInput = document.getElementById('emiMonths');
       emiInput.value = parseInt(emiInput.value) + 1;
       calc();
     });

     document.getElementById('emiMinus').addEventListener('click', () => {
       const emiInput = document.getElementById('emiMonths');
       if (parseInt(emiInput.value) > 1) {
         emiInput.value = parseInt(emiInput.value) - 1;
         calc();
       }
     });

     document.getElementById('emiMonths').addEventListener('input', () => {
       if (parseInt(document.getElementById('emiMonths').value) < 1) {
         document.getElementById('emiMonths').value = 1;
       }
       calc();
     });

     function save() {

     }

     document.getElementById('btnPrint').addEventListener('click', function() {
       window.print();
     });

     document.getElementById('taxPct').addEventListener('input', () => {
       calc();
       save();
     });
     document.getElementById('discount').addEventListener('input', () => {
       calc();
       save();
     });

     document.querySelectorAll('.editable').forEach(el => {
       el.addEventListener('input', () => save());
       el.addEventListener('blur', () => save());
     });

     // Today date
     document.getElementById('today').textContent = new Date().toLocaleDateString();
   </script>
 </div>