<?php
    $errors = $this->session->userdata('errors');
    if (isset($errors)) {
        ?>
        <script>
            swal ( "Oops" ,  "<?php echo $errors ?>" ,  "error" )
        </script>
        <?php echo $errors ?>
        <?php
        $this->session->unset_userdata('errors');
    }
    $error = $this->session->userdata('error');
    if (isset($error)) {
        ?>
         <script>
            swal ( "Oops" ,  "<?php echo $error ?>" ,  "error" )
        </script>
        <?php
        $this->session->unset_userdata('error');
    }
    $success = $this->session->userdata('success');
    if (isset($success)) {
        ?>
         <script>
            swal({
          title: "Done!",
          text: "<?php echo $success ?>",
          icon: "success",
        });
        </script>
        <?php
        $this->session->unset_userdata('success');
    }
    ?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>View All Lead</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
              <li class="breadcrumb-item active">View All Lead</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">

          <div class="col-sm-12">
            <div class="card card-default">
              <div class="card-header">
                <div style="display: inline-block;">
                    <label> Filter Data By Status : </label>
                </div>
                <div style="display: inline-block;">
                  <select  class="form-control" id="table-filter-course">
                      <option value="A_1">No Action Taken</option>
                      <option value="A_2">Follow up</option>
                      <option value="A_3">Deal Complete</option>
                      <option value="A_4">Not Interested</option>
                      <option value="A_5">Call Ringing</option>
                      <option value="A_6">Wrong Number</option>
                  </select>
               </div>
              </div>
                <div class="card-body">
                  <table id="lead_table" class="table table-bordered table-striped">
                    <thead>
                    <tr>
                      <th>id</th>
                      <th>Name</th>
                      <th>Contact Details</th>
                      <th>Lead Data</th>
                      <th>Lead Category</th>
                      <th>Category / Product</th>
                      <th>Status</th>
                      <th class="d-none">sss</th>
                      <th></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $i=1; foreach ($all_data as $key => $data):?>
                    <tr>
                      <td><?php echo $i ?></td>
                      <td><?php echo $data->lead_name; ?></td>
                      <td>
                        Mobile : <b><?php echo $data->lead_mobile ?>
                        <br/>
                        Email : <b><?php echo $data->lead_email ?>

                        <?php if($data->lead_address):?>
                          <br/>
                          Address : <b><?php echo $data->lead_address ?>
                        <?php endif;?>
                      </td>
                      <td><?php echo $data->lead_mode ?></td>
                      <td>
                        <?php if($data->lead_course != 0):?>
                          Course
                        <?php elseif($data->lead_mode == "Our Recruitment Page"):?>
                          Recruitment Page
                        <?php elseif($data->lead_mode == "Hire Talent Page"):?>
                          Hire Talent
                        <?php else: ?>
                          Product
                        <?php endif;?>
                      </td>
                      <td>
                        <?php 
                        if($data->lead_mode == "Join Free Live Video Class" || $data->lead_mode == "Join Free Demo Class" || $data->lead_mode == "Download Syllabus" || $data->lead_mode == "Book a Free Trail Class"):
                          if(strlen($data->lead_course) > 6):
                            $this->db->select('title');
                            $this->db->where('rand_id', $data->lead_course);
                            $course =  $this->db->get('course')->row();
                            echo $course->title;
                          else:
                            $this->db->select('title');
                            $this->db->where('id', $data->lead_course);
                            $course =  $this->db->get('course')->row();
                            echo $course->title;
                          endif;
                        elseif($data->lead_mode == "Our Recruitment Page" || $data->lead_mode == "Hire Talent Page"): ?>
                          N/A
                        <?php elseif($data->lead_mode != "Join Customize Training"):
                          $this->db->select('prd_name');
                          $this->db->where('prd_id', $data->lead_product_id);
                          $product =  $this->db->get('products')->row();
                          echo $product->prd_name;
                         endif;?>

                      </td>
                      <td><?php if($data->lead_status == 0): ?>
                          <span class="badge badge-danger">No Action Taken</span>
                        <?php elseif($data->lead_status == 1):?>
                          <span class="badge badge-primary">Follow up</span>
                        <?php elseif($data->lead_status == 2):?>
                          <span class="badge badge-success">Deal Complete</span>
                        <?php elseif($data->lead_status == 3):?>
                          <span class="badge badge-secondary">Not Interested</span>
                        <?php elseif($data->lead_status == 4):?>
                          <span class="badge badge-warning">Call Ringing</span>
                        <?php else: ?>
                          <span class="badge badge-danger">Wrong Number</span>
                        <?php endif;?>
                      </td>

                      <td class="d-none">
                        <?php if($data->lead_status == 0): ?>
                          A_1
                        <?php elseif($data->lead_status == 1):?>
                          A_2
                        <?php elseif($data->lead_status == 2):?>
                          A_3
                        <?php elseif($data->lead_status == 3):?>
                          A_4
                        <?php elseif($data->lead_status == 4):?>
                          A_5
                        <?php else: ?>
                          A_5
                        <?php endif;?>
                      </td>
                      <td>
                        <div class="input-group-prepend">
                          <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                            Action
                          </button>
                          <div class="dropdown-menu" style="">
                            <a class="dropdown-item" href="javascript:void()" onclick="chnage_status(1, <?php echo $data->lead_id ?>)"><i class="fa fa-long-arrow-right" aria-hidden="true"></i> &nbsp;Follow up</a>
                            <a class="dropdown-item" href="javascript:void()" onclick="chnage_status(2, <?php echo $data->lead_id ?>)"><i class="fa fa-long-arrow-right" aria-hidden="true"></i> &nbsp;Deal Complete</a>
                            <a class="dropdown-item" href="javascript:void()" onclick="chnage_status(3, <?php echo $data->lead_id ?>)"><i class="fa fa-long-arrow-right" aria-hidden="true"></i> &nbsp;Not Interested</a>
                            <a class="dropdown-item" href="javascript:void()" onclick="chnage_status(4, <?php echo $data->lead_id ?>)"><i class="fa fa-long-arrow-right" aria-hidden="true"></i> &nbsp;Call Ringing</a>
                            <a class="dropdown-item" href="javascript:void()" onclick="chnage_status(5, <?php echo $data->lead_id ?>)"><i class="fa fa-long-arrow-right" aria-hidden="true"></i> &nbsp;Wrong Number</a>
                          </div>
                        </div>
                      </td>
                    </tr>
                    <?php $i++; ?>
                    <?php endforeach; ?>
                    </tbody>
                    
                  </table>
                </div>
              </div>
            </div>
          </div>
      </div>
    </section>
    <!-- /.content -->
  </div>

<script type="text/javascript">
$(document).ready(function() {
   var course_table = $('#lead_table').DataTable({
      "responsive": true,
      "autoWidth": false,
      "lengthChange": true,
      "paging": true,
         dom: 'Bfrtip',
        buttons: [
            'copyHtml5',
            'excelHtml5',
            'csvHtml5',
            'pdfHtml5',
            'pageLength'
        ]

    });
   $('#table-filter-course').on('change', function(){
       course_table.search(this.value).draw();   
    });
});   
function chnage_status(status, id) 
{
    var base_url = "<?php echo base_url(); ?>";
    var item_id = status;
    if(item_id != '')
    {
       $.ajax({
          url: base_url+"/admin/admin/change_lead_mgmt_status/"+status+"/"+id,
          method: "GET",
          success: function(data) {
            if(data)
            {
              $("#lead_table").load(window.location.href + " #lead_table" );
               swal({
                  title: "Done!",
                  text: "Status Successfully Changed",
                  icon: "success",
                });
            }
            else
            {
                alert("System Error")
            }
            
          }
       });
    }
}
</script>