
  <!-- Content Wrapper. Contains Course content -->
  <div class="content-wrapper">
    <!-- Content Header (Course header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Add Master Class Course</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
              <li class="breadcrumb-item active">Master Class Course</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <?php echo form_open_multipart(base_url().'admin/master_class/add_master_class_course'); ?>
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-12">
            <div class="card card-default">
              <div class="card-header">
                <h3 class="card-title">Course SEO</h3>
              </div>
              <div class="card-body">
                <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                      <label>Main Course <span class="text-danger">*</span></label>
                      <select type="text" name="mc_course_main_id" class="form-control" placeholder="Enter Course Meta Title" required>
                        <option value="">Select A Course</option>
                        <?php foreach ($get_all_course as $key => $course):?>
                        <option value="<?php echo $course->class_id; ?>"><?php echo $course->class_title; ?></option>
                          <?php endforeach?>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-8">
                    <div class="form-group">
                      <label>Course Meta Title</label>
                      <input type="text" name="mc_course__meta_title" class="form-control" placeholder="Enter Course Meta Title" >
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Course Meta Keywords</label>
                      <textarea type="text" name="mc_course_meta_keywords" class="form-control" placeholder="Enter Course Meta Keywords"></textarea>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Course Meta Description</label>
                      <textarea type="text" name="mc_course_meta_description" class="form-control" placeholder="Enter Course Meta Description"></textarea>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Course Title <span class="text-danger">*</span></label>
                      <input type="text" name="mc_course_title" class="form-control" placeholder="Enter Course Title" required/>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Course Trainner Name <span class="text-danger">*</span></label>
                      <input type="text" name="tarinner_name" class="form-control" placeholder="Enter Course Trainner Name" required/>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Course Trainner Image <span class="text-danger">*</span></label>
                      <input type="file" name="mc_course_trainner_image" class="form-control" placeholder="Enter Course Title" required/>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Course Trainner Position <span class="text-danger">*</span></label>
                      <input type="text" name="tarinner_position" class="form-control" placeholder="Enter Course Trainner Position" required/>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Course Timing <span class="text-danger">*</span></label>
                      <input type="number" name="course_timing" class="form-control" placeholder="Enter Course Timing" required/>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Course Rating <span class="text-danger">*</span></label>
                      <input type="text" name="course_rating" class="form-control" placeholder="Enter Course Rating" required/>
                    </div>
                  </div>
                  <div class="col-md-4">
                    <div class="form-group">
                      <label>Course Enrolled <span class="text-danger">*</span></label>
                      <input type="text" name="course_enrolled" class="form-control" placeholder="Enter Course Enrolled" required/>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Course Video Banner <span class="text-danger">*</span></label>
                      <input type="file" name="mc_course_video_banner" class="form-control" placeholder="Enter Course Enrolled" required/>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-group">
                      <label>Course Video URL <span class="text-danger">*</span></label>
                      <input type="file" name="mc_course_video_id" class="form-control" placeholder="Enter Course Video URL" required/>
                    </div>
                  </div>

                  
                  <div class="col-md-12">
                    <div class="form-group">
                      <button class="btn btn-info" type="submit" style="float: right">Add</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    
    <?php echo form_close(); ?>
  </div>

