<?php
$errors = $this->session->userdata('errors');
if (isset($errors)) {
?>
  <script>
    swal("Oops", "<?php echo $errors ?>", "error")
  </script>
  <?php echo $errors ?>
<?php
  $this->session->unset_userdata('errors');
}
$error = $this->session->userdata('error');
if (isset($error)) {
?>
  <script>
    swal("Oops", "<?php echo $error ?>", "error")
  </script>
<?php
  $this->session->unset_userdata('error');
}
$success = $this->session->userdata('success');
if (isset($success)) {
?>
  <script>
    swal({
      title: "Done!",
      text: "<?php echo $success ?>",
      icon: "success",
    });
  </script>
<?php
  $this->session->unset_userdata('success');
}
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>View All Master Class </h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
            <li class="breadcrumb-item active">View All Master Class </li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <div class="row">

        <div class="col-sm-12">
          <div class="card card-default">
            <div class="card-header">
              <h3 class="card-title">All Master Class Page</h3>
              <div class="card-tools">
                <a href="<?php echo admin_url() ?>master_class/add_new_page"><button type="button" class="btn btn-success btn-sm">Add New Page</button></a>
              </div>
            </div>
            <div class="card-body">
              <table id="example" class="table table-bordered table-striped">
                <thead>
                  <tr>
                    <th>id</th>
                    <th>Title</th>
                    <th>Slug</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
                  <?php $i = 1;
                  foreach ($get_all_page as $key => $data) : ?>
                    <tr>
                      <td><?php echo $i ?></td>
                      <td><?php echo $data->class_title ?></td>
                      <td><a href="<?php echo base_url() ?>mc/<?php echo $data->class_slug ?>" target="_blank">Go to Page</a></td>
                      <td>
                        <a href="<?php echo base_url() ?>admin/master_class/update_master_class_page/<?php echo $data->class_id ?>" class="btn btn-success btn-sm"><i class="fa fa-edit" aria-hidden="true"></i></a>
                        <a class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')" href="<?php echo base_url() ?>admin/master_class/delete_master_class_page/<?php echo $data->class_id ?>"><i class="fa fa-trash" aria-hidden="true"></i></a>
                      </td>
                    </tr>
                    <?php $i++; ?>
                  <?php endforeach; ?>
                </tbody>

              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- /.content -->
</div>