<?php
$errors = $this->session->userdata('errors');
if (isset($errors)) {
?>
  <script>
    swal("Oops", "<?php echo $errors ?>", "error")
  </script>
  <?php echo $errors ?>
<?php
  $this->session->unset_userdata('errors');
}
$error = $this->session->userdata('error');
if (isset($error)) {
?>
  <script>
    swal("Oops", "<?php echo $error ?>", "error")
  </script>
<?php
  $this->session->unset_userdata('error');
}
$success = $this->session->userdata('success');
if (isset($success)) {
?>
  <script>
    swal({
      title: "Done!",
      text: "<?php echo $success ?>",
      icon: "success",
    });
  </script>
<?php
  $this->session->unset_userdata('success');
}
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>View All Master Class Slider </h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
            <li class="breadcrumb-item active">View All Master Class Slider </li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <div class="row">

        <div class="col-sm-12">
          <div class="card card-default">
            <div class="card-header">
              <h3 class="card-title">All Master Class Slider</h3>
              <div class="card-tools">
                <a href="#"><button data-toggle="modal" data-target="#exampleModal" type="button" class="btn btn-success btn-sm">Add New Slider</button></a>
              </div>
            </div>
            <div class="card-body">
              <table id="example" class="table table-bordered table-striped">
                <thead>
                  <tr>
                    <th>id</th>
                    <th>Course</th>
                    <th>Image</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
                  <?php $i = 1;
                  foreach ($all_data as $key => $data) : ?>
                    <tr>
                      <td><?php echo $i ?></td>
                      <td><?php echo $data->class_title ?></td>
                      <td><img src="<?php echo base_url(); ?><?php echo $data->mc_slider_image; ?>" width="70px"></td>
                      <td>
                        <a class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')" href="<?php echo base_url() ?>admin/master_class/delete_master_class_page_slider/<?php echo $data->mc_slider_id ?>"><i class="fa fa-trash" aria-hidden="true"></i></a>
                      </td>
                    </tr>
                    <?php $i++; ?>
                  <?php endforeach; ?>
                </tbody>

              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
  <!-- /.content -->
</div>
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">New message</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <?php echo
        form_open_multipart(base_url() . 'admin/master_class/add_new_master_class_slider');
        ?>
        <div class="form-group">
          <label for="recipient-name" class="col-form-label">Course <span class="text-danger">*</span></label>
          <select type="text" class="form-control" name="mc_slider_course_id" required>
            <option value="">Select From List</option>
            <?php foreach ($get_all_course as $key => $course) : ?>
              <option value="<?php echo $course->class_id; ?>"><?php echo $course->class_title; ?></option>
            <?php endforeach;  ?>
          </select>
        </div>
        <div class="form-group">
          <label for="recipient-name" class="col-form-label">Upload Image <span class="text-danger">*</span></label>
          <input type="file" class="form-control" name="mc_slider_image" required>
        </div>
        <div class="form-group text-center">
        <button type="submit" class="btn btn-primary">Save</button>
        </div>
      </div>
      <?php echo
      form_close();
      ?>
    </div>
  </div>
</div>