<?php
$errors = $this->session->userdata('errors');
if (isset($errors)) {
?>
  <script>
    swal("Oops", "<?php echo $errors ?>", "error")
  </script>
  <?php echo $errors ?>
<?php
  $this->session->unset_userdata('errors');
}
$error = $this->session->userdata('error');
if (isset($error)) {
?>
  <script>
    swal("Oops", "<?php echo $error ?>", "error")
  </script>
<?php
  $this->session->unset_userdata('error');
}
$success = $this->session->userdata('success');
if (isset($success)) {
?>
  <script>
    swal({
      title: "Done!",
      text: "<?php echo $success ?>",
      icon: "success",
    });
  </script>
<?php
  $this->session->unset_userdata('success');
}
?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>Edit Product</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
            <li class="breadcrumb-item ">Product</li>
            <li class="breadcrumb-item active">Edit Product</li>
          </ol>
        </div>
      </div>
    </div><!-- /.container-fluid -->
  </section>

    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header d-flex justify-content-between align-items-center">
            <h3 class="card-title">Edit Product: <?php echo $product['prd_title']; ?></h3>
            <a class="btn btn-primary" href="<?php echo site_url('product/' . $product['prd_slug']); ?>" target="_blank">Open Page</a>
          </div>
          <div class="card-body">
            <ul class="nav nav-tabs" id="productTab" role="tablist">
              <li class="nav-item"><a class="nav-link active" data-toggle="tab" href="#tab-basic">Basic</a></li>
              <?php
              $tab_keys = ['hero_section', 'communication_1', 'device_manage', 'communication_2', 'communication_3', 'smart_watch_1', 'communication_4', 'smart_watch_2', 'pricing_section'];
              foreach ($tab_keys as $i => $key): ?>
                <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#tab-<?php echo $key; ?>"><?php echo ucwords(str_replace(['_', '-'], ' ', $key)); ?></a></li>
              <?php endforeach; ?>
              <li class="nav-item"><a class="nav-link" data-toggle="tab" href="#tab-slider">Slider</a></li>
            </ul>


            <div class="tab-content pt-3">
              <div class="tab-pane active" id="tab-basic">
                <form method="post" action="<?php echo site_url('admin/products/update_basic/' . $product['prd_id']); ?>">
                  <div class="form-group">
                    <label>Title</label>
                    <input name="prd_title" class="form-control" value="<?php echo $product['prd_title']; ?>">
                  </div>
                  <div class="form-group">
                    <label>Category</label>
                    <input name="prd_category" class="form-control" value="<?php echo $product['prd_category']; ?>">
                  </div>
                  <button class="btn btn-primary">Save</button>
                </form>
              </div>


              <?php foreach ($tab_keys as $key):
                $s = isset($sections[$key]) ? $sections[$key] : ['title' => '', 'body' => ''];
              ?>
                <div class="tab-pane" id="tab-<?php echo $key; ?>">
                  <form class="section-form" method="post" action="<?php echo site_url('admin/products/save_section'); ?>">
                    <input type="hidden" name="prd_id" value="<?php echo $product['prd_id']; ?>">
                    <input type="hidden" name="section_key" value="<?php echo $key; ?>">


                    <div class="form-group">
                      <label>Section Title</label>
                      <input name="title" class="form-control" value="<?php echo isset($s['title']) ? $s['title'] : ''; ?>">
                    </div>


                    <div class="form-group">
                      <label>Content JSON (use for arbitrary fields, or save as {'body':'...','list':[...]} )</label>
                      <textarea name="content" class="form-control" rows="8"><?php echo htmlentities(json_encode($s, JSON_PRETTY_PRINT)); ?></textarea>
                    </div>


                    <button class="btn btn-success">Save Section</button>
                  </form>
                </div>
              <?php endforeach; ?>


              <div class="tab-pane" id="tab-slider">
                </script>


              </div>