<?php
    $errors = $this->session->userdata('errors');
    if (isset($errors)) {
        ?>
        <script>
            swal ( "Oops" ,  "<?php echo $errors ?>" ,  "error" )
        </script>
        <?php echo $errors ?>
        <?php
        $this->session->unset_userdata('errors');
    }
    $error = $this->session->userdata('error');
    if (isset($error)) {
        ?>
         <script>
            swal ( "Oops" ,  "<?php echo $error ?>" ,  "error" )
        </script>
        <?php
        $this->session->unset_userdata('error');
    }
    $success = $this->session->userdata('success');
    if (isset($success)) {
        ?>
         <script>
            swal({
          title: "Done!",
          text: "<?php echo $success ?>",
          icon: "success",
        });
        </script>
        <?php
        $this->session->unset_userdata('success');
    }
    ?>
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>All Products</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?php echo admin_url() ?>admin">Home</a></li>
              <li class="breadcrumb-item active">All Products</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>


    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-12">
            <div class="card card-default">
              <div class="card-header">
                <h4>View All Product</h4>
                <?php 
                $product_id       = user()->product;
                $prd_last_pay_id  = user()->prd_last_pay_id;
                $this->db->select('a.package, a.prd_name, a.prd_image, a.advance_payment, a.main_price, a.disocunt_price, a.prd_code, a.special_whatsapp_group, a.special_fb_group, b.*');
                $this->db->from('products a');
                $this->db->join('product_inquery b', 'b.prd_inq_prd_id = a.prd_id', 'left');
                $this->db->where('a.prd_id', $product_id);
                $this->db->where('b.prd_inq_id', $prd_last_pay_id);
                $product = $this->db->get()->row();

                // $dt = json_decode($product->package)[0]->dis_price;
                // echo '<pre>';
                // print_r($dt);
                

               if(json_decode($product->package)[$product->package_id]->dis_price > 0)
               {
                  $main_price = json_decode($product->package)[0]->dis_price;
               }
               else
               {
                  $main_price = json_decode($product->package)[0]->dis_price;
               }
               $ppt = $main_price - $product->prd_inq_pay_amount;
                ?>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="example" class="table table-bordered table-striped">
                   <thead>
                        <tr>
                           <th>Image</th>
                           <th>Name</th>
                           <th>Pay Amount</th>
                           <th>Due</th>
                           <th></th>
                           <?php if($ppt == 0):?>
                            <th>Download Code</th>
                          <?php endif;?>
                          <th>Join Community</th>
                        </tr>
                     </thead>
                     <tbody>
                        <?php if($product): ?>
                          <tr>
                             <td>
                                <img src="<?php echo base_url() ?><?php echo $product->prd_image ?>" alt="Product 1" class="img-size-32 mr-2">
                             </td>
                             <td><?php echo $product->prd_name; ?></td>
                             <td>&#x20B9;<?php echo $product->prd_inq_pay_amount; ?></td>
                             <td>&#x20B9;<?php 

                              echo $ppt ; ?>
                                
                              </td>
                               <td>
                              <?php if($ppt == 0):?>
                                <span class="badge badge-success">Paid</span>
                              <?php else: ?>
                                <a href="<?php echo base_url()?>admin/product/pay_due_amount/<?php echo $product->prd_inq_id ?>/<?php echo $product->package_id ?>" class="btn btn-success btn-xs">Pay Due Amount</a>
                              <?php endif;?>
                              </td>
                              <?php if($ppt == 0):?>
                                <td>
                                <a href="<?php echo base_url()?>admin/product/download_code/<?php echo $product->prd_code ?>/<?php echo $product->package_id ?>" class="btn btn-success btn-xs">Download</a>
                              </td>
                              <?php endif;?>
                              <td>
                                <?php if($product->special_fb_group): ?>
                                  <a href="<?php echo $product->special_fb_group ?>" target="_blank" class="nav-link btn btn-xs" style="background-color: #4267B2;color: #fff;border-color:#4267B2;"> <i class="fa fa-facebook"></i> Facebook Community</a>
                                <?php endif; ?>
                                <?php if($product->special_whatsapp_group): ?>
                                  <a href="<?php echo $product->special_whatsapp_group ?>" target="_blank" class="nav-link btn btn-xs" style=" background-color: #25D366;color: #fff; border-color:#25D366;"><i class="fa fa-whatsapp"></i> WhatsAppp Community</a>
                                <?php endif; ?>
                              </td>
                          </tr>
                        <?php else:?>
                          <tr>
                            <td class="text-center" colspan="5">No Product Found</td>
                          </tr>
                        <?php endif;?>
                     </tbody>
                  </table>
                </div>
            </div>
          </div>
      </div>
    </section>
    <!-- /.content -->
  </div>
